/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import oracle.ide.Context;
import oracle.ide.file.ProjectCache;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Workspace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.jdeveloper.java.JavaManager;

public final class JDevDependencyCache {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Collection<Project> getProjectsUsing(Context context, String ... fqClassNames) throws InterruptedException {
        ProjectCache cache = ProjectCache.getInstance((Workspace)context.getWorkspace());
        try {
            HashSet<Project> results = new HashSet<Project>();
            Object queueProperty = context.getProperty("JDevDependencyCacheInitialProjectQueue");
            LinkedList queue = queueProperty != null && queueProperty instanceof LinkedList ? (LinkedList)queueProperty : new LinkedList();
            ArrayList<String> classNames = new ArrayList<String>(Arrays.asList(fqClassNames));
            Project project = context.getProject();
            if (project != null) {
                queue.add(project);
            }
            while (!queue.isEmpty() && !classNames.isEmpty()) {
                Collection upList;
                boolean found = false;
                Project current = (Project)queue.removeFirst();
                JavaManager javaManager = JavaManager.getJavaManager(current);
                Iterator iterator = classNames.iterator();
                while (iterator.hasNext()) {
                    JavaClass javaClass = javaManager.getClass((String)iterator.next());
                    if (javaClass == null) continue;
                    found = true;
                    if (!JDevDependencyCache.isOwner(current, javaClass)) continue;
                    iterator.remove();
                }
                if (!found) continue;
                results.add(current);
                Collection downList = cache.getDownstreamDependencies(current);
                if (downList != null) {
                    results.addAll(downList);
                }
                if ((upList = cache.getDirectDependencies(current)) == null) continue;
                for (Project upProject : upList) {
                    if (results.contains(upProject)) continue;
                    queue.add(upProject);
                }
            }
            Collection<Project> collection = Collections.unmodifiableCollection(results);
            return collection;
        }
        finally {
            cache.close();
        }
    }

    private static boolean isOwner(Project project, JavaClass javaClass) {
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        if (sourceClass != null) {
            SourceFile owningSourceFile = sourceClass.getOwningSourceFile();
            ContentSet contents = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
            if (contents.canHaveMember(owningSourceFile.getURL())) {
                return true;
            }
        }
        return false;
    }
}

