/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaHasName;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaNode;

public final class JavaClassNode
extends JavaNode {
    public static final String EXT = ".class";

    protected Reader createReader(URL url) {
        String classText = this.getDecompiledClass(url);
        return classText == null ? null : new StringReader(classText);
    }

    protected void saveImpl() {
    }

    public boolean isReadOnly() {
        return true;
    }

    private String getDecompiledClass(final URL url) {
        JavaManager javaManager;
        JavaFile javaFile;
        Project project;
        final String cmd = System.getProperty("jcncmd");
        if (cmd != null) {
            SwingWorker<String, String> swingWorker = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() {
                    try {
                        URLTempFile tempFile = new URLTempFile(url);
                        File file = tempFile.getFile();
                        if (file == null) {
                            return null;
                        }
                        Process process = Runtime.getRuntime().exec(cmd + " " + file.getAbsolutePath());
                        final BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                        final StringBuffer buf = new StringBuffer();
                        Thread outputPump = new Thread(){

                            @Override
                            public void run() {
                                try {
                                    String line;
                                    while ((line = br.readLine()) != null) {
                                        buf.append(line).append("\n");
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        };
                        outputPump.start();
                        int exitCode = process.waitFor();
                        outputPump.join();
                        if (exitCode == 0) {
                            return buf.toString();
                        }
                    }
                    catch (Throwable e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, "decompiling " + URLFileSystem.getPlatformPathName((URL)url) + " using \"" + cmd + "\"", e);
                    }
                    return null;
                }
            };
            try {
                swingWorker.execute();
                String result = (String)swingWorker.get(15L, TimeUnit.SECONDS);
                if (result != null) {
                    return result;
                }
            }
            catch (ExecutionException ee) {
            }
            catch (TimeoutException te) {
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        if (project != null && (javaFile = (javaManager = JavaManager.getJavaManager(project)).getFile(url)) != null) {
            return JavaClassNode.emitFile(javaFile);
        }
        return null;
    }

    protected static String emitFile(JavaFile javaFile) {
        StringBuffer out = new StringBuffer(4096);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitComment(0, "Oracle JDeveloper Stub Generated Source", out);
        JavaClassNode.emitComment(0, "", out);
        JavaClassNode.emitPackage(javaFile.getPackageName(), out);
        int importInsertionPoint = out.length();
        HashSet<String> imports = new HashSet<String>();
        JavaClass javaClass = javaFile.getPrimaryClass();
        JavaClassNode.emitClass(javaClass, out, imports);
        ArrayList<String> checkedImports = new ArrayList<String>();
        String packagePrefix = javaFile.getPackageName();
        if (!packagePrefix.isEmpty()) {
            packagePrefix = packagePrefix + ".";
        }
        String javaLangPrefix = "java.lang.";
        for (String oneImport : imports) {
            if (!packagePrefix.isEmpty() && (oneImport.startsWith(packagePrefix) ? oneImport.indexOf(46, packagePrefix.length()) < 0 : oneImport.startsWith(javaLangPrefix) && oneImport.indexOf(46, javaLangPrefix.length()) < 0)) continue;
            checkedImports.add(oneImport);
        }
        if (!checkedImports.isEmpty()) {
            Collections.sort(checkedImports);
            for (String oneImport : checkedImports) {
                String line = "import " + oneImport + ";\n";
                out.insert(importInsertionPoint, line);
                importInsertionPoint += line.length();
            }
            out.insert(importInsertionPoint, "\n");
        }
        return out.toString();
    }

    private static void emitPackage(String packageName, StringBuffer out) {
        if (packageName != null && packageName.length() > 0) {
            out.append("package ");
            out.append(packageName);
            out.append(";");
            JavaClassNode.emitEOL(out);
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitTypeAnnotations(JavaType javaType, StringBuffer out, Set<String> imports) {
        Collection annotations = javaType.getTypeAnnotations();
        Iterator iter = annotations.iterator();
        while (iter.hasNext()) {
            JavaClassNode.emitAnnotation((JavaAnnotation)iter.next(), out, imports);
            out.append(' ');
        }
    }

    private static void emitClass(JavaClass javaClass, StringBuffer out, Set<String> imports) {
        Collection methods;
        boolean hasMethods;
        Collection fields;
        boolean hasFields;
        String modifierText;
        Collection annotations = javaClass.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out, imports);
        }
        if ((modifierText = JavaClassNode.getClassModifiers(javaClass)).length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        boolean isInterface = false;
        boolean isAnnotation = false;
        if (javaClass.isAnnotation()) {
            out.append("@interface");
            isAnnotation = true;
        } else if (javaClass.isInterface()) {
            out.append("interface");
            isInterface = true;
        } else {
            out.append("class");
        }
        JavaClassNode.emitSpaces(1, out);
        String vmName = javaClass.getVMName().replace('\\', '/');
        int index = vmName.lastIndexOf(47);
        if (index >= 0) {
            vmName = vmName.substring(index + 1);
        }
        out.append(vmName);
        JavaClassNode.emitTypeParameters(javaClass.getTypeParameters(), out, imports);
        JavaClassNode.emitEOL(out);
        if (!isAnnotation) {
            JavaType javaType = javaClass.getSuperclass();
            if (javaType != null) {
                if (!"java.lang.Object".equals(javaType.getRawName())) {
                    JavaClassNode.emitIndent(1, out);
                    out.append("extends ");
                    JavaClassNode.emitType(javaType, out, imports);
                    JavaClassNode.emitEOL(out);
                }
            } else {
                String superClassName;
                UnresolvedType superClass = javaClass.getUnresolvedSuperclass();
                if (superClass != null && !"java.lang.Object".equals(superClassName = superClass.toString())) {
                    JavaClassNode.emitIndent(1, out);
                    out.append("extends ");
                    out.append(superClassName);
                    JavaClassNode.emitEOL(out);
                }
            }
            Collection unresolvedInterfaces = javaClass.getUnresolvedInterfaces();
            Collection resolvedInterfaces = javaClass.getInterfaces();
            if (!unresolvedInterfaces.isEmpty()) {
                String superTypesIndent;
                JavaClassNode.emitIndent(1, out);
                if (isInterface) {
                    out.append("extends ");
                    superTypesIndent = "        ";
                } else {
                    out.append("implements ");
                    superTypesIndent = "           ";
                }
                Iterator unresolvedIterator = unresolvedInterfaces.iterator();
                Iterator resolvedIterator = resolvedInterfaces.iterator();
                String comma = ",\n";
                boolean emitComma = false;
                while (unresolvedIterator.hasNext() && resolvedIterator.hasNext()) {
                    if (emitComma) {
                        out.append(comma);
                        JavaClassNode.emitIndent(1, out);
                        out.append(superTypesIndent);
                    } else {
                        emitComma = true;
                    }
                    JavaType resolvedType = (JavaType)resolvedIterator.next();
                    UnresolvedType unresolvedType = (UnresolvedType)unresolvedIterator.next();
                    if (resolvedType != null) {
                        JavaClassNode.emitType(resolvedType, out, imports);
                        continue;
                    }
                    out.append(unresolvedType.toString());
                }
                JavaClassNode.emitEOL(out);
            }
        }
        out.append("{");
        JavaClassNode.emitEOL(out);
        Collection constructors = javaClass.getDeclaredConstructors();
        Iterator iterator = constructors.iterator();
        boolean hasConstructors = iterator.hasNext();
        if (hasConstructors) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Constructors", out);
            JavaClassNode.emitComment(1, "", out);
        }
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod constructor = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(javaClass, constructor, out, imports);
        }
        if (hasConstructors) {
            JavaClassNode.emitEOL(out);
        }
        if (hasFields = (iterator = (fields = javaClass.getDeclaredFields()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Fields", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaField field = (JavaField)iterator.next();
            JavaClassNode.emitField(field, out, imports);
        }
        if (hasFields) {
            JavaClassNode.emitEOL(out);
        }
        if (hasMethods = (iterator = (methods = javaClass.getDeclaredMethods()).iterator()).hasNext()) {
            JavaClassNode.emitComment(1, "", out);
            JavaClassNode.emitComment(1, "Methods", out);
            JavaClassNode.emitComment(1, "", out);
        }
        first = true;
        while (iterator.hasNext()) {
            if (!first) {
                JavaClassNode.emitEOL(out);
            }
            first = false;
            JavaMethod method = (JavaMethod)iterator.next();
            JavaClassNode.emitMethod(javaClass, method, out, imports);
        }
        out.append("}");
        JavaClassNode.emitEOL(out);
    }

    private static void emitTypeParameters(Collection<JavaTypeVariable> typeParameters, StringBuffer out, Set<String> imports) {
        if (!typeParameters.isEmpty()) {
            out.append('<');
            Iterator<JavaTypeVariable> typeParamIter = typeParameters.iterator();
            boolean emitComma = false;
            while (typeParamIter.hasNext()) {
                if (emitComma) {
                    out.append(", ");
                } else {
                    emitComma = true;
                }
                JavaClassNode.emitTypeVariable(typeParamIter.next(), out, imports);
            }
            out.append('>');
        }
    }

    private static void emitTypeVariable(JavaTypeVariable typeVariable, StringBuffer out, Set<String> imports) {
        block8: {
            Collection unresolvedBounds;
            block7: {
                JavaClassNode.emitTypeAnnotations((JavaType)typeVariable, out, imports);
                out.append(typeVariable.getName());
                Collection bounds = typeVariable.getBounds();
                unresolvedBounds = typeVariable.getUnresolvedBounds();
                if (bounds.size() != unresolvedBounds.size() || bounds.contains(null)) break block7;
                if (bounds.isEmpty()) break block8;
                out.append(" extends ");
                boolean emitAtSign = false;
                Iterator iterator = bounds.iterator();
                while (iterator.hasNext()) {
                    if (emitAtSign) {
                        out.append(" & ");
                    } else {
                        emitAtSign = true;
                    }
                    JavaClassNode.emitType((JavaType)iterator.next(), out, imports);
                }
                break block8;
            }
            if (!unresolvedBounds.isEmpty()) {
                out.append(" extends ");
                boolean emitAtSign = false;
                Iterator iterator = unresolvedBounds.iterator();
                while (iterator.hasNext()) {
                    if (emitAtSign) {
                        out.append(" & ");
                    } else {
                        emitAtSign = true;
                    }
                    out.append(((UnresolvedType)iterator.next()).toString());
                }
            }
        }
    }

    private static String getShortTypeName(JavaType javaType, Set<String> imports) {
        String packagePrefix;
        String rawName = javaType.getRawName();
        if (rawName.startsWith(packagePrefix = javaType.getPackageName() + ".")) {
            int dotIndex = (rawName = rawName.substring(packagePrefix.length())).indexOf(46);
            String className = dotIndex > 0 ? rawName.substring(0, dotIndex) : rawName;
            imports.add(packagePrefix + className);
        }
        return rawName;
    }

    private static void emitType(JavaType javaType, StringBuffer out, Set<String> imports) {
        if (javaType.isArray()) {
            JavaType baseComponentType = javaType.getBaseComponentType();
            if (baseComponentType != null) {
                JavaClassNode.emitType(baseComponentType, out, imports);
            } else {
                UnresolvedType type = javaType.getUnresolvedType();
                out.append(type != null ? type.toString() : "java.lang.Object");
            }
            while (javaType != null && javaType.isArray()) {
                if (javaType.getTypeAnnotations().size() > 0) {
                    out.append(" ");
                    JavaClassNode.emitTypeAnnotations(javaType, out, imports);
                }
                out.append("[]");
                javaType = javaType.getComponentType();
            }
        } else {
            JavaClassNode.emitTypeAnnotations(javaType, out, imports);
            JavaClass owningClass = javaType.getOwningClass();
            if (owningClass != null) {
                JavaClassNode.emitType((JavaType)owningClass, out, imports);
                out.append('.');
            }
            if (javaType.getElementKind() == 11) {
                out.append('?');
                JavaWildcardType wildcardType = (JavaWildcardType)javaType;
                Collection bounds = wildcardType.getUpperBounds();
                if (!bounds.isEmpty() && !bounds.contains(null)) {
                    out.append(" extends ");
                    JavaClassNode.emitType((JavaType)bounds.iterator().next(), out, imports);
                } else {
                    bounds = wildcardType.getLowerBounds();
                    if (!bounds.isEmpty() && !bounds.contains(null)) {
                        out.append(" super ");
                        JavaClassNode.emitType((JavaType)bounds.iterator().next(), out, imports);
                    }
                }
            } else {
                out.append(JavaClassNode.getShortTypeName(javaType, imports));
            }
            if (javaType.hasActualTypeArguments()) {
                boolean needComma = false;
                out.append('<');
                Collection actualTypeArguments = javaType.getActualTypeArguments();
                for (JavaType actualTypeArg : actualTypeArguments) {
                    if (needComma) {
                        out.append(", ");
                    } else {
                        needComma = true;
                    }
                    if (actualTypeArg == null) {
                        out.append("?");
                        continue;
                    }
                    JavaClassNode.emitType(actualTypeArg, out, imports);
                }
                out.append('>');
            }
        }
    }

    private static void emitField(JavaField javaField, StringBuffer out, Set<String> imports) {
        JavaType javaType;
        JavaClassNode.emitIndent(1, out);
        String modifierText = JavaClassNode.getFieldModifiers(javaField);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        if ((javaType = javaField.getResolvedType()) != null) {
            JavaClassNode.emitType(javaType, out, imports);
        } else {
            UnresolvedType type = javaField.getUnresolvedType();
            out.append(type == null ? "java.lang.Object" : type.toString());
        }
        JavaClassNode.emitSpaces(1, out);
        out.append(javaField.getName());
        Object constantValue = javaField.getConstantValue();
        if (constantValue != null) {
            out.append(" = ");
            JavaClassNode.emitConstantValue(constantValue, out, imports);
        }
        out.append(";");
        JavaClassNode.emitEOL(out);
    }

    private static void emitConstantValue(Object constantValue, StringBuffer out, Set<String> imports) {
        boolean isArray = constantValue instanceof Object[];
        if (isArray) {
            out.append("{ ");
            Object[] constantValues = (Object[])constantValue;
            boolean emitComma = false;
            for (Object oneValue : constantValues) {
                if (emitComma) {
                    out.append(", ");
                } else {
                    emitComma = true;
                }
                JavaClassNode.emitConstantValue(oneValue, out, imports);
            }
            out.append(" }");
        } else if (constantValue instanceof String) {
            out.append("\"");
            out.append(constantValue.toString());
            out.append("\"");
        } else if (constantValue instanceof JavaType) {
            out.append(JavaClassNode.getShortTypeName((JavaType)constantValue, imports));
            out.append(EXT);
        } else if (constantValue instanceof JavaField) {
            JavaField field = (JavaField)constantValue;
            JavaClass owner = field.getOwningClass();
            if (owner != null) {
                out.append(JavaClassNode.getShortTypeName((JavaType)owner, imports));
                out.append('.');
            } else {
                UnresolvedType unresolvedType = field.getUnresolvedType();
                if (unresolvedType != null) {
                    out.append(unresolvedType.toString());
                    out.append('.');
                }
            }
            out.append(field.getName());
        } else if (constantValue != null) {
            out.append(constantValue.toString());
        } else {
            out.append("<null>");
        }
    }

    private static void emitMethod(JavaClass javaClass, JavaMethod javaMethod, StringBuffer out, Set<String> imports) {
        boolean isConstructor;
        String modifierText;
        JavaClassNode.emitIndent(1, out);
        Collection annotations = javaMethod.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            JavaClassNode.emitAnnotations(annotations, out, imports);
        }
        String string = modifierText = (isConstructor = javaMethod.isConstructor()) ? JavaClassNode.getConstructorModifiers(javaMethod) : JavaClassNode.getMethodModifiers(javaMethod);
        if (modifierText.length() > 0) {
            out.append(modifierText);
            JavaClassNode.emitSpaces(1, out);
        }
        if (javaMethod.getTypeParameters().size() > 0) {
            JavaClassNode.emitTypeParameters(javaMethod.getTypeParameters(), out, imports);
            JavaClassNode.emitSpaces(1, out);
        }
        if (isConstructor) {
            out.append(javaClass.getName());
        } else {
            JavaType javaType = javaMethod.getResolvedType();
            if (javaType != null) {
                JavaClassNode.emitType(javaType, out, imports);
                JavaClassNode.emitSpaces(1, out);
            } else {
                UnresolvedType returnType = javaMethod.getUnresolvedType();
                if (returnType != null) {
                    out.append(returnType.toString());
                    JavaClassNode.emitSpaces(1, out);
                }
            }
            out.append(javaMethod.getName());
        }
        JavaClassNode.emitMethodParameters(javaClass, javaMethod, out, imports);
        if (javaClass.isAnnotation()) {
            Object defaultValue = javaMethod.getDefaultValue();
            if (defaultValue != null) {
                JavaClassNode.emitSpaces(1, out);
                out.append("default");
                JavaClassNode.emitSpaces(1, out);
                JavaClassNode.emitAnnotationComponentValue(out, defaultValue, imports);
            }
            out.append(";");
        } else {
            JavaClassNode.emitSpaces(1, out);
            out.append("{ }");
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitMethodParameters(JavaClass javaClass, JavaMethod javaMethod, StringBuffer out, Set<String> imports) {
        Collection parameters;
        out.append("(");
        String comma = "";
        Collection receiverAnnotations = javaMethod.getReceiverAnnotations();
        if (receiverAnnotations.size() > 0) {
            Iterator iter = receiverAnnotations.iterator();
            while (iter.hasNext()) {
                JavaClassNode.emitAnnotation((JavaAnnotation)iter.next(), out, imports);
                out.append(' ');
            }
            out.append(javaClass.getName());
            out.append(" this");
            comma = ", ";
        }
        if ((parameters = javaMethod.getParameters()) != null) {
            int index = 1;
            for (JavaVariable parameter : parameters) {
                out.append(comma);
                comma = ", ";
                JavaType javaType = parameter.getResolvedType();
                if (javaType != null) {
                    JavaClassNode.emitType(javaType, out, imports);
                } else {
                    UnresolvedType type = parameter.getUnresolvedType();
                    out.append(type == null ? "java.lang.Object" : type.toString());
                }
                JavaClassNode.emitSpaces(1, out);
                String parameterName = parameter.getName();
                if (parameterName != null && parameterName.length() > 0) {
                    out.append(parameterName);
                    continue;
                }
                out.append("p").append(index++);
            }
        }
        out.append(")");
    }

    private static String getFieldModifiers(JavaField javaField) {
        int modifiers = javaField.getModifiers();
        return Modifier.toString(modifiers);
    }

    private static String getMethodModifiers(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getOwningClass();
        boolean isInterfaceMethod = javaClass.isInterface();
        int modifiers = javaMethod.getModifiers();
        if (isInterfaceMethod) {
            modifiers &= 0xFFFFFBFE;
        }
        return Modifier.toString(modifiers);
    }

    private static String getConstructorModifiers(JavaMethod javaMethod) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaMethod.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        return out.toString().trim();
    }

    private static String getClassModifiers(JavaClass javaClass) {
        StringBuffer out = new StringBuffer(30);
        int modifiers = javaClass.getModifiers();
        boolean isInterface = javaClass.isInterface();
        if (Modifier.isPublic(modifiers)) {
            out.append("public ");
        }
        if (Modifier.isPrivate(modifiers)) {
            out.append("private ");
        }
        if (Modifier.isProtected(modifiers)) {
            out.append("protected ");
        }
        if (!isInterface && Modifier.isAbstract(modifiers)) {
            out.append("abstract ");
        }
        if (Modifier.isStatic(modifiers)) {
            out.append("static ");
        }
        if (Modifier.isFinal(modifiers)) {
            out.append("final ");
        }
        if (Modifier.isNative(modifiers)) {
            out.append("native ");
        }
        return out.toString().trim();
    }

    private static void emitEOL(StringBuffer out) {
        out.append("\n");
    }

    private static void emitSpaces(int count, StringBuffer out) {
        for (int i = 0; i < count; ++i) {
            out.append(' ');
        }
    }

    private static void emitIndent(int level, StringBuffer out) {
        for (int i = 0; i < level; ++i) {
            out.append("    ");
        }
    }

    private static int findIndent(StringBuffer out) {
        int index = out.length() - 1;
        int count = 0;
        while (index >= 0) {
            if (out.charAt(index) == '\n') {
                return count;
            }
            --index;
            ++count;
        }
        return count;
    }

    private static void emitComment(int level, String comment, StringBuffer out) {
        JavaClassNode.emitIndent(level, out);
        out.append("//");
        if (comment != null && comment.length() > 0) {
            out.append(' ');
            out.append(comment);
        }
        JavaClassNode.emitEOL(out);
    }

    private static void emitAnnotations(Collection annotations, StringBuffer out, Set<String> imports) {
        for (Object element : annotations) {
            if (!(element instanceof JavaAnnotation)) continue;
            JavaClassNode.emitAnnotation((JavaAnnotation)element, out, imports);
            JavaClassNode.emitEOL(out);
        }
    }

    private static void emitAnnotation(JavaAnnotation annotation, StringBuffer out, Set<String> imports) {
        JavaType annotationType = annotation.getAnnotationType();
        if (annotationType != null) {
            out.append("@" + JavaClassNode.getShortTypeName(annotationType, imports));
        } else {
            out.append("@" + annotation.getUnresolvedType().getSimplifiedName());
        }
        Map arguments = annotation.getUnresolvedArguments();
        if (arguments != null && arguments.size() > 0) {
            out.append("(");
            int indent = JavaClassNode.findIndent(out);
            Iterator j = arguments.keySet().iterator();
            while (j.hasNext()) {
                String key = (String)j.next();
                Object value = arguments.get(key);
                if (value == null) continue;
                if (!key.equals("value") || arguments.size() != 1) {
                    out.append(key);
                    JavaClassNode.emitSpaces(1, out);
                    out.append("=");
                    JavaClassNode.emitSpaces(1, out);
                }
                JavaClassNode.emitAnnotationComponentValue(out, value, imports);
                if (!j.hasNext()) continue;
                out.append(",");
                JavaClassNode.emitEOL(out);
                JavaClassNode.emitSpaces(indent, out);
            }
            out.append(")");
        }
    }

    private static void emitAnnotationComponentValue(StringBuffer out, Object value, Set<String> imports) {
        if (value instanceof String) {
            out.append("\"" + value.toString() + "\"");
            return;
        }
        if (value instanceof Object[]) {
            out.append("{");
            Object[] values = (Object[])value;
            for (int x = 0; x < values.length; ++x) {
                if (x > 0) {
                    out.append(", ");
                }
                JavaClassNode.emitAnnotationComponentValue(out, values[x], imports);
            }
            out.append("}");
            return;
        }
        if (value instanceof JavaAnnotation) {
            JavaClassNode.emitAnnotation((JavaAnnotation)value, out, imports);
            return;
        }
        if (value instanceof JavaField) {
            JavaField fieldObject = (JavaField)value;
            JavaClass owningClass = fieldObject.getOwningClass();
            if (owningClass != null) {
                JavaClassNode.emitType((JavaType)owningClass, out, imports);
                out.append('.');
            } else {
                UnresolvedType unresolvedType = fieldObject.getUnresolvedType();
                if (unresolvedType != null) {
                    out.append(unresolvedType.toString());
                    out.append('.');
                }
            }
            out.append(fieldObject.getName());
            return;
        }
        if (value instanceof JavaHasType) {
            JavaHasType javaHasType = (JavaHasType)value;
            JavaType resolvedType = javaHasType.getResolvedType();
            if (resolvedType != null) {
                out.append(resolvedType.getName() + EXT);
                return;
            }
            UnresolvedType unresolvedType = javaHasType.getUnresolvedType();
            if (unresolvedType != null) {
                out.append(unresolvedType.getSimplifiedName() + EXT);
                return;
            }
        } else if (value instanceof JavaHasName) {
            out.append(((JavaHasName)value).getName());
            return;
        }
        if (value != null) {
            out.append(value.toString());
        }
    }
}

