/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.List;
import java.util.Map;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.PatternFilter;
import oracle.jdeveloper.model.ContentFolder;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaContentValidator;

public class JavaContentSetHelper
extends ContentSetHelper {
    public JavaContentSetHelper(String key) {
        super(key);
    }

    protected void addContentImpl(URL url, ContentSet contentSet, boolean includeSubFolders, ProgressBar progressBar) {
        boolean canShowUI;
        boolean isDir = URLFileSystem.isDirectory((URL)url);
        boolean bl = canShowUI = progressBar != null;
        if (!isDir) {
            URL srcRoot = JProjectUtil.getSourceRootForFile(url, canShowUI, JavaContentValidator.getRegisteredSourceRootHelpers());
            URL contentFolderURL = URLFileSystem.getParent((URL)url);
            if (srcRoot == null) {
                srcRoot = contentFolderURL;
            }
            ContentFolder cf = new ContentFolder(contentFolderURL, srcRoot);
            URLPath urlPath = new URLPath(cf.getRootURL());
            String pattern = urlPath.toRelativePath(url);
            PatternFilter pf = PatternFilter.newInclude((String)pattern);
            cf.addFilter(pf);
            contentSet.setContentFolderURL(cf.getContentFolderURL());
            contentSet.getURLPath().setEntries(new URL[]{cf.getRootURL()});
            contentSet.getPatternFilters().setFilters(cf.getAllFilters());
        } else {
            List<Object> roots;
            if (canShowUI) {
                JavaContentValidator validator = new JavaContentValidator();
                Map<URL, List<URL>> results = validator.processURLsAndConfirm(new URL[]{url});
                roots = results.get(url);
            } else {
                roots = JProjectUtil.getSourceRootsFromFolder(url, JavaContentValidator.getRegisteredSourceRootHelpers());
            }
            int counter = 0;
            for (URL srcRoot : roots) {
                ContentFolder cf = url.toString().length() < srcRoot.toString().length() ? new ContentFolder(srcRoot, srcRoot) : new ContentFolder(url, srcRoot);
                cf.setIncludeSubfolders(includeSubFolders);
                ContentSet activeContentSet = counter == 0 ? contentSet : this.newContentSet();
                activeContentSet.setContentFolderURL(cf.getContentFolderURL());
                activeContentSet.getURLPath().setEntries(new URL[]{cf.getRootURL()});
                activeContentSet.getPatternFilters().setFilters(cf.getAllFilters());
                ++counter;
            }
        }
    }

    protected boolean restoreContentImpl(URL url, ContentSet contentSet) {
        String pattern;
        String rel;
        URLPath urlPath = contentSet.getURLPath();
        if (urlPath != null && urlPath.size() > 0 && (rel = this.getPathRelativeToContentFolder(url, contentSet)) != null && this.unExclude(pattern = contentSet.getURLPath().toRelativePath(url), contentSet)) {
            return true;
        }
        for (int i = 0; i < contentSet.countContentSets(); ++i) {
            if (!this.restoreContentImpl(url, contentSet.getContentSet(i))) continue;
            return true;
        }
        return false;
    }

    protected void removeContentImpl(URL url, ContentSet contentSet) {
        String rel = this.getPathRelativeToContentFolder(url, contentSet);
        if (rel != null) {
            String pattern = contentSet.toRelativePath(url);
            contentSet.getPatternFilters().addExclude(pattern);
        }
        int count = contentSet.countContentSets();
        for (int i = 0; i < count; ++i) {
            this.removeContentImpl(url, contentSet.getContentSet(i));
        }
    }

    private String getPathRelativeToContentFolder(URL url, ContentSet contentSet) {
        URL contentFolderURL = contentSet.getContentFolderURL();
        URLPath urlPath = contentFolderURL == null ? contentSet.getURLPath() : new URLPath(contentFolderURL);
        return urlPath.toRelativePath(url);
    }
}

