/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.awt.Container;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.cmtimpl.JbFeature;

final class JbBeanFeatures
extends JbFeature {
    Boolean hidden_state;
    Boolean isContainer;
    String containerDelegate;
    BeanInfo beanInfo;

    JbBeanFeatures(JbComponent component, BeanInfo bi) {
        super(component, bi.getBeanDescriptor());
        this.beanInfo = bi;
        BeanDescriptor bd = (BeanDescriptor)this.getFeatureDescriptor();
        Object o = bd.getValue("hidden_state");
        if (o != null && o instanceof Boolean) {
            this.hidden_state = (Boolean)o;
        }
        o = bd.getValue("isContainer");
        String className = bd.getBeanClass().getName();
        if (className != null) {
            if (className.equals("javax.swing.JFormattedTextField") || className.equals("javax.swing.JTextPane")) {
                o = Boolean.FALSE;
            } else if (className.equals("javax.swing.JPopupMenu")) {
                o = Boolean.TRUE;
            }
        }
        if (o != null && o instanceof Boolean) {
            this.isContainer = (Boolean)o;
        } else {
            try {
                CmtPackages pkgs = component.getComponents().getPackages();
                Class cls = pkgs.loadClass(className, true);
                if (cls != null) {
                    this.isContainer = Container.class.isAssignableFrom(cls) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        o = bd.getValue("containerDelegate");
        if (o != null && o instanceof String) {
            this.containerDelegate = (String)o;
            this.isContainer = Boolean.TRUE;
        }
    }

    JbBeanFeatures(JbComponent component, String name) {
        super(component, name);
    }

    public BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public Class getCustomizerClass() {
        return this.fd != null ? ((BeanDescriptor)this.fd).getCustomizerClass() : null;
    }

    public boolean isHiddenState() {
        return this.hidden_state != null && this.hidden_state == true;
    }

    public int getDefaultPropertyIndex() {
        return this.beanInfo != null ? this.beanInfo.getDefaultPropertyIndex() : -1;
    }

    public String getDefaultPropertyName() {
        int index = this.getDefaultPropertyIndex();
        if (index >= 0) {
            PropertyDescriptor[] descriptors;
            PropertyDescriptor[] propertyDescriptorArray = descriptors = this.beanInfo != null ? this.beanInfo.getPropertyDescriptors() : null;
            if (descriptors != null && descriptors.length > index) {
                return descriptors[index].getName();
            }
        }
        return null;
    }

    public int getDefaultEventIndex() {
        return this.beanInfo != null ? this.beanInfo.getDefaultEventIndex() : -1;
    }

    public String getDefaultEventName() {
        int index = this.getDefaultEventIndex();
        if (index >= 0) {
            Method[] methods;
            EventSetDescriptor[] descriptors;
            EventSetDescriptor[] eventSetDescriptorArray = descriptors = this.beanInfo != null ? this.beanInfo.getEventSetDescriptors() : null;
            if (descriptors != null && descriptors.length > index && (methods = descriptors[index].getListenerMethods()) != null && methods.length > 0) {
                return methods[0].getName();
            }
        }
        return null;
    }

    public Boolean isContainer() {
        return this.isContainer;
    }

    public void setContainer(boolean b) {
        this.isContainer = new Boolean(b);
    }

    public String getContainerDelegate() {
        return this.containerDelegate;
    }

    public void setContainerDelegate(String c) {
        this.containerDelegate = c;
    }

    public String toString() {
        return "[Bean]name=" + this.name;
    }
}

