/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.cmtimpl;

import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import oracle.ide.Ide;
import oracle.ide.util.Assert;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.jdeveloper.cmt.CmtComponentManager;
import oracle.jdeveloper.cmt.CmtComponents;
import oracle.jdeveloper.cmt.CmtPackages;
import oracle.jdeveloper.cmt.CmtPropertySource;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdevimpl.cmtimpl.JbComponent;
import oracle.jdevimpl.cmtimpl.JbFeature;
import oracle.jdevimpl.uieditor.JdevUiEditorUtils;

final class JbProperty
extends JbFeature
implements CmtPropertySource {
    private static final int SOURCE_UNKNOWN = 0;
    private static final int SOURCE_EVENTSET = 1;
    private static final int SOURCE_BEANINFO = 2;
    private JavaType type;
    private String typeName;
    private JavaMethod getter;
    private JavaMethod setter;
    private String getterName;
    private String setterName;
    private Method liveGetter;
    private Method liveSetter;
    private boolean getterSetterKnown;
    private String editorName;
    private PropertyEditor editor;
    private PropertyEditor transducer;
    private boolean hasCustomEditor;
    private boolean hidden;
    private String[] attributes;
    private String[] valuesAsStrings;
    private int[] values;
    private boolean gotEnumerations;
    private boolean gotJotMethods;
    private int propertySource = 0;

    public JbProperty(JbComponent component, String name) {
        super(component, JbProperty.capitalize(name));
    }

    public JbProperty(JbComponent component, String name, JavaType type, JavaMethod adder) {
        super(component, JbProperty.capitalize(name));
        this.propertySource = 1;
        this.type = type;
        this.typeName = type != null ? type.getQualifiedName() : null;
        this.setter = adder;
    }

    public JbProperty(JbComponent component, PropertyDescriptor pd) {
        super(component, pd);
        this.propertySource = 2;
        this.typeName = JotNames.dotSignatureToType(pd.getPropertyType().getName());
        this.hidden = pd.isHidden();
        this.setName(JbProperty.capitalize(this.getName()));
        Class<?> editorClass = pd.getPropertyEditorClass();
        if (editorClass != null) {
            this.editorName = editorClass.getName();
            this.hasCustomEditor = true;
        }
    }

    public boolean hasCustomEditor() {
        return this.hasCustomEditor;
    }

    private void findGetterSetter() {
        if (!this.getterSetterKnown) {
            switch (this.propertySource) {
                case 2: {
                    PropertyDescriptor pd = (PropertyDescriptor)this.fd;
                    this.liveGetter = pd.getReadMethod();
                    this.liveSetter = pd.getWriteMethod();
                    if (this.liveGetter != null) {
                        this.getterName = this.liveGetter.getName();
                    }
                    if (this.liveSetter == null) break;
                    this.setterName = this.liveSetter.getName();
                    break;
                }
                case 0: {
                    boolean knownGetter;
                    boolean bl = knownGetter = this.getterName != null;
                    if (this.getterName == null) {
                        this.getterName = "get" + Character.toUpperCase(this.getName().charAt(0)) + this.getName().substring(1);
                    }
                    if (this.setterName == null) {
                        this.setterName = "set" + this.getterName.substring(3);
                    }
                    this.getJotMethods(this.getterName, this.setterName);
                    if (this.getter == null && !knownGetter) {
                        this.getterName = "is" + this.getterName.substring(3);
                        this.gotJotMethods = false;
                        this.getJotMethods(this.getterName, this.setterName);
                    }
                    this.getLiveMethods(this.getterName, this.setterName);
                    if (this.liveGetter == null) {
                        this.getterName = null;
                    }
                    if (this.liveSetter != null) break;
                    this.setterName = null;
                    break;
                }
            }
            this.getterSetterKnown = true;
        }
    }

    private synchronized void getEnumerations(FeatureDescriptor fd) {
        if (this.gotEnumerations || fd == null) {
            return;
        }
        this.gotEnumerations = true;
        this.attributes = null;
        this.values = null;
        this.valuesAsStrings = null;
        Object o = fd.getValue("enumerationValues");
        if (o != null && o instanceof Object[]) {
            this.setSwingEnumerations((Object[])o);
            return;
        }
        o = fd.getValue("ENUMERATION");
        if (o == null) {
            return;
        }
        if (o instanceof String) {
            this.setEnumerationsByString((String)o);
        } else if (o instanceof String[]) {
            this.setEnumerationsByArray((String[])o);
        }
    }

    void setSwingEnumerations(Object[] ar) {
        int len = ar.length / 3;
        boolean requiresPrefix = this.component.getType().getQualifiedName().startsWith("javax.swing.");
        this.attributes = new String[len];
        this.values = new int[len];
        this.valuesAsStrings = new String[len];
        try {
            int storeAt = 0;
            int i = 0;
            while (i < ar.length) {
                this.attributes[storeAt] = ar[i].toString();
                this.values[storeAt] = (Integer)ar[i + 1];
                this.valuesAsStrings[storeAt] = ar[i + 2].toString();
                if (requiresPrefix && this.valuesAsStrings[storeAt].indexOf(".") > 0 && !this.valuesAsStrings[storeAt].startsWith("javax.swing.")) {
                    this.valuesAsStrings[storeAt] = "javax.swing." + this.valuesAsStrings[storeAt];
                }
                i += 3;
                ++storeAt;
            }
        }
        catch (Exception e) {
            Assert.println((String)("error analyzing enumerationValues for " + this.getName() + " property"));
        }
    }

    void setEnumerationsByArray(String[] ar) {
        this.attributes = new String[ar.length];
        this.valuesAsStrings = new String[ar.length];
        this.values = new int[ar.length];
        for (int i = 0; i < ar.length; ++i) {
            int equalPos = ar[i].indexOf(61);
            if (equalPos >= 0) {
                this.attributes[i] = ar[i].substring(0, equalPos);
                this.valuesAsStrings[i] = ar[i].substring(equalPos + 1);
                try {
                    this.values[i] = Integer.parseInt(ar[i].substring(equalPos + 1));
                }
                catch (Exception e) {
                    Assert.println((String)("Warning: the enumeration attribute \"" + ar[i] + "\" for the " + this.getName() + " property should be an integer"));
                    this.values[i] = i;
                }
                continue;
            }
            this.attributes[i] = ar[i];
            this.values[i] = i;
            this.valuesAsStrings[i] = Integer.toString(i);
        }
    }

    void setEnumerationsByString(String s) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(s, ",");
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextElement());
        }
        String[] ar = new String[list.size()];
        list.toArray(ar);
        this.setEnumerationsByArray(ar);
    }

    void addMethod(JavaMethod method) {
        String methodName = method.getName();
        this.findGetterSetter();
        this.getJotMethods(this.getterName, this.setterName);
        if (methodName.startsWith("set")) {
            if (this.setter != method) {
                this.setter = method;
                if (this.typeName == null) {
                    Iterator pIter;
                    Collection params = this.setter.getParameters();
                    Iterator iterator = pIter = params != null ? params.iterator() : null;
                    if (pIter != null && pIter.hasNext()) {
                        JavaVariable param = (JavaVariable)pIter.next();
                        this.type = param != null ? param.getResolvedType() : null;
                        this.typeName = this.type != null ? this.type.getQualifiedName() : null;
                    }
                }
            }
        } else {
            this.getter = method;
            if (this.typeName == null) {
                this.type = this.getter.getReturnType();
                this.typeName = this.type != null ? this.type.getQualifiedName() : null;
            } else if (this.setter != null && this.typeName != null && !this.typeName.equals(this.getter.getReturnType().getQualifiedName())) {
                this.type = this.getter.getReturnType();
                this.typeName = this.type != null ? this.type.getQualifiedName() : null;
                JavaClass clazz = this.getter.getOwningClass();
                this.setter = clazz.getDeclaredMethod(this.setter.getName(), new JavaType[]{this.type});
            }
        }
    }

    void getJotMethods(String getterName, String setterName) {
        if (this.gotJotMethods) {
            return;
        }
        this.gotJotMethods = true;
        JavaClass jCls = this.component.getType();
        if (getterName != null) {
            this.getter = jCls.getMethod(getterName, new JavaType[0]);
        }
        if (setterName != null) {
            this.setter = jCls.getMethod(setterName, new JavaType[]{this.getType()});
        }
    }

    void getLiveMethods() {
        this.getJotMethods(this.getterName, this.setterName);
        this.getLiveMethods(this.getter != null ? this.getter.getName() : null, this.setter != null ? this.setter.getName() : null);
    }

    void getLiveMethods(String getterName, String setterName) {
        if (getterName != null && this.liveGetter == null || setterName != null && this.liveSetter == null) {
            try {
                CmtComponents cmtMgr = this.component.getComponents();
                JavaClass jCls = this.component.getType();
                Class liveClazz = cmtMgr.getPackages().loadClass(jCls.getQualifiedName(), false);
                if (getterName != null && this.liveGetter == null) {
                    try {
                        this.liveGetter = liveClazz.getMethod(getterName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        // empty catch block
                    }
                }
                if (setterName != null && this.typeName != null && this.liveSetter == null) {
                    String livePropSig = JotNames.typeToDotSignature(this.typeName);
                    Class livePropClazz = cmtMgr.getPackages().loadClass(livePropSig, false);
                    try {
                        this.liveSetter = liveClazz.getMethod(setterName, livePropClazz);
                    }
                    catch (NoSuchMethodException e) {}
                }
            }
            catch (ClassNotFoundException e) {
                Assert.printStackTrace((Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
    }

    @Override
    public synchronized Class getPropertyType() {
        try {
            String dotSignature = JotNames.typeToDotSignature(this.typeName);
            return this.component.getComponents().getPackages().loadClass(dotSignature, true);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return null;
        }
    }

    @Override
    public synchronized JavaType getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.typeName != null) {
            this.type = this.component.getComponents().getPackages().getClass(this.typeName);
        } else {
            this.getJotMethods(this.getterName, this.setterName);
            if (this.getter != null) {
                this.setType(this.getter.getReturnType());
            } else if (this.liveGetter != null) {
                Class<?> liveType = this.liveGetter.getReturnType();
                this.typeName = JotNames.dotSignatureToType(liveType.getName());
                this.type = this.component.getComponents().getPackages().getClass(this.typeName);
            }
        }
        return this.type;
    }

    @Override
    public synchronized void setType(JavaType type) {
        this.type = type;
        this.typeName = type != null ? type.getQualifiedName() : null;
    }

    @Override
    public boolean isReadable() {
        this.findGetterSetter();
        return this.getterName != null;
    }

    @Override
    public void setReadable(boolean readable) {
    }

    @Override
    public JavaMethod getReadMethod() {
        this.findGetterSetter();
        this.getJotMethods(this.getterName, this.setterName);
        return this.getter;
    }

    @Override
    public String getReadMethodName() {
        this.findGetterSetter();
        return this.getterName;
    }

    @Override
    public boolean isWritable() {
        this.findGetterSetter();
        return this.setterName != null;
    }

    @Override
    public void setWritable(boolean writable) {
    }

    @Override
    public JavaMethod getWriteMethod() {
        this.findGetterSetter();
        this.getJotMethods(this.getterName, this.setterName);
        return this.setter;
    }

    @Override
    public String getWriteMethodName() {
        this.findGetterSetter();
        return this.setterName;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isBound() {
        return this.fd != null && ((PropertyDescriptor)this.fd).isBound();
    }

    @Override
    public boolean isConstrained() {
        return this.fd != null && ((PropertyDescriptor)this.fd).isConstrained();
    }

    @Override
    public boolean isEvent() {
        return this.propertySource == 1;
    }

    private synchronized PropertyEditor createDefaultPropertyEditor() {
        String sig = null;
        try {
            this.getEnumerations(this.getFeatureDescriptor());
            if (this.typeName != null && this.typeName.equals("int") && !this.hasCustomEditor && this.attributes != null) {
                return JdevUiEditorUtils.getInstance().createIntegerTagEditor(this.values, this.attributes, this.valuesAsStrings);
            }
            sig = JotNames.typeToDotSignature(this.typeName);
            Class typeClass = this.component.getComponents().getPackages().loadClass(sig, false);
            PropertyEditor pe = CmtComponentManager.findEditor(typeClass);
            return pe;
        }
        catch (ClassNotFoundException e) {
            Ide.getStatusBar().setText(e.toString() + ":createDefaultPropertyEditor(" + sig + ")");
        }
        catch (NoClassDefFoundError e) {
            Ide.getStatusBar().setText(e.toString() + ":createDefaultPropertyEditor(" + sig + ")");
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            Ide.getStatusBar().setText(e.toString() + ":createDefaultPropertyEditor(" + sig + ")");
        }
        return null;
    }

    private PropertyEditor createPropertyEditor(String className) {
        try {
            Class editorClass = this.component.getComponents().getPackages().loadClass(className, false);
            return this.createPropertyEditor(editorClass);
        }
        catch (ClassNotFoundException e) {
            return this.createDefaultPropertyEditor();
        }
        catch (NoClassDefFoundError e) {
            return this.createDefaultPropertyEditor();
        }
    }

    private PropertyEditor createPropertyEditor(Class editorClass) {
        if (editorClass != null) {
            try {
                return (PropertyEditor)editorClass.newInstance();
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return this.createDefaultPropertyEditor();
    }

    @Override
    public synchronized PropertyEditor getEditor() {
        if (this.editorName == null) {
            this.editor = this.createDefaultPropertyEditor();
            if (this.editor != null) {
                this.editorName = this.editor.getClass().getName();
            }
        } else if (this.editor == null) {
            try {
                CmtPackages mgr = this.component.getComponents().getPackages();
                this.editor = (PropertyEditor)mgr.loadClass(this.editorName, true).newInstance();
            }
            catch (Exception e) {
                this.editor = this.createDefaultPropertyEditor();
                this.editorName = this.editor.getClass().getName();
            }
        }
        return this.editor;
    }

    public synchronized void setEditor(PropertyEditor editor) {
        this.editor = editor;
        this.editorName = editor != null ? editor.getClass().getName() : null;
    }

    public PropertyEditor getTransducer() {
        if (this.transducer == null) {
            this.transducer = this.getEditor();
        }
        if (this.transducer == null) {
            this.transducer = JdevUiEditorUtils.getInstance().createSubcomponentChoiceEditor();
        }
        return this.transducer;
    }

    public static String extractName(JavaMethod method) {
        if ((method.getModifiers() & 9) != 1) {
            return null;
        }
        String methodName = method.getName();
        if (methodName.length() < 4 && !methodName.startsWith("is") || methodName.length() < 3) {
            return null;
        }
        JavaType retType = method.getReturnType();
        if (retType == null) {
            return null;
        }
        Collection params = method.getParameters();
        if (params == null || params.isEmpty()) {
            if (methodName.startsWith("get")) {
                return Introspector.decapitalize(methodName.substring(3));
            }
            if (retType.getQualifiedName().equals("boolean") && methodName.startsWith("is")) {
                return Introspector.decapitalize(methodName.substring(2));
            }
            return null;
        }
        if (params != null && params.size() == 1 && methodName.startsWith("set") && retType.getQualifiedName().equals("void")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    static String capitalize(String name) {
        return Introspector.decapitalize(name);
    }

    public Method getLiveGetter() {
        this.findGetterSetter();
        return this.liveGetter;
    }

    public Method getLiveSetter() {
        this.findGetterSetter();
        return this.liveSetter;
    }

    public boolean matchesWriteMethodName(String methodName) {
        if (this.getterName == null) {
            this.findGetterSetter();
        }
        return this.setterName != null && methodName.equals(this.setterName);
    }
}

