/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.compiler.OjcConfiguration;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdevimpl.compiler.CompilerDescription;
import oracle.jdevimpl.compiler.CompilerOption;
import oracle.jdevimpl.compiler.JavacCompilerDescription;
import oracle.jdevimpl.resource.CompilerArb;

public class CompilerOptionManager
extends HashStructureAdapter {
    public static final String COMPILER_NAME = "compiler.name";
    public static final String DEFAULT_COMPILER_NAME = "Javac";
    public static final String COMPILER_OPTIONS_AS_STRING = "commandline.options";
    public static final String COMPILER_OPTIONS_AS_LIST = "commandline.optionlist";
    static List<String> compilerOptionPanelTreeState;
    static final String ADDITIONAL_OPTIONS = "additional.options";
    private static List<CompilerDescription> compilers;
    private String jdkVersion;

    public static CompilerOptionManager getInstance(PropertyStorage project) {
        return new CompilerOptionManager(CompilerOptionManager.findOrCreate((PropertyStorage)project, (String)OjcConfiguration.DATA_KEY), project);
    }

    protected CompilerOptionManager(HashStructure hash, PropertyStorage project) {
        super(hash);
        this.jdkVersion = this.getJdkVersion(project);
    }

    public void setToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            this.rebuildStorageOfOptions(compiler.getName(), true);
        }
    }

    public void reSetToDefaultOptions() {
        for (CompilerDescription compiler : compilers) {
            String[] optionKeys;
            for (String optionKey : optionKeys = compiler.getOptionNames()) {
                this._hash.remove(optionKey);
            }
            for (String optionKey : optionKeys = compiler.getDiscontinuedOptionNames()) {
                this._hash.remove(optionKey);
            }
            this.rebuildStorageOfOptions(compiler.getName(), true);
        }
    }

    public String[] getCompilerOptionsAsArray(String compilerName) {
        return this.getCompilerOptionsAsArray(compilerName, false);
    }

    private String[] getCompilerOptionsAsArray(String compilerName, boolean getDefaultOptions) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = getDefaultOptions ? this.getDefaultCompilerOptions(compilerName) : this.getCompilerOptions(compilerName);
        String additionalOptions = null;
        ArrayList<String> optionStrings = new ArrayList<String>();
        for (CompilerOption option : compilerOptions) {
            if (!option.isTurnedOn()) continue;
            if (option.getName().equals(ADDITIONAL_OPTIONS)) {
                if (option.getArgument() == null || option.getArgument().trim().length() <= 0) continue;
                additionalOptions = option.getArgument().trim();
                continue;
            }
            if (option.getArgument() != null && option.getArgument().trim().length() == 0) continue;
            String trimmedOptionName = option.getName().trim();
            if (trimmedOptionName.endsWith(":")) {
                if (option.getArgument() != null) {
                    optionStrings.add(trimmedOptionName + option.getArgument().trim());
                    continue;
                }
                optionStrings.add(trimmedOptionName);
                continue;
            }
            optionStrings.add(trimmedOptionName);
            if (option.getArgument() == null) continue;
            optionStrings.add(option.getArgument().trim());
        }
        if (additionalOptions != null) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ");
            while (tokenizer.hasMoreTokens()) {
                optionStrings.add(tokenizer.nextToken().trim());
            }
        }
        return optionStrings.toArray(new String[optionStrings.size()]);
    }

    private void throwOptionNotRecognized() {
        throw new IllegalArgumentException("Compiler does not recognize option");
    }

    public String getCompilerOptionAsString(String compilerName, String optionName) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = this.getCompilerOptions(compilerName);
        for (CompilerOption option : compilerOptions) {
            if (!option.getName().equals(optionName)) continue;
            if (!option.isTurnedOn()) {
                return null;
            }
            StringBuilder buf = new StringBuilder();
            buf.append(optionName);
            String argument = option.getArgument();
            if (argument != null && argument.trim().length() > 0) {
                buf.append(' ');
                buf.append(argument);
            }
            return buf.toString();
        }
        this.throwOptionNotRecognized();
        return null;
    }

    public boolean compilerRecognizesOption(String compilerName, String optionName) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = this.getCompilerOptions(compilerName);
        for (CompilerOption option : compilerOptions) {
            if (!option.getName().equals(optionName)) continue;
            return true;
        }
        return false;
    }

    public boolean compilerOptionRequiresArgument(String compilerName, String optionName) {
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        Collection<CompilerOption> compilerOptions = this.getDefaultCompilerOptions(compilerName);
        for (CompilerOption option : compilerOptions) {
            if (!option.getName().equals(optionName)) continue;
            return option.getArgument() != null;
        }
        this.throwOptionNotRecognized();
        return false;
    }

    public void enableCompilerOption(String compilerName, String optionName, String argument) {
        String debugOption;
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        if ((debugOption = this.getDebugInformationOption(compilerName)) != null && debugOption.equals(optionName)) {
            this.setDebugInformation(compilerName, true);
            return;
        }
        Collection<CompilerOption> compilerOptions = this.getCompilerOptions(compilerName);
        for (CompilerOption option : compilerOptions) {
            if (!option.getName().equals(optionName)) continue;
            if (option.getArgument() == null && argument != null) {
                throw new IllegalArgumentException("Option " + optionName + " requires no arguments!");
            }
            if (option.getArgument() != null && argument == null) {
                throw new IllegalArgumentException("Option " + optionName + " requires an argument!");
            }
            option.setTurnedOn(true);
            option.setArgument(argument);
            this.setCompilerOption(option);
            return;
        }
        this.throwOptionNotRecognized();
    }

    public void disableCompilerOption(String compilerName, String optionName) {
        String debugOption;
        if (compilerName == null) {
            compilerName = this.getCurrentCompiler();
        }
        if ((debugOption = this.getDebugInformationOption(compilerName)) != null && debugOption.equals(optionName)) {
            this.setDebugInformation(compilerName, false);
            return;
        }
        Collection<CompilerOption> compilerOptions = this.getCompilerOptions(compilerName);
        for (CompilerOption option : compilerOptions) {
            if (!option.getName().equals(optionName)) continue;
            option.setTurnedOn(false);
            if (this.compilerOptionRequiresArgument(compilerName, optionName)) {
                option.setArgument("");
            } else {
                option.setArgument(null);
            }
            this.setCompilerOption(option);
        }
        if (!this.compilerRecognizesOption(compilerName, optionName)) {
            this.throwOptionNotRecognized();
        }
    }

    public String getCompilerOptionsAsString(String compilerName) {
        return this.getCompilerOptionsAsString(compilerName, false);
    }

    private String getCompilerOptionsAsString(String compilerName, boolean useDefaultOptions) {
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        StringBuffer buf = new StringBuffer();
        for (String option : options) {
            buf.append(option);
            buf.append(' ');
        }
        return buf.toString();
    }

    static String[] getOptionNames() {
        ArrayList<String> keyList = new ArrayList<String>();
        for (CompilerDescription provider : compilers) {
            keyList.addAll(Arrays.asList(provider.getOptionNames()));
        }
        return keyList.toArray(new String[keyList.size()]);
    }

    Collection<CompilerOption> getOptionsOfAllCompilers() {
        return this.getCompilerOptions(null);
    }

    private Collection<CompilerOption> getCompilerOptions(String compilerName) {
        ArrayList<CompilerOption> optionList = new ArrayList<CompilerOption>();
        for (CompilerDescription compiler : compilers) {
            if (compilerName != null && !compilerName.equalsIgnoreCase(compiler.getName())) continue;
            String[] qualifiedOptionNames = compiler.getOptionNames();
            for (int x = 0; x < qualifiedOptionNames.length; ++x) {
                optionList.add(this.getCompilerOption(qualifiedOptionNames[x]));
            }
        }
        return this.filterCompilerOptions(compilerName, optionList);
    }

    public List<String> getCompilers() {
        ArrayList<String> compilerList = new ArrayList<String>();
        for (CompilerDescription compiler : compilers) {
            compilerList.add(compiler.getName());
        }
        return compilerList;
    }

    public String getCurrentCompiler() {
        String compilerName = this._hash.getString(COMPILER_NAME);
        if (compilerName != null) {
            for (CompilerDescription compiler : compilers) {
                if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
                return compilerName;
            }
        }
        return DEFAULT_COMPILER_NAME;
    }

    public void setCurrentCompiler(String compilerName) {
        this._hash.remove("useJavac");
        this._hash.remove(COMPILER_NAME);
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            this._hash.putString(COMPILER_NAME, compilerName);
            break;
        }
    }

    private CompilerOption getCompilerOption(String compilerName, String optionName) {
        StringBuffer buf = new StringBuffer();
        buf.append(compilerName);
        buf.append('.');
        buf.append(optionName);
        return this.getCompilerOption(buf.toString());
    }

    CompilerOption getCompilerOption(String fullyQualifiedOptionName) {
        CompilerOption option = this.getOldStyleOption(fullyQualifiedOptionName, "-g", "debugInformation", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-forcecodegen", "alwaysGenClasses", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-warn", "showWarnings", false);
        if (option != null) {
            return option;
        }
        option = this.getOldStyleOption(fullyQualifiedOptionName, "-deprecation", "showDeprecations", false);
        if (option != null) {
            return option;
        }
        String optionString = this._hash.getString(fullyQualifiedOptionName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(fullyQualifiedOptionName);
        if (optionString == null) {
            return defaultOption;
        }
        if (defaultOption.isPath()) {
            optionString = optionString.replace('`', File.pathSeparatorChar);
        }
        return CompilerOption.createCompilerOption(defaultOption, fullyQualifiedOptionName, optionString);
    }

    private CompilerOption getOldStyleOption(String optionName, String name, String key, boolean reverseOption) {
        if (optionName.endsWith(name) && this._hash.containsKey(key)) {
            boolean optionOn = this._hash.getBoolean(key);
            if (reverseOption) {
                optionOn = !optionOn;
            }
            CompilerOption option = this.getDefaultCompilerOption(optionName);
            option.setTurnedOn(optionOn);
            return option;
        }
        return null;
    }

    void setCompilerOption(CompilerOption option) {
        String qualifiedName = option.getQualifiedName();
        CompilerOption currentOption = this.getCompilerOption(option.getQualifiedName());
        if (currentOption.equals(option)) {
            return;
        }
        this.setOldStyleOption(qualifiedName, "-g", "debugInformation");
        this.setOldStyleOption(qualifiedName, "-forcecodegen", "alwaysGenClasses");
        this.setOldStyleOption(qualifiedName, "-warn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-nowarn", "showWarnings");
        this.setOldStyleOption(qualifiedName, "-deprecation", "showDeprecations");
        this._hash.remove(qualifiedName);
        CompilerOption defaultOption = this.getDefaultCompilerOption(qualifiedName);
        if (!defaultOption.equals(option)) {
            String optionString;
            String string = optionString = option.isTurnedOn() ? "true" : "false";
            if (option.getArgument() != null) {
                optionString = option.isPath() ? optionString + option.getArgument().replace(File.pathSeparatorChar, '`') : optionString + option.getArgument();
            }
            this._hash.putString(qualifiedName, optionString);
        }
        this.rebuildStorageOfOptions(option.getCompilerName(), false);
    }

    private void rebuildStorageOfOptions(String compilerName, boolean useDefaultOptions) {
        this._hash.remove(compilerName + "." + COMPILER_OPTIONS_AS_STRING);
        String[] options = this.getCompilerOptionsAsArray(compilerName, useDefaultOptions);
        ListStructure listStruct = ListStructure.newInstance();
        for (int x = 0; x < options.length; ++x) {
            listStruct.add((Object)options[x]);
        }
        this._hash.putListStructure(compilerName + "." + COMPILER_OPTIONS_AS_LIST, listStruct);
    }

    private void setOldStyleOption(String optionName, String name, String key) {
        if (optionName.endsWith(name)) {
            this._hash.remove(key);
        }
    }

    private CompilerOption getDefaultCompilerOption(String name) {
        for (CompilerDescription compiler : compilers) {
            CompilerOption option = compiler.getOption(name);
            if (option == null) continue;
            return new CompilerOption(option.getCompilerName(), option.getCategory(), option.isTurnedOn(), option.getName(), option.getArgument(), option.getDescription(), option.isPath());
        }
        int dotIndex = name.indexOf(46);
        String compilerName = this.getCurrentCompiler();
        if (dotIndex > 0) {
            compilerName = name.substring(0, dotIndex);
            name = name.substring(dotIndex + 1);
        }
        return new CompilerOption(compilerName, CompilerArb.getString(71), false, name, null, "fake option", false);
    }

    private Collection<CompilerOption> getDefaultCompilerOptions(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            return this.filterCompilerOptions(compilerName, compiler.getOptions());
        }
        return Collections.emptyList();
    }

    private Collection<CompilerOption> filterCompilerOptions(String compilerName, Collection<CompilerOption> options) {
        if (compilerName == null || compilerName.equalsIgnoreCase("javac")) {
            ArrayList<CompilerOption> filteredOptions = new ArrayList<CompilerOption>();
            for (CompilerOption option : options) {
                if (this.filterJavacOption(option, compilerName, "1.8", new String[]{"-Xlint:auxiliaryclass", "-Xlint:-auxiliaryclass"}) || this.filterJavacOption(option, compilerName, "1.7", new String[]{"-Werror", "-Xlint:classfile", "-Xlint:-classfile", "-Xlint:dep-ann", "-Xlint:-dep-ann", "-Xlint:options", "-Xlint:-options", "-Xlint:processing", "-Xlint:-processing", "-Xlint:rawtypes", "-Xlint:-rawtypes", "-Xlint:static", "-Xlint:-static", "-Xlint:try", "-Xlint:-try", "-Xlint:varargs", "-Xlint:-varargs"}) || this.filterJavacOption(option, compilerName, "1.6", new String[]{"-proc", "-Xlint:none", "-Xlint:cast", "-Xlint:-cast", "-Xlint:divzero", "-Xlint:-divzero", "-Xlint:empty", "-Xlint:-empty", "-Xlint:overrides", "-Xlint:-overrides", "-Xprint"}) || this.filterJavacOption(option, compilerName, "1.5", new String[]{"-X", "-cp", "-endors", "-version"}) || this.filterJavacOption(option, compilerName, "1.3", new String[]{"-g:", "-boot", "-ext"})) continue;
                filteredOptions.add(option);
            }
            return filteredOptions;
        }
        return options;
    }

    boolean filterJavacOption(CompilerOption option, String compilerName, String firstSupportedVersion, String[] filteredOptions) {
        if (this.jdkVersion.compareTo(firstSupportedVersion) < 0) {
            for (String filteredOption : filteredOptions) {
                if (!option.getName().startsWith(filteredOption) || compilerName == null && !option.getCompilerName().equalsIgnoreCase("javac")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUseJavac() {
        return this.getCurrentCompiler().equalsIgnoreCase(DEFAULT_COMPILER_NAME);
    }

    public boolean isShowWarnings() {
        String currentCompiler = this.getCurrentCompiler();
        String showWarningsOption = this.getShowWarningsOption(currentCompiler);
        if (showWarningsOption != null) {
            return this.getCompilerOption(currentCompiler, showWarningsOption).isTurnedOn();
        }
        return false;
    }

    public void setShowWarnings(boolean showWarnings) {
        String currentCompiler = this.getCurrentCompiler();
        String showWarningsOption = this.getShowWarningsOption(currentCompiler);
        if (showWarningsOption != null) {
            CompilerOption option = this.getCompilerOption(currentCompiler, showWarningsOption);
            option.setTurnedOn(showWarnings);
            this.setCompilerOption(option);
        }
    }

    public boolean isShowDeprecations() {
        String currentCompiler = this.getCurrentCompiler();
        String showDeprecationWarnings = this.getShowDeprecationWarningsOption(currentCompiler);
        if (showDeprecationWarnings != null) {
            return this.getCompilerOption(currentCompiler, showDeprecationWarnings).isTurnedOn();
        }
        return false;
    }

    public void setShowDeprecations(boolean showDeprecations) {
        String currentCompiler = this.getCurrentCompiler();
        String showDeprecationWarningsOption = this.getShowDeprecationWarningsOption(currentCompiler);
        if (showDeprecationWarningsOption != null) {
            CompilerOption option = this.getCompilerOption(currentCompiler, showDeprecationWarningsOption);
            option.setTurnedOn(showDeprecations);
            this.setCompilerOption(option);
        }
    }

    public boolean isDebugInformation() {
        return this.isDebugInformation(this.getCurrentCompiler());
    }

    public boolean isDebugInformation(String compilerName) {
        String debugInformationOption = this.getDebugInformationOption(compilerName);
        if (debugInformationOption != null) {
            return this.getCompilerOption(compilerName, debugInformationOption).isTurnedOn();
        }
        return false;
    }

    public void setDebugInformation(boolean debugInformation) {
        String currentCompiler = this.getCurrentCompiler();
        this.setDebugInformation(currentCompiler, debugInformation);
    }

    public void setDebugInformation(String compilerName, boolean debugInformation) {
        String debugInformationOption = this.getDebugInformationOption(compilerName);
        if (debugInformationOption != null) {
            CompilerOption option = this.getCompilerOption(compilerName, debugInformationOption);
            option.setTurnedOn(debugInformation);
            this.setCompilerOption(option);
            String noDebugInformationOption = this.getNoDebugInformationOption(compilerName);
            if (noDebugInformationOption != null) {
                option = this.getCompilerOption(compilerName, noDebugInformationOption);
                option.setTurnedOn(!debugInformation);
                this.setCompilerOption(option);
            }
        }
    }

    private String getJdkVersion(PropertyStorage project) {
        VersionNumber ver;
        JDK jdk;
        JProjectLibraries libs = JProjectLibraries.getInstance((PropertyStorage)project);
        if (libs != null && (jdk = libs.getJDK()) != null && (ver = jdk.getJavaVersion()) != null) {
            return ver.toString();
        }
        return "1.1";
    }

    private String getShowWarningsOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getShowWarningsOption();
        }
        return null;
    }

    private String getShowDeprecationWarningsOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getShowDeprecationWarningsOption();
        }
        return null;
    }

    private String getDebugInformationOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getDebugInformationOption();
        }
        return null;
    }

    private String getNoDebugInformationOption(String compilerName) {
        for (CompilerDescription compiler : compilers) {
            if (!compiler.getName().equalsIgnoreCase(compilerName)) continue;
            return compiler.getNoDebugInformationOption();
        }
        return null;
    }

    static {
        compilers = new ArrayList<CompilerDescription>();
        compilers.add(new JavacCompilerDescription());
        compilerOptionPanelTreeState = null;
    }
}

