/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.parser.java.v2.JavaParser;
import oracle.javatools.parser.java.v2.JdkVersion;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdevimpl.java.types.JavaTypeParser;
import oracle.jdevimpl.java.types.JavaTypeTable;

final class JotParser
extends JavaTypeParser {
    private final URL root;
    private JavaManager javaManager;

    public JotParser(URL root) {
        this.root = root;
    }

    private synchronized JavaManager getJavaManager() {
        if (this.javaManager == null) {
            this.javaManager = JavaManager.getInstance(new URLPath(), new URLPath(this.root));
        }
        return this.javaManager;
    }

    @Override
    public Collection<JavaTypeParser.JavaType> getTypes(URL url) {
        if (JavaTypeTable.isJavaSourceFile(url)) {
            return this.getTypesFromSource(url);
        }
        return this.getTypes(this.getJavaManager(), url);
    }

    @Override
    public Collection<JavaTypeParser.JavaType> getTypes(ReadTextBuffer buffer, URL url) {
        ArrayList<JavaTypeParser.JavaType> out = new ArrayList<JavaTypeParser.JavaType>();
        this.getTypes(buffer, url, out);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTypes(ReadTextBuffer buffer, URL url, Collection<JavaTypeParser.JavaType> out) {
        buffer.readLock();
        try {
            JavaFile file = JavaParser.lightParse((ReadTextBuffer)buffer, (URL)url, null, (JdkVersion)JdkVersion.getMaxVersion());
            if (file != null) {
                this.getTypes(file, out);
            }
        }
        finally {
            buffer.readUnlock();
        }
    }

    @Override
    public synchronized void dispose() {
        if (this.javaManager != null) {
            this.javaManager.getCacheSupport().flushCache();
        }
    }

    private Collection<JavaTypeParser.JavaType> getTypes(JavaManager javaManager, URL url) {
        JavaFile file = javaManager.getFile(url);
        if (file != null) {
            return this.getTypes(file);
        }
        return Collections.emptySet();
    }

    private Collection<JavaTypeParser.JavaType> getTypes(JavaFile file) {
        ArrayList<JavaTypeParser.JavaType> out = new ArrayList<JavaTypeParser.JavaType>();
        this.getTypes(file, out);
        return out;
    }

    private void getTypes(JavaFile file, Collection<JavaTypeParser.JavaType> out) {
        for (JavaClass type : file.getClasses()) {
            this.processTypes(type, out);
        }
    }

    private void processTypes(JavaClass type, Collection<JavaTypeParser.JavaType> types) {
        if (!type.isAnonymousClass() && !type.isLocalClass()) {
            String qname = type.getQualifiedName();
            String pkg = type.getPackageName();
            String name = qname.substring(pkg.length() + 1);
            types.add(new JavaTypeParser.JavaType(name, pkg, this.getModifiers((JavaType)type)));
            for (JavaClass subtype : type.getDeclaredClasses()) {
                if (!URLFileSystem.equals((URL)subtype.getFile().getURL(), (URL)type.getFile().getURL())) continue;
                this.processTypes(subtype, types);
            }
        }
    }

    private int getModifiers(JavaType type) {
        int modifiers = 0;
        if (type.isInterface()) {
            modifiers |= 0x200;
        }
        if (type.isAnnotation()) {
            modifiers |= 0x2000;
        }
        if (type.isEnum()) {
            modifiers |= 0x4000;
        }
        if (type.isAbstract()) {
            modifiers |= 0x400;
        }
        if (type.isFinal()) {
            modifiers |= 0x10;
        }
        if (type.isStatic()) {
            modifiers |= 8;
        }
        if (type.isPublic()) {
            modifiers |= 1;
        }
        if (type.isProtected()) {
            modifiers |= 4;
        }
        if (type.isPrivate()) {
            modifiers |= 2;
        }
        return modifiers;
    }

    private Collection<JavaTypeParser.JavaType> getTypesFromSource(URL url) {
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node instanceof TextNode) {
                TextNode textNode = (TextNode)node;
                ArrayList<JavaTypeParser.JavaType> out = new ArrayList<JavaTypeParser.JavaType>();
                if (!this.getTypesFromNode(textNode, url, out)) {
                    this.getTypesFromFile(textNode, url, out);
                }
                return out;
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return Collections.emptySet();
    }

    private boolean getTypesFromNode(final TextNode textNode, final URL url, final Collection<JavaTypeParser.JavaType> out) {
        final boolean[] success = new boolean[]{false};
        if (textNode.isOpen()) {
            textNode.tryRunUnderReadLock(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block7: {
                        TextBuffer buffer = textNode.tryAcquireTextBuffer();
                        if (buffer != null) {
                            try {
                                if (!buffer.tryReadLock()) break block7;
                                try {
                                    JotParser.this.getTypes((ReadTextBuffer)buffer, url, out);
                                    success[0] = true;
                                }
                                finally {
                                    buffer.readUnlock();
                                }
                            }
                            finally {
                                textNode.releaseTextBuffer();
                            }
                        }
                    }
                }
            });
        }
        return success[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTypesFromFile(TextNode textNode, URL url, Collection<JavaTypeParser.JavaType> out) {
        ReadTextBuffer buffer = this.getTextBuffer(textNode);
        buffer.readLock();
        try {
            this.getTypes(buffer, url, out);
        }
        finally {
            buffer.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadTextBuffer getTextBuffer(TextNode node) {
        TextBuffer textBuffer;
        block6: {
            InputStream is = null;
            try {
                URL url = node.getURL();
                is = URLFileSystem.openInputStream((URL)url);
                InputStreamReader isr = new InputStreamReader(is, node.getLoadEncoding());
                TextBuffer textBuffer2 = TextBufferFactory.createArrayTextBuffer();
                textBuffer2.read((Reader)isr);
                textBuffer = textBuffer2;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            is.close();
        }
        return textBuffer;
    }
}

