/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.view.View;
import oracle.javatools.buffer.GuardedTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.CommonUtilities;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaHasType;
import oracle.javatools.parser.java.v2.model.JavaIsGeneric;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaTypeVariable;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.JavaWildcardType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMemberVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.UnresolvedType;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.expression.CompiledTmpVariable;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.util.BindingContext;
import oracle.jdeveloper.java.legacy.JotNames;
import oracle.jdeveloper.java.util.SourceUtils;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdevimpl.java.JavaArb;
import oracle.jdevimpl.java.JavaHelper;

public class CodeGenUtil {
    private CodeGenUtil() {
    }

    public static String getSignature(JavaField field) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(field.getName());
        buffer.append(" : ");
        buffer.append(CodeGenUtil.resolveName((JavaHasType)field, true));
        return buffer.toString();
    }

    public static String getSignature(JavaMethod method) {
        Collection parameters;
        StringBuffer buffer = new StringBuffer();
        if (!method.isConstructor()) {
            buffer.append(method.getName());
        }
        if ((parameters = method.getParameters()).isEmpty()) {
            buffer.append("()");
        } else {
            String delimiter = "(";
            Iterator p = parameters.iterator();
            while (p.hasNext()) {
                buffer.append(delimiter);
                JavaVariable parameter = (JavaVariable)p.next();
                buffer.append(CodeGenUtil.resolveName((JavaHasType)parameter, true));
                delimiter = ", ";
            }
            buffer.append(')');
        }
        if (!method.isConstructor()) {
            buffer.append(" : ");
            buffer.append(CodeGenUtil.resolveName((JavaHasType)method, true));
        }
        return buffer.toString();
    }

    public static SourceMethod implementMethod(JavaMethod method, SourceClass cls, int modifiers, boolean copyJavadoc, boolean addOverride, SourceElement siblingElement, boolean before) {
        SourceFile file = cls.getOwningSourceFile();
        SourceFactory factory = file.getFactory();
        BindingContext bindingContext = new BindingContext(file.getProvider(), (JavaIsGeneric)method, (JavaType)cls);
        String methodName = method.getName();
        int mods = modifiers & 0xFFFFFBFF & 0xFFFFFEFF;
        if ((modifiers & 0x200) != 512) {
            mods &= 0xFFFFFDFF;
        }
        SourceMethod newMethod = method.isConstructor() ? SourceUtils.addConstructor((SourceClass)cls, (int)mods, (SourceElement)siblingElement, (boolean)before) : SourceUtils.addMethod((SourceClass)cls, (String)CodeGenUtil.resolveName((JavaHasType)method, false), (String)methodName, (int)mods, (SourceElement)siblingElement, (boolean)before);
        if (!JavaHelper.isRaw((JavaType)method.getOwningClass())) {
            CodeGenUtil.addTypeParameters(factory, method, newMethod);
        }
        String[] parameterNames = CodeGenUtil.addFormalParameters(method, newMethod, bindingContext);
        SourceBlock body = newMethod.getBlock();
        if (body != null) {
            SourceUtils.addLineComment((SourceBlock)body, (String)(" TODO " + JavaArb.getString(389)));
            if (method.isConstructor()) {
                if (parameterNames.length > 0 || CodeGenUtil.superHasZeroLenConstr((JavaType)cls)) {
                    SourceUtils.addMethodCallStatement((SourceBlock)body, (String)"", (String)"super", (String[])parameterNames);
                }
            } else {
                JavaClass owningClass = method.getOwningClass();
                boolean canCallSuper = owningClass != null && !owningClass.isInterface();
                JavaType returnType = method.getReturnType();
                if (returnType != null) {
                    if (returnType.getQualifiedName().equals("void")) {
                        if (!method.isAbstract() && canCallSuper) {
                            SourceUtils.addMethodCallStatement((SourceBlock)body, (String)"super", (String)methodName, (String[])parameterNames);
                        }
                    } else if (!method.isAbstract() && canCallSuper) {
                        SourceExpression initializer = SourceUtils.createMethodCall((SourceBlock)body, (String)"super", (String)methodName, (String[])parameterNames);
                        SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                        returnStatement.addSelf((SourceElement)body);
                    } else {
                        JavaType boundType = bindingContext.bind(returnType);
                        SourceExpression initializer = JavaHelper.getDefaultInitializer(factory, boundType);
                        SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                        returnStatement.addSelf((SourceElement)body);
                        SourceTypeReference newReturnType = factory.createType(boundType.getQualifiedName());
                        newMethod.setSourceReturnType(newReturnType);
                    }
                } else {
                    UnresolvedType unresolvedType = method.getUnresolvedType();
                    SourceExpression initializer = JavaHelper.getDefaultInitializer(factory, unresolvedType);
                    SourceReturnStatement returnStatement = factory.createReturnStatement(initializer);
                    returnStatement.addSelf((SourceElement)body);
                }
            }
        }
        CodeGenUtil.addThrowsClause(method, newMethod);
        if (copyJavadoc) {
            CodeGenUtil.addJavadocComments(method, file, newMethod);
        }
        if (addOverride && method.isAbstract()) {
            boolean addAnnotation = true;
            JavaProvider provider = file.getProvider();
            if (provider != null) {
                byte javaVersion = CommonUtilities.provider2jdkVersion((JavaProvider)provider);
                JavaClass owningClass = method.getOwningClass();
                if (owningClass.isInterface() && javaVersion < 4 || javaVersion < 3) {
                    addAnnotation = false;
                }
            }
            if (addAnnotation) {
                SourceAnnotation annotation = factory.createAnnotation("Override");
                annotation.addSelf((SourceElement)newMethod);
            }
        }
        return newMethod;
    }

    private static String[] addFormalParameters(JavaMethod originalMethod, SourceMethod newMethod, BindingContext bindingContext) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Collection parameters = originalMethod.getParameters();
        for (JavaVariable variable : parameters) {
            String parameterType;
            if (variable instanceof CompiledTmpVariable) continue;
            JavaType type = variable.getResolvedType();
            if (type != null) {
                Object boundType = bindingContext.bind(type);
                if (boundType.getElementKind() == 11) {
                    Collection bounds = ((JavaWildcardType)boundType).getLowerBounds();
                    if (bounds == null || bounds.isEmpty()) {
                        bounds = ((JavaWildcardType)boundType).getUpperBounds();
                    }
                    boundType = bounds == null || bounds.isEmpty() ? boundType.getTypeErasure() : (JavaType)bounds.iterator().next();
                }
                parameterType = boundType.getQualifiedName();
            } else {
                parameterType = variable.getUnresolvedType().getSimplifiedName();
            }
            String parameterName = CodeGenUtil.getParameterName(variable, parameterNames);
            parameterNames.add(parameterName);
            SourceUtils.addMethodParameter((SourceMethod)newMethod, (String)parameterType, (String)parameterName);
        }
        String[] names = new String[parameterNames.size()];
        return parameterNames.toArray(names);
    }

    private static void addTypeParameters(SourceFactory factory, JavaMethod originalMethod, SourceMethod newMethod) {
        for (JavaTypeVariable methodTypeParameter : originalMethod.getTypeParameters()) {
            Collection parameterBounds;
            SourceTypeReference[] newMethodParameterBounds = null;
            int counter = 0;
            if (methodTypeParameter.isSourceElement()) {
                parameterBounds = ((SourceTypeParameter)methodTypeParameter).getSourceBounds();
                newMethodParameterBounds = new SourceTypeReference[parameterBounds.size()];
                for (JavaType parameterBound : parameterBounds) {
                    if (parameterBound.getResolvedType() != null) {
                        newMethodParameterBounds[counter++] = factory.createType(parameterBound.getResolvedType().getRawName());
                        continue;
                    }
                    newMethodParameterBounds[counter++] = factory.createType(parameterBound.getName());
                }
            } else {
                parameterBounds = methodTypeParameter.getBounds();
                newMethodParameterBounds = new SourceTypeReference[parameterBounds.size()];
                for (JavaType parameterBound : parameterBounds) {
                    newMethodParameterBounds[counter++] = factory.createType(parameterBound.getRawName());
                }
            }
            SourceTypeParameter createTypeParameter = factory.createTypeParameter(methodTypeParameter.getName(), newMethodParameterBounds);
            createTypeParameter.addSelf((SourceElement)newMethod);
        }
    }

    private static void addThrowsClause(JavaMethod originalMethod, SourceMethod newMethod) {
        Collection thrown = originalMethod.getExceptions();
        if (!thrown.isEmpty()) {
            for (JavaType excptnType : thrown) {
                SourceUtils.addThrows((SourceMethod)newMethod, (String)excptnType.getQualifiedName());
            }
        }
    }

    private static void addJavadocComments(JavaMethod method, SourceFile file, SourceMethod newMethod) {
        SourceDocComment cmt;
        SourceMethod srcMethod = (SourceMethod)method.getSourceElement();
        if (srcMethod != null && (cmt = srcMethod.getDocComment()) != null) {
            try {
                SourceDocComment sourceComment = (SourceDocComment)cmt.cloneSelf(file);
                sourceComment.addSelf((SourceElement)newMethod);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String resolveName(JavaHasType hasType, boolean simplified) {
        JavaType type = hasType.getResolvedType();
        if (type != null) {
            return simplified ? type.getUnqualifiedName() : type.getQualifiedName();
        }
        return hasType.getUnresolvedType().getSimplifiedName();
    }

    private static String getParameterName(JavaVariable variable, List paramNames) {
        String name;
        SourceVariable sourceVariable = (SourceVariable)variable.getSourceElement();
        String p = sourceVariable != null ? ((name = sourceVariable.getName()).length() == 0 ? CodeGenUtil.getDefaultParamName(variable) : name) : CodeGenUtil.getDefaultParamName(variable);
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String pName = prefs.getParameterName(p);
        if (paramNames.contains(pName)) {
            int i = 1;
            int len = p.length();
            String prefix = Character.isDigit(p.charAt(len - 1)) ? p + "_" + i : p;
            String s = prefs.getParameterName(prefix);
            while (paramNames.contains(s)) {
                s = prefix + ++i;
            }
            return s;
        }
        return pName;
    }

    private static String getDefaultParamName(JavaVariable variable) {
        String s;
        String paramName;
        JavaType type = variable.getResolvedType();
        if (type == null) {
            String typeName = variable.getUnresolvedType().getSimplifiedName();
            paramName = CodeGenUtil.toParamName(typeName);
        } else {
            int bracket;
            String qName = type.getTypeErasure().getQualifiedName();
            String typeName = CodeGenUtil.toParamName(qName);
            paramName = type.isPrimitive() ? typeName.substring(0, 1) : (type.isArray() ? ((bracket = typeName.indexOf("[")) != -1 ? typeName.substring(0, bracket) : typeName.substring(0, 1)) : typeName);
        }
        if (JotNames.isValidIdentifier(paramName)) {
            return paramName;
        }
        if (paramName.length() > 1 && JotNames.isValidIdentifier(s = paramName.substring(0, 1))) {
            return s;
        }
        return "param";
    }

    public static String getParameterName(String defaultName, Set inUse) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, defaultName);
        n = prefs.getParameterName(n);
        return CodeGenUtil.generateUniqueName(n, inUse);
    }

    public static String generateUniqueName(String name, Set inUse) {
        int i = 1;
        String n = name;
        while (inUse.contains(n)) {
            n = name + i++;
        }
        return n;
    }

    public static String getFieldName(String name, SourceClass srcClass) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getFieldName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, Collections.EMPTY_SET) : n;
    }

    public static String getStaticFieldName(String name, SourceClass srcClass) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getStaticFieldName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, Collections.EMPTY_SET) : n;
    }

    public static String getLocalVariableName(String name, SourceClass srcClass, Set inUse) {
        CodingStyleOptions prefs = CodeGenUtil.getCodingStyleOptions();
        String n = CodeGenUtil.trim(prefs, name);
        n = prefs.getLocalVariableName(n);
        return srcClass != null ? CodeGenUtil.ensureNameIsUniqueInClass(n, srcClass, inUse) : n;
    }

    private static String ensureNameIsUniqueInClass(String name, SourceClass srcClass, Set inUse) {
        String n = name;
        int i = 1;
        while (inUse.contains(n) || srcClass.getField(n) != null) {
            n = name + i++;
        }
        return n;
    }

    private static String trim(CodingStyleOptions prefs, String name) {
        String prefix;
        String normalPrefix = prefs.getFieldPrefix();
        String normalSuffix = prefs.getFieldSuffix();
        String staticPrefix = prefs.getStaticFieldPrefix();
        String staticSuffix = prefs.getStaticFieldSuffix();
        String string = normalPrefix != null && name.startsWith(normalPrefix) ? normalPrefix : (prefix = staticPrefix != null && name.startsWith(staticPrefix) ? staticPrefix : null);
        String suffix = normalSuffix != null && name.startsWith(normalSuffix) ? normalSuffix : (staticSuffix != null && name.startsWith(staticSuffix) ? staticSuffix : null);
        return CodeGenUtil.trim(name, prefix, suffix);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String trim(String name, String prefix, String suffix) {
        if (prefix != null) {
            if (suffix == null) return name.substring(prefix.length());
            if (name.length() <= prefix.length() + suffix.length()) return name;
            return name.substring(prefix.length(), name.length() - suffix.length());
        }
        if (suffix == null) return name;
        return name.substring(0, name.length() - suffix.length());
    }

    private static CodingStyleOptions getCodingStyleOptions() {
        CodingStyleManager manager = CodingStyleManager.getCodingStyleManager();
        return manager.getCodingStyleOptions();
    }

    private static String toParamName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        String name = lastDot != -1 ? qualifiedName.substring(lastDot + 1) : qualifiedName;
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static boolean superHasZeroLenConstr(JavaType type) {
        JavaType superType = type.getSuperclass();
        if (superType != null) {
            return superType.getDeclaredConstructor(null) != null;
        }
        return false;
    }

    public static final SourceElementLocation findSourceElementLocation(Context context, SourceFile sourceFile) {
        SourceElementLocation END_OF_CLASS = new SourceElementLocation(null, false);
        if (context == null || sourceFile == null) {
            return END_OF_CLASS;
        }
        int currentOffset = CodeGenUtil.getCurrentOffset(context);
        if (currentOffset == -1) {
            return END_OF_CLASS;
        }
        EnumSet<SourceFile.ElementAtMask> mask = EnumSet.of(SourceFile.ElementAtMask.AFTER, SourceFile.ElementAtMask.ALL);
        SourceElement e = sourceFile.getElementAt(currentOffset, mask);
        SourceClass enclosingType = CommonUtilities.getEnclosingType((SourceElement)e);
        if (enclosingType == null) {
            return END_OF_CLASS;
        }
        SourceElementLocation res = END_OF_CLASS;
        SourceClassBody body = enclosingType.getSourceBody();
        List bodyChildren = body.getChildren(458752);
        GuardedTextBuffer guardedTextBuffer = CodeGenUtil.getGuardedBuffer(context);
        ListIterator iter = bodyChildren.listIterator(bodyChildren.size());
        boolean precedingElementFound = false;
        while (iter.hasPrevious()) {
            SourceElement member = (SourceElement)iter.previous();
            if ((member.getStartOffset() > currentOffset || member.getEndOffset() < currentOffset) && member.getEndOffset() >= currentOffset && (!(member instanceof SourceMemberVariable) || !((SourceMemberVariable)member).isEnumConstant())) continue;
            precedingElementFound = true;
            break;
        }
        if (!precedingElementFound) {
            SourceElement firstElement = null;
            if (iter.hasNext()) {
                firstElement = (SourceElement)iter.next();
            }
            return new SourceElementLocation(firstElement, true);
        }
        while (iter.hasNext()) {
            SourceElement sourceElement = (SourceElement)iter.next();
            if (guardedTextBuffer != null && guardedTextBuffer.isOffsetGuarded(sourceElement.getEndOffset() - 1)) continue;
            res = new SourceElementLocation(sourceElement, false);
            break;
        }
        return res;
    }

    private static GuardedTextBuffer getGuardedBuffer(Context context) {
        TextBuffer textBuffer;
        CodeEditor editor;
        BasicEditorPane basicEditorPane;
        View view = context.getView();
        if (view instanceof CodeEditor && (basicEditorPane = (editor = (CodeEditor)view).getFocusedEditorPane()) != null && (textBuffer = basicEditorPane.getTextBuffer()) instanceof GuardedTextBuffer) {
            return (GuardedTextBuffer)textBuffer;
        }
        return null;
    }

    private static int getCurrentOffset(Context context) {
        View view = context.getView();
        if (view instanceof CodeEditor) {
            CodeEditor editor = (CodeEditor)view;
            return editor.getCaretPosition();
        }
        return -1;
    }

    public static final class SourceElementLocation {
        public final SourceElement sibling;
        public final boolean addBefore;

        public SourceElementLocation(SourceElement sibling, boolean addBefore) {
            this.sibling = sibling;
            this.addBefore = addBefore;
        }
    }
}

