/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.editor.Editor;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.TextElement;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourcePackage;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JavaSourceNode;

public class ElementFinder {
    private ElementFinder() {
    }

    public static SourceClass getOwningClassFromContext(Context context) {
        Project project;
        if (context != null && (project = context.getProject()) != null && context.getNode() instanceof JavaSourceNode) {
            URL url;
            JavaManager javaManager;
            SourceFile file;
            View view = context.getView();
            if (view instanceof Editor) {
                Element element = context.getElement();
                if (element != null && element.getData() instanceof SourceElement) {
                    return ElementFinder.getParentClass((SourceElement)element.getData());
                }
            } else if (view instanceof ExplorerWindow && (file = (javaManager = JavaManager.getJavaManager(project)).getSourceFile(url = context.getNode().getURL())) != null) {
                try {
                    int offset;
                    SourceClass parent;
                    Element element = context.getElement();
                    if (element instanceof TextElement && (parent = ElementFinder.getParentClass(file.getElementAt(offset = ((TextElement)element).getStartOffset()))) != null) {
                        return parent;
                    }
                    return file.getSourcePrimaryClass();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static SourceClass getParentClass(SourceElement element) {
        while (element != null && !(element instanceof SourceClass) && !(element instanceof SourceFile)) {
            element = element.getParent();
        }
        if (element instanceof SourceClass) {
            return (SourceClass)element;
        }
        if (element instanceof SourceFile) {
            return ((SourceFile)element).getSourcePrimaryClass();
        }
        return null;
    }

    public static SourceElement getElementAt(Context context) {
        SourceElement element = null;
        try {
            Element selection;
            View view = context.getView();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            URL url = context.getNode().getURL();
            SourceFile file = javaManager.getSourceFile(url);
            if (view instanceof CodeEditor) {
                CodeEditor editor = (CodeEditor)view;
                int offset = editor.getCaretPosition();
                element = ElementFinder.getElementAt(file, offset);
            } else if (view instanceof ExplorerWindow && (selection = context.getElement()) instanceof TextElement) {
                int offset = ((TextElement)selection).getStartOffset();
                element = ElementFinder.getElementAt(file, offset);
            }
        }
        catch (Exception e) {
            element = null;
            Assert.printStackTrace((Throwable)e);
        }
        return element;
    }

    private static SourceElement getElementAt(SourceFile file, int offset) {
        for (SourceElement element = file.getElementAt(offset); element != null; element = element.getParent()) {
            if (element instanceof SourceClassInitializer) {
                return null;
            }
            if (element instanceof SourceMember) {
                SourceClassBody body;
                int startOffset;
                if (element instanceof SourceClass && offset > (startOffset = (body = ((SourceClass)element).getSourceBody()).getStartOffset())) {
                    return null;
                }
                if (!(element instanceof SourceFieldVariable)) {
                    return element;
                }
            }
            if (element instanceof SourceBlock) {
                return null;
            }
            if (!(element instanceof SourcePackage)) continue;
            return element;
        }
        return null;
    }
}

