/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.java.util;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.CacheSupport;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.refactoring.util.MakeWritableHelper;
import oracle.jdeveloper.util.Helpers;

public class JavaCommandSupport {
    private final Map<SourceFile, SourceTransaction> _transactions = new HashMap<SourceFile, SourceTransaction>();
    private final Set<Node> _affectedNodes = new HashSet<Node>();
    private final Map<URL, Set<String>> _originalClassNames = new HashMap<URL, Set<String>>();
    private HashMap _caretPositionings;

    public final void repositionCaret(CodeEditor codeEditor, SourceElement sourceElement, boolean afterElement) {
        CaretPositioning caretPositioning = new CaretPositioning(codeEditor, sourceElement, afterElement);
        if (this._caretPositionings == null) {
            this._caretPositionings = new HashMap(1);
        }
        this._caretPositionings.put(codeEditor, caretPositioning);
    }

    public final void addAffectedURL(URL url) {
        this._affectedNodes.add(NodeFactory.findOrCreateOrFail((URL)url));
    }

    private void addOriginalClassNames(URL url, SourceFile sourceFile) {
        String[] classNames = Helpers.getClasses((JavaFile)sourceFile);
        HashSet<String> classNameSet = new HashSet<String>();
        for (String className : classNames) {
            classNameSet.add(className);
        }
        this._originalClassNames.put(url, classNameSet);
    }

    public final SourceTransaction beginTransaction(SourceElement sourceElement) {
        SourceFile sourceFile = sourceElement.getOwningSourceFile();
        SourceTransaction sourceTransaction = this._transactions.get(sourceFile);
        if (sourceTransaction == null) {
            TextBuffer textBuffer = sourceFile.getTextBuffer();
            textBuffer.setReadOnly(false);
            sourceTransaction = sourceFile.beginTransaction();
            this._transactions.put(sourceFile, sourceTransaction);
            this.transactionStarted(sourceTransaction);
            URL url = sourceFile.getURL();
            if (url != null) {
                this.addAffectedURL(url);
                this.addOriginalClassNames(url, sourceFile);
            }
        }
        return sourceTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean commit(Context context, String transactionName) throws Exception {
        boolean ret = false;
        Command command = this.createCommand(context, transactionName);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        try {
            ret = commandProcessor.invoke(command) == 0;
        }
        finally {
            if (!ret) {
                for (Node node : this._affectedNodes) {
                    TextNode textNode;
                    TextBuffer textBuffer;
                    if (!node.isReadOnly() || !(node instanceof TextNode) || (textBuffer = (textNode = (TextNode)node).acquireTextBuffer()).isReadOnly()) continue;
                    textBuffer.setReadOnly(true);
                }
            }
        }
        return ret;
    }

    public final void abort() {
        Collection<SourceTransaction> sourceTransactions = this._transactions.values();
        for (SourceTransaction sourceTransaction : sourceTransactions) {
            sourceTransaction.abort();
        }
        this._affectedNodes.clear();
        this._transactions.clear();
        this._originalClassNames.clear();
    }

    protected void transactionStarted(SourceTransaction transaction) {
    }

    protected Command createCommand(Context context, String transactionName) {
        return new BaseCommand(context, transactionName, this){

            @Override
            protected void fireBeforeCommandEvent() {
            }

            @Override
            protected void fireAfterCommandEvent() {
            }

            @Override
            protected void fireBeforeUndoEvent() {
            }

            @Override
            protected void fireAfterUndoEvent() {
            }

            @Override
            protected Collection<URL> createdUrls() {
                return null;
            }

            @Override
            protected Collection<URL> deletedUrls() {
                return null;
            }

            @Override
            protected boolean isDeletedFile(URL url) {
                return false;
            }

            @Override
            protected boolean isCreatedFile(URL url) {
                return false;
            }

            @Override
            protected void openFiles(Collection<URL> files) {
            }

            @Override
            protected void createTodos() {
            }
        };
    }

    private static class CaretPositioning {
        private CodeEditor _codeEditor;
        private SourceElement _element;
        private boolean _after;

        public CaretPositioning(CodeEditor codeEditor, SourceElement element, boolean after) {
            this._codeEditor = codeEditor;
            this._element = element;
            this._after = after;
        }

        public void repositionCaret() {
            int offset = this._after ? this._element.getEndOffset() : this._element.getStartOffset();
            if (offset != -1) {
                this._codeEditor.setCaretPosition(offset);
            }
        }
    }

    protected static abstract class BaseCommand
    extends Command {
        private Node[] _affectedNodes;
        private Map<URL, Set<String>> _originalClassNames;
        private JavaCommandSupport _pendingCommand;
        private UndoableEdit[] _undoableEdits;
        private Map<URL, String> _createdFiles;
        private Map<URL, Set<String>> _createdClassNames;
        private Map<URL, String> _deletedFiles;
        private int _caretPositionBefore = -1;
        private int _caretPositionAfter = -1;
        private WeakReference _codeEditorReference;
        private boolean _isDone = false;

        public BaseCommand(Context context, String name, JavaCommandSupport commandSupport) {
            super(-1, 3, name);
            this.setContext(context);
            Set affectedNodes = commandSupport._affectedNodes;
            this._affectedNodes = affectedNodes.toArray(new Node[affectedNodes.size()]);
            this._originalClassNames = commandSupport._originalClassNames;
            this._pendingCommand = commandSupport;
        }

        protected final Map<URL, String> createdFiles() {
            return Collections.unmodifiableMap(this._createdFiles);
        }

        protected final JavaCommandSupport pendingCommand() {
            return this._pendingCommand;
        }

        protected abstract void fireBeforeCommandEvent();

        protected abstract void fireAfterCommandEvent();

        protected abstract void fireBeforeUndoEvent();

        protected abstract void fireAfterUndoEvent();

        protected abstract Collection<URL> createdUrls();

        protected abstract Collection<URL> deletedUrls();

        protected abstract boolean isDeletedFile(URL var1);

        protected abstract boolean isCreatedFile(URL var1);

        protected abstract void openFiles(Collection<URL> var1);

        protected abstract void createTodos();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int doit() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                List<Node> nodesToSave = this.getNodesToSave();
                try {
                    this.fireBeforeCommandEvent();
                    if (this._pendingCommand == null) {
                        this.redo();
                    } else {
                        CodeEditor codeEditor;
                        SourceElement highlightedElement = null;
                        Context context = this.getContext();
                        View view = context.getView();
                        if (view instanceof CodeEditor && view.isVisible()) {
                            Element[] selected;
                            codeEditor = (CodeEditor)view;
                            this._caretPositionBefore = codeEditor.getCaretPosition();
                            int start = codeEditor.getSelectionStart();
                            int end = codeEditor.getSelectionEnd();
                            if (end > start && (selected = codeEditor.getSelection()).length == 1 && selected[0].getData() != null && selected[0].getData() instanceof SourceElement && (highlightedElement = (SourceElement)selected[0].getData()).getStartOffset() != -1) {
                                this._pendingCommand.repositionCaret(codeEditor, highlightedElement, false);
                            }
                            this._codeEditorReference = new WeakReference<CodeEditor>(codeEditor);
                        } else {
                            codeEditor = null;
                        }
                        HashMap caretPositionings = this._pendingCommand._caretPositionings;
                        this.commitTransactions();
                        if (this._createdFiles != null) {
                            this.openFiles(this._createdFiles.keySet());
                        }
                        if (caretPositionings != null) {
                            Collection positionings = caretPositionings.values();
                            for (CaretPositioning caretPositioning : positionings) {
                                caretPositioning.repositionCaret();
                            }
                        }
                        if (codeEditor != null) {
                            this._caretPositionAfter = codeEditor.getCaretPosition();
                            if (highlightedElement != null) {
                                codeEditor.setSelectionEnd(highlightedElement.getEndOffset());
                            }
                        }
                    }
                    this.deleteURLs(this._deletedFiles);
                    this._isDone = true;
                    ret = 0;
                }
                finally {
                    this.saveAffectedNodes(nodesToSave);
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireAfterCommandEvent();
                }
            }
            return ret;
        }

        private void redo() throws IllegalAccessException, InstantiationException, IOException {
            CodeEditor codeEditor;
            if (this._createdFiles != null) {
                for (Map.Entry<URL, String> entry : this._createdFiles.entrySet()) {
                    this.createNode(entry.getKey(), entry.getValue());
                }
            }
            for (int i = 0; i < this._undoableEdits.length; ++i) {
                UndoableEdit undoableEdit = this._undoableEdits[i];
                undoableEdit.redo();
            }
            if (this._caretPositionAfter >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                codeEditor.setCaretPosition(this._caretPositionAfter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int undo() throws Exception {
            int ret = 1;
            if (this.prepareFiles()) {
                CacheSupport cacheSupport = this.beginCacheUse();
                List<Node> nodesToSave = this.getNodesToSave();
                this.fireBeforeUndoEvent();
                try {
                    CodeEditor codeEditor;
                    if (this._deletedFiles != null) {
                        for (Map.Entry<URL, String> entry : this._deletedFiles.entrySet()) {
                            this.createNode(entry.getKey(), entry.getValue());
                        }
                    }
                    for (int i = 0; i < this._undoableEdits.length; ++i) {
                        UndoableEdit undoableEdit = this._undoableEdits[i];
                        undoableEdit.undo();
                    }
                    this.deleteURLs(this._createdFiles);
                    if (this._caretPositionBefore >= 0 && this._codeEditorReference != null && (codeEditor = (CodeEditor)this._codeEditorReference.get()) != null) {
                        codeEditor.setCaretPosition(this._caretPositionBefore);
                    }
                    ret = 0;
                    this._isDone = false;
                }
                finally {
                    this.saveAffectedNodes(nodesToSave);
                    cacheSupport.endCacheUse();
                }
                if (ret == 0) {
                    this.fireAfterUndoEvent();
                }
            }
            return ret;
        }

        private List<Node> getNodesToSave() {
            ArrayList<Node> nodesToSave = new ArrayList<Node>();
            if (this._affectedNodes.length != 1 || !this.isCurrentEditorNode(this._affectedNodes[0])) {
                for (int i = 0; i < this._affectedNodes.length; ++i) {
                    Node node = this._affectedNodes[i];
                    if (node.isDirty()) continue;
                    nodesToSave.add(node);
                }
            }
            return nodesToSave;
        }

        private boolean isCurrentEditorNode(Node node) {
            Node editorNode;
            Context context;
            Editor editor;
            EditorManager editorManager = EditorManager.getEditorManager();
            return editorManager != null && (editor = editorManager.getCurrentEditor()) != null && (context = editor.getContext()) != null && (editorNode = context.getNode()) != null && editorNode.equals(node);
        }

        private boolean prepareFiles() {
            ArrayList nameList = new ArrayList();
            for (Map.Entry<URL, Set<String>> entry : this._originalClassNames.entrySet()) {
                if (this._deletedFiles != null && this._deletedFiles.containsKey(entry.getKey())) continue;
                nameList.addAll(entry.getValue());
            }
            if (this._createdClassNames != null) {
                for (Set set : this._createdClassNames.values()) {
                    nameList.addAll(set);
                }
            }
            String[] nameArray = nameList.toArray(new String[nameList.size()]);
            Helpers.removeClasses(this.context.getProject(), nameArray);
            URL[] uRLArray = new URL[this._affectedNodes.length];
            for (int i = 0; i < this._affectedNodes.length; ++i) {
                URL url;
                Node node = this._affectedNodes[i];
                uRLArray[i] = url = node.getURL();
            }
            return MakeWritableHelper.makeWritable((URL[])uRLArray);
        }

        private void deleteURLs(Map urls) throws IOException {
            if (urls != null) {
                for (URL url : urls.keySet()) {
                    Node node = NodeFactory.find((URL)url);
                    if (node != null) {
                        node.delete();
                        continue;
                    }
                    URLFileSystem.delete((URL)url);
                }
            }
        }

        public Node[] getAffectedNodes() {
            ArrayList<Object> ret;
            Collection<URL> excludeUrls;
            if (this._pendingCommand == null) {
                Map<URL, String> excludedMap = this._isDone ? this._deletedFiles : this._createdFiles;
                excludeUrls = excludedMap == null ? null : excludedMap.keySet();
            } else {
                excludeUrls = this.createdUrls();
            }
            if (excludeUrls != null) {
                ret = new ArrayList(this._affectedNodes.length);
                for (int i = 0; i < this._affectedNodes.length; ++i) {
                    Node affectedNode = this._affectedNodes[i];
                    URL url = affectedNode.getURL();
                    if (excludeUrls.contains(url)) continue;
                    ret.add(affectedNode);
                }
            } else {
                ret = new ArrayList<Node>(Arrays.asList(this._affectedNodes));
            }
            Node contextNode = this.context.getNode();
            ret.remove(contextNode);
            return ret.toArray(new Node[ret.size()]);
        }

        private CacheSupport beginCacheUse() {
            Context context = this.getContext();
            Project project = context.getProject();
            JavaManager javaManager = JavaManager.getJavaManager(project);
            CacheSupport cacheSupport = javaManager.getCacheSupport();
            cacheSupport.beginCacheUse();
            return cacheSupport;
        }

        private void commitTransactions() throws Exception {
            Map transactions = this._pendingCommand._transactions;
            Collection<URL> deletedURLs = this.deletedUrls();
            if (deletedURLs != null) {
                for (URL deletedURL : deletedURLs) {
                    this.addFileDeletion(deletedURL);
                }
            }
            ArrayList<UndoableEdit> undoableEdits = new ArrayList<UndoableEdit>();
            for (Map.Entry entry : transactions.entrySet()) {
                SourceFile sourceFile = (SourceFile)entry.getKey();
                URL url = sourceFile.getURL();
                if (this.isDeletedFile(url)) continue;
                SourceTransaction sourceTransaction = (SourceTransaction)entry.getValue();
                UndoableEdit undoableEdit = sourceTransaction.commit();
                if (this.isCreatedFile(url)) {
                    this.addFileCreation(sourceFile);
                    Node node = NodeFactory.find((URL)url);
                    node.save();
                    continue;
                }
                if (undoableEdit == null) continue;
                undoableEdits.add(undoableEdit);
            }
            this.createTodos();
            this._pendingCommand = null;
            this._undoableEdits = undoableEdits.toArray(new UndoableEdit[undoableEdits.size()]);
        }

        private void addFileCreation(SourceFile sourceFile) {
            URL url = sourceFile.getURL();
            if (url == null) {
                return;
            }
            String text = sourceFile.getText();
            if (this._createdFiles == null) {
                this._createdFiles = new HashMap<URL, String>(1);
            }
            this._createdFiles.put(url, text);
            String[] classNames = Helpers.getClasses((JavaFile)sourceFile);
            HashSet<String> classNameSet = new HashSet<String>();
            for (String className : classNames) {
                classNameSet.add(className);
            }
            if (this._createdClassNames == null) {
                this._createdClassNames = new HashMap<URL, Set<String>>();
            }
            this._createdClassNames.put(url, classNameSet);
        }

        private void addFileDeletion(URL url) {
            try {
                TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
                TextBuffer textBuffer = node.acquireTextBuffer();
                String text = textBuffer.getString(0, textBuffer.getLength());
                if (this._deletedFiles == null) {
                    this._deletedFiles = new HashMap<URL, String>(1);
                }
                this._deletedFiles.put(url, text);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void createNode(URL url, String text) throws IllegalAccessException, InstantiationException, IOException {
            char[] chars = text.toCharArray();
            TextNode node = (TextNode)NodeFactory.findOrCreate((URL)url);
            TextBuffer textBuffer = node.acquireTextBuffer();
            textBuffer.beginEdit();
            textBuffer.removeToEnd(0);
            textBuffer.append(chars);
            textBuffer.endEdit();
            node.releaseTextBuffer();
            node.save();
        }

        private void saveAffectedNodes(List<Node> affectedNodes) throws IOException {
            for (Node node : affectedNodes) {
                node.save();
            }
        }
    }
}

