/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import oracle.ide.hover.HoverBundle;
import oracle.javatools.util.PlatformUtils;

public final class HoverActivator {
    private final EnumSet<Modifier> modifiers;

    public HoverActivator(EnumSet<Modifier> modifiers) {
        this.modifiers = modifiers == null ? EnumSet.of(Modifier.NONE) : modifiers;
    }

    public HoverActivator(String string) {
        this.modifiers = EnumSet.of(Modifier.NONE);
        if (string == null || string.length() == 0) {
            return;
        }
        for (Modifier m : Modifier.values()) {
            if (!string.contains(m.name())) continue;
            this.modifiers.add(m);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Modifier m : this.modifiers) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(m.name());
        }
        return sb.toString();
    }

    public boolean isSuitable(boolean shiftDown, boolean controlDown, boolean altDown, boolean metaDown) {
        if (this.modifiers.contains((Object)Modifier.OFF)) {
            return false;
        }
        return shiftDown == this.modifiers.contains((Object)Modifier.SHIFT) && controlDown == this.modifiers.contains((Object)Modifier.CONTROL) && metaDown == this.modifiers.contains((Object)Modifier.META) && altDown == this.modifiers.contains((Object)Modifier.ALT);
    }

    public String getDisplayName() {
        return HoverActivator.getDisplayName(this.modifiers);
    }

    public static String getDisplayName(Collection<Modifier> modifiers) {
        if (modifiers.contains((Object)Modifier.OFF)) {
            return HoverBundle.get("OFF");
        }
        StringBuilder sb = new StringBuilder();
        if (modifiers.contains((Object)Modifier.CONTROL)) {
            sb.append(sb.length() == 0 ? HoverBundle.get("CONTROL") : HoverBundle.get("AND_CONTROL"));
        }
        if (modifiers.contains((Object)Modifier.SHIFT)) {
            sb.append(sb.length() == 0 ? HoverBundle.get("SHIFT") : HoverBundle.get("AND_SHIFT"));
        }
        if (modifiers.contains((Object)Modifier.ALT)) {
            sb.append(sb.length() == 0 ? HoverBundle.get("ALT") : HoverBundle.get("AND_ALT"));
        }
        if (modifiers.contains((Object)Modifier.META)) {
            if (PlatformUtils.isWindows()) {
                sb.append(sb.length() == 0 ? HoverBundle.get("WINDOWS") : HoverBundle.get("AND_WINDOWS"));
            } else if (PlatformUtils.isMac()) {
                sb.append(sb.length() == 0 ? HoverBundle.get("COMMAND") : HoverBundle.get("AND_COMMAND"));
            } else {
                sb.append(sb.length() == 0 ? HoverBundle.get("META") : HoverBundle.get("AND_META"));
            }
        }
        if (sb.length() == 0) {
            sb.append(HoverBundle.get("NONE"));
        }
        return sb.toString();
    }

    public Set<Modifier> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    public static enum Modifier {
        OFF,
        NONE,
        ALT,
        SHIFT,
        CONTROL,
        META;


        public String getDisplayName() {
            switch (this) {
                case OFF: {
                    return HoverBundle.get("OFF");
                }
                case NONE: {
                    return HoverBundle.get("NONE");
                }
                case CONTROL: {
                    return HoverBundle.get("CONTROL");
                }
                case ALT: {
                    return HoverBundle.get("ALT");
                }
                case SHIFT: {
                    return HoverBundle.get("SHIFT");
                }
                case META: {
                    if (PlatformUtils.isWindows()) {
                        return HoverBundle.get("WINDOWS");
                    }
                    if (PlatformUtils.isMac()) {
                        return HoverBundle.get("COMMAND");
                    }
                    return HoverBundle.get("META");
                }
            }
            return "";
        }
    }
}

