/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.hover;

import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;

public final class HoverableRegistry {
    private static Map<Component, List<Hoverable>> componentHoverableMap = new HashMap<Component, List<Hoverable>>();

    public static final void registerComponent(Component component, Hoverable hoverable) {
        List<Hoverable> hoverableList = componentHoverableMap.get(component);
        if (hoverableList == null) {
            hoverableList = new ArrayList<Hoverable>();
            componentHoverableMap.put(component, hoverableList);
        }
        if (!hoverableList.contains(hoverable)) {
            hoverableList.add(hoverable);
        }
    }

    @Deprecated
    public static final void unregisterComponent(Component component) {
        List<Hoverable> hoverableList = componentHoverableMap.get(component);
        if (hoverableList != null) {
            hoverableList.remove(component);
            if (hoverableList.isEmpty()) {
                componentHoverableMap.remove(component);
            }
        }
    }

    public static final void unregisterComponent(Component component, Hoverable hoverable) {
        List<Hoverable> hoverableList = componentHoverableMap.get(component);
        if (hoverableList != null) {
            hoverableList.remove(hoverable);
            if (hoverableList.isEmpty()) {
                componentHoverableMap.remove(component);
            }
        }
    }

    public static final Hover getHover(List<HoverFlavor> flavors, Component component, Point screenP) {
        List<Hoverable> hoverableList = componentHoverableMap.get(component);
        if (hoverableList == null || hoverableList.size() == 0) {
            return null;
        }
        for (Hoverable hoverable : hoverableList) {
            Hover hover = hoverable.hover((Point)screenP.clone(), flavors);
            if (hover == null) continue;
            return hover;
        }
        return null;
    }
}

