REM Copyright (c) 2012, Oracle and/or its affiliates. 
REM All rights reserved. 

create or replace package sqlserver_tsql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob);

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2);

end;
/

create or replace package body sqlserver_tsql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob) as
  language java
  name 'oracle.dbtools.babelfish.sqlserver.SQLServerTSQLTranslator.translateSQL(oracle.sql.CLOB,oracle.sql.CLOB[])';

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2) as
  language java
  name 'oracle.dbtools.babelfish.sqlserver.SQLServerTSQLTranslator.translateError(int,int[],java.lang.String[])';

end;
/
EXIT