-- Test Cube Dimension Alters

create analytic workspace gdimalter;

create cube dimension testdim1 
(level1 level, level2 level, level3 level, level4 level,
hierarchy1 hierarchy  (level1 child of level2 child of level3 child of level4),
hierarchy2 hierarchy (level2 child of level3))
analytic workspace gdimalter;

alter cube dimension testdim1 default hierarchy hierarchy2;

alter cube dimension testdim1 modify ( hierarchy1 hierarchy drop ( level3 level ), hierarchy1 hierarchy drop ( level4 level ) );

-- attribute cannot be both nls and indexed
alter cube dimension testdim1 
add (
  attr1 attribute varchar2(60) ALLOWAUTODATATYPECHANGE, 
  attr2 attribute varchar2(70) ALLOWAUTODATATYPECHANGE nls,
  attr3 attribute varchar2(70) ALLOWAUTODATATYPECHANGE indexed
);

alter cube dimension testdim1 modify (level1 level visible attributes (attr1, attr2, attr3) );

alter cube dimension testdim1 modify (level1 level visible attributes (drop attr1, attr2, attr3) );

alter cube dimension testdim1 modify (hierarchy1 hierarchy level1 level visible attributes (attr1, attr2, attr3) );

alter cube dimension testdim1 modify (hierarchy1 hierarchy level1 level visible attributes (drop attr1, attr2, attr3) );

alter cube dimension testdim1 
drop (
  attr2 ,
  attr3
);

alter cube dimension testdim1 modify (
    level1 level description ( 
     'LongDescription'='level1 ld', 
     'ShortDescription'='level1 sd', 
     'Description'='level1 desc' ) );
   
alter cube dimension testdim1 modify (
   attr1 attribute description ( 
    'LongDescription'='attr1 ld', 
    'ShortDescription'='attr1 sd', 
    'Description'='attr1 desc' ) );

alter cube dimension testdim1 modify (
   hierarchy1 hierarchy description ( 
    'LongDescription'='hier1 ld', 
    'ShortDescription'='hier1 sd', 
    'Description'='hier1 desc' ) );

drop cube dimension testdim1;

create cube dimension time19 time (
   calendar_quarter level
  ,"MONTH" level
  ,end_date end date attribute date ALLOWAUTODATATYPECHANGE
  ,time_span time span attribute number ALLOWAUTODATATYPECHANGE
  ,calendar hierarchy ( "MONTH" child of CALENDAR_QUARTER ) 
)
analytic workspace gdimalter;

alter cube dimension time19 time add (
   fiscal_quarter level
  ,fiscal hierarchy ( "MONTH" child of fiscal_quarter )
);
  
drop cube dimension time19 time;


create cube dimension channel19 
( total_channel level, channel level,
  standard hierarchy  (channel child of total_channel),
  short_description attribute varchar2(60) star ALLOWAUTODATATYPECHANGE,
  long_description attribute varchar2(60) star ALLOWAUTODATATYPECHANGE
)
analytic workspace gdimalter;


alter cube dimension channel19 modify (standard hierarchy 
 (
   channel map ( query "CHANNEL_DIM" key CHANNEL_DIM.CHANNEL_ID ( long_description attribute key CHANNEL_DIM.CHANNEL_DSC 
      , short_description attribute key CHANNEL_DIM.CHANNEL_DSC ) )
   child of   
   total_channel map ( query "CHANNEL_DIM" key CHANNEL_DIM.TOTAL_CHANNEL_ID ( long_description attribute key CHANNEL_DIM.TOTAL_CHANNEL_DSC 
    , short_description attribute key CHANNEL_DIM.TOTAL_CHANNEL_DSC ) )
 )   
);

drop cube dimension channel19;


CREATE CUBE DIMENSION TEST_ATTR_VISIBLE_DIM (
 LEVEL1 LEVEL description ( 'ShortDescription'='Level1' , 'LongDescription'='Level1' , 'Description'='Level1' ) 
 , LEVEL2 LEVEL VISIBLE ATTRIBUTES ( ATTRIBUTE1) 
  description ( 'ShortDescription'='Level2' , 'LongDescription'='Level2' , 'Description'='Level2' ) 
 , LEVEL3 LEVEL description ( 'ShortDescription'='Level3' , 'LongDescription'='Level3' , 'Description'='Level3' ) 
 , SHORT_DESCRIPTION SHORT DESCRIPTION ATTRIBUTE VARCHAR2(100) ALLOWAUTODATATYPECHANGE STAR VISIBLE ALL description ( 'ShortDescription'='Short Description' , 'LongDescription'='Short Description' , 'Description'='Short Description' ) 
 , LONG_DESCRIPTION LONG DESCRIPTION ATTRIBUTE VARCHAR2(100) ALLOWAUTODATATYPECHANGE STAR VISIBLE ALL description ( 'ShortDescription'='Long Description' , 'LongDescription'='Long Description' , 'Description'='Long Description' ) 
 , ATTRIBUTE1 ATTRIBUTE VARCHAR2(100) ALLOWAUTODATATYPECHANGE STAR description ( 'ShortDescription'='Attribute1' , 'LongDescription'='Attribute1' , 'Description'='Attribute1' ) 
 , HIERARCHY1 HIERARCHY DEFAULT ( LEVEL3  CHILD OF LEVEL2 VISIBLE ATTRIBUTES ( ATTRIBUTE1) 
   CHILD OF LEVEL1 ) description ( 'ShortDescription'='Hierarchy1' , 'LongDescription'='Hierarchy1' , 'Description'='Hierarchy1' ) 
 , VALUEHIER1 HIERARCHY VISIBLE ATTRIBUTES ( ATTRIBUTE1) 
  description ( 'ShortDescription'='ValueHier1' , 'LongDescription'='ValueHier1' , 'Description'='ValueHier1' ) 
 )
 ENFORCE STAR CONSISTENCY
description ( 'ShortDescription'='Test Attr Visible Dim' , 'LongDescription'='Test Attr Visible Dim' , 'Description'='Test Attr Visible Dim' ) 
 ANALYTIC WORKSPACE gdimalter;
 

ALTER CUBE DIMENSION TEST_ATTR_VISIBLE_DIM MODIFY (VALUEHIER1 VALUE HIERARCHY VISIBLE ATTRIBUTES (DROP ATTRIBUTE1) );
 

ALTER CUBE DIMENSION TEST_ATTR_VISIBLE_DIM MODIFY (VALUEHIER1 VALUE HIERARCHY VISIBLE ATTRIBUTES (ATTRIBUTE1) );
 

drop cube dimension TEST_ATTR_VISIBLE_DIM;

CREATE CUBE DIMENSION SORT_DIM_TEST1 (
 LEVEL1 LEVEL description ( 'ShortDescription'='Level1' , 'LongDescription'='Level1' , 'Description'='Level1' ) 
 , LEVEL2 LEVEL description ( 'ShortDescription'='Level2' , 'LongDescription'='Level2' , 'Description'='Level2' ) 
 , LEVEL3 LEVEL description ( 'ShortDescription'='Level3' , 'LongDescription'='Level3' , 'Description'='Level3' ) 
 , SHORT_DESCRIPTION SHORT DESCRIPTION ATTRIBUTE VARCHAR2(100) ALLOWAUTODATATYPECHANGE STAR VISIBLE ALL description ( 'ShortDescription'='Short Description' , 'LongDescription'='Short Description' , 'Description'='Short Description' ) 
 , LONG_DESCRIPTION LONG DESCRIPTION ATTRIBUTE VARCHAR2(100) ALLOWAUTODATATYPECHANGE STAR VISIBLE ALL description ( 'ShortDescription'='Long Description' , 'LongDescription'='Long Description' , 'Description'='Long Description' ) 
 , HIERARCHY1 HIERARCHY DEFAULT ( LEVEL3  CHILD OF LEVEL2  CHILD OF LEVEL1 ) description ( 'ShortDescription'='Hierarchy1' , 'LongDescription'='Hierarchy1' , 'Description'='Hierarchy1' ) 
 )
 ENFORCE STAR CONSISTENCY
 ORDER BY "SORT_DIM_TEST1".LONG_DESCRIPTION ASCENDING NULLS FIRST
 description ( 'ShortDescription'='sort dim test1' , 'LongDescription'='sort dim test1' , 'Description'='sort dim test1' ) 
 ANALYTIC WORKSPACE gdimalter;
 
ALTER CUBE DIMENSION SORT_DIM_TEST1 ORDER BY LONG_DESCRIPTION NOT ASCENDING NULLS FIRST;
 
ALTER CUBE DIMENSION SORT_DIM_TEST1 ORDER BY SHORT_DESCRIPTION NOT ASCENDING NOT NULLS FIRST;
 
ALTER CUBE DIMENSION SORT_DIM_TEST1 ORDER BY "null" NOT ASCENDING NOT NULLS FIRST;
 
drop cube dimension SORT_DIM_TEST1;

drop analytic workspace gdimalter;
