/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.command;

import javax.ide.menu.IDEAction;

/**
 * <tt>InvokeHandler</tt>s are responsible for performing an action in a
 * specific context.
 */
public interface InvokeHandler 
{
  /**
   * Invoke the specified action in the specified context.
   * 
   * @param action the action to invoke.
   * @param context the context in which to invoke the action.
   * 
   * @return true if the action was invoked by this handler.
   */
  boolean invoke( IDEAction action, Context context );
}
