/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.editor;

import java.util.EventObject;

import javax.ide.editor.Editor;

/**
 * The DocumentEvent is the parameter passed to the {@link EditorListener} 
 * methods when the state of {@link Editor} has changed. <p>
 *
 * The <code>EditorEvent</code> source is the editor instance whose state 
 * is changing. The convenience method {@link #getEditor} can be used to 
 * retrieve the editor instance.
 */
public final class EditorEvent extends EventObject
{
  /**
   * Constructor.
   *
   * @param editor the editor where the event happened.
   */
  public EditorEvent( Editor editor )
  {
    super(editor);
  }

  /**
   * Get the {@link Editor} where the event happened.
   * This is functionally equivalent to casting the result of getSource() to 
   * a <code>Editor</code> object.
   *
   * @return the {@link Editor} whose state has changed.
   */
  public Editor getEditor() 
  {
    return (Editor)getSource();
  }
}
