/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.extension.spi;

import javax.ide.util.MetaClass;

/**
 * Record of information identifying an object type. The information used 
 * to initialize this class comes from an extension manifest.  <p>
 *
 * The information kept in this class includes the object type identifier
 * and the object {@link MetaClass}. Object type identifiers are
 * unique labels given to objects declared in an extension manifest. 
 * By convention these labels are dash or dot separated strings. 
 * Sample identifiers can be found in the {@link javax.ide.IDEConstants} class.
 */
public class TypeInfo 
{
  private String _id;
  private MetaClass _mclass;

  /**
   * Constructor.
   */
  public TypeInfo() 
  {
  }

  /**
   * Get the object type identifier. 
   * @return The object type identifier.
   */
  public String getTypeIdentifier()
  {
    return _id;
  }

  /**
   * Set the object type identifier. 
   * @param id The object type identifier.
   */
  public void setTypeIdentifier( String id )
  {
    _id = id;
  }

  /**
   * Get the class of the object. 
   *
   * @return The object {@link MetaClass}.
   */
  public MetaClass getMetaClass()
  {
    return _mclass;
  }

  /**
   * Set the class of the object. 
   *
   * @param mclass The object class name.
   */
  public void setMetaClass( MetaClass mclass )
  {
    _mclass = mclass;
  }
}
