/*
 * Copyright 2005 by Oracle USA
 * 500 Oracle Parkway, Redwood Shores, California, 94065, U.S.A.
 * All rights reserved.
 */
package javax.ide.view;

import java.net.URI;
import javax.ide.command.Context;

/**
 * This interface gives clients a portable interface to control basic file
 * and directory selection dialogs.
 */
public interface URISelectionDialog 
{
  /**
   * Clients of the <code>URISelectionDialog</code> implement a 
   * <code>Validator</code> when they need to validate the selected URI(s) 
   * before the selection dialog is dismissed.
   */
  public interface Validator
  {
    /**
     * Method called when the user presses the OK button of the 
     * <code>URISelectionDialog</code>. 
     * @param uri the {@link URI}s to validate. 
     * @param context the current {@link Context}.
     * @return true if the selected URIs validated.
     */
    boolean validate( URI[] uri, Context context );
  }

  /**
   * Shows the dialog. 
   *
   * @return An integer value indicating whether the use pressed the OK, or 
   * Cancel button. The returned value can be checked against the constants:
   * {@link IDEDialogs#OK_ID} and {@link IDEDialogs#CANCEL_ID}.
   */
  int show();

  /**
   * Shows the dialog. 
   * @param validator An implementation of the <code>Validator</code> interface
   * that will be called to validate selected URIs.
   * @return An integer value indicating whether the use pressed the OK, or 
   * Cancel button. 
   */
  int show( Validator validator );

  /**
   * Gets any dialog result parameters as an array of objects.
   * @return URI[] An array of result URIs or an empty array
   */
  URI[] getResults();
}

