<?xml version="1.0"?>
<!--

 Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved. 

NAME
    kuatype.xsl
DESCRIPTION
    Convert sxml TYPE_SPEC  diff document to ALTER_XML document

MODIFIED        MM/DD/YY
    abodge      06/29/12 - Fix xmlns attribute problem
    rapayne     11/30/08 - when calling Datatype we need to flag as a type object.
    lbarton     07/10/08 - bug 5709159: SQL_LIST_ITEM subelements
    rapayne     05/8/08  - add method support.
    rapayne     04/15/08 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuacomm.xsl"/>
 <xsl:import href="kuatcol.xsl"/>
 <xsl:import href="kustyped.xsl"/>
 <!-- params for parse -->
 <xsl:param name="PRS_ALTERABLE">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_CLAUSE_TYPE">0</xsl:param>
 <xsl:param name="PRS_COLUMN_ATTRIBUTE">0</xsl:param>
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="DoLF">1</xsl:param>
 <!-- need to override the TEXT method set indirectly via kustyped.xsl 
       Note: this appears to cause 'xml version' tag to get generated!
 -->
 <xsl:output method="xml" indent="yes"/>
 <!-- Templates -->
 <xsl:template match="sxml:TYPE_SPEC">
  <!-- *******************************************************************
Template: TYPE_SPEC - top-level template for types.
******************************************************************** -->
  <xsl:element name="ALTER_XML" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <!-- Object type -->
   <xsl:element name="OBJECT_TYPE">TYPE_SPEC</xsl:element>
   <!-- Display schema.objname for CoMPareObjects 1 and 2 -->
   <xsl:call-template name="CmpObjects">
    <xsl:with-param name="ParentNode" select="."/>
   </xsl:call-template>
   <!-- Alter list -->
   <xsl:element name="ALTER_LIST">
    <!-- Top most check for unalterable cases  -->
    <xsl:call-template name="checkAlterable">
     <xsl:with-param name="ParentNode" select="."/>
    </xsl:call-template>
    <!-- Alter OBJECT Types -->
    <xsl:if test="sxml:OBJECT and not(sxml:OBJECT/@src)">
     <xsl:call-template name="AlterObjectType">
      <xsl:with-param name="TypeNode" select="."/>
      <xsl:with-param name="ObjectNode" select="./sxml:OBJECT"/>
     </xsl:call-template>
    </xsl:if>
    <!-- Alter VARRAY Types -->
    <xsl:if test="sxml:VARRAY and not(sxml:VARRAY/@src)">
     <xsl:apply-templates select="sxml:VARRAY"/>
    </xsl:if>
    <!-- Alter NESTED_TABLE Types -->
    <xsl:if test="sxml:NESTED_TABLE and not(sxml:NESTED_TABLE/@src)">
     <xsl:apply-templates select="sxml:NESTED_TABLE"/>
    </xsl:if>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AlterObjectType">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ObjectNode" select="''"/>
  <!-- *******************************************************************
Template: AlterObjectType
Parameters:
TypeNode    - <TYPE_SPEC>
 ObjectNode - <OBJECT>   
******************************************************************** -->
  <!-- Check for UNDER differences - and if found generate not_alterable -->
  <xsl:if test="$ObjectNode/sxml:UNDER/@src or 
                      $ObjectNode/sxml:UNDER/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="$ObjectNode/sxml:UNDER"/>
    <xsl:with-param name="Reason">UNDER</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ObjectNode/sxml:SQLJ_OBJECT_TYPE/@src or 
                      $ObjectNode/sxml:SQLJ_OBJECT_TYPE//@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="$ObjectNode/sxml:SQLJ_OBJECT_TYPE"/>
    <xsl:with-param name="Reason">MODIFY SQLJAVA MAPPING</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <!-- ATTRIBUTE list can NOT always be modified due to potential data implications. 
If an attribute is dropped than the data corresponding to this attribute are correspondingly dropped. However, we still will add new attributes.-->
  <xsl:if test="$ObjectNode/sxml:ATTRIBUTE_LIST//@value1 or 
                      $ObjectNode/sxml:ATTRIBUTE_LIST//@src">
   <xsl:call-template name="AlterAttributes">
    <xsl:with-param name="TypeNode" select="$TypeNode"/>
    <xsl:with-param name="AttrListNode" select="$ObjectNode/sxml:ATTRIBUTE_LIST"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="$ObjectNode/sxml:AUTHID_CURRENT_USER/@src">
   <xsl:choose>
    <!-- AUTHID can ONLY be altered if the type attributes have not been altered -->
    <xsl:when test="$ObjectNode/sxml:ATTRIBUTE_LIST//@value1 or 
                                 $ObjectNode/sxml:ATTRIBUTE_LIST//@src">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="$ObjectNode/sxml:AUTHID_CURRENT_USER"/>
      <xsl:with-param name="Reason">EVOLVED ATTRIBUTES</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterInvokersRights">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterInvokersRights">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ObjectNode" select="$ObjectNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="$ObjectNode/sxml:ELEMENT_LIST//@value1 or 
                                 $ObjectNode/sxml:ELEMENT_LIST//@src">
   <xsl:call-template name="AlterElementList">
    <xsl:with-param name="TypeNode" select="."/>
    <xsl:with-param name="ElemListNode" select="$ObjectNode/sxml:ELEMENT_LIST"/>
   </xsl:call-template>
  </xsl:if>
  <!-- Process TYPE property diffs (FINAL | INSTANTIABLE) -->
  <!-- Alter FINAL diffs -->
  <xsl:if test="$ObjectNode/sxml:NOT_FINAL/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterTypeProperty">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
     <xsl:with-param name="PropertyNode" select="$ObjectNode/sxml:NOT_FINAL"/>
     <xsl:with-param name="PropertyText">FINAL</xsl:with-param>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterTypeProperty">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
     <xsl:with-param name="PropertyNode" select="$ObjectNode/sxml:NOT_FINAL"/>
     <xsl:with-param name="PropertyText">FINAL</xsl:with-param>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
  <!-- Alter INSTANTIABLE diffs -->
  <xsl:if test="$ObjectNode/sxml:NOT_INSTANTIABLE/@src">
   <xsl:element name="ALTER_LIST_ITEM">
    <xsl:call-template name="AlterTypeProperty">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
     <xsl:with-param name="PropertyNode" select="$ObjectNode/sxml:NOT_INSTANTIABLE"/>
     <xsl:with-param name="IPropertyText">INSTANTIABLE</xsl:with-param>
     <xsl:with-param name="Action">PARSE</xsl:with-param>
    </xsl:call-template>
    <xsl:call-template name="AlterTypeProperty">
     <xsl:with-param name="TypeNode" select="$TypeNode"/>
     <xsl:with-param name="PropertyNode" select="$ObjectNode/sxml:NOT_INSTANTIABLE"/>
     <xsl:with-param name="PropertyText">INSTANTIABLE</xsl:with-param>
     <xsl:with-param name="Action">SQL</xsl:with-param>
    </xsl:call-template>
   </xsl:element>
  </xsl:if>
 </xsl:template>
 <xsl:template match="sxml:VARRAY | sxml:NESTED_TABLE">
  <!-- *******************************************************************
Template: VARRAY | NESTED_TABLE
    The only difference between varrays and nested_tables is LIMIT. Which will just be 
    skipped over for nested_tables. Therefore, this template can be used for both varrays 
    and nested_tables:
Note: Varray Limit can only be increased otherwise NOT_ALTERABLE.
Local Variable:
 TypeNode    - <TYPE_SPEC>
 CollectionNode - <VARRAY>   
******************************************************************** -->
  <xsl:variable name="CollectionNode" select="."/>
  <xsl:variable name="TypeNode" select=".."/>
  <!-- Alter the collection size/limit if necessary -->
  <xsl:if test="$CollectionNode/sxml:LIMIT/@value1">
   <xsl:choose>
    <xsl:when test="($CollectionNode/sxml:LIMIT) >  ($CollectionNode/sxml:LIMIT/@value1)">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AlterCollectionLimit">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="CollectionNode" select="$CollectionNode"/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AlterCollectionLimit">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="CollectionNode" select="$CollectionNode"/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="."/>
      <xsl:with-param name="Reason">LIMIT DECREASE</xsl:with-param>
     </xsl:call-template>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <!-- Alter the collection datatype if necessary:
     Note: only widening of the collection element type is allowed. Therefore, 
         changes to DATATYPE, SCALE, PRECISION are NOT_ALTERABLE
   -->
  <xsl:choose>
   <xsl:when test="sxml:DATATYPE/@value1 or 
                             sxml:SCALE/@value1 or 
                             sxml:PRECISION/@value1">
    <xsl:call-template name="CommonNotAlterable">
     <xsl:with-param name="NameParent" select="sxml:DATATYPE"/>
     <xsl:with-param name="Reason">DATATYPE</xsl:with-param>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="sxml:LENGTH/@value1">
    <xsl:choose>
     <xsl:when test="(sxml:LENGTH) >  (sxml:LENGTH/@value1)">
      <xsl:element name="ALTER_LIST_ITEM">
       <xsl:call-template name="AlterDatatype">
        <xsl:with-param name="TypeNode" select="$TypeNode"/>
        <xsl:with-param name="ParentNode" select="$CollectionNode"/>
        <xsl:with-param name="Action">PARSE</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="AlterDatatype">
        <xsl:with-param name="TypeNode" select="$TypeNode"/>
        <xsl:with-param name="ParentNode" select="$CollectionNode"/>
        <xsl:with-param name="Action">SQL</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:when>
     <xsl:otherwise>
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="NameParent" select="."/>
       <xsl:with-param name="Reason">LENGTH DECREASE</xsl:with-param>
      </xsl:call-template>
     </xsl:otherwise>
    </xsl:choose>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterDatatype">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ParentNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterDatatype
Description: this template is only used to 'widen' of a collection element type.
       All other diffs related to DATATYPE are NOT_ALTERABLE.
Parameters:
TypeNode - <TYPE_SPEC>
ParentNode - <VARRAY>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ParentNode/sxml:DATATYPE"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DATATYPE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY ELEMENT TYPE </xsl:text>
       <xsl:call-template name="Datatype">
        <xsl:with-param name="TypeObj">1</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterCollectionLimit">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="CollectionNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterCollectionLimit
Parameters:
TypeNode - <TYPE_SPEC>
CollectionNode - <VARRAY>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$CollectionNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">COLLECTION LIMIT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> MODIFY LIMIT </xsl:text>
       <xsl:value-of select="$CollectionNode/sxml:LIMIT"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterAttributes">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="AttrListNode" select="''"/>
  <!-- *******************************************************************
Template: AlterAttributes
NOTE: This template is currently only called if there are new attributes to be added. We can not modify or delete attributes due to the data implications of modifying the attributes. If for example, an attribute is dropped than all the data associated with this attribute are correspondingly deleted.
Parameters:
TypeNode - <TYPE_SPEC>
AttrListNode - <ATTRIBUTE_LIST>
******************************************************************** -->
  <xsl:for-each select="$AttrListNode/sxml:ATTRIBUTE_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="./@src=2">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AddAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AddAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <!--xsl:when test="./@src=1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="DropAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DropAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:when test="./sxml:NAME/@value1 or
                              ./sxml:DATATYPE/@value1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="DropAddAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DropAddAttribute">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="AttrNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when-->
    <xsl:when test="./@src=1 or
                                .//@value1">
     <xsl:call-template name="CommonNotAlterable">
      <xsl:with-param name="NameParent" select="."/>
      <xsl:with-param name="Reason">ATTRIBUTES NOT MODIFIABLE</xsl:with-param>
     </xsl:call-template>
    </xsl:when>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AlterInvokersRights">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ObjectNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterInvokersRights
Parameters:
TypeNode - <TYPE_SPEC>
ObjectNode - parent of <AUTHID_CURRENT_USER>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ObjectNode/sxml:AUTHID_CURRENT_USER"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">RIGHTS_CLAUSE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> REPLACE AUTHID </xsl:text>
       <xsl:if test="$ObjectNode/sxml:AUTHID_CURRENT_USER/@src=1">DEFINER </xsl:if>
       <xsl:if test="$ObjectNode/sxml:AUTHID_CURRENT_USER/@src=2">CURRENT_USER</xsl:if>
       <xsl:call-template name="RebuildAttrList">
        <xsl:with-param name="TypeNode" select="$TypeNode"/>
        <xsl:with-param name="AttrListNode" select="$ObjectNode/sxml:ATTRIBUTE_LIST"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="RebuildAttrList">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="AttrListNode" select="''"/>
  <!-- *******************************************************************
Template: RebuildAttrList
Description: This template will dump all of the type attributes which is required
   by the ALTER TYPE REPLACE directive (i.e., which has been generated already
   by the AlterAuthID template.
Parameters:
TypeNode    - <TYPE_SPEC>
 AttrListNode - <ATTRIBUTE_LIST>   
Notes: 
******************************************************************** -->
  <xsl:text>AS OBJECT </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <!-- regenerate the sqljava mapping clause if appropriate -->
  <xsl:if test="$TypeNode/sxml:OBJECT/sxml:SQLJ_OBJECT_TYPE">
   <xsl:call-template name="DoSQLJClause">
    <xsl:with-param name="sqljNode" select="$TypeNode/sxml:OBJECT/sxml:SQLJ_OBJECT_TYPE"/>
   </xsl:call-template>
  </xsl:if>
  <xsl:text>&#xa; (</xsl:text>
  <xsl:for-each select="$AttrListNode/sxml:ATTRIBUTE_LIST_ITEM">
   <xsl:call-template name="DoAttribute">
    <xsl:with-param name="AttrNode" select="."/>
   </xsl:call-template>
   <!--
   <xsl:call-template name="QuotedName">
    <xsl:with-param name="NameNode" select="./sxml:NAME"/>
   </xsl:call-template>
   <xsl:text> </xsl:text>
     <xsl:call-template name="Datatype">
   <xsl:with-param name="TypeObj">1</xsl:with-param>
  </xsl:call-template>
   <xsl:if test="position()!=last()">
    <xsl:text>, </xsl:text>
   </xsl:if>
<-->
  </xsl:for-each>
  <!-- **NOTE: Need to reconstruct the ELEMENT_SPEC as well -->
  <xsl:text>&#xa; )</xsl:text>
 </xsl:template>
 <xsl:template name="checkAlterable">
  <!-- *******************************************************************
Template: checkAlterable - Detects certain non-alterable cases
 1. type name diffs 
 2. type 'classes' different (e.g, OBJECT vs VARRAY)
Parameters:
 ParentNode - Parent node of SCHEMA, NAME
******************************************************************** -->
  <!-- Check for type NAME difference -->
  <xsl:if test="sxml:NAME/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="./sxml:NAME"/>
    <xsl:with-param name="Reason">RENAME</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="./sxml:OBJECT/@src or 
                      ./sxml:VARRAY/@src or
                      ./sxml:NESTED_TABLE/@src">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="."/>
    <xsl:with-param name="Reason">INCOMPATIBLE TYPES</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="./sxml:OID/@src or 
                      ./sxml:OID/@value1">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="sxml:OID"/>
    <xsl:with-param name="Reason">OID</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
  <xsl:if test="./sxml:INCOMPLETE/@src">
   <xsl:call-template name="CommonNotAlterable">
    <xsl:with-param name="NameParent" select="sxml:INCOMPLETE"/>
    <xsl:with-param name="Reason">INCOMPLETE</xsl:with-param>
   </xsl:call-template>
  </xsl:if>
 </xsl:template>
 <xsl:template name="CommonNotAlterable">
  <xsl:param name="NameParent" select="''"/>
  <xsl:param name="Reason" select="''"/>
  <!-- *******************************************************************
Template: CommonNotAlterable
Parameters:
 NameParent
 Reason:   
******************************************************************** -->
  <xsl:element name="ALTER_LIST_ITEM">
   <xsl:element name="PARSE_LIST">
    <xsl:call-template name="AddXPathParseItem">
     <xsl:with-param name="Node" select="$NameParent"/>
    </xsl:call-template>
    <xsl:call-template name="AddParseItem">
     <xsl:with-param name="ParseIt" select="$PRS_ALTERABLE"/>
     <xsl:with-param name="Item">NOT_ALTERABLE</xsl:with-param>
     <xsl:with-param name="Value1" select="$Reason"/>
    </xsl:call-template>
   </xsl:element>
  </xsl:element>
 </xsl:template>
 <xsl:template name="AddAttribute">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="AttrNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddAttribute
Parameters:
TypeNode - <TYPE_SPEC>
AttrNode - <ATTRIBUTE_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$AttrNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD ATTRIBUTE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> ADD ATTRIBUTE </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$AttrNode/sxml:NAME"/>
       </xsl:call-template>
       <xsl:text> </xsl:text>
       <xsl:call-template name="Datatype">
        <xsl:with-param name="TypeObj">1</xsl:with-param>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropAttribute">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="AttrNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropAttribute
NOTE: This template is currently NOT called due to the data implications of modifying the attributes. If for example, an attribute is dropped than all the data associated with this attribute are correspondingly deleted.
Parameters:
TypeNode - <TYPE_SPEC>
AttrNode - <ATTRIBUTE_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$AttrNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP ATTRIBUTE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> DROP ATTRIBUTE </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$AttrNode/sxml:NAME"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropAddAttribute">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="AttrNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropAddAttribute
NOTE: This template is currently NOT called due to the data implications of modifying the attributes. If for example, an attribute is dropped than all the data associated with this attribute are correspondingly deleted.
Parameters:
TypeNode - <TYPE_SPEC>
AttrNode - <ATTRIBUTE_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$AttrNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP-ADD ATTRIBUTE</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> DROP ATTRIBUTE </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$AttrNode/sxml:NAME/@value1"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:element>
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> ADD ATTRIBUTE </xsl:text>
       <xsl:call-template name="QuotedName">
        <xsl:with-param name="NameNode" select="$AttrNode/sxml:NAME"/>
       </xsl:call-template>
       <xsl:text> </xsl:text>
       <xsl:call-template name="Datatype">
        <xsl:with-param name="TypeObj">1</xsl:with-param>
       </xsl:call-template>
       <xsl:text> CASCADE</xsl:text>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterTypeProperty">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="PropertyNode" select="''"/>
  <xsl:param name="PropertyText" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AlterTypeProperty
Parameters:
TypeNode - <TYPE_SPEC>
PropertyNode  - <NOT_INSTANTIABLE | NOT_FINAL | NOT_OVERRIDING>
PropertyText  - INSTANTIABLE | FINAL | OVERRIDING
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$PropertyNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1" select="$PropertyText"/>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:if test="$PropertyNode/@src='2'">
        <xsl:text> NOT</xsl:text>
       </xsl:if>
       <xsl:text> </xsl:text>
       <xsl:value-of select="$PropertyText"/>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="AlterElementList">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ElemListNode" select="''"/>
  <!-- *******************************************************************
Template: AlterElementList
Parameters:
TypeNode - <TYPE_SPEC>
ElemListNode - <ELEMENT_LIST>
******************************************************************** -->
  <xsl:for-each select="$ElemListNode/sxml:ELEMENT_LIST_ITEM">
   <xsl:choose>
    <xsl:when test="./@src=2">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="AddElement">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ElementNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="AddElement">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ElementNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:when test="./@src=1">
     <xsl:element name="ALTER_LIST_ITEM">
      <xsl:call-template name="DropElement">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ElementNode" select="."/>
       <xsl:with-param name="Action">PARSE</xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="DropElement">
       <xsl:with-param name="TypeNode" select="$TypeNode"/>
       <xsl:with-param name="ElementNode" select="."/>
       <xsl:with-param name="Action">SQL</xsl:with-param>
      </xsl:call-template>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:if test=".//@value1 or .//@src">
      <xsl:call-template name="CommonNotAlterable">
       <xsl:with-param name="NameParent" select="."/>
       <xsl:with-param name="Reason">MODIFIED METHOD</xsl:with-param>
      </xsl:call-template>
     </xsl:if>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:for-each>
 </xsl:template>
 <xsl:template name="AddElement">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ElementNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: AddElement
Parameters:
TypeNode - <TYPE_SPEC>
ElementNode - <ELEMENT_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ElementNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">ADD ELEMENT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> ADD </xsl:text>
       <xsl:call-template name="DispatchSubprogram">
      </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DropElement">
  <xsl:param name="TypeNode" select="''"/>
  <xsl:param name="ElementNode" select="''"/>
  <xsl:param name="Action" select="''"/>
  <!-- *******************************************************************
Template: DropElement
Parameters:
TypeNode - <TYPE_SPEC>
ElementNode - <ELEMENT_LIST_ITEM>
 Action   PARSE or SQL
******************************************************************** -->
  <xsl:choose>
   <xsl:when test="$Action='PARSE' and ($PRS_NAME=1 or 
                                        $PRS_CLAUSE_TYPE=1 or
                                        $PRS_ALTERABLE=1 or
                                        $PRS_XPATH=1)">
    <xsl:element name="PARSE_LIST">
     <xsl:call-template name="AddXPathParseItem">
      <xsl:with-param name="Node" select="$ElementNode"/>
     </xsl:call-template>
     <xsl:call-template name="AddParseItem">
      <xsl:with-param name="ParseIt" select="$PRS_CLAUSE_TYPE"/>
      <xsl:with-param name="Item">CLAUSE_TYPE</xsl:with-param>
      <xsl:with-param name="Value1">DROP ELEMENT</xsl:with-param>
     </xsl:call-template>
    </xsl:element>
   </xsl:when>
   <xsl:when test="$Action='SQL'">
    <xsl:element name="SQL_LIST">
     <xsl:element name="SQL_LIST_ITEM">
      <xsl:element name="TEXT">
       <xsl:text>ALTER TYPE </xsl:text>
       <xsl:call-template name="SchemaName">
        <xsl:with-param name="ParentNode" select="$TypeNode"/>
       </xsl:call-template>
       <xsl:text> DROP </xsl:text>
       <xsl:call-template name="DispatchSubprogram">
      </xsl:call-template>
      </xsl:element>
     </xsl:element>
    </xsl:element>
   </xsl:when>
  </xsl:choose>
 </xsl:template>
 <xsl:template name="DispatchSubprogram">
  <!-- *******************************************************************
Template: DispatchSubprogram
Implicit Parameters:
CurrentNode - <ELEMENT_LIST_ITEM>
******************************************************************** -->
  <xsl:if test="sxml:FINAL">
   <xsl:choose>
    <xsl:when test="sxml:FINAL/@src=2 or not(sxml:FINAL/@src)"> FINAL </xsl:when>
    <xsl:when test="sxml:FINAL/@src=1"> NOT FINAL </xsl:when>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="sxml:OVERRIDING">OVERRIDING </xsl:if>
  <xsl:if test="sxml:NOT_INSTANTIABLE">NOT INSTANTIABLE </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:STATIC">
    <xsl:text>STATIC </xsl:text>
    <xsl:call-template name="DoSubprogram">
     <xsl:with-param name="ProgramParent" select="sxml:STATIC"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="sxml:MEMBER">
    <xsl:text>MEMBER </xsl:text>
    <xsl:call-template name="DoSubprogram">
     <xsl:with-param name="ProgramParent" select="sxml:MEMBER"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="sxml:MAP_MEMBER">
    <xsl:text>MAP_MEMBER </xsl:text>
    <xsl:call-template name="DoSubprogram">
     <xsl:with-param name="ProgramParent" select="sxml:MAP_MEMBER"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:when test="sxml:ORDER_MEMBER">
    <xsl:text>ORDER_MEMBER </xsl:text>
    <xsl:call-template name="DoSubprogram">
     <xsl:with-param name="ProgramParent" select="sxml:ORDER_MEMBER"/>
    </xsl:call-template>
   </xsl:when>
   <xsl:otherwise>
    <!-- ERROR -->
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
