<?xml version="1.0"?>
<!-- 
NAME
    kuproxy.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_proxy_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED      MM/DD/YY
    rapayne   11/02/05 - Bug 4715313: Reformat with XMLSpy
    jnaras    05/27/04 - Alter User changes for EUS Proxy project 
    tkeefe    09/19/02 - Add support for AUTHENTICATION REQUIRED proxy feature
    htseng    08/02/02 - add pgrantee parse param
    htseng    07/26/02 - add more parse params
    htseng    09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng    06/13/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="PROXY_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">PROXY</xsl:with-param>
   <xsl:with-param name="Grantee" select="CLIENT_NAME"/>
  </xsl:call-template>
  <xsl:text> ALTER USER </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="CLIENT_NAME"/>
  </xsl:call-template>
  <xsl:text> GRANT CONNECT THROUGH </xsl:text>
  <xsl:choose>
   <xsl:when test="FLAGS =16">
    <xsl:text> ENTERPRISE USERS </xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:call-template name="QuoteObject">
     <xsl:with-param name="Object" select="PROXY_NAME"/>
    </xsl:call-template>
    <xsl:if test="FLAGS =2">
     <xsl:text> WITH NO ROLES</xsl:text>
    </xsl:if>
    <xsl:if test="FLAGS =4">
     <xsl:text> WITH ROLE </xsl:text>
    </xsl:if>
    <xsl:if test="FLAGS =8">
     <xsl:text> WITH ROLE ALL EXCEPT </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="PROXY_ROLE_LIST"/>
    <xsl:if test="CRED_TYPE =5">
     <xsl:text> AUTHENTICATION REQUIRED</xsl:text>
    </xsl:if>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="PROXY_ROLE_LIST">
  <xsl:for-each select="PROXY_ROLE_LIST_ITEM">
   <xsl:call-template name="QuoteObject">
    <xsl:with-param name="Object" select="ROLE"/>
   </xsl:call-template>
   <xsl:if test="not(position()=last())">
    <xsl:text>, </xsl:text>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
