<?xml version="1.0"?>
<!-- 
NAME
    kurollback.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_rollback_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED        MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    lbarton     05/11/04 - Bug 3617842: SAMPLE and PCTSPACE 
    lbarton     11/07/03 - Bug 3238141: SEGMENT_ATTRIBUTES param 
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    lbarton     08/02/02 - transportable export
    lbarton     06/13/02 - define EXPORT param
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <xsl:import href="kustorag.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <xsl:param name="TRANSPORTABLE">0</xsl:param>
 <xsl:param name="PCTSPACE">100</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_TABLESPACE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <!-- Template to recreate ROLLBACK SEGMENTs -->
 <xsl:template match="ROLLBACK_T">
  <xsl:if test="$PRS_TABLESPACE=1">
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>ATABLESPACE</xsl:text>
   <xsl:value-of select="$PRS_DELIM"/>
   <xsl:text>B</xsl:text>
   <xsl:value-of select="TABLESPACE/NAME"/>
  </xsl:if>
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">CREATE</xsl:with-param>
   <xsl:with-param name="ObjectType">ROLLBACK_SEGMENT</xsl:with-param>
   <xsl:with-param name="NameNode" select="NAME"/>
  </xsl:call-template>
  <xsl:text>CREATE </xsl:text>
  <!-- Determine if this is public or not -->
  <xsl:if test="USER_NUM = 1">
   <xsl:text>PUBLIC </xsl:text>
  </xsl:if>
  <xsl:text>ROLLBACK SEGMENT "</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>" </xsl:text>
  <xsl:if test="$SEGMENT_ATTRIBUTES=1">
   <xsl:if test="$TABLESPACE=1">
    <xsl:text>TABLESPACE "</xsl:text>
    <xsl:value-of select="TABLESPACE/NAME"/>
    <xsl:text>" </xsl:text>
   </xsl:if>
   <xsl:if test="$STORAGE=1">
    <xsl:call-template name="NamedStorage">
     <xsl:with-param name="BlkSize" select="TABLESPACE/BLOCKSIZE"/>
     <xsl:with-param name="ObjType" select="'ROLLBACK'"/>
     <xsl:with-param name="Node" select="current()"/>
     <xsl:with-param name="Pctspace" select="$PCTSPACE"/>
    </xsl:call-template>
   </xsl:if>
  </xsl:if>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
