<?xml version="1.0"?>
<!--
 Copyright (c) 2005, 2012, Oracle and/or its affiliates. All rights reserved. 
NAME
    kusmv.xsl
DESCRIPTION
    Convert mdapi M_VIEW_T document to MATERIALIZED_VIEW document (SXML)

MODIFIED        MM/DD/YY
    abodge      06/29/12 - Fix xmlns attribute problem
    abodge      09/22/09 - CONSOLIDATE STYLESHEETS: PHYSICAL_PROPERTIES hack
    lbarton     01/24/08 - Bug 6724820: move VERSION param to kuscomm.xsl
    lbarton     01/02/08 - bug 6720629: column aliases
    htseng      12/16/05 - add transform param
    lbarton     11/09/05 - bug 4724986: fix handling of xmlns 
    rapayne     11/03/05 - Bug 4715313: Reformat with XMLSpy
    htseng      08/25/05 - add trusted constraints 
    htseng      05/03/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://xmlns.oracle.com/ku">
 <!-- Top level imports -->
 <xsl:import href="kuscomm.xsl"/>
 <xsl:import href="kustbphy.xsl"/>
 <xsl:import href="kuspar.xsl"/>
 <xsl:import href="kuscnstr.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PHYSICAL_PROPERTIES">1</xsl:param>
 <xsl:param name="SEGMENT_ATTRIBUTES">1</xsl:param>
 <xsl:param name="STORAGE">1</xsl:param>
 <xsl:param name="TABLESPACE">1</xsl:param>
 <xsl:param name="PARSE_EXPRESSIONS">0</xsl:param>
 <!-- needed to handle START_WITH properly -->
 <xsl:param name="START_WITH">0</xsl:param>
<!-- Templates -->
 <xsl:template match="M_VIEW_T">
 <!-- *******************************************************************
Template:M_VIEW_T - top-level template for MATERIALIZED_VIEW.
  This template puts out
   - the opening MATERIALIZED_VIEW element (with xmlns and version attributes)
   - NAME elements

******************************************************************** -->
  <xsl:element name="MATERIALIZED_VIEW" namespace="http://xmlns.oracle.com/ku">
   <xsl:attribute name="version">1.0</xsl:attribute>
   <xsl:element name="SCHEMA">
    <xsl:value-of select="MVIEW/SOWNER"/>
   </xsl:element>
   <xsl:element name="NAME">
    <xsl:value-of select="MVIEW/VNAME"/>
   </xsl:element>
   <xsl:choose>
    <xsl:when test="(MVIEW/OBJFLAG mod 4) >= 2">
     <xsl:element name="OF_TYPE">
      <xsl:element name="SCHEMA">
       <xsl:value-of select="MVIEW/SNA_TYPE_OWNER"/>
      </xsl:element>
      <xsl:element name="NAME">
       <xsl:value-of select="MVIEW/SNA_TYPE_NAME"/>
      </xsl:element>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="COL_LIST">
      <xsl:for-each
 select="MVIEW_TAB/COL_LIST/COL_LIST_ITEM[((PROPERTY mod 65536)&lt;32768) and
                                        ((PROPERTY mod 64)&lt;32
                                      or (PROPERTY mod 2097152)>=1048576
                                      or (PROPERTY mod 8388608)>=4194304)
                                      and PROPERTY!=1048608]">
       <xsl:element name="COL_LIST_ITEM">
        <xsl:element name="NAME">
         <xsl:value-of select="NAME"/>
        </xsl:element>
       </xsl:element>
      </xsl:for-each>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <!-- ???? scope_constraint_definition -->
   <xsl:call-template name="ScopeConstraints"/>
   <xsl:choose>
    <!--prebuilt_table_clause-->
    <xsl:when test="(MVIEW/FLAG mod 262144) >= 131072">
     <xsl:element name="ON_PREBUILT_TABLE">
      <xsl:choose>
       <xsl:when test="(MVIEW/FLAG mod 524288) >= 262144">
        <xsl:element name="REDUCED_PRECISION">Y</xsl:element>
       </xsl:when>
       <xsl:otherwise>
        <xsl:element name="REDUCED_PRECISION">N</xsl:element>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:when>
    <!-- physical_properties-->
    <xsl:otherwise>
     <xsl:call-template name="TablePhysicalProperties">
      <xsl:with-param name="TabNode" select="MVIEW_TAB"/>
      <xsl:with-param name="PROPERTY" select="MVIEW_TAB/PROPERTY"/>
     </xsl:call-template>
     <!-- materialized view properties -->
     <!-- Column properties -->
     <xsl:call-template name="TableColumnProperties">
      <xsl:with-param name="ColListParent" select="MVIEW_TAB"/>
      <xsl:with-param name="TabBlocksize" select="MVIEW_TAB/BLOCKSIZE"/>
     </xsl:call-template>
     <!-- table partitioning -->
     <xsl:if test="MVIEW_TAB/PART_OBJ">
      <xsl:call-template name="TablePartitioning">
       <xsl:with-param name="PartobjNode" select="MVIEW_TAB/PART_OBJ"/>
       <xsl:with-param name="PropertyNode" select="MVIEW_TAB/PROPERTY"/>
       <xsl:with-param name="ColListNode" select="MVIEW_TAB/PART_OBJ/PARTCOLS"/>
       <xsl:with-param name="TabBlocksize" select="MVIEW_TAB/BLOCKSIZE"/>
      </xsl:call-template>
     </xsl:if>
     <!-- CACHE -->
     <xsl:if test="(MVIEW_TAB/FLAGS mod 16)>=8">
      <xsl:element name="CACHE"/>
     </xsl:if>
     <!-- Parallel -->
     <xsl:call-template name="ParallelClause">
      <xsl:with-param name="ParentNode" select="MVIEW_TAB"/>
     </xsl:call-template>
     <!-- build_clause -->
     <xsl:element name="BUILD">
      <xsl:choose>
       <xsl:when test="(MVIEW/FLAG mod 1048576)>= 524288">DEFERRED</xsl:when>
       <xsl:otherwise>IMMEDIATE</xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <xsl:choose>
    <xsl:when test="(MVIEW/FLAG2 mod 2048) >= 1024">
     <xsl:element name="USING_NO_INDEX"/>
    </xsl:when>
    <xsl:when test="MVIEW_IDX_LIST/MVIEW_IDX_LIST_ITEM[1]">
     <xsl:if test="$SEGMENT_ATTRIBUTES=1 and 
                   ($CM_MODE=0 or $PHYSICAL_PROPERTIES=1)">
      <xsl:element name="INDEX_ATTRIBUTES">
       <xsl:call-template name="PhysicalAttributes">
        <xsl:with-param name="ParentNode" select="MVIEW_IDX_LIST/MVIEW_IDX_LIST_ITEM[1]"/>
        <xsl:with-param name="ObjType">INDEX</xsl:with-param>
        <xsl:with-param name="Partitioned">0</xsl:with-param>
       </xsl:call-template>
       <xsl:call-template name="Tablespace">
        <xsl:with-param name="ParentNode" select="MVIEW_IDX_LIST/MVIEW_IDX_LIST_ITEM[1]"/>
       </xsl:call-template>
      </xsl:element>
     </xsl:if>
    </xsl:when>
   </xsl:choose>
   <!-- refresh -->
   <xsl:choose>
    <xsl:when test="MVIEW/AUTO_FAST = 'NEVER'">
     <xsl:element name="NEVER_REFRESH"/>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="REFRESH">
      <xsl:choose>
       <xsl:when test="MVIEW/AUTO_FAST='FAST'">
        <xsl:element name="FAST"/>
       </xsl:when>
       <xsl:when test="MVIEW/AUTO_FAST='COMPLETE'">
        <xsl:element name="COMPLETE"/>
       </xsl:when>
      </xsl:choose>
      <xsl:choose>
       <xsl:when test="(MVIEW/FLAG mod 128) >= 64"/>
       <xsl:otherwise>
        <xsl:element name="ON_COMMIT"/>
       </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="MVIEW/AUTO_DATE">
       <xsl:element name="START_WITH">
        <xsl:text>sysdate+</xsl:text>
        <xsl:value-of select="$START_WITH"/>
       </xsl:element>
      </xsl:if>
      <xsl:if test="MVIEW/AUTO_FUN">
       <xsl:element name="NEXT">
        <xsl:value-of select="normalize-space(MVIEW/AUTO_FUN)"/>
       </xsl:element>
      </xsl:if>
      <xsl:if test="(MVIEW/FLAG mod 64) >= 32">
       <xsl:element name="WITH_PRIMARY_KEY"/>
      </xsl:if>
      <xsl:if test="(MVIEW/FLAG mod 32) >= 16">
       <xsl:element name="WITH_ROWID"/>
      </xsl:if>
      <!-- master_rollback_segment -->
      <xsl:choose>
       <xsl:when test="MVIEW/MAS_ROLL_SEG">
        <xsl:element name="MASTER_ROLLBACK_SEGMENT">
         <xsl:element name="NAME">
          <xsl:value-of select="MVIEW/MAS_ROLL_SEG"/>
         </xsl:element>
        </xsl:element>
       </xsl:when>
       <xsl:when test="(MVIEW/FLAG mod 16777216) >= 8388608">
        <xsl:element name="MASTER_ROLLBACK_SEGMENT">
         <xsl:element name="DEFAULT"/>
        </xsl:element>
       </xsl:when>
       <xsl:otherwise/>
      </xsl:choose>
      <!-- local_rollback_segment -->
      <xsl:element name="LOCAL_ROLLBACK_SEGMENT">
       <xsl:choose>
        <xsl:when test="MVIEW/LOC_ROLL_SEG">
         <xsl:element name="NAME">
          <xsl:value-of select="MVIEW/LOC_ROLL_SEG"/>
         </xsl:element>
        </xsl:when>
        <xsl:otherwise>
         <xsl:element name="DEFAULT"/>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
      <!--refresh_constrains-->
      <xsl:element name="CONSTRAINTS">
       <xsl:choose>
        <xsl:when test="(MVIEW/FLAG2 mod 131072) >= 65536">
         <xsl:text>TRUSTED</xsl:text>
        </xsl:when>
        <xsl:otherwise>
         <xsl:text>ENFORCED</xsl:text>
        </xsl:otherwise>
       </xsl:choose>
      </xsl:element>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
   <!--update_clause-->
   <xsl:if test="(MVIEW/FLAG mod 4) >= 2">
    <xsl:element name="FOR_UPDATE"/>
   </xsl:if>
   <!-- query_rewrite-->
   <xsl:choose>
    <xsl:when test="(MVIEW/FLAG mod 4194304)>= 2097152"/>
    <xsl:otherwise>
     <xsl:element name="QUERY_REWRITE"/>
    </xsl:otherwise>
   </xsl:choose>
   <!-- subquery_clause -->
   <xsl:choose>
    <xsl:when test="$PARSE_EXPRESSIONS=1 and MVIEW/PARSED_QUERY_TXT">
     <xsl:element name="PARSED_SUBQUERY">
      <xsl:copy-of select="MVIEW/PARSED_QUERY_TXT/*"/>
     </xsl:element>
    </xsl:when>
    <xsl:otherwise>
     <xsl:element name="SUBQUERY">
      <xsl:choose>
       <xsl:when test="MVIEW/QUERY_VCNT">
        <xsl:for-each select="MVIEW/QUERY_VCNT/QUERY_VCNT_ITEM">
         <xsl:value-of select="."/>
        </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
        <xsl:value-of select="MVIEW/QUERY_TXT"/>
       </xsl:otherwise>
      </xsl:choose>
     </xsl:element>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:element>
 </xsl:template>
</xsl:stylesheet>
