create or replace
PACKAGE TERADATA_UTILITIES AS

-- Teradata Aggregate functions
----- Unsupported functions -----
FUNCTION skew( p_val_expr VARCHAR2, p_expr VARCHAR2 DEFAULT 'ALL') RETURN NUMBER;
FUNCTION kurtosis(p_val_expr VARCHAR2, p_expr VARCHAR2 DEFAULT 'ALL') RETURN NUMBER;
---------------------------------

-- Teradata Analytical functions
----- Unsupported functions -----
FUNCTION mlinreg(p_val_expr NUMBER, p_width BINARY_INTEGER, p_sort_expression NUMBER) RETURN NUMBER;

-- Teradata Attribute functions
FUNCTION type(p_expr IN VARCHAR2) RETURN VARCHAR2;
FUNCTION ora_default(p_expr1 IN VARCHAR2, p_expr2 IN VARCHAR2) RETURN VARCHAR2;
FUNCTION ora_default(p_expr1 IN VARCHAR2, p_expr2 IN BINARY_INTEGER) RETURN VARCHAR2;

-- Teradata Arithmetic functions
FUNCTION radians(p_degree IN NUMBER) RETURN NUMBER;
FUNCTION degrees(p_angle_radians IN NUMBER)  RETURN NUMBER;
FUNCTION random(p_x BINARY_INTEGER, p_y BINARY_INTEGER) RETURN BINARY_INTEGER;
----- Unsupported functions -----
FUNCTION case_n(p_expr_list IN VARCHAR2) RETURN BINARY_INTEGER;
FUNCTION range_n(p_expr_list IN VARCHAR2) RETURN BINARY_INTEGER;
---------------------------------

-- Teradata Compression/Decompression functions
----- Unsupported functions -----
FUNCTION camset(p_expr IN VARCHAR2) RETURN BLOB;
FUNCTION camset_l(p_expr IN VARCHAR2) RETURN BLOB;
FUNCTION decamset(p_expr IN BLOB) RETURN VARCHAR2;
FUNCTION decamset_l(p_expr IN BLOB) RETURN VARCHAR2;
FUNCTION lzcomp(p_expr IN VARCHAR2) RETURN BLOB;
FUNCTION lzcomp_L(p_expr IN VARCHAR2) RETURN BLOB;
FUNCTION lzdecomp(p_expr IN BLOB) RETURN VARCHAR2;
FUNCTION lzdecomp_l(p_expr IN BLOB) RETURN VARCHAR2;
FUNCTION transunicode_to_utf8(p_expr IN VARCHAR2) RETURN BLOB;
FUNCTION transutf8_to_unicode(p_expr IN BLOB) RETURN VARCHAR2;
---------------------------------

-- Teradata String functions
FUNCTION position(p_findstr IN VARCHAR2, p_instr IN VARCHAR2) RETURN NUMBER;
FUNCTION position(p_findstr IN RAW, p_instr IN BLOB) RETURN NUMBER;
FUNCTION ora_index(p_str IN VARCHAR2, p_findstr IN VARCHAR2) RETURN NUMBER;
FUNCTION ora_index(p_str IN BLOB, p_findstr IN RAW) RETURN NUMBER;
FUNCTION char2hexint(p_str IN VARCHAR2) RETURN VARCHAR2;
----- Unsupported functions -----
FUNCTION vargraphic(p_expr IN VARCHAR2) RETURN NVARCHAR2;
FUNCTION string_cs(p_expr IN VARCHAR2) RETURN BINARY_INTEGER;
FUNCTION translate(p_expr IN VARCHAR2, p_src_to_tgt_cset IN VARCHAR2) RETURN VARCHAR2;
FUNCTION translate(p_expr IN CLOB, p_src_to_tgt_cset IN VARCHAR2) RETURN CLOB;
FUNCTION translate_chk(p_expr IN VARCHAR2, p_src_to_tgt_cset IN VARCHAR2) RETURN BINARY_INTEGER;
FUNCTION translate_chk(p_expr IN CLOB, p_src_to_tgt_cset IN VARCHAR2) RETURN BINARY_INTEGER; 
---------------------------------

-- Teradata Calendar functions
FUNCTION day_of_week(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION day_of_week(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION day_of_month(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION day_of_month(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION day_of_year(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION day_of_year(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION day_of_calendar(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION day_of_calendar(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION weekday_of_month(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION weekday_of_month(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION week_of_month(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION week_of_month(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION week_of_year(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION week_of_year(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION week_of_calendar(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION week_of_calendar(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION month_of_quarter(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION month_of_quarter(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION month_of_year(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION month_of_year(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION month_of_calendar(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION month_of_calendar(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION quarter_of_calendar(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION quarter_of_calendar(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION quarter_of_year(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION quarter_of_year(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;
FUNCTION year_of_calendar(p_tstz IN TIMESTAMP WITH TIME ZONE) RETURN NUMBER;
FUNCTION year_of_calendar(p_tstz IN VARCHAR2, p_format VARCHAR2) RETURN NUMBER;

-- Teradata Built-in functions
-- FUNCTION CURRENT_TIME(p_fra_prsn IN VARCHAR2 := NULL) RETURN TIMESTAMP WITH TIME ZONE;
-- FUNCTION CURRENT_TIME(p_fra_prsn IN VARCHAR2, p_tzstr IN VARCHAR2, p_tdwzcontrol IN VARCHAR2 := 'Y') RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION CURRENT_TIME(p_fra_prsn IN VARCHAR2, p_tzstr IN VARCHAR2 := NULL) RETURN TIMESTAMP WITH TIME ZONE;
-- FUNCTION current_timestamp(p_fra_prsn IN VARCHAR2, p_tzstr IN VARCHAR2 := SESSIONTIMEZONE, p_tdwzcontrol IN VARCHAR2 := 'Y') RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION CURRENT_TIMESTAMP(p_fra_prsn IN VARCHAR2, p_tzstr IN VARCHAR2 := 'LOCAL') RETURN TIMESTAMP WITH TIME ZONE;
FUNCTION ora_add_months(p_expr IN VARCHAR2, p_months IN PLS_INTEGER) RETURN TIMESTAMP;

FUNCTION hex_2_integer(p_expr IN RAW) RETURN BINARY_INTEGER;
FUNCTION hex_2_char(p_expr IN RAW) RETURN VARCHAR2;

-- Teradata Byte/Bit Manipulation functions
FUNCTION ora_bitcomplement(p_expr IN NUMBER) RETURN NUMBER;
FUNCTION ora_bitcomplement(p_expr IN RAW) RETURN RAW;

FUNCTION ora_bitor(p_expr1 IN NUMBER, p_expr2 IN NUMBER) RETURN NUMBER;
FUNCTION ora_bitor(p_expr1 IN RAW, p_expr2 IN RAW) RETURN RAW;
FUNCTION ora_bitor(p_expr1 IN RAW, p_expr2 IN NUMBER) RETURN RAW;
FUNCTION ora_bitor(p_expr1 IN NUMBER, p_expr2 IN RAW) RETURN NUMBER;

FUNCTION ora_bitxor(p_expr1 IN NUMBER, p_expr2 IN NUMBER) RETURN NUMBER;
FUNCTION ora_bitxor(p_expr1 IN RAW, p_expr2 IN RAW) RETURN RAW;
FUNCTION ora_bitxor(p_expr1 IN RAW, p_expr2 IN NUMBER) RETURN RAW;
FUNCTION ora_bitxor(p_expr1 IN NUMBER, p_expr2 IN RAW) RETURN NUMBER;

FUNCTION ora_bitand(p_expr1 IN NUMBER, p_expr2 IN NUMBER) RETURN NUMBER;
FUNCTION ora_bitand(p_expr1 IN RAW, p_expr2 IN RAW) RETURN RAW;
FUNCTION ora_bitand(p_expr1 IN RAW, p_expr2 IN NUMBER) RETURN RAW;
FUNCTION ora_bitand(p_expr1 IN NUMBER, p_expr2 IN RAW) RETURN NUMBER;

-- Teradata Conversion Functions (using CAST)     

--CASTING VARCHAR2/CHAR FUNCTIONS

FUNCTION apply_format(p_expr IN VARCHAR2, p_fmtstr IN VARCHAR2) RETURN VARCHAR2;

FUNCTION cast_to_number(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_decimal(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_float(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_real(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_double_precision(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_integer(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_smallint(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;

FUNCTION cast_to_date(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_fmtstr IN VARCHAR2 := NULL) RETURN DATE;
           
FUNCTION cast_to_timestamp(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_fmtstr IN VARCHAR2 := NULL) RETURN TIMESTAMP;
           
FUNCTION cast_to_time(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_fmtstr IN VARCHAR2 := NULL) RETURN TIMESTAMP;
           
FUNCTION cast_to_timestamp_tz(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_fmtstr IN VARCHAR2 := NULL) RETURN TIMESTAMP WITH TIME ZONE;
           
FUNCTION cast_to_time_tz(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_fmtstr IN VARCHAR2 := NULL) RETURN TIMESTAMP WITH TIME ZONE;

FUNCTION cast_to_interval_year_to_month(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2) RETURN YMINTERVAL_UNCONSTRAINED;

FUNCTION cast_to_interval_day_to_second(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2 := NULL) RETURN DSINTERVAL_UNCONSTRAINED;
           
--CASTING DATE/TIMESTAMP FUNCTIONS
FUNCTION apply_format(p_expr IN DATE, p_fmtstr IN VARCHAR2) RETURN TIMESTAMP;

-- FUNCTION apply_format(p_expr IN TIMESTAMP WITH TIME ZONE, p_fmtstr IN VARCHAR2) RETURN TIMESTAMP WITH TIME ZONE;

FUNCTION cast_to_char(p_expr IN TIMESTAMP, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN VARCHAR2;
           
FUNCTION cast_to_number(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_decimal(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_float(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_real(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_double_precision(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_integer(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_smallint(p_expr IN DATE, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_timestamp(p_expr IN TIMESTAMP, p_precision IN BINARY_INTEGER := NULL) RETURN TIMESTAMP;

FUNCTION cast_to_time(p_expr IN TIMESTAMP, p_precision IN BINARY_INTEGER := NULL) RETURN TIMESTAMP;


--CASTING INTERVAL FUNCTIONS
FUNCTION cast_to_char(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN VARCHAR2;
           
FUNCTION cast_to_char(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN VARCHAR2;
           
FUNCTION cast_to_number(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;

FUNCTION cast_to_decimal(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_float(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_real(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_double_precision(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_integer(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_smallint(p_expr IN INTERVAL YEAR TO MONTH, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;

FUNCTION cast_to_number(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_decimal(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_float(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_real(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_double_precision(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_integer(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_smallint(p_expr IN INTERVAL DAY TO SECOND, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_interval_year_to_month(p_expr IN YMINTERVAL_UNCONSTRAINED, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2) RETURN YMINTERVAL_UNCONSTRAINED;

FUNCTION cast_to_interval_day_to_second(p_expr IN DSINTERVAL_UNCONSTRAINED, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2 := NULL) RETURN DSINTERVAL_UNCONSTRAINED;

--CASTING NUMBER FUNCTIONS
FUNCTION apply_format(p_expr IN NUMBER, p_fmtstr IN VARCHAR2) RETURN VARCHAR2;

FUNCTION cast_to_char(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN VARCHAR2;

FUNCTION cast_to_number(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_decimal(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_float(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_real(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_double_precision(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BINARY_DOUBLE;
           
FUNCTION cast_to_integer(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;
           
FUNCTION cast_to_smallint(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NUMBER;

FUNCTION cast_to_date(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN DATE;
           
FUNCTION cast_to_interval_year_to_month(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2 := 'YEAR') RETURN INTERVAL YEAR TO MONTH;

FUNCTION cast_to_interval_day_to_second(p_expr IN NUMBER, p_precision IN BINARY_INTEGER := NULL, 
           p_component IN VARCHAR2 := 'DAY') RETURN INTERVAL DAY TO SECOND;
           
--CASTING BLOB/BYTE/VARBYTE/GRAPHIC/LONG VARGRAPHIC FUNCTIONS
FUNCTION cast_to_blob(p_expr IN BLOB, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BLOB;
           
FUNCTION cast_to_blob(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN BLOB;

FUNCTION cast_to_char(p_expr IN BLOB, p_precision IN BINARY_INTEGER := NULL, 
            p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN CHAR;

FUNCTION cast_to_char(p_expr IN CHAR, p_precision IN BINARY_INTEGER := NULL, 
            p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN CHAR;

FUNCTION cast_to_nchar(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NCHAR;
           
FUNCTION cast_to_clob(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN CLOB;
           
FUNCTION cast_to_nvarchar2(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NVARCHAR2;
           
FUNCTION cast_to_nvarchar2(p_expr IN CLOB, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN NVARCHAR2;
           
FUNCTION cast_to_varchar2(p_expr IN VARCHAR2, p_precision IN BINARY_INTEGER := NULL, 
           p_scale IN BINARY_INTEGER := NULL, p_fmtstr IN VARCHAR2 := NULL, p_chrset IN VARCHAR2 := NULL) RETURN VARCHAR2;

           
END TERADATA_UTILITIES;