/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.dbmsoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.Utility;
import oracle.ide.Ide;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class DbmsOutputPane
extends JPanel {
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private JTextField bufferSize;
    private int pollCycle = 15;
    private Timer localTimer = new Timer();
    private Connection connLocal = null;
    private boolean enabled = false;
    private final Toolbar _toolbar = new Toolbar();
    Timer timer;
    boolean frozen = false;
    int delay;

    public DbmsOutputPane(SqlEditorMainPanel parent) {
        this.init(parent);
    }

    public void setDividerLocation(int loc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDbmsOutput() {
        if (!this.enabled) {
            String plsqlString;
            try {
                this.localTimer.cancel();
            }
            catch (IllegalStateException i) {
                // empty catch block
            }
            String isNumber = this.bufferSize.getText();
            try {
                int i = Integer.parseInt(isNumber);
                plsqlString = "BEGIN DBMS_OUTPUT.ENABLE(" + isNumber + "); END;";
            }
            catch (NumberFormatException e) {
                plsqlString = "BEGIN DBMS_OUTPUT.ENABLE(-1); END;";
            }
            CallableStatement stmt = null;
            try {
                stmt = this.connLocal.prepareCall(plsqlString);
                stmt.execute();
                this._toolbar.getComponent(6).setEnabled(true);
                this._toolbar.getComponent(7).setEnabled(true);
                this._toolbar.getComponent(8).setEnabled(true);
                this._toolbar.getComponent(9).setEnabled(true);
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "set serveroutput on\n", null);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                this.start_poll(this.connLocal);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {}
            }
            this.enabled = true;
        }
    }

    public void saveFile(URL filename) {
        String encoding = IdeUtil.getIdeEncoding();
        try {
            FileOutputStream fout = new FileOutputStream(filename.getPath());
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, encoding);
            out.write(this.textPanelArea.getText());
            out.close();
        }
        catch (IOException io) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(filename.getPath() + filename.getFile()), null);
            System.err.println(io);
        }
    }

    public void printOutput() {
        Utility.printText("DBMS Output", this.textPanelArea.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableDbmsOutput() {
        if (this.enabled) {
            String plsqlString = "BEGIN DBMS_OUTPUT.DISABLE(); END;";
            CallableStatement stmt = null;
            try {
                stmt = this.connLocal.prepareCall(plsqlString);
                stmt.execute();
                this._toolbar.getComponent(6).setEnabled(false);
                this._toolbar.getComponent(7).setEnabled(false);
                this._toolbar.getComponent(8).setEnabled(false);
                this._toolbar.getComponent(9).setEnabled(false);
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "set serveroutput off\n", null);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
                this.stop_poll(this.connLocal);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            this.enabled = false;
        }
    }

    public void setupPoller() {
    }

    public void setConnection(Connection conn) {
        this.connLocal = conn;
    }

    public void setStatement(String strStmt) {
        PipedInputStream in = new PipedInputStream();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new PipedOutputStream(in));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void stop_poll(Connection conn) {
        try {
            this.localTimer.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void start_poll(Connection conn) {
        this.localTimer = new Timer();
        this.localTimer.schedule((TimerTask)new Poller(conn, this.textPanelArea), 0L, 3000L);
    }

    private void init(SqlEditorMainPanel parent) {
        ToolbarManager manager = ToolbarManager.getToolbarManager();
        manager.installToolbar("DBMSOutput.Toolbar", this._toolbar, (View)parent.getEditor());
        this._toolbar.addSeparator(new Dimension(15, 15));
        JLabel jLabel = new JLabel("Buffer Size:");
        this._toolbar.add((Component)jLabel);
        this.bufferSize = new JTextField();
        this.bufferSize.setColumns(10);
        this.bufferSize.setText("20000");
        this.bufferSize.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c == 'u') {
                    DbmsOutputPane.this.bufferSize.setText("unlimited");
                    e.consume();
                } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
                    DbmsOutputPane.this.getToolkit().beep();
                    e.consume();
                }
            }
        });
        this.bufferSize.setMaximumSize(new Dimension(70, 20));
        this._toolbar.add((Component)this.bufferSize);
        JSlider pollRateSlider = new JSlider();
        pollRateSlider.setMaximum(15);
        pollRateSlider.setPaintTicks(true);
        pollRateSlider.setToolTipText("Poll frequency [Max 15s]");
        pollRateSlider.setFont(new Font("Dialog", 0, 7));
        pollRateSlider.setMinorTickSpacing(1);
        pollRateSlider.setMajorTickSpacing(15);
        pollRateSlider.setMaximumSize(new Dimension(80, 20));
        pollRateSlider.setActionMap(new ActionMap());
        pollRateSlider.setSnapToTicks(true);
        MouseListener taskPerformer = new MouseListener(){

            public void actionPerformed(ActionEvent evt) {
                JSlider source = (JSlider)evt.getSource();
                int fps = source.getValue();
            }

            public void mouseClicked(MouseEvent e) {
                JSlider source = (JSlider)e.getSource();
                int pollCycle = source.getValue();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        pollRateSlider.addMouseListener(taskPerformer);
        this._toolbar.add((Component)pollRateSlider);
        JLabel jLabelPoll = new JLabel("Poll");
        this._toolbar.add((Component)jLabelPoll);
        JScrollPane scrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.add((Component)scrollPane, "Center");
        PipedInputStream in = new PipedInputStream();
        OutputRedirector outputRedirector = new OutputRedirector(in, this.textPanelArea.getDocument());
        outputRedirector.start();
        UIUtils.addFontListener((Component)this.textPanelArea);
    }

    void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateVisibleActions(UpdateMessage msg) {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    class Poller
    extends TimerTask {
        private Connection localConn = null;
        private CallableStatement show_stmt;
        private BasicEditorPane textPanelArea;

        public Poller(Connection Connin, BasicEditorPane textPanelAreaIn) {
            this.textPanelArea = textPanelAreaIn;
            this.localConn = Connin;
            try {
                this.show_stmt = this.localConn.prepareCall("declare     l_line varchar2(255);     l_done number;     l_buffer long; begin   loop     exit when length(l_buffer)+255 > :maxbytes OR l_done = 1;     dbms_output.get_line( l_line, l_done );     l_buffer := l_buffer || l_line || chr(10);   end loop;  :done := l_done;  :buffer := l_buffer; end;");
            }
            catch (SQLException e) {
                // empty catch block
            }
        }

        public void run() {
            int done = 0;
            try {
                this.show_stmt.registerOutParameter(2, 4);
                this.show_stmt.registerOutParameter(3, 12);
                do {
                    this.show_stmt.setInt(1, DbmsOutputPane.this.pollCycle * 1000);
                    this.show_stmt.executeUpdate();
                    String dbmsOutputString = this.show_stmt.getString(3);
                    if (dbmsOutputString.length() <= 1) continue;
                    try {
                        this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), dbmsOutputString, null);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                } while ((done = this.show_stmt.getInt(2)) != 1);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    class OutputRedirector
    extends Thread {
        PipedInputStream in;
        Document text;
        JScrollPane display;
        String line = "";
        BufferedReader reader;

        public OutputRedirector(PipedInputStream in, Document text) {
            this.in = in;
            this.text = text;
            this.reader = new BufferedReader(new InputStreamReader(in));
        }

        public void run() {
            try {
                while (this.line != null) {
                    try {
                        this.text.insertString(DbmsOutputPane.this.textPanelArea.getDocument().getLength(), this.line + "\n", null);
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                    this.line = this.reader.readLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

