/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.explainPlan;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.util.FastStringBuffer;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;

class ExplainPlanNode
extends DefaultMutableTreeNode {
    private static String[] COLUMNS = new String[]{"LABEL", "OPTIMIZER", "COST", "CARDINALITY", "BYTES", "PARTITION_START", "PARTITION_STOP", "PARTITION_ID", "ACCESS_PREDICATES", "FILTER_PREDICATES"};
    private String _id;
    private String _pId;
    private Map _values = new HashMap();
    protected int _iconID;
    private static final NodeIcon[] _icons = new NodeIcon[]{new NodeIcon(null, null, 245), new NodeIcon("AND-EQUAL", null, 225), new NodeIcon("BITMAP CONVERSION", null, 226), new NodeIcon("BITMAP INDEX", null, 226), new NodeIcon("BITMAP MERGE", null, 227), new NodeIcon("BITMAP MINUS", null, 226), new NodeIcon("BITMAP OR", null, 226), new NodeIcon("CONNECT BY", null, 229), new NodeIcon("CONCATENATION", null, 228), new NodeIcon("COUNT", null, 230), new NodeIcon("DELETE", null, 231), new NodeIcon("DELETE STATEMENT", null, 231), new NodeIcon("DOMAIN INDEX", null, 232), new NodeIcon("FILTER", null, 233), new NodeIcon("FIRST ROW", null, 234), new NodeIcon("FIXED TABLE", null, 235), new NodeIcon("FOR UPDATE", null, 236), new NodeIcon("HASH JOIN", null, 237), new NodeIcon("INDEX", null, 238), new NodeIcon("INSERT STATEMENT", null, 254), new NodeIcon("INLIST ITERATOR", null, 239), new NodeIcon("INTERSECTION", null, 240), new NodeIcon("MERGE JOIN", null, 242), new NodeIcon("MERGE JOIN", "CARTESIAN", 241), new NodeIcon("MINUS", null, 243), new NodeIcon("NESTED LOOPS", null, 244), new NodeIcon("PARTITION", null, 246), new NodeIcon("PARTITION RANGE", null, 248), new NodeIcon("PARTITION HASH", null, 247), new NodeIcon("PROJECTION", null, 249), new NodeIcon("REMOTE", null, 250), new NodeIcon("SELECT STATEMENT", null, 254), new NodeIcon("SEQUENCE", null, 251), new NodeIcon("SORT", null, 252), new NodeIcon("SORT", "JOIN", 253), new NodeIcon("TABLE ACCESS", null, 255), new NodeIcon("UNION", null, 256), new NodeIcon("UNION-ALL", null, 257), new NodeIcon("UPDATE", null, 258), new NodeIcon("UPDATE STATEMENT", null, 258), new NodeIcon("VIEW", null, 259), new NodeIcon("GENERATE", null, 245)};
    private static Map COLUMN_NAMES = new HashMap();

    public static int getColumnCount() {
        return COLUMNS.length;
    }

    public static String getColumnName(int col) {
        return (String)COLUMN_NAMES.get(COLUMNS[col]);
    }

    public ExplainPlanNode(ResultSet rs) throws SQLException {
        this._id = rs.getString("ID");
        this._pId = rs.getString("PARENT_ID");
        String oper = rs.getString("OPERATION");
        String options = rs.getString("OPTIONS");
        String oNode = rs.getString("OBJECT_NODE");
        String oOwner = rs.getString("OBJECT_OWNER");
        String oName = rs.getString("OBJECT_NAME");
        FastStringBuffer buf = new FastStringBuffer(512);
        buf.append(oper);
        if (options != null) {
            buf.append('(').append(options).append(')');
        }
        if (ModelUtil.hasLength((String)oName)) {
            buf.append(' ');
            if (ModelUtil.hasLength((String)oOwner)) {
                buf.append(oOwner).append('.');
            }
            buf.append(oName);
            if (ModelUtil.hasLength((String)oNode)) {
                buf.append('@').append(oNode);
            }
        }
        this._values.put(COLUMNS[0], buf.toString());
        this._iconID = ExplainPlanNode.findBestIcon(oper, options);
        for (int i = 1; i < COLUMNS.length; ++i) {
            try {
                this._values.put(COLUMNS[i], rs.getString(COLUMNS[i]));
                continue;
            }
            catch (SQLException se) {
                if (se.getErrorCode() == 17006) {
                    this._values.put(COLUMNS[i], "");
                    continue;
                }
                se.printStackTrace();
            }
        }
    }

    public String getNodeID() {
        return this._id;
    }

    public String getNodeParentID() {
        return this._pId;
    }

    public String toString() {
        return (String)this._values.get(COLUMNS[0]);
    }

    public String getValue(int col) {
        String result = (String)this._values.get(COLUMNS[col]);
        return result != null ? result : "";
    }

    public Icon getIcon() {
        return _icons[this._iconID].getIcon();
    }

    private static int findBestIcon(String oper, String options) {
        int nBestMatch = 0;
        int nBestPos = 0;
        for (int i = 1; i < _icons.length; ++i) {
            int nNewMatch = _icons[i].getMatch(oper, options);
            if (nNewMatch <= nBestMatch) continue;
            nBestMatch = nNewMatch;
            nBestPos = i;
            if (nNewMatch == 5) break;
        }
        return nBestPos;
    }

    protected boolean isRootPlanNode() {
        return this._pId == null;
    }

    private static void addColumnName(String strColumnName, int nResourceID) {
        String strText = null;
        try {
            strText = ConnectionArb.getString((int)nResourceID);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (strText != null) {
            COLUMN_NAMES.put(strColumnName, strText);
        } else {
            COLUMN_NAMES.put(strColumnName, Translate.translate((String)strColumnName));
        }
    }

    static {
        ExplainPlanNode.addColumnName("LABEL", 209);
        ExplainPlanNode.addColumnName("COST", 210);
        ExplainPlanNode.addColumnName("CARDINALITY", 211);
        ExplainPlanNode.addColumnName("BYTES", 212);
        ExplainPlanNode.addColumnName("OPTIMIZER", 213);
        ExplainPlanNode.addColumnName("PARTITION_START", 216);
        ExplainPlanNode.addColumnName("PARTITION_STOP", 217);
        ExplainPlanNode.addColumnName("PARTITION_ID", 218);
        ExplainPlanNode.addColumnName("ACCESS_PREDICATES", -1);
        ExplainPlanNode.addColumnName("FILTER_PREDICATES", -1);
    }

    private static class NodeIcon {
        public static final int MAX_MATCH = 5;
        private String _strOper;
        private String _strOpt;
        private int _nResIconID;

        NodeIcon(String strOper, String strOpt, int nResIconID) {
            this._strOper = strOper;
            this._strOpt = strOpt;
            this._nResIconID = nResIconID;
        }

        public Icon getIcon() {
            return ConnectionArb.getIcon((int)this._nResIconID);
        }

        public int getMatch(String strOper, String strOpt) {
            if (this._strOper != null) {
                if (this._strOper.equals(strOper)) {
                    if (strOpt == null) {
                        if (this._strOpt == null) {
                            return 4;
                        }
                        return 3;
                    }
                    if (this._strOpt == null) {
                        return 3;
                    }
                    if (this._strOpt == strOpt) {
                        return 5;
                    }
                    return 4;
                }
            } else {
                return 1;
            }
            return 0;
        }
    }
}

