/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.explainPlan;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.sqlworksheet.explainPlan.ExplainNodeRenderer;
import oracle.dbtools.sqlworksheet.explainPlan.ExplainPlanTreeModel;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.TreeTableModel;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;

public class ExplainPlanPane
extends JPanel {
    private JFastTreeTable _table;
    private ExplainPlanTreeModel _model = new ExplainPlanTreeModel();
    private static final TableCellRenderer RENDERER = new CellRenderer();

    public ExplainPlanPane() {
        this.init();
    }

    public void setDividerLocation(int loc) {
    }

    public void setConnection(Connection conn) {
        this._model.setConnection(conn);
    }

    public void setStatement(String strStmt) {
        this._model.setStatement(strStmt);
        this._table.getSelectionModel().clearSelection();
        this._model.reload();
        JTree tree = this._table.getTree();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
        }
        int width = tree.getPreferredSize().width;
        TableColumnModel cModel = this._table.getColumnModel();
        TableColumn col = cModel.getColumn(0);
        col.setPreferredWidth(width);
        col.setMinWidth(width);
        int prefWidth = width;
        for (int i = 1; i < cModel.getColumnCount(); ++i) {
            col = cModel.getColumn(i);
            prefWidth += col.getPreferredWidth();
        }
        this.setPreferredSize(new Dimension(prefWidth, this.getPreferredSize().height));
        this._table.getSelectionModel().setSelectionInterval(0, 0);
        this._table.doLayout();
    }

    private void init() {
        this._table = new JFastTreeTable((TreeTableModel)this._model);
        JScrollPane pane = new JScrollPane((Component)this._table);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setVerticalScrollBarPolicy(20);
        this._table.setAutoResizeMode(0);
        TableColumnModel cModel = this._table.getColumnModel();
        TableColumn col = cModel.getColumn(0);
        col.setPreferredWidth(200);
        col.setWidth(200);
        col.setMinWidth(200);
        for (int i = 1; i < cModel.getColumnCount(); ++i) {
            col = cModel.getColumn(i);
            col.setCellRenderer(RENDERER);
        }
        JTree tree = this._table.getTree();
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new ExplainNodeRenderer());
        Color background = this._table.getBackground();
        pane.setBackground(background);
        pane.getViewport().setBackground(background);
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    public NiceTablePersistentSettings getPersistentSettings() {
        int i;
        NiceTablePersistentSettings settings = new NiceTablePersistentSettings();
        int[] widths = new int[this._table.getModel().getColumnCount()];
        ArrayList<Object> order = new ArrayList<Object>();
        for (i = 0; i < this._table.getModel().getColumnCount(); ++i) {
            int viewColumn = this._table.convertColumnIndexToView(i);
            TableColumn tc = null;
            if (viewColumn != -1) {
                tc = this._table.getTableHeader().getColumnModel().getColumn(viewColumn);
            }
            widths[i] = tc == null ? 0 : tc.getWidth();
        }
        for (i = 0; i < this._table.getColumnModel().getColumnCount(); ++i) {
            TableColumn col = this._table.getColumnModel().getColumn(i);
            Object id = col.getIdentifier();
            order.add(id);
        }
        settings.setColumnWidths(widths);
        settings.setColumnPositions(order);
        return settings;
    }

    public void setPersistentSettings(NiceTablePersistentSettings settings) {
        for (int i = 0; i < settings.getColumnWidths().length; ++i) {
            int viewColumn = this._table.convertColumnIndexToView(i);
            TableColumn tc = null;
            if (viewColumn != -1) {
                tc = this._table.getTableHeader().getColumnModel().getColumn(viewColumn);
            }
            if (tc == null) continue;
            tc.setPreferredWidth(settings.getColumnWidths()[i]);
        }
        List positions = settings.getColumnPositions();
        if (positions != null) {
            for (int pos = 0; pos < positions.size(); ++pos) {
                try {
                    int oldPos = this._table.getColumnModel().getColumnIndex(positions.get(pos));
                    if (oldPos == pos) continue;
                    this._table.getColumnModel().moveColumn(oldPos, pos);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private static class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
            this.setHorizontalAlignment(2);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                Integer.valueOf((String)value);
                c.setHorizontalAlignment(4);
            }
            catch (Exception e) {
                c.setHorizontalAlignment(2);
            }
            return c;
        }
    }
}

