/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.owaoutput;

import java.awt.Component;
import java.net.URL;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.owaoutput.OWAOutputPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLChooser;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public final class OWAOutputController
implements Controller {
    private static final int CLEAR_CMD_ID = Ide.createCmdID((String)"owaoutput.clear");
    private static final int TOGGLE_CMD_ID = Ide.createCmdID((String)"owaoutput.toggle");
    private static final int POLL_CMD_ID = Ide.createCmdID((String)"owaoutput.poll");

    public void createActions() {
        IdeAction.find((int)11).addController((Controller)this);
        IdeAction.find((int)16).addController((Controller)this);
        String category = ConnectionArb.getString((int)20);
        String label = SQLWorksheetArb.getString(13);
        IdeAction.get((int)CLEAR_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)category, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)SQLWorksheetArb.getInstance(), (int)14, null, (boolean)false).addController((Controller)this);
        label = SQLWorksheetArb.getString(11);
        IdeAction toggleAction = IdeAction.get((int)TOGGLE_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)category, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)SQLWorksheetArb.getInstance(), (int)12, null, (boolean)false);
        toggleAction.addController((Controller)this);
        toggleAction.putValue("Check", (Object)Boolean.TRUE);
        toggleAction.setState(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean handleEvent(IdeAction action, Context context) {
        OWAOutputPane pane = this.getPane(context);
        if (pane == null) return false;
        if (action.getCommandId() == CLEAR_CMD_ID) {
            pane.clear();
            return true;
        }
        if (action.getCommandId() == TOGGLE_CMD_ID) {
            if (action.getState()) {
                pane.enableOwaOutput();
                return true;
            }
            pane.disableOwaOutput();
            return true;
        }
        if (action.getCommandId() == 11) {
            URLChooser saveDialog = new URLChooser();
            int saveState = saveDialog.showSaveDialog((Component)pane);
            if (saveState == 0) {
                URL owaFileName = saveDialog.getSelectedURL();
                pane.saveFile(owaFileName);
                return true;
            }
            if (saveState != 1) return true;
            return true;
        } else {
            if (action.getCommandId() == 16) {
                pane.printOutput();
                return true;
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Not yet implemented!", (String)((String)action.getValue("Name")), null);
        }
        return true;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.getPane(context) != null) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    private OWAOutputPane getPane(Context context) {
        SqlEditor editor;
        Component subPage;
        View view = context.getView();
        if (view instanceof SqlEditor && (subPage = (editor = (SqlEditor)context.getView()).getActiveSubPage()) instanceof OWAOutputPane) {
            return (OWAOutputPane)subPage;
        }
        return null;
    }
}

