/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.scriptRunner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.sql.Connection;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.Utility;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class ScriptRunnerPane
extends JPanel {
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private final Toolbar _toolbar = new Toolbar();
    private Connection connLocal = null;
    private ScriptRunnerContext scriptRunnerContext = null;
    private IdeAction actClear;
    private ScriptRunner runner;
    private boolean interrupted = false;
    private SqlEditorMainPanel _parent;

    public void cancelScript() {
        if (this.runner != null) {
            this.runner.interrupt();
        } else {
            this.interrupted = true;
        }
    }

    public boolean isFinished() {
        return !this.runner.isAlive();
    }

    public BasicEditorPane getScriptOutput() {
        return this.textPanelArea;
    }

    public ScriptRunnerPane(SqlEditorMainPanel parent) {
        this._parent = parent;
        this.createActions(parent);
        this.init(parent);
    }

    private void createActions(SqlEditorMainPanel parent) {
        this.actClear = IdeAction.newLocalAction((int)ScriptRunnerController.CLEAR_CMD_ID, (View)parent.getEditor());
    }

    public void setDividerLocation(int loc) {
    }

    public void setConnection(Connection conn) {
        this.connLocal = conn;
    }

    void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void saveFile(URL filename) {
        String encoding = IdeUtil.getIdeEncoding();
        try {
            FileOutputStream fout = new FileOutputStream(filename.getPath());
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, encoding);
            out.write(this.textPanelArea.getText());
            out.close();
        }
        catch (IOException io) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(filename.getPath() + filename.getFile()), null);
            System.err.println(io);
        }
    }

    public void printOutput() {
        Utility.printText("Script Output", this.textPanelArea.getText());
    }

    public void setStatement(String strStmt) {
        BufferedOutputStream out;
        PipedInputStream in;
        block4: {
            in = new PipedInputStream();
            out = null;
            if (this.scriptRunnerContext == null) {
                this.scriptRunnerContext = new ScriptRunnerContext();
            }
            try {
                out = new BufferedOutputStream(new PipedOutputStream(in));
            }
            catch (IOException e) {
                if (this.interrupted) break block4;
                Assert.printStackTrace((Throwable)e);
            }
        }
        this.runner = new ScriptRunner();
        this.scriptRunnerContext.setTopLevel(true);
        this.scriptRunnerContext.setLastUrl(this._parent.getLastUrl());
        this.runner.setOut(out);
        this.runner.setConn(this._parent.getEditor().getConnection());
        this.runner.setScriptRunnerContext(this.scriptRunnerContext);
        this.runner.setStmt(strStmt);
        if (!this.interrupted) {
            this.runner.start();
        }
        this.interrupted = false;
        OutputRedirector outputRedirector = new OutputRedirector(in, this.textPanelArea.getDocument());
        outputRedirector.start();
    }

    private void init(SqlEditorMainPanel parent) {
        Document doc = this.textPanelArea.getDocument();
        ToolbarManager manager = ToolbarManager.getToolbarManager();
        manager.installToolbar("ScriptRunner.Toolbar", this._toolbar, (View)parent.getEditor());
        this._toolbar.addSeparator(new Dimension(15, 15));
        JScrollPane scrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        MouseListener taskPerformer = new MouseListener(){

            public void actionPerformed(ActionEvent evt) {
            }

            public void mouseClicked(MouseEvent e) {
                ScriptRunnerPane.this.clear();
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        this._toolbar.getComponent(0).addMouseListener(taskPerformer);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.add((Component)scrollPane, "Center");
        this._toolbar.getComponent(0).setEnabled(true);
        this._toolbar.getComponent(1).setEnabled(true);
        this._toolbar.getComponent(2).setEnabled(true);
        this._toolbar.getComponent(3).setEnabled(true);
    }

    public void moveToLastRow() {
        this.textPanelArea.setCaretPositionCenter(this.textPanelArea.getDocument().getLength());
    }

    public void updateVisibleActions(UpdateMessage msg) {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    class OutputRedirector
    extends Thread {
        PipedInputStream in;
        Document text;
        JScrollPane display;
        String line = "";
        BufferedReader reader;
        final int DISPLAY_NUMBER_OF_LINES = 50;

        public OutputRedirector(PipedInputStream in, Document textPanelArea) {
            this.in = in;
            this.text = textPanelArea;
            try {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringBuffer chunk = new StringBuffer();
            try {
                while (this.line != null) {
                    for (int i = 0; i <= 50; ++i) {
                        this.line = this.reader.readLine();
                        if (this.line == null) break;
                        chunk.append(this.line + "\n");
                    }
                    this.text.insertString(this.text.getLength(), chunk.toString(), null);
                    chunk = null;
                    chunk = new StringBuffer();
                    ScriptRunnerPane.this.moveToLastRow();
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    this.text.insertString(this.text.getLength(), chunk.toString(), null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                ScriptRunnerPane.this.moveToLastRow();
            }
        }
    }
}

