/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.controls.celleditor.ResultSetCellEditor;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryFilterModel;
import oracle.dbtools.sqlworksheet.sqlview.SqlHistoryModel;
import oracle.dbtools.util.Resource;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SqlEditorHistory {
    private static SqlEditorHistory _sqlEditorHistory = null;
    private JEWTDialog dlg;
    private File file = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "SqlHistory.xml");
    private DefaultTableModel _model = new DefaultTableModel();
    private SqlHistoryModel _sqlHistoryModel = new SqlHistoryModel();
    private SqlHistoryFilterModel _sqlHistoryFilterModel = new SqlHistoryFilterModel(this._model);
    private TableSorter sorter = new TableSorter((TableModel)this._sqlHistoryFilterModel);
    private String[] titles = new String[]{Translate.translate((String)"Sql"), Translate.translate((String)"Connection"), Translate.translate((String)"TimeStamp"), Translate.translate((String)"Executed")};
    private JTable _table = null;
    private JButton btnAppend = null;
    private JButton btnReplace = null;
    private JButton btnClear = null;
    private boolean append;
    private JTextComponent _editor;
    private JTextField _filterText;

    protected SqlEditorHistory() {
        this.loadModel();
        this._table = new JTable((TableModel)this.sorter){

            public Component prepareEditor(TableCellEditor editor, int row, int column) {
                Object value = this.getValueAt(row, column);
                TableCellEditor ed = this.getDefaultEditor(value.getClass());
                Component c2 = ed.getTableCellEditorComponent(this, value, this.isCellSelected(row, column), row, column);
                if (c2 instanceof JTextComponent) {
                    ((JTextComponent)c2).setEditable(false);
                }
                return c2;
            }

            public boolean stopCellEditing() {
                return true;
            }

            public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
                Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    if (this.getValueAt(rowIndex, vColIndex) instanceof Integer) {
                        jc.setToolTipText("<HTML>" + ((Integer)this.getValueAt(rowIndex, vColIndex)).toString().replaceAll("\n", "<br/>\n"));
                    } else {
                        jc.setToolTipText("<HTML>" + ((String)this.getValueAt(rowIndex, vColIndex)).replaceAll("\n", "<br/>\n"));
                    }
                }
                return c;
            }
        };
        this._table.setDefaultEditor(String.class, (TableCellEditor)new ResultSetCellEditor());
        this._table.setDefaultEditor(TableColumn.class, (TableCellEditor)new ResultSetCellEditor());
        this.sorter.setTableHeader(this._table.getTableHeader());
        this._table.setSelectionMode(0);
        Object col = null;
    }

    public int getSize() {
        if (this._model == null) {
            return 0;
        }
        return this._model.getRowCount();
    }

    public void displayHistory(JTextComponent editor) {
        this._editor = editor;
        PropertyPanel filterPanel = new PropertyPanel();
        filterPanel.setLayout((LayoutManager)new BorderLayout());
        this._filterText = new JTextField();
        JButton filterButton = new JButton("Filter");
        filterPanel.add((Component)this._filterText, (Object)"Center");
        filterPanel.add((Component)filterButton, (Object)"East");
        filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SqlEditorHistory.this._sqlHistoryFilterModel.setFilter(SqlEditorHistory.this._filterText.getText());
            }
        });
        PropertyPanel panel = new PropertyPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        String title = Translate.translate((String)"SQL History List");
        JScrollPane sp = new JScrollPane(this._table, 22, 32);
        sp.setSize(this._table.getPreferredSize());
        panel.add((Component)sp, (Object)"Center");
        panel.add((Component)filterPanel, (Object)"North");
        panel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)6);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, "f1_bdbsqlhistory_html");
        this.btnClear = new JButton("Clear");
        this.dlg.addCustomButton((Component)this.btnClear);
        this.btnReplace = new JButton("Replace");
        this.dlg.addCustomButton((Component)this.btnReplace);
        this.btnAppend = new JButton("Append");
        this.dlg.addCustomButton((Component)this.btnAppend);
        ActionListener btnHandler = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Object src = ae.getSource();
                if (src.equals(SqlEditorHistory.this.btnReplace)) {
                    if (SqlEditorHistory.this._table.getSelectedRow() != -1) {
                        String sql = SqlEditorHistory.this.sorter.getValueAt(SqlEditorHistory.this._table.getSelectedRow(), 0).toString();
                        if (!sql.contains(";")) {
                            sql = sql + ";\n";
                        }
                        SqlEditorHistory.this._editor.setText(sql);
                        SqlEditorHistory.this.dlg.dispose();
                    }
                } else if (src.equals(SqlEditorHistory.this.btnAppend)) {
                    if (SqlEditorHistory.this._table.getSelectedRow() != -1) {
                        String sql = SqlEditorHistory.this._editor.getText() + "\n" + SqlEditorHistory.this.sorter.getValueAt(SqlEditorHistory.this._table.getSelectedRow(), 0).toString() + ";\n";
                        SqlEditorHistory.this._editor.setText(sql);
                        SqlEditorHistory.this.dlg.dispose();
                    }
                } else if (src.equals(SqlEditorHistory.this.btnClear)) {
                    for (int i = SqlEditorHistory.this._model.getRowCount(); i > 0; --i) {
                        SqlEditorHistory.this._model.removeRow(i - 1);
                    }
                    SqlEditorHistory.this._model.fireTableDataChanged();
                    SqlEditorHistory.this.writeTable();
                }
            }
        };
        this.btnReplace.addActionListener(btnHandler);
        this.btnAppend.addActionListener(btnHandler);
        this.btnClear.addActionListener(btnHandler);
        MouseListener tblClick = new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    JTable target = (JTable)e.getSource();
                    String sql = SqlEditorHistory.this.sorter.getValueAt(target.getSelectedRow(), 0).toString();
                    SqlEditorHistory.this._editor.setText(sql);
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        };
        this._table.addMouseListener(tblClick);
        Dimension dim = panel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public static synchronized SqlEditorHistory getInstance() {
        if (_sqlEditorHistory == null) {
            _sqlEditorHistory = new SqlEditorHistory();
        }
        return _sqlEditorHistory;
    }

    private synchronized void loadModel() {
        if (this._model.getColumnCount() == 0) {
            for (int i = 0; i < this.titles.length; ++i) {
                this._model.addColumn(this.titles[i]);
            }
            Node _document = null;
            try {
                File sqlHistoryFile = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "SqlHistory.xml");
                DOMParser parser = new DOMParser();
                BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlHistoryFile), "UTF-8")));
                parser.setPreserveWhitespace(false);
                parser.parse((Reader)xml);
                _document = parser.getDocument();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (_document != null) {
                Node _root = _document.getFirstChild();
                NodeList children = _root.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    String sql = XMLHelper.getNodeValue((Node)children.item(i), (String)"Sql");
                    String conn = XMLHelper.getNodeValue((Node)children.item(i), (String)"Connection");
                    String time = XMLHelper.getNodeValue((Node)children.item(i), (String)"TimeStamp");
                    int nosExecuted = 0;
                    try {
                        nosExecuted = Integer.parseInt(XMLHelper.getNodeValue((Node)children.item(i), (String)"Executed"));
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    Object[] data = new Object[]{sql, conn, time, nosExecuted};
                    this._model.addRow(data);
                }
            }
        }
    }

    private int isDuplicate(String data) {
        boolean duplicate = false;
        for (int i = 0; i < this._model.getRowCount(); ++i) {
            if (!data.equals((String)this._model.getValueAt(i, 0))) continue;
            duplicate = true;
            return i;
        }
        return -1;
    }

    private int sqlTimesExecuted(int index) {
        String tmp = this._model.getValueAt(index, 3).toString();
        return Integer.parseInt(tmp);
    }

    public synchronized void saveSql(String sql, String conn) {
        if (!this.hasPassword(sql)) {
            int histCount = 0;
            int executedTimes = 0;
            Object[] data = new String[]{};
            Date now = new Date();
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            String time = df.format(now);
            String timesExecuted = "1";
            executedTimes = Integer.parseInt(timesExecuted);
            int duplicateIndex = this.isDuplicate(sql);
            if (duplicateIndex > -1) {
                executedTimes = this.sqlTimesExecuted(duplicateIndex) + 1;
                this._model.removeRow(duplicateIndex);
                data = new String[]{sql, conn, time, "" + executedTimes};
            } else {
                data = new String[]{sql, conn, time, timesExecuted};
            }
            String HistSize = System.getProperty("raptor.historysize");
            histCount = HistSize == null ? 500 : Integer.parseInt(HistSize);
            if (this._model.getRowCount() >= histCount) {
                this._model.removeRow(this._model.getRowCount() - 1);
                this._model.insertRow(0, data);
            } else {
                this._model.insertRow(0, data);
            }
            this._model.fireTableDataChanged();
            this.writeTable();
        }
    }

    private boolean hasPassword(String sql) {
        return this.hasTokens(sql);
    }

    private boolean hasTokens(String command) {
        boolean retVal = false;
        String[] stringArray = command.trim().split("[ \t\n\r]");
        if (stringArray != null && stringArray.length > 2) {
            if (stringArray[0].equalsIgnoreCase("create") && stringArray[1].equalsIgnoreCase("database") && stringArray[2].equalsIgnoreCase("link") || stringArray[0].equalsIgnoreCase("connect") || stringArray[0].equalsIgnoreCase("alter") && stringArray[1].equalsIgnoreCase("user")) {
                return true;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (i <= 1 || !stringArray[i - 1].equalsIgnoreCase("identified") || !stringArray[i].equalsIgnoreCase("by")) continue;
                return true;
            }
        }
        return false;
    }

    private void writeTable() {
        try {
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.file));
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)output, "UTF-8");
            XMLFormatter formatter = null;
            formatter = new XMLFormatter(this._table, outWriter);
            formatter.setResult(false);
            formatter.print();
            outWriter.close();
        }
        catch (IOException io) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)this.file.getName(), null);
            System.err.println(io);
        }
    }
}

