/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.utils.PlsNode;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.dbmsoutput.DbmsOutputPane;
import oracle.dbtools.sqlworksheet.explainPlan.ExplainPlanPane;
import oracle.dbtools.sqlworksheet.owaoutput.OWAOutputPane;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMarginMark;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorUndoWrapper;
import oracle.dbtools.sqlworksheet.sqlview.SqlLaunchOnOpen;
import oracle.dbtools.sqlworksheet.sqlview.Utility;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolButton;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.view.View;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.DatabaseAddin;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.runner.run.RunArb;

public final class SqlEditorMainPanel
extends JPanel
implements GutterClickListener,
GutterColumnListener {
    private static final String RESULT_PANEL_DATA = "Data";
    private static final String RESULT_PANEL_EXPLAIN = "Explain";
    private static final String RESULT_PANEL_TEXT = "Text";
    private static final String RESULT_PANEL_SCRIPT = "Script";
    private static final String RESULT_DBMS_OUTPUT_PANEL = "DbmsOutput";
    private static final String RESULT_OWA_OUTPUT_PANEL = "OWAOutput";
    private static final String LINE_NUMBER = "SqlEditorContext.LINE_NUMBER";
    private static final String MARK_CATEGORY = "sqlbookmark";
    private static final GridBagConstraints LBL_CONS = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 2, 0), 0, 0);
    private static final GridBagConstraints PNL_CONS = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints DBS_CONS = new GridBagConstraints(0, 1, 1, 1, 2.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints OWA_CONS = new GridBagConstraints(0, 1, 1, 1, 3.0, 3.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
    private JSplitPane spMain = new JSplitPane();
    private JPanel northPanel = new JPanel();
    private JPanel southPane = new JPanel();
    private JPanel southDataPanel = new JPanel();
    private JPanel southTextPanel = new JPanel();
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private JScrollPane spTextPanelArea = new JScrollPane((Component)this.textPanelArea, 22, 32);
    private JPanel southPlanPanel = new JPanel();
    private ScriptRunnerPane southScriptRunnerPanel = new ScriptRunnerPane(this);
    private ExplainPlanPane southExplainPanel = new ExplainPlanPane();
    private DbmsOutputPane southDbmsOutputPane = new DbmsOutputPane(this);
    private OWAOutputPane southOWAOutputPane = new OWAOutputPane(this);
    private Toolbar toolBar = new Toolbar();
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml")};
    private BasicEditorPane taSql = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
    private JScrollPane spSql = new JScrollPane((Component)this.taSql, 22, 32);
    private JViewport viewRows = new JViewport();
    private LineGutterPlugin sqlGutter = new LineGutterPlugin();
    public static HighlightStyle bookMarkHighlightStyle;
    private FileOverviewMargin fileOverviewMargin;
    private JPopupMenu _gridCtxMenu;
    private ResultSetTable tblResults = new ResultSetTable(false);
    private JScrollPane spResults = new JScrollPane((Component)this.tblResults, 22, 30);
    private IdeAction actExecute;
    private IdeAction actExplain;
    private IdeAction actScript;
    private IdeAction actHistory;
    private IdeAction actRefresh;
    private IdeAction actClear;
    private IdeAction actCancel;
    private IdeAction actCommit;
    private IdeAction actRollback;
    private SqlEditor _editor;
    private SqlEditorHandler _handler;
    private FocusHelper _focusHelper;
    private DBConnectionComboBox dbSelector;
    private int gutterLineNo;
    private SqlEditorMainPanel columnListenerPanel;
    private JLabel timerLabel = null;
    private CustomTabbedPane customTab;
    private JProgressBar progressBar;
    private URL _lastUrl;
    private boolean _selectedText = false;
    private Node _node;
    private EditorStatusBar _statusBar;
    private List marksList;
    private List marginMarkList;
    private Icon bookMark;

    SqlEditorMainPanel(SqlEditor editor) {
        try {
            this._editor = editor;
            this.createActions();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFinished() {
        return this.southScriptRunnerPanel.isFinished();
    }

    public void cancelScript() {
        if (this.southScriptRunnerPanel != null) {
            this.southScriptRunnerPanel.cancelScript();
        }
    }

    void updateVisibleActions(UpdateMessage msg) {
        this.southScriptRunnerPanel.updateVisibleActions(msg);
        this.southDbmsOutputPane.updateVisibleActions(msg);
        this.southOWAOutputPane.updateVisibleActions(msg);
    }

    public void addSelectionListener(ChangeListener sl) {
        this.customTab.addChangeListener(sl);
    }

    public void removeChangeListener(ChangeListener sl) {
        this.customTab.removeChangeListener(sl);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.taSql.setEditable(enabled);
    }

    public int getCaretLine() {
        int position = this.taSql.getCaretPosition();
        BasicDocument document = (BasicDocument)this.taSql.getDocument();
        LineMap lineMap = document.getLineMap();
        int line = lineMap.getLineFromOffset(position) + 1;
        return line;
    }

    public void addNotify() {
        super.addNotify();
        if (this._handler == null) {
            this._handler = new SqlEditorHandler();
            this.taSql.addPopupManager((PopupManager)this._handler);
            this.taSql.addKeyListener((KeyListener)this._handler);
            Document doc = this.taSql.getDocument();
            doc.addUndoableEditListener(this._handler);
            this._focusHelper = new FocusHelper(doc);
            this._editor.setCopyableJTableAdapter(new CopyableResultSetTableAdapter((JTable)this.tblResults));
            this.tblResults.addMouseListener((MouseListener)this._handler);
        }
    }

    public void removeNotify() {
        if (this._handler != null) {
            this.taSql.removePopupManager((PopupManager)this._handler);
            this.taSql.removeKeyListener((KeyListener)this._handler);
            this._editor.setCopyableJTableAdapter(null);
            this.taSql.removeMouseListener((MouseListener)this._handler);
            Document doc = this.taSql.getDocument();
            doc.removeUndoableEditListener(this._handler);
            this._focusHelper.cleanup();
            this._focusHelper = null;
            this._handler = null;
        }
        super.removeNotify();
    }

    public void dispose() {
        this.tblResults.closeModel();
        this.taSql.dispose();
        this.textPanelArea.dispose();
        this.toolBar.dispose();
        this.setNode(null);
        this._editor = null;
    }

    private static IdeAction createAction(String actionName, int cmd_id) {
        IdeAction action = IdeAction.get((int)cmd_id, (String)null, (String)actionName);
        action.setEnabled(true);
        action.addController((Controller)SqlEditorController.getInstance());
        action.putValue("sqlworksheet.run", (Object)actionName);
        return action;
    }

    public void createActions() {
        boolean isdbready = false;
        if (this._editor.getDatabase() != null) {
            isdbready = true;
        }
        this.actExecute = IdeAction.newLocalAction((int)SqlEditorController.EXECUTE_SQL_CMD_ID, (View)this._editor);
        this.actExecute.setEnabled(false);
        this.actScript = IdeAction.newLocalAction((int)SqlEditorController.SCRIPT_RUNNER_CMD_ID, (View)this._editor);
        this.actScript.setEnabled(false);
        this.actExplain = IdeAction.newLocalAction((int)SqlEditorController.EXPLAIN_PLAN_CMD_ID, (View)this._editor);
        this.actExplain.setEnabled(false);
        IdeAction action = IdeAction.find((int)SqlEditorController.HISTORY_CMD_ID);
        this.actHistory = action.newLocalAction((View)this._editor);
        this.actHistory.setEnabled(true);
        this.actRefresh = IdeAction.newLocalAction((int)51, (View)this._editor);
        this.actClear = IdeAction.newLocalAction((int)SqlEditorController.CLEAR_CMD_ID, (View)this._editor);
        this.actClear.setEnabled(true);
        this.actCancel = IdeAction.newLocalAction((int)SqlEditorController.CANCEL_CMD_ID, (View)this._editor);
        this.actCancel.setEnabled(false);
        this.actCommit = IdeAction.newLocalAction((int)SqlEditorController.COMMIT_CMD_ID, (View)this._editor);
        this.actCommit.setEnabled(isdbready);
        this.actRollback = IdeAction.newLocalAction((int)SqlEditorController.ROLLBACK_CMD_ID, (View)this._editor);
        this.actRollback.setEnabled(isdbready);
    }

    private void jbInit() throws Exception {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap ksm = kso.getLocalKeyMap(ksc);
        ToolButton button = null;
        this.setLayout(new BorderLayout());
        this.spMain.setOrientation(0);
        this.spMain.setOneTouchExpandable(true);
        this.southDataPanel.setLayout(new GridBagLayout());
        this.southTextPanel.setLayout(new GridBagLayout());
        this.southPlanPanel.setLayout(new GridBagLayout());
        this.textPanelArea.setText("");
        button = this.toolBar.add((ToggleAction)this.actExecute);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(35)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actExecute.getCommandId()) + ")");
        button = this.toolBar.add((ToggleAction)this.actScript);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(36)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actScript.getCommandId()) + ")");
        button = this.toolBar.add((ToggleAction)this.actCommit);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(50)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actCommit.getCommandId()) + ")");
        button = this.toolBar.add((ToggleAction)this.actRollback);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(51)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actRollback.getCommandId()) + ")");
        button = this.toolBar.add((ToggleAction)this.actCancel);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(7)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actCancel.getCommandId()) + ")");
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        button = this.toolBar.add((ToggleAction)this.actHistory);
        button.setToolTipText(StringUtils.stripMnemonic((String)ConnectionArb.getString((int)178)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actHistory.getCommandId()) + ")");
        button = this.toolBar.add((ToggleAction)this.actExplain);
        button.setToolTipText(StringUtils.stripMnemonic((String)ConnectionArb.getString((int)177)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actExplain.getCommandId()) + ")");
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        button = this.toolBar.add((ToggleAction)this.actClear);
        button.setToolTipText(StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(5)) + " (" + KeyUtil.getAcceleratorTooltip((KeyStrokeMap)ksm, (int)this.actClear.getCommandId()) + ")");
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.progressBar = new JProgressBar(0, 60);
        this.progressBar.setIndeterminate(true);
        Dimension minDim = this.progressBar.getMinimumSize();
        this.progressBar.setMinimumSize(new Dimension(65, minDim.height));
        this.progressBar.setVisible(false);
        this.progressBar.setMaximumSize(new Dimension(65, minDim.height));
        this.toolBar.addSeparator();
        this.toolBar.add((Component)this.progressBar);
        this.timerLabel = new JLabel();
        this.timerLabel.setSize(10, 2);
        this.toolBar.add((Component)this.timerLabel);
        this.toolBar.addSeparator();
        this.toolBar.add(Box.createHorizontalGlue());
        this.dbSelector = new DBConnectionComboBox((Container)this.toolBar);
        this.dbSelector.getJComboBox().addItemListener(new ItemListener(){
            private Object lastConn;

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && SqlEditorMainPanel.this._editor != null) {
                    SqlLaunchOnOpen.OPEN_DEFAULT = false;
                    if (SqlEditorMainPanel.this.dbSelector.getCurrentDatabase() == null) {
                        SqlEditorMainPanel.this.dbSelector.setCurrentConnection(((JLabel)this.lastConn).getText());
                    } else {
                        SqlEditorMainPanel.this._editor.setDb(SqlEditorMainPanel.this.dbSelector.getCurrentDatabase());
                        SqlEditorMainPanel.this.updateToolBarActions();
                    }
                    View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.getToolbar());
                    SqlLaunchOnOpen.OPEN_DEFAULT = true;
                } else if (e.getStateChange() == 2) {
                    this.lastConn = e.getItem();
                }
            }
        });
        JLabel lblSql = new JLabel();
        ResourceUtils.resLabel((JLabel)lblSql, (Component)this.taSql, (String)ConnectionArb.getString((int)160));
        this.taSql.setText("");
        this.taSql.setDocument((Document)new BasicDocument("foo.plsql"));
        this.taSql.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this._statusBar = new EditorStatusBar();
        this.taSql.installPlugin((EditorPlugin)this._statusBar);
        this.taSql.installPlugin((EditorPlugin)this.sqlGutter);
        this.spSql.setRowHeaderView((Component)this.sqlGutter);
        this.sqlGutter.addGutterClickListener((GutterClickListener)this);
        this.createContextMenu();
        this.fileOverviewMargin = new FileOverviewMargin();
        this.taSql.installPlugin((EditorPlugin)this.fileOverviewMargin);
        this.northPanel.setLayout(new GridBagLayout());
        this.northPanel.add((Component)lblSql, LBL_CONS);
        this.northPanel.add((Component)this.spSql, PNL_CONS);
        this.northPanel.setPreferredSize(new Dimension(200, 200));
        JPanel editorAndMargin = new JPanel(new BorderLayout());
        editorAndMargin.add((Component)this.northPanel, "Center");
        editorAndMargin.add((Component)this.fileOverviewMargin, "East");
        this.spMain.setLeftComponent(editorAndMargin);
        this.textPanelArea.setDocument((Document)new BasicDocument("foo.txt"));
        LineGutterPlugin textGutter = new LineGutterPlugin();
        this.textPanelArea.installPlugin((EditorPlugin)textGutter);
        this.spTextPanelArea.setRowHeaderView((Component)textGutter);
        JTable rowHeader = this.tblResults.getRowHeader();
        this.viewRows.setView(rowHeader);
        this.viewRows.setPreferredSize(rowHeader.getMaximumSize());
        this.spResults.setRowHeader(this.viewRows);
        JLabel lblResults = new JLabel();
        ResourceUtils.resLabel((JLabel)lblResults, (Component)this.tblResults, (String)ConnectionArb.getString((int)161));
        this.southDataPanel.add((Component)lblResults, LBL_CONS);
        this.southDataPanel.add((Component)this.spResults, PNL_CONS);
        JLabel lblExplain = new JLabel();
        ResourceUtils.resLabel((JLabel)lblExplain, (Component)this.southExplainPanel, (String)ConnectionArb.getString((int)162));
        this.southPlanPanel.add((Component)lblExplain, LBL_CONS);
        this.southPlanPanel.add((Component)this.southExplainPanel, PNL_CONS);
        JLabel lblScript = new JLabel();
        ResourceUtils.resLabel((JLabel)lblScript, (Component)this.southScriptRunnerPanel, (String)"Script Results");
        JLabel lblDbms = new JLabel();
        ResourceUtils.resLabel((JLabel)lblDbms, (Component)this.southScriptRunnerPanel, (String)"DBMS Output");
        JLabel lblOwa = new JLabel();
        ResourceUtils.resLabel((JLabel)lblOwa, (Component)this.southScriptRunnerPanel, (String)"OWA Output");
        this.southPlanPanel.add((Component)lblScript, LBL_CONS);
        this.southPlanPanel.add((Component)this.southScriptRunnerPanel, PNL_CONS);
        this.southPlanPanel.add((Component)lblDbms, LBL_CONS);
        this.southPlanPanel.add((Component)this.southDbmsOutputPane, DBS_CONS);
        this.southPlanPanel.add((Component)lblOwa, LBL_CONS);
        this.southPlanPanel.add((Component)this.southOWAOutputPane, OWA_CONS);
        JLabel lblResults2 = new JLabel();
        ResourceUtils.resLabel((JLabel)lblResults2, (Component)this.textPanelArea, (String)ConnectionArb.getString((int)161));
        this.southTextPanel.add((Component)lblResults2, LBL_CONS);
        this.southTextPanel.add((Component)this.spTextPanelArea, PNL_CONS);
        this.southPane.setLayout(new CardLayout());
        this.southPane.add(RESULT_PANEL_DATA, this.southDataPanel);
        this.southPane.add(RESULT_PANEL_SCRIPT, this.southPlanPanel);
        this.southPane.add(RESULT_PANEL_EXPLAIN, this.southPlanPanel);
        this.southPane.add(RESULT_PANEL_TEXT, this.southTextPanel);
        this.southPane.add(RESULT_DBMS_OUTPUT_PANEL, this.southTextPanel);
        this.southPane.add(RESULT_OWA_OUTPUT_PANEL, this.southTextPanel);
        this.customTab = new CustomTabbedPane();
        this.customTab.addTab(RunArb.getIcon((int)3), "Results", (JComponent)this.southPane);
        this.customTab.addTab(SQLWorksheetArb.getIcon(37), "Script Output", (JComponent)this.southScriptRunnerPanel);
        this.customTab.addTab(ConnectionArb.getIcon((int)159), RESULT_PANEL_EXPLAIN, (JComponent)this.southExplainPanel);
        this.customTab.addTab(SQLWorksheetArb.getIcon(39), "DBMS Output", (JComponent)this.southDbmsOutputPane);
        this.customTab.addTab(SQLWorksheetArb.getIcon(10), "OWA Output", (JComponent)this.southOWAOutputPane);
        this.spMain.setRightComponent((Component)this.customTab);
        final DocumentListener DL = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.toolBar);
            }

            public void removeUpdate(DocumentEvent e) {
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.taSql.getDocument().addDocumentListener(DL);
        this.taSql.addPropertyChangeListener("document", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent pce) {
                Document newDoc;
                Document oldDoc = (Document)pce.getOldValue();
                if (oldDoc != null) {
                    oldDoc.removeDocumentListener(DL);
                    if (SqlEditorMainPanel.this._handler != null) {
                        oldDoc.removeUndoableEditListener(SqlEditorMainPanel.this._handler);
                    }
                }
                if ((newDoc = (Document)pce.getNewValue()) != null) {
                    newDoc.addDocumentListener(DL);
                    if (SqlEditorMainPanel.this._handler != null) {
                        newDoc.addUndoableEditListener(SqlEditorMainPanel.this._handler);
                    }
                }
            }
        });
        this.spMain.revalidate();
        this.spMain.setDividerLocation(150);
        this.add((Component)this.toolBar, "North");
        this.add((Component)this.spMain, "Center");
        new RaptorDnD((JTextComponent)this.taSql);
        this.tblResults.setTranslatedColNames(false);
        this.tblResults.setThreaded(false);
    }

    public JSplitPane getSplitPane() {
        return this.spMain;
    }

    public void invokeInsight() {
        if (DatabaseAddin.useDatabaseInsight()) {
            Context ctx = this._editor.getContext();
            this.taSql.installPlugin((EditorPlugin)new CompletionInsight(ctx, this._editor.getDatabase()));
        }
    }

    Toolbar getToolbar() {
        return this.toolBar;
    }

    public boolean isTextSelected() {
        return this._selectedText;
    }

    public String getSqlStatement() {
        String selectedText = this.taSql.getSelectedText();
        String result = "";
        if (selectedText != null) {
            result = selectedText;
            this._selectedText = true;
        } else {
            result = this.taSql.getText();
            this._selectedText = false;
        }
        if (result == null) {
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasText(boolean skipWhitespace) {
        boolean hasText;
        block5: {
            hasText = false;
            TextBuffer buf = ((BasicDocument)this.taSql.getDocument()).getTextBuffer();
            buf.readLock();
            try {
                int len = buf.getLength();
                if (!skipWhitespace) {
                    hasText = len > 0;
                    break block5;
                }
                int pos = 0;
                while (pos < len) {
                    char c;
                    if (Character.isWhitespace(c = buf.getChar(pos++))) continue;
                    hasText = true;
                    break;
                }
            }
            finally {
                buf.readUnlock();
            }
        }
        return hasText;
    }

    public String stripCarriageReturns(String sql) {
        if (sql == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(sql.length());
        char[] chars = sql.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\r') continue;
            result.append(chars[i]);
        }
        return result.toString();
    }

    public void updateToolBarActions() {
        if (this._editor.getDatabase() != null) {
            this.actExecute.setEnabled(true);
            this.actExplain.setEnabled(true);
            this.actScript.setEnabled(true);
            this.actHistory.setEnabled(true);
            this.actRefresh.setEnabled(true);
            this.actClear.setEnabled(true);
            this.actCancel.setEnabled(false);
        }
    }

    public void setSqlStatement(String sqlStmt) {
        this.updateToolBarActions();
        this.taSql.setText(sqlStmt);
    }

    public boolean canRefreshView() {
        return this.southDataPanel.isShowing();
    }

    public void refreshView() {
        if (this.tblResults != null) {
            this.tblResults.refresh();
        }
    }

    void setSQLText(String txt) {
        this.setSqlStatement(txt);
    }

    String getSQLText() {
        return this.taSql.getText();
    }

    TextBuffer getSQLTextAsBuffer() {
        BasicDocument doc = (BasicDocument)this.taSql.getDocument();
        return doc.getTextBuffer();
    }

    public BasicEditorPane getSQLEditorPane() {
        return this.taSql;
    }

    public BasicEditorPane getScriptOutputArea() {
        return this.southScriptRunnerPanel.getScriptOutput();
    }

    public final void setResultSet(ResultSet rs, String text, boolean success, String sql) {
        this._closeTableModel();
        if (rs == null) {
            this._setResultSetText(text, success);
        } else {
            this._setResultSetData(rs, sql);
        }
    }

    public final void setFocusForResultSet() {
        this.customTab.setSelectedIndex(0);
    }

    public final void setResultSet(ResultSet rs, String text, boolean success, String sql, ArrayList binds) {
        this._closeTableModel();
        if (rs == null) {
            this._setResultSetText(text, success);
        } else {
            this._setResultSetData(rs, sql, binds);
        }
    }

    public final void setQueryResultSet(ResultSet rs, String text, boolean success, String sql, HashMap binds) {
        this._closeTableModel();
        this._setQueryResultSetData(rs, sql, binds);
    }

    public final void setResultSet(ResultSet rs, String text, boolean success, String sql, HashMap binds) {
        this._closeTableModel();
        if (rs == null) {
            this._setResultSetText(text, success);
        } else {
            this._setResultSetData(rs, sql, binds);
        }
    }

    private final void _setResultSetData(ResultSet rs, String sql) {
        Assert.precondition((rs != null ? 1 : 0) != 0, (String)"(null) ResultSet passed to _setResultSetData");
        this.tblResults.setQuery(this._editor.getConnection(), rs, sql);
    }

    private final void _setResultSetData(ResultSet rs, String sql, ArrayList binds) {
        Assert.precondition((rs != null ? 1 : 0) != 0, (String)"(null) ResultSet passed to _setResultSetData");
        this.tblResults.setQuery(this._editor.getConnection(), rs, sql, binds);
    }

    private final void _setQueryResultSetData(ResultSet rs, String sql, HashMap binds) {
        this.tblResults.setQuery(this._editor.getConnection(), rs, sql, binds);
    }

    private final void _setResultSetData(ResultSet rs, String sql, HashMap binds) {
        Assert.precondition((rs != null ? 1 : 0) != 0, (String)"(null) ResultSet passed to _setResultSetData");
        this.tblResults.setQuery(this._editor.getConnection(), rs, sql, binds);
    }

    private void _closeTableModel() {
        this.tblResults.closeModel();
    }

    private final void _setResultSetText(String text, boolean fSuccess) {
        if (fSuccess) {
            String results = text.equals("0") || text.equals("-1") ? ConnectionArb.getString((int)168) : (text.equals("1") ? ConnectionArb.getString((int)169) : ConnectionArb.format((int)170, (Object)text));
            this.textPanelArea.setEditable(true);
            this.textPanelArea.setText(results);
            this.textPanelArea.setEditable(false);
        } else {
            this.textPanelArea.setEditable(true);
            this.textPanelArea.setText(text);
            this.textPanelArea.setEditable(false);
        }
    }

    public final void explainPlan(String strStmt) {
        this.southExplainPanel.setStatement(strStmt);
        this.customTab.setSelectedIndex(2);
    }

    public final void scriptRunner(String strStmt) {
        this.southScriptRunnerPanel.setStatement(strStmt);
        this.customTab.setSelectedIndex(1);
    }

    private void _tryContextMenu(MouseEvent e) {
        Context ctx;
        Component c = e.getComponent();
        c.requestFocus();
        if (e.isPopupTrigger() && (ctx = this._editor.getContext(e)) != null) {
            this._editor.getContextMenu().show(ctx);
        }
    }

    public SqlEditor getEditor() {
        return this._editor;
    }

    public void setConnections(Connection conn) {
        this.southExplainPanel.setConnection(conn);
        this.southScriptRunnerPanel.setConnection(conn);
        this.southDbmsOutputPane.setConnection(conn);
        this.southOWAOutputPane.setConnection(conn);
        this.dbSelector.setCurrentConnection(this._editor.getDb().getConnectionName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveView(boolean prompt) {
        int saveState = 0;
        boolean askForName = true;
        if (this._node instanceof SqlNode) {
            askForName = false;
        } else if (this._node instanceof SqlEditorNode) {
            SqlEditorNode sen = (SqlEditorNode)this._node;
            boolean bl = askForName = sen.getSqlNode() == null || sen.isTempFile();
        }
        if (prompt || askForName) {
            if (this._lastUrl == null) {
                this.setLastUrl();
            }
            URLChooser saveDialog = DialogUtil.newURLChooser((URL)this._lastUrl);
            saveDialog.clearChooseableURLFilters();
            saveDialog.addChooseableURLFilter(PlsNode.PLS_FILTER);
            saveDialog.addChooseableURLFilter(PlsNode.PLB_FILTER);
            saveDialog.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
            saveDialog.setURLFilter(SqlNode.SQL_FILTER);
            saveState = saveDialog.showSaveDialog((Component)this);
            if (saveState == 0) {
                URL url = saveDialog.getSelectedURL();
                if (!ModelUtil.hasLength((String)URLFileSystem.getSuffix((URL)url))) {
                    if (saveDialog.getSelectedFilter() == PlsNode.PLS_FILTER) {
                        url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".pls");
                    } else if (saveDialog.getSelectedFilter() == PlsNode.PLB_FILTER) {
                        url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".plb");
                    } else if (saveDialog.getSelectedFilter() == SqlNode.SQL_FILTER) {
                        url = URLFileSystem.convertSuffix((URL)url, (String)"", (String)".sql");
                    }
                }
                if (URLFileSystem.exists((URL)url)) {
                    switch (MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)"File exists, overwrite? ", (String)URLFileSystem.getPlatformPathName((URL)url))) {
                        case 1: {
                            this.saveImpl(url);
                            this._editor.getContext().getNode().notifyObservers((Object)this._editor.getContext().getNode(), new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
                            break;
                        }
                    }
                } else {
                    this.saveImpl(url);
                }
                FileOpenHistory.getInstance().updateFileHistory(url);
                this._lastUrl = url;
                return;
            }
            if (saveState != 1) return;
        }
        try {
            this._node.save();
            this._editor.markDirty(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this._editor.setMD5(this.taSql.getText());
    }

    private void saveImpl(URL url) {
        SqlEditorMainPanel.writeFile(url, this.getSQLTextAsBuffer());
        if (this._node instanceof SqlNode) {
            SqlNode sqlNode = (SqlNode)this._node;
            sqlNode.setURL(url);
        } else {
            SqlEditorNode sen = (SqlEditorNode)this._node;
            SqlNode sqlNode = sen.getSqlNode();
            if (sqlNode == null) {
                sqlNode = new SqlNode(url);
                sen.setSqlNode(sqlNode);
            } else {
                sqlNode.setURL(url);
            }
            sen.setTempFile(false);
        }
        this._editor.markDirty(false);
        this._editor.setMD5(this.taSql.getText());
    }

    private void setLastUrl() {
        try {
            URL home;
            File f = new File(System.getProperty("user.home"));
            this._lastUrl = home = f.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public URL getLastUrl() {
        if (this._lastUrl == null) {
            this.setLastUrl();
        }
        return this._lastUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeFile(URL url, TextBuffer buf) {
        OutputStream os = null;
        Writer w = null;
        try {
            os = URLFileSystem.openOutputStream((URL)url);
            w = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), IdeUtil.getIdeEncoding());
            buf.write(w, false);
        }
        catch (IOException ex) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)URLFileSystem.getPlatformPathName((URL)url), null);
            System.err.println(ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (Exception ex) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    public static boolean writeFile(File file, String dataString) {
        try {
            String encoding = IdeUtil.getIdeEncoding();
            FileOutputStream fout = new FileOutputStream(file.getPath());
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)bout, encoding);
            out.write(dataString);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)file.toString(), null);
            System.err.println(e);
            return false;
        }
        return true;
    }

    public void printView() {
        Utility.printText(SQLWorksheetArb.getString(42), this.taSql.getText());
    }

    public void openWsFile() {
        int openState = 0;
        if (this._lastUrl == null) {
            this.setLastUrl();
        }
        URLChooser openDialog = DialogUtil.newURLChooser((URL)this._lastUrl);
        openDialog.clearChooseableURLFilters();
        openDialog.addChooseableURLFilter(PlsNode.PLS_FILTER);
        openDialog.addChooseableURLFilter(PlsNode.PLB_FILTER);
        openDialog.addChooseableURLFilter(URLChooser.ALL_FILES_FILTER);
        openDialog.setURLFilter(SqlNode.SQL_FILTER);
        openState = openDialog.showOpenDialog((Component)this);
        if (openState == 0) {
            this.openFile(openDialog.getSelectedURL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFile(URL filename) {
        BasicDocument doc = (BasicDocument)this.taSql.getDocument();
        TextBuffer buffer = doc.getTextBuffer();
        buffer.writeLock();
        this._lastUrl = filename;
        Reader reader = null;
        try {
            String encoding = IdeUtil.getIdeEncoding();
            this.taSql.setText("");
            reader = URLFileSystem.createReader((URL)filename, (String)encoding);
            buffer.read(reader);
            if (this._node instanceof SqlNode) {
                SqlNode sqlNode = (SqlNode)this._node;
                sqlNode.setURL(filename);
            } else {
                SqlEditorNode sen = (SqlEditorNode)this._node;
                SqlNode sqlNode = sen.getSqlNode();
                if (sqlNode == null) {
                    sqlNode = new SqlNode(filename);
                    sen.setSqlNode(sqlNode);
                } else {
                    sqlNode.setURL(filename);
                }
                sen.setTempFile(false);
            }
            this._editor.markDirty(false);
            this.taSql.setCaretPosition(this.taSql.getText().length());
            View.updateToolbarActions((Toolbar)this.toolBar);
        }
        catch (IOException io) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could not Read File", (String)(filename.getPath() + filename.getFile()), null);
            Assert.printStackTrace((Throwable)io);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
            buffer.writeUnlock();
        }
        this._editor.updateVisibleActions();
    }

    public Icon getIcon(String iconString) {
        URL url;
        if (this.bookMark == null && (url = this.getClass().getResource(iconString)) != null) {
            this.bookMark = new ImageIcon(url);
        }
        return this.bookMark;
    }

    public void lineClicked(Gutter gutter, int i, MouseEvent e) {
        this.gutterLineNo = i;
        this.columnListenerPanel = this;
        LineGutterPlugin thisGutter = (LineGutterPlugin)e.getSource();
        int nModifier = e.getModifiers();
        if ((nModifier & 8) != 0 || (nModifier & 4) != 0) {
            this._gridCtxMenu.show((Component)thisGutter, e.getX(), e.getY());
        }
    }

    private void createContextMenu() {
        if (this._gridCtxMenu == null) {
            this._gridCtxMenu = new JPopupMenu("Context Menu");
            JMenuItem bmrk = new JMenuItem("Toggle BookMarks");
            JMenuItem lnum = new JMenuItem("Toggle Line Numbers");
            JPopupMenu gutterOptions = new JPopupMenu("Gutter Menu");
            bmrk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Assert.println((String)"BookMark");
                    GutterColumn column1 = SqlEditorMainPanel.this.sqlGutter.lookupGutterColumn("BookMarks");
                    if (column1 == null) {
                        column1 = SqlEditorMainPanel.this.sqlGutter.createGutterColumn("BookMarks", (GutterColumnListener)SqlEditorMainPanel.this.columnListenerPanel);
                    }
                    if (SqlEditorMainPanel.this.marksList == null) {
                        SqlEditorMainPanel.this.marksList = new ArrayList();
                        SqlEditorMainPanel.this.bookMark = SqlEditorMainPanel.this.getIcon(SQLWorksheetArb.getString(22));
                    }
                    if (SqlEditorMainPanel.this.marginMarkList == null) {
                        SqlEditorMainPanel.this.marginMarkList = new ArrayList();
                    }
                    boolean markFound = false;
                    Iterator marksIterator = SqlEditorMainPanel.this.marksList.iterator();
                    int clickedLine = SqlEditorMainPanel.this.gutterLineNo;
                    while (marksIterator.hasNext()) {
                        GutterMark mark = (GutterMark)marksIterator.next();
                        if (mark.getLine() != clickedLine) continue;
                        mark.getGutterColumn().removeGutterMark(mark);
                        marksIterator.remove();
                        markFound = true;
                        break;
                    }
                    if (!markFound) {
                        Object newMark = null;
                        EditorProperties properties = EditorProperties.getProperties();
                        HighlightRegistry hregistry = properties.getHighlightRegistry();
                        bookMarkHighlightStyle = hregistry.createStyle("Bookmark", "BookMark", 20, Color.black, new Color(153, 255, 255));
                        FileOverviewMargin.setMarkColor((String)SqlEditorMainPanel.MARK_CATEGORY, (HighlightStyle)bookMarkHighlightStyle);
                        SqlEditorMainPanel.this.marksList.add(column1.addGutterMark(clickedLine, SqlEditorMainPanel.this.bookMark, bookMarkHighlightStyle, 1, 1));
                        SqlEditorMarginMark marginMark = new SqlEditorMarginMark(clickedLine, clickedLine, "BookMark: Line " + clickedLine);
                        SqlEditorMainPanel.this.fileOverviewMargin.addMark(SqlEditorMainPanel.MARK_CATEGORY, clickedLine, (FileOverviewMark)marginMark);
                        if (newMark != null) {
                            SqlEditorMainPanel.this.marksList.add(newMark);
                        }
                    }
                }
            });
            lnum.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditorProperties properties = EditorProperties.getProperties();
                    boolean showLineNumbers = !properties.getBooleanProperty("show-line-numbers");
                    properties.putBooleanProperty("show-line-numbers", showLineNumbers);
                }
            });
            gutterOptions.add(bmrk);
            gutterOptions.add(lnum);
            this._gridCtxMenu.add(gutterOptions);
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    int nModifier = e.getModifiers();
                    if ((nModifier & 8) != 0 || (nModifier & 4) != 0) {
                        SqlEditorMainPanel.this._gridCtxMenu.show((Component)SqlEditorMainPanel.this.sqlGutter, e.getX(), e.getY());
                    }
                }
            });
            this._gridCtxMenu = gutterOptions;
        }
    }

    public void markMoved(GutterMark gutterMark, int i, int j) {
    }

    public void markRemoved(GutterMark gutterMark, int i) {
        int existingIndex = this.marksList.indexOf(gutterMark);
        if (existingIndex != -1) {
            this.marksList.remove(existingIndex);
        }
    }

    public void markClicked(GutterMark gutterMark, int i, MouseEvent mouseEvent) {
        gutterMark.getGutterColumn().removeGutterMark(gutterMark);
        this.marksList.remove(gutterMark);
    }

    public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
        return null;
    }

    void setNode(Node node) {
        if (node != this._node) {
            SqlNode sNode = this.getSqlNode(this._node);
            if (sNode != null) {
                sNode.releaseTextBuffer();
            }
            this._node = node;
            sNode = this.getSqlNode(this._node);
            if (this._node != null) {
                TextBuffer buffer = sNode.acquireTextBuffer();
                BasicDocument doc = new BasicDocument("foo.sql", buffer);
                this.taSql.setDocument((Document)doc);
            }
        }
    }

    private SqlNode getSqlNode(Node node) {
        if (node instanceof SqlNode) {
            return (SqlNode)node;
        }
        if (node instanceof SqlEditorNode) {
            return ((SqlEditorNode)node).getSqlNode();
        }
        return null;
    }

    public NiceTablePersistentSettings getPersistentSettings() {
        return this.southExplainPanel.getPersistentSettings();
    }

    public void setPersistentSettings(NiceTablePersistentSettings settings) {
        this.southExplainPanel.setPersistentSettings(settings);
    }

    public ResultSetTable getResultSetTable() {
        return this.tblResults;
    }

    public JComponent getActivePanel() {
        return this.customTab.getActivePanel();
    }

    public CustomTabbedPane getCustomTabbedPanel() {
        return this.customTab;
    }

    public void updateTimer(long time) {
        if (this.timerLabel != null) {
            float sec = 0.0f;
            if (time > 0L) {
                sec = Float.parseFloat(time + "") / 1000.0f;
            }
            Object[] args = new Object[]{new Float(sec)};
            String s = MessageFormat.format("{0,number,#.####} seconds", args);
            this.timerLabel.setText(" " + s);
            this.timerLabel.repaint();
            this.toggleProgress(false);
        }
    }

    public void toggleProgress(Boolean state) {
        this.progressBar.setVisible(state);
    }

    public void refreshTimer() {
        if (this.timerLabel != null) {
            this.timerLabel.setBorder(null);
            this.timerLabel.setText("");
            this.timerLabel.repaint();
        }
    }

    public EditorStatusBar getStatusBar() {
        return this._statusBar;
    }

    private class SqlEditorHandler
    implements PopupManager,
    KeyListener,
    MouseListener,
    UndoableEditListener {
        private SqlEditorHandler() {
        }

        public void showPopup(BasicEditorPane editor, MouseEvent event) {
            ContextMenu contextMenu = SqlEditorMainPanel.this._editor.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show(SqlEditorMainPanel.this._editor.getContext(event));
            }
        }

        public void hidePopup(BasicEditorPane editor) {
        }

        public void keyTyped(KeyEvent e) {
            IdeAction action;
            View.updateToolbarActions((Toolbar)SqlEditorMainPanel.this.toolBar);
            if (e.getKeyChar() == '\n' && e.isControlDown() && (action = IdeAction.find((int)SqlEditorController.EXECUTE_SQL_CMD_ID)) != null) {
                try {
                    action.performAction();
                }
                catch (Exception ex) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
                }
            }
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            Context ctx = SqlEditorMainPanel.this._editor.getContext(e);
            Object obj = ctx.getEvent().getSource();
            if (!obj.getClass().toString().equals("oracle.javatools.editor.gutter.LineGutterPlugin")) {
                SqlEditorMainPanel.this._tryContextMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            SqlEditorMainPanel.this._tryContextMenu(e);
        }

        public void undoableEditHappened(UndoableEditEvent event) {
            UndoableEdit edit = event.getEdit();
            SqlEditorUndoWrapper command = new SqlEditorUndoWrapper(edit);
            CommandProcessor processor = CommandProcessor.getInstance();
            command.setContext(SqlEditorMainPanel.this._editor.getContext());
            try {
                processor.invoke((Command)command);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private final class FocusHelper
    implements FocusListener {
        private FocusHelper(Document doc) {
            this.addFocusListenerRecurse(SqlEditorMainPanel.this);
        }

        private void addFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] children = ((Container)component).getComponents();
                for (int i = 0; i < children.length; ++i) {
                    this.addFocusListenerRecurse(children[i]);
                }
            }
            component.addFocusListener(this);
        }

        private void cleanup() {
            this.removeFocusListenerRecurse(SqlEditorMainPanel.this);
        }

        private void removeFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] children = ((Container)component).getComponents();
                for (int i = 0; i < children.length; ++i) {
                    this.removeFocusListenerRecurse(children[i]);
                }
            }
            component.removeFocusListener(this);
        }

        public void focusGained(FocusEvent event) {
            SqlEditorMainPanel.this._editor.setFocusedComponent((Component)event.getSource());
            Component focusedComponent = SqlEditorMainPanel.this._editor.getFocusedComponent();
        }

        public void focusLost(FocusEvent event) {
        }
    }
}

