/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class SqlHistoryFilterModel
extends AbstractTableModel
implements TableModelListener {
    protected ArrayList indexList = new ArrayList(0);
    protected String filter = "";
    protected TableModel model;

    public SqlHistoryFilterModel() {
    }

    public SqlHistoryFilterModel(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel model) {
        this.model = model;
        model.addTableModelListener(this);
        this.reallocateIndexes();
    }

    public TableModel getModel() {
        return this.model;
    }

    public synchronized void setFilter(String filter) {
        this.filter = filter;
        int rowCount = this.model.getRowCount();
        this.indexList.clear();
        for (int z = 0; z < rowCount; ++z) {
            String sql = (String)this.model.getValueAt(z, 0);
            if (filter.equals("")) {
                this.indexList.add(new Integer(z));
                continue;
            }
            if (!sql.contains(filter)) continue;
            this.indexList.add(new Integer(z));
        }
        this.fireTableDataChanged();
    }

    public String getFilter() {
        return this.filter;
    }

    public String getColumnName(int aColumn) {
        return this.model.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return this.model.getColumnClass(aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return this.model.isCellEditable(row, column);
    }

    public synchronized void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        this.indexList.clear();
        for (int z = 0; z < rowCount; ++z) {
            String sql = (String)this.model.getValueAt(z, 0);
            if (this.filter.equals("")) {
                this.indexList.add(new Integer(z));
                continue;
            }
            if (!sql.contains(this.filter)) continue;
            this.indexList.add(new Integer(z));
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.fireTableChanged(e);
    }

    public int getRowCount() {
        return this.indexList.size();
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int newIndex = (Integer)this.indexList.get(rowIndex);
        return this.model.getValueAt(newIndex, columnIndex);
    }
}

