/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controls.WaitCursor;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeListener;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdeveloper.cm.dt.DatabaseConnectionNode;

public class SqlLaunchOnOpen
extends NodeListener
implements IdeListener {
    private ConnectionNode _cn;
    private Connections _conns;
    private HashMap<String, String> _openedConns = new HashMap();
    public static boolean OPEN_DEFAULT = true;

    public SqlLaunchOnOpen() {
        this._cn = (ConnectionNode)Ide.getSystem().getChild(ConnectionNode.class);
        ConnectionNode.addNodeListenerForType(DatabaseConnectionNode.class, (NodeListener)this);
        Ide.addIdeListener((IdeListener)this);
    }

    public void nodeOpened(NodeEvent e) {
        final DatabaseConnectionNode node = (DatabaseConnectionNode)e.getNode();
        if (!ConnectionSelectorUI.SELECTOR_ACTIVE && OPEN_DEFAULT) {
            IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    WaitCursor wc = Ide.getWaitCursor();
                    wc.show();
                    try {
                        SqlEditor.openNewEditor(node.getConnectionName());
                    }
                    finally {
                        wc.hide();
                    }
                }
            });
        }
    }

    public void nodeWillClose(NodeEvent e) {
        List editors = EditorManager.getEditorManager().getAllEditors();
        for (int i = 0; i < editors.size(); ++i) {
            if (!(editors.get(i) instanceof SqlEditor) || !((SqlEditor)editors.get(i)).getDatabase().getConnectionName().equals(((DatabaseConnectionNode)e.getNode()).getConnectionName())) continue;
            ((SqlEditor)editors.get(i)).close();
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
    }

    public void mainWindowClosing(IdeEvent e) {
        List eds = EditorManager.getEditorManager().getAllEditors();
        ArrayList<Editor> closeEditors = new ArrayList<Editor>();
        Node n = null;
        for (Editor ed : eds) {
            n = ed.getContext().getNode();
            if (!(n instanceof SqlEditorNode) || !((SqlEditorNode)n).isTempFile()) continue;
            closeEditors.add(ed);
        }
        EditorManager.getEditorManager().closeEditors(closeEditors);
    }
}

