/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

class FastShortMessage
extends ShortMessage {
    private int packedMsg;

    public FastShortMessage(int n2) throws InvalidMidiDataException {
        this.packedMsg = n2;
        this.getDataLength(n2 & 0xFF);
    }

    public FastShortMessage(ShortMessage shortMessage) {
        this.packedMsg = shortMessage.getStatus() | shortMessage.getData1() << 8 | shortMessage.getData2() << 16;
    }

    int getPackedMsg() {
        return this.packedMsg;
    }

    public byte[] getMessage() {
        int n2 = 0;
        try {
            n2 = this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            // empty catch block
        }
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            byArray[0] = (byte)(this.packedMsg & 0xFF);
            if (n2 > 1) {
                byArray[1] = (byte)((this.packedMsg & 0xFF00) >> 8);
                if (n2 > 2) {
                    byArray[2] = (byte)((this.packedMsg & 0xFF0000) >> 16);
                }
            }
        }
        return byArray;
    }

    public int getLength() {
        try {
            return this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return 0;
        }
    }

    public void setMessage(int n2) throws InvalidMidiDataException {
        int n3 = this.getDataLength(n2);
        if (n3 != 0) {
            super.setMessage(n2);
        }
        this.packedMsg = this.packedMsg & 0xFFFF00 | n2 & 0xFF;
    }

    public void setMessage(int n2, int n3, int n4) throws InvalidMidiDataException {
        this.getDataLength(n2);
        this.packedMsg = n2 & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16;
    }

    public void setMessage(int n2, int n3, int n4, int n5) throws InvalidMidiDataException {
        this.getDataLength(n2);
        this.packedMsg = n2 & 0xF0 | n3 & 0xF | (n4 & 0xFF) << 8 | (n5 & 0xFF) << 16;
    }

    public int getChannel() {
        return this.packedMsg & 0xF;
    }

    public int getCommand() {
        return this.packedMsg & 0xF0;
    }

    public int getData1() {
        return (this.packedMsg & 0xFF00) >> 8;
    }

    public int getData2() {
        return (this.packedMsg & 0xFF0000) >> 16;
    }

    public int getStatus() {
        return this.packedMsg & 0xFF;
    }

    public Object clone() {
        try {
            return new FastShortMessage(this.packedMsg);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return null;
        }
    }
}

