/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private ZipEntry entry;
    private Vector entries = new Vector();
    private Hashtable names = new Hashtable();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long locoff = 0L;
    private String comment;
    private int method = 8;
    private boolean finished;
    private boolean closed = false;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
        this.usesDefaultDeflater = true;
    }

    public void setComment(String string) {
        if (string != null && string.length() > 21845 && ZipOutputStream.getUTF8Length(string) > 65535) {
            throw new IllegalArgumentException("ZIP file comment too long.");
        }
        this.comment = string;
    }

    public void setMethod(int n2) {
        if (n2 != 8 && n2 != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n2;
    }

    public void setLevel(int n2) {
        this.def.setLevel(n2);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        if (zipEntry.time == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        if (zipEntry.method == -1) {
            zipEntry.method = this.method;
        }
        switch (zipEntry.method) {
            case 8: {
                if (zipEntry.size == -1L || zipEntry.csize == -1L || zipEntry.crc == -1L) {
                    zipEntry.flag = 8;
                } else if (zipEntry.size != -1L && zipEntry.csize != -1L && zipEntry.crc != -1L) {
                    zipEntry.flag = 0;
                } else {
                    throw new ZipException("DEFLATED entry missing size, compressed size, or crc-32");
                }
                zipEntry.version = 20;
                break;
            }
            case 0: {
                if (zipEntry.size == -1L) {
                    zipEntry.size = zipEntry.csize;
                } else if (zipEntry.csize == -1L) {
                    zipEntry.csize = zipEntry.size;
                } else if (zipEntry.size != zipEntry.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (zipEntry.size == -1L || zipEntry.crc == -1L) {
                    throw new ZipException("STORED entry missing size, compressed size, or crc-32");
                }
                zipEntry.version = 10;
                zipEntry.flag = 0;
                break;
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        zipEntry.offset = this.written;
        if (this.names.put(zipEntry.name, zipEntry) != null) {
            throw new ZipException("duplicate entry: " + zipEntry.name);
        }
        this.writeLOC(zipEntry);
        this.entries.addElement(zipEntry);
        this.entry = zipEntry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        ZipEntry zipEntry = this.entry;
        if (zipEntry != null) {
            switch (zipEntry.method) {
                case 8: {
                    this.def.finish();
                    while (!this.def.finished()) {
                        this.deflate();
                    }
                    if ((zipEntry.flag & 8) == 0) {
                        if (zipEntry.size != this.def.getBytesRead()) {
                            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.def.getBytesRead() + " bytes)");
                        }
                        if (zipEntry.csize != this.def.getBytesWritten()) {
                            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.def.getBytesWritten() + " bytes)");
                        }
                        if (zipEntry.crc != this.crc.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                        }
                    } else {
                        zipEntry.size = this.def.getBytesRead();
                        zipEntry.csize = this.def.getBytesWritten();
                        zipEntry.crc = this.crc.getValue();
                        this.writeEXT(zipEntry);
                    }
                    this.def.reset();
                    this.written += zipEntry.csize;
                    break;
                }
                case 0: {
                    if (zipEntry.size != this.written - this.locoff) {
                        throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + (this.written - this.locoff) + " bytes)");
                    }
                    if (zipEntry.crc == this.crc.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                default: {
                    throw new InternalError("invalid compression method");
                }
            }
            this.crc.reset();
            this.entry = null;
        }
    }

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (n2 < 0 || n3 < 0 || n2 > byArray.length - n3) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if (this.entry == null) {
            throw new ZipException("no current ZIP entry");
        }
        switch (this.entry.method) {
            case 8: {
                super.write(byArray, n2, n3);
                break;
            }
            case 0: {
                this.written += (long)n3;
                if (this.written - this.locoff > this.entry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(byArray, n2, n3);
                break;
            }
            default: {
                throw new InternalError("invalid compression method");
            }
        }
        this.crc.update(byArray, n2, n3);
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        if (this.entries.size() < 1) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        long l2 = this.written;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            this.writeCEN((ZipEntry)enumeration.nextElement());
        }
        this.writeEND(l2, this.written - l2);
        this.finished = true;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(ZipEntry zipEntry) throws IOException {
        this.writeInt(67324752L);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.flag);
        this.writeShort(zipEntry.method);
        this.writeInt(zipEntry.time);
        if ((zipEntry.flag & 8) == 8) {
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            this.writeInt(zipEntry.crc);
            this.writeInt(zipEntry.csize);
            this.writeInt(zipEntry.size);
        }
        byte[] byArray = ZipOutputStream.getUTF8Bytes(zipEntry.name);
        this.writeShort(byArray.length);
        this.writeShort(zipEntry.extra != null ? zipEntry.extra.length : 0);
        this.writeBytes(byArray, 0, byArray.length);
        if (zipEntry.extra != null) {
            this.writeBytes(zipEntry.extra, 0, zipEntry.extra.length);
        }
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry zipEntry) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(zipEntry.crc);
        this.writeInt(zipEntry.csize);
        this.writeInt(zipEntry.size);
    }

    private void writeCEN(ZipEntry zipEntry) throws IOException {
        byte[] byArray;
        this.writeInt(33639248L);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.flag);
        this.writeShort(zipEntry.method);
        this.writeInt(zipEntry.time);
        this.writeInt(zipEntry.crc);
        this.writeInt(zipEntry.csize);
        this.writeInt(zipEntry.size);
        byte[] byArray2 = ZipOutputStream.getUTF8Bytes(zipEntry.name);
        this.writeShort(byArray2.length);
        this.writeShort(zipEntry.extra != null ? zipEntry.extra.length : 0);
        if (zipEntry.comment != null) {
            byArray = ZipOutputStream.getUTF8Bytes(zipEntry.comment);
            this.writeShort(byArray.length);
        } else {
            byArray = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(zipEntry.offset);
        this.writeBytes(byArray2, 0, byArray2.length);
        if (zipEntry.extra != null) {
            this.writeBytes(zipEntry.extra, 0, zipEntry.extra.length);
        }
        if (byArray != null) {
            this.writeBytes(byArray, 0, byArray.length);
        }
    }

    private void writeEND(long l2, long l3) throws IOException {
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.entries.size());
        this.writeShort(this.entries.size());
        this.writeInt(l3);
        this.writeInt(l2);
        if (this.comment != null) {
            byte[] byArray = ZipOutputStream.getUTF8Bytes(this.comment);
            this.writeShort(byArray.length);
            this.writeBytes(byArray, 0, byArray.length);
        } else {
            this.writeShort(0);
        }
    }

    private void writeShort(int n2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n2 >>> 0 & 0xFF);
        outputStream.write(n2 >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long l2) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l2 >>> 0 & 0xFFL));
        outputStream.write((int)(l2 >>> 8 & 0xFFL));
        outputStream.write((int)(l2 >>> 16 & 0xFFL));
        outputStream.write((int)(l2 >>> 24 & 0xFFL));
        this.written += 4L;
    }

    private void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.out.write(byArray, n2, n3);
        this.written += (long)n3;
    }

    static int getUTF8Length(String string) {
        int n2 = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 <= '\u007f') {
                ++n2;
                continue;
            }
            if (c2 <= '\u07ff') {
                n2 += 2;
                continue;
            }
            n2 += 3;
        }
        return n2;
    }

    private static byte[] getUTF8Bytes(String string) {
        int n2;
        char[] cArray = string.toCharArray();
        int n3 = cArray.length;
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 = cArray[i2];
            if (n2 <= 127) {
                ++n4;
                continue;
            }
            if (n2 <= 2047) {
                n4 += 2;
                continue;
            }
            n4 += 3;
        }
        byte[] byArray = new byte[n4];
        n2 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            char c2 = cArray[i3];
            if (c2 <= '\u007f') {
                byArray[n2++] = (byte)c2;
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n2++] = (byte)(c2 >> 6 | 0xC0);
                byArray[n2++] = (byte)(c2 & 0x3F | 0x80);
                continue;
            }
            byArray[n2++] = (byte)(c2 >> 12 | 0xE0);
            byArray[n2++] = (byte)(c2 >> 6 & 0x3F | 0x80);
            byArray[n2++] = (byte)(c2 & 0x3F | 0x80);
        }
        return byArray;
    }
}

