/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.security.JMXPluggableAuthenticator;
import com.sun.jmx.remote.util.ClassLogger;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RMIServerImpl
implements RMIServer {
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIServerImpl");
    private final List clientList = new ArrayList();
    private ClassLoader cl;
    private MBeanServer mbeanServer;
    private final Map env;
    private RMIConnectorServer connServer;
    private static int connectionIdNumber;
    private NotificationBuffer notifBuffer;
    private final AccessControlContext callerACC;

    public RMIServerImpl(Map<String, ?> map) {
        this.env = map == null ? Collections.EMPTY_MAP : map;
        this.callerACC = AccessController.getContext();
        if (logger.debugOn()) {
            logger.trace("RMIServerImpl", "class=" + this.getClass().getName());
        }
    }

    void setRMIConnectorServer(RMIConnectorServer rMIConnectorServer) throws IOException {
        this.connServer = rMIConnectorServer;
    }

    protected abstract void export() throws IOException;

    public abstract Remote toStub() throws IOException;

    public synchronized void setDefaultClassLoader(ClassLoader classLoader) {
        this.cl = classLoader;
    }

    public synchronized ClassLoader getDefaultClassLoader() {
        return this.cl;
    }

    public synchronized void setMBeanServer(MBeanServer mBeanServer) {
        this.mbeanServer = mBeanServer;
    }

    public synchronized MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    @Override
    public String getVersion() {
        return "1.0 java_runtime_" + (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.runtime.version");
            }
        });
    }

    @Override
    public RMIConnection newClient(Object object) throws IOException {
        try {
            final Object object2 = object;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RMIConnection>(){

                @Override
                public RMIConnection run() throws IOException {
                    return RMIServerImpl.this.doNewClient(object2);
                }
            }, this.callerACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMIConnection doNewClient(Object object) throws IOException {
        boolean bl2 = logger.traceOn();
        if (bl2) {
            logger.trace("newClient", "making new client");
        }
        if (this.getMBeanServer() == null) {
            throw new IllegalStateException("Not attached to an MBean server");
        }
        Subject subject = null;
        JMXAuthenticator jMXAuthenticator = (JMXAuthenticator)this.env.get("jmx.remote.authenticator");
        if (jMXAuthenticator == null && (this.env.get("jmx.remote.x.password.file") != null || this.env.get("jmx.remote.x.login.config") != null)) {
            jMXAuthenticator = new JMXPluggableAuthenticator(this.env);
        }
        if (jMXAuthenticator != null) {
            if (bl2) {
                logger.trace("newClient", "got authenticator: " + jMXAuthenticator.getClass().getName());
            }
            try {
                subject = jMXAuthenticator.authenticate(object);
            }
            catch (SecurityException securityException) {
                logger.trace("newClient", "Authentication failed: " + securityException);
                throw securityException;
            }
        }
        if (bl2) {
            if (subject != null) {
                logger.trace("newClient", "subject is not null");
            } else {
                logger.trace("newClient", "no subject");
            }
        }
        String string = RMIServerImpl.makeConnectionId(this.getProtocol(), subject);
        if (bl2) {
            logger.trace("newClient", "making new connection: " + string);
        }
        RMIConnection rMIConnection = this.makeClient(string, subject);
        this.connServer.connectionOpened(string, "Connection opened", null);
        this.dropDeadReferences();
        WeakReference<RMIConnection> weakReference = new WeakReference<RMIConnection>(rMIConnection);
        List list = this.clientList;
        synchronized (list) {
            this.clientList.add(weakReference);
        }
        if (bl2) {
            logger.trace("newClient", "new connection done: " + string);
        }
        return rMIConnection;
    }

    protected abstract RMIConnection makeClient(String var1, Subject var2) throws IOException;

    protected abstract void closeClient(RMIConnection var1) throws IOException;

    protected abstract String getProtocol();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIConnection rMIConnection) throws IOException {
        boolean bl2 = logger.debugOn();
        if (bl2) {
            logger.trace("clientClosed", "client=" + rMIConnection);
        }
        if (rMIConnection == null) {
            throw new NullPointerException("Null client");
        }
        List list = this.clientList;
        synchronized (list) {
            this.dropDeadReferences();
            Iterator iterator = this.clientList.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference.get() != rMIConnection) continue;
                iterator.remove();
                break;
            }
        }
        if (bl2) {
            logger.trace("clientClosed", "closing client.");
        }
        this.closeClient(rMIConnection);
        if (bl2) {
            logger.trace("clientClosed", "sending notif");
        }
        this.connServer.connectionClosed(rMIConnection.getConnectionId(), "Client connection closed", null);
        if (bl2) {
            logger.trace("clientClosed", "done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        boolean bl2 = logger.traceOn();
        boolean bl3 = logger.debugOn();
        if (bl2) {
            logger.trace("close", "closing");
        }
        IOException iOException = null;
        try {
            if (bl3) {
                logger.debug("close", "closing Server");
            }
            this.closeServer();
        }
        catch (IOException iOException2) {
            if (bl2) {
                logger.trace("close", "Failed to close server: " + iOException2);
            }
            if (bl3) {
                logger.debug("close", iOException2);
            }
            iOException = iOException2;
        }
        if (bl3) {
            logger.debug("close", "closing Clients");
        }
        while (true) {
            List list = this.clientList;
            synchronized (list) {
                if (bl3) {
                    logger.debug("close", "droping dead references");
                }
                this.dropDeadReferences();
                if (bl3) {
                    logger.debug("close", "client count: " + this.clientList.size());
                }
                if (this.clientList.size() == 0) {
                    break;
                }
                Iterator iterator = this.clientList.iterator();
                while (iterator.hasNext()) {
                    WeakReference weakReference = (WeakReference)iterator.next();
                    RMIConnection rMIConnection = (RMIConnection)weakReference.get();
                    iterator.remove();
                    if (rMIConnection == null) continue;
                    try {
                        rMIConnection.close();
                    }
                    catch (IOException iOException3) {
                        if (bl2) {
                            logger.trace("close", "Failed to close client: " + iOException3);
                        }
                        if (bl3) {
                            logger.debug("close", iOException3);
                        }
                        if (iOException != null) break;
                        iOException = iOException3;
                    }
                    break;
                }
            }
        }
        if (this.notifBuffer != null) {
            this.notifBuffer.dispose();
        }
        if (iOException != null) {
            if (bl2) {
                logger.trace("close", "close failed.");
            }
            throw iOException;
        }
        if (bl2) {
            logger.trace("close", "closed.");
        }
    }

    protected abstract void closeServer() throws IOException;

    private static synchronized String makeConnectionId(String string, Subject subject) {
        ++connectionIdNumber;
        String string2 = "";
        try {
            string2 = RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException serverNotActiveException) {
            logger.trace("makeConnectionId", "getClientHost", serverNotActiveException);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(":");
        if (string2.length() > 0) {
            stringBuffer.append("//").append(string2);
        }
        stringBuffer.append(" ");
        if (subject != null) {
            Set<Principal> set = subject.getPrincipals();
            String string3 = "";
            for (Principal principal : set) {
                String string4 = principal.getName().replace(' ', '_').replace(';', ':');
                stringBuffer.append(string3).append(string4);
                string3 = ";";
            }
        }
        stringBuffer.append(" ").append(connectionIdNumber);
        if (logger.traceOn()) {
            logger.trace("newConnectionId", "connectionId=" + stringBuffer);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropDeadReferences() {
        List list = this.clientList;
        synchronized (list) {
            Iterator iterator = this.clientList.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                if (weakReference.get() != null) continue;
                iterator.remove();
            }
        }
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.mbeanServer, this.env);
        }
        return this.notifBuffer;
    }
}

