/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.im.InputContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicDropTargetListener;
import javax.swing.plaf.basic.BasicTransferable;
import javax.swing.plaf.basic.DragRecognitionSupport;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import sun.awt.AppContext;
import sun.swing.DefaultLookup;

public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    private static final EditorKit defaultKit = new DefaultEditorKit();
    transient JTextComponent editor;
    transient boolean painted = false;
    transient RootView rootView = new RootView();
    transient UpdateHandler updateHandler = new UpdateHandler();
    private static final TransferHandler defaultTransferHandler = new TextTransferHandler();
    private static DropTargetListener defaultDropTargetListener = null;
    private final DragListener dragListener = BasicTextUI.getDragListener();
    private static final Position.Bias[] discardBias = new Position.Bias[1];

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected String getKeymapName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1, string.length());
        }
        return string;
    }

    protected Keymap createKeymap() {
        String string = this.getKeymapName();
        Keymap keymap = JTextComponent.getKeymap(string);
        if (keymap == null) {
            Keymap keymap2 = JTextComponent.getKeymap("default");
            keymap = JTextComponent.addKeymap(string, keymap2);
            String string2 = this.getPropertyPrefix();
            Object object = DefaultLookup.get(this.editor, this, string2 + ".keyBindings");
            if (object != null && object instanceof JTextComponent.KeyBinding[]) {
                JTextComponent.KeyBinding[] keyBindingArray = (JTextComponent.KeyBinding[])object;
                JTextComponent.loadKeymap(keymap, keyBindingArray, this.getComponent().getActions());
            }
        }
        return keymap;
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    protected abstract String getPropertyPrefix();

    protected void installDefaults() {
        Insets insets;
        Border border;
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        Color color6;
        String string = this.getPropertyPrefix();
        Font font = this.editor.getFont();
        if (font == null || font instanceof UIResource) {
            this.editor.setFont(UIManager.getFont(string + ".font"));
        }
        if ((color6 = this.editor.getBackground()) == null || color6 instanceof UIResource) {
            this.editor.setBackground(UIManager.getColor(string + ".background"));
        }
        if ((color5 = this.editor.getForeground()) == null || color5 instanceof UIResource) {
            this.editor.setForeground(UIManager.getColor(string + ".foreground"));
        }
        if ((color4 = this.editor.getCaretColor()) == null || color4 instanceof UIResource) {
            this.editor.setCaretColor(UIManager.getColor(string + ".caretForeground"));
        }
        if ((color3 = this.editor.getSelectionColor()) == null || color3 instanceof UIResource) {
            this.editor.setSelectionColor(UIManager.getColor(string + ".selectionBackground"));
        }
        if ((color2 = this.editor.getSelectedTextColor()) == null || color2 instanceof UIResource) {
            this.editor.setSelectedTextColor(UIManager.getColor(string + ".selectionForeground"));
        }
        if ((color = this.editor.getDisabledTextColor()) == null || color instanceof UIResource) {
            this.editor.setDisabledTextColor(UIManager.getColor(string + ".inactiveForeground"));
        }
        if ((border = this.editor.getBorder()) == null || border instanceof UIResource) {
            this.editor.setBorder(UIManager.getBorder(string + ".border"));
        }
        if ((insets = this.editor.getMargin()) == null || insets instanceof UIResource) {
            this.editor.setMargin(UIManager.getInsets(string + ".margin"));
        }
    }

    private void installDefaults2() {
        DropTarget dropTarget;
        TransferHandler transferHandler;
        Highlighter highlighter;
        this.editor.addMouseListener(this.dragListener);
        this.editor.addMouseMotionListener(this.dragListener);
        String string = this.getPropertyPrefix();
        Caret caret = this.editor.getCaret();
        if (caret == null || caret instanceof UIResource) {
            caret = this.createCaret();
            this.editor.setCaret(caret);
            int n2 = DefaultLookup.getInt(this.getComponent(), this, string + ".caretBlinkRate", 500);
            caret.setBlinkRate(n2);
        }
        if ((highlighter = this.editor.getHighlighter()) == null || highlighter instanceof UIResource) {
            this.editor.setHighlighter(this.createHighlighter());
        }
        if ((transferHandler = this.editor.getTransferHandler()) == null || transferHandler instanceof UIResource) {
            this.editor.setTransferHandler(this.getTransferHandler());
        }
        if ((dropTarget = this.editor.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TextDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void uninstallDefaults() {
        this.editor.removeMouseListener(this.dragListener);
        this.editor.removeMouseMotionListener(this.dragListener);
        if (this.editor.getCaretColor() instanceof UIResource) {
            this.editor.setCaretColor(null);
        }
        if (this.editor.getSelectionColor() instanceof UIResource) {
            this.editor.setSelectionColor(null);
        }
        if (this.editor.getDisabledTextColor() instanceof UIResource) {
            this.editor.setDisabledTextColor(null);
        }
        if (this.editor.getSelectedTextColor() instanceof UIResource) {
            this.editor.setSelectedTextColor(null);
        }
        if (this.editor.getBorder() instanceof UIResource) {
            this.editor.setBorder(null);
        }
        if (this.editor.getMargin() instanceof UIResource) {
            this.editor.setMargin(null);
        }
        if (this.editor.getCaret() instanceof UIResource) {
            this.editor.setCaret(null);
        }
        if (this.editor.getHighlighter() instanceof UIResource) {
            this.editor.setHighlighter(null);
        }
        if (this.editor.getTransferHandler() instanceof UIResource) {
            this.editor.setTransferHandler(null);
        }
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installKeyboardActions() {
        ActionMap actionMap;
        this.editor.setKeymap(this.createKeymap());
        InputMap inputMap = this.getInputMap();
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.editor, 0, inputMap);
        }
        if ((actionMap = this.getActionMap()) != null) {
            SwingUtilities.replaceUIActionMap(this.editor, actionMap);
        }
        this.updateFocusAcceleratorBinding(false);
    }

    InputMap getInputMap() {
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        InputMap inputMap = (InputMap)DefaultLookup.get(this.editor, this, this.getPropertyPrefix() + ".focusInputMap");
        if (inputMap != null) {
            inputMapUIResource.setParent(inputMap);
        }
        return inputMapUIResource;
    }

    void updateFocusAcceleratorBinding(boolean bl2) {
        char c2 = this.editor.getFocusAccelerator();
        if (bl2 || c2 != '\u0000') {
            InputMap inputMap = SwingUtilities.getUIInputMap(this.editor, 2);
            if (inputMap == null && c2 != '\u0000') {
                inputMap = new ComponentInputMapUIResource(this.editor);
                SwingUtilities.replaceUIInputMap(this.editor, 2, inputMap);
                ActionMap actionMap = this.getActionMap();
                SwingUtilities.replaceUIActionMap(this.editor, actionMap);
            }
            if (inputMap != null) {
                inputMap.clear();
                if (c2 != '\u0000') {
                    inputMap.put(KeyStroke.getKeyStroke((int)c2, 8), "requestFocus");
                }
            }
        }
    }

    void updateFocusTraversalKeys() {
        EditorKit editorKit = this.getEditorKit(this.editor);
        if (editorKit != null && editorKit instanceof DefaultEditorKit) {
            Set<AWTKeyStroke> set = this.editor.getFocusTraversalKeys(0);
            Set<AWTKeyStroke> set2 = this.editor.getFocusTraversalKeys(1);
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(set);
            HashSet<AWTKeyStroke> hashSet2 = new HashSet<AWTKeyStroke>(set2);
            if (this.editor.isEditable()) {
                hashSet.remove(KeyStroke.getKeyStroke(9, 0));
                hashSet2.remove(KeyStroke.getKeyStroke(9, 1));
            } else {
                hashSet.add(KeyStroke.getKeyStroke(9, 0));
                hashSet2.add(KeyStroke.getKeyStroke(9, 1));
            }
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysForward", hashSet);
            LookAndFeel.installProperty(this.editor, "focusTraversalKeysBackward", hashSet2);
        }
    }

    TransferHandler getTransferHandler() {
        return defaultTransferHandler;
    }

    ActionMap getActionMap() {
        Action action;
        String string = this.getPropertyPrefix() + ".actionMap";
        ActionMap actionMap = (ActionMap)UIManager.get(string);
        if (actionMap == null && (actionMap = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put(string, actionMap);
        }
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("requestFocus", new FocusAction());
        if (this.getEditorKit(this.editor) instanceof DefaultEditorKit && actionMap != null && (action = actionMap.get("insert-break")) != null && action instanceof DefaultEditorKit.InsertBreakAction) {
            TextActionWrapper textActionWrapper = new TextActionWrapper((TextAction)action);
            actionMapUIResource.put(textActionWrapper.getValue("Name"), textActionWrapper);
        }
        if (actionMap != null) {
            actionMapUIResource.setParent(actionMap);
        }
        return actionMapUIResource;
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        for (Action action : this.editor.getActions()) {
            actionMapUIResource.put(action.getValue("Name"), action);
        }
        actionMapUIResource.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMapUIResource.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMapUIResource.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        return actionMapUIResource;
    }

    protected void uninstallKeyboardActions() {
        this.editor.setKeymap(null);
        SwingUtilities.replaceUIInputMap(this.editor, 2, null);
        SwingUtilities.replaceUIActionMap(this.editor, null);
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.editor.getBackground());
        graphics.fillRect(0, 0, this.editor.getWidth(), this.editor.getHeight());
    }

    protected final JTextComponent getComponent() {
        return this.editor;
    }

    protected void modelChanged() {
        ViewFactory viewFactory = this.rootView.getViewFactory();
        Document document = this.editor.getDocument();
        Element element = document.getDefaultRootElement();
        this.setView(viewFactory.create(element));
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        this.painted = false;
        this.editor.revalidate();
        this.editor.repaint();
    }

    protected void paintSafely(Graphics graphics) {
        Rectangle rectangle;
        this.painted = true;
        Highlighter highlighter = this.editor.getHighlighter();
        Caret caret = this.editor.getCaret();
        if (this.editor.isOpaque()) {
            this.paintBackground(graphics);
        }
        if (highlighter != null) {
            highlighter.paint(graphics);
        }
        if ((rectangle = this.getVisibleEditorRect()) != null) {
            this.rootView.paint(graphics, rectangle);
        }
        if (caret != null) {
            caret.paint(graphics);
        }
    }

    public void installUI(JComponent jComponent) {
        if (jComponent instanceof JTextComponent) {
            this.editor = (JTextComponent)jComponent;
            this.installDefaults();
            this.installDefaults2();
            LookAndFeel.installProperty(this.editor, "opaque", Boolean.TRUE);
            LookAndFeel.installProperty(this.editor, "autoscrolls", Boolean.TRUE);
            this.editor.addPropertyChangeListener(this.updateHandler);
            Document document = this.editor.getDocument();
            if (document == null) {
                this.editor.setDocument(this.getEditorKit(this.editor).createDefaultDocument());
            } else {
                document.addDocumentListener(this.updateHandler);
                this.modelChanged();
            }
            this.installListeners();
            this.installKeyboardActions();
            LayoutManager layoutManager = this.editor.getLayout();
            if (layoutManager == null || layoutManager instanceof UIResource) {
                this.editor.setLayout(this.updateHandler);
            }
        } else {
            throw new Error("TextUI needs JTextComponent");
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.editor.removePropertyChangeListener(this.updateHandler);
        this.editor.getDocument().removeDocumentListener(this.updateHandler);
        this.painted = false;
        this.uninstallDefaults();
        this.rootView.setView(null);
        jComponent.removeAll();
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager instanceof UIResource) {
            jComponent.setLayout(null);
        }
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.editor = null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(Graphics graphics, JComponent jComponent) {
        if (this.rootView.getViewCount() > 0 && this.rootView.getView(0) != null) {
            Document document = this.editor.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.paintSafely(graphics);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (dimension.width > insets.left + insets.right && dimension.height > insets.top + insets.bottom) {
                this.rootView.setSize(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
            } else if (dimension.width == 0 && dimension.height == 0) {
                this.rootView.setSize(2.1474836E9f, 2.1474836E9f);
            }
            dimension.width = (int)Math.min((long)this.rootView.getPreferredSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getPreferredSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)this.rootView.getMinimumSpan(0) + insets.left + insets.right;
            dimension.height = (int)this.rootView.getMinimumSpan(1) + insets.top + insets.bottom;
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize(JComponent jComponent) {
        Document document = this.editor.getDocument();
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            dimension.width = (int)Math.min((long)this.rootView.getMaximumSpan(0) + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
            dimension.height = (int)Math.min((long)this.rootView.getMaximumSpan(1) + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return dimension;
    }

    protected Rectangle getVisibleEditorRect() {
        Rectangle rectangle = this.editor.getBounds();
        if (rectangle.width > 0 && rectangle.height > 0) {
            rectangle.y = 0;
            rectangle.x = 0;
            Insets insets = this.editor.getInsets();
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
            return rectangle;
        }
        return null;
    }

    public Rectangle modelToView(JTextComponent jTextComponent, int n2) throws BadLocationException {
        return this.modelToView(jTextComponent, n2, Position.Bias.Forward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle modelToView(JTextComponent jTextComponent, int n2, Position.Bias bias) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n2, rectangle, bias);
                if (shape != null) {
                    Rectangle rectangle2 = shape.getBounds();
                    return rectangle2;
                }
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return null;
    }

    public int viewToModel(JTextComponent jTextComponent, Point point) {
        return this.viewToModel(jTextComponent, point, discardBias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int viewToModel(JTextComponent jTextComponent, Point point, Position.Bias[] biasArray) {
        int n2 = -1;
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            Rectangle rectangle = this.getVisibleEditorRect();
            if (rectangle != null) {
                this.rootView.setSize(rectangle.width, rectangle.height);
                n2 = this.rootView.viewToModel(point.x, point.y, rectangle, biasArray);
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n2, Position.Bias bias, int n3, Position.Bias[] biasArray) throws BadLocationException {
        Document document = this.editor.getDocument();
        if (document instanceof AbstractDocument) {
            ((AbstractDocument)document).readLock();
        }
        try {
            if (this.painted) {
                Rectangle rectangle = this.getVisibleEditorRect();
                if (rectangle != null) {
                    this.rootView.setSize(rectangle.width, rectangle.height);
                }
                int n4 = this.rootView.getNextVisualPositionFrom(n2, bias, rectangle, n3, biasArray);
                return n4;
            }
        }
        finally {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readUnlock();
            }
        }
        return -1;
    }

    public void damageRange(JTextComponent jTextComponent, int n2, int n3) {
        this.damageRange(jTextComponent, n2, n3, Position.Bias.Forward, Position.Bias.Backward);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damageRange(JTextComponent jTextComponent, int n2, int n3, Position.Bias bias, Position.Bias bias2) {
        Rectangle rectangle;
        if (this.painted && (rectangle = this.getVisibleEditorRect()) != null) {
            Document document = jTextComponent.getDocument();
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                this.rootView.setSize(rectangle.width, rectangle.height);
                Shape shape = this.rootView.modelToView(n2, bias, n3, bias2, rectangle);
                Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.editor.repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
    }

    public EditorKit getEditorKit(JTextComponent jTextComponent) {
        return defaultKit;
    }

    public View getRootView(JTextComponent jTextComponent) {
        return this.rootView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToolTipText(JTextComponent jTextComponent, Point point) {
        if (!this.painted) {
            return null;
        }
        Document document = this.editor.getDocument();
        String string = null;
        Rectangle rectangle = this.getVisibleEditorRect();
        if (rectangle != null) {
            if (document instanceof AbstractDocument) {
                ((AbstractDocument)document).readLock();
            }
            try {
                string = this.rootView.getToolTipText(point.x, point.y, rectangle);
            }
            finally {
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readUnlock();
                }
            }
        }
        return string;
    }

    public View create(Element element) {
        return null;
    }

    public View create(Element element, int n2, int n3) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DragListener getDragListener() {
        Class<DragListener> clazz = DragListener.class;
        synchronized (DragListener.class) {
            DragListener dragListener = (DragListener)AppContext.getAppContext().get(DragListener.class);
            if (dragListener == null) {
                dragListener = new DragListener();
                AppContext.getAppContext().put(DragListener.class, dragListener);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return dragListener;
        }
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    static class DragListener
    extends MouseInputAdapter
    implements DragRecognitionSupport.BeforeDrag {
        private boolean dragStarted;

        DragListener() {
        }

        public void dragStarting(MouseEvent mouseEvent) {
            this.dragStarted = true;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled()) {
                this.dragStarted = false;
                if (this.isDragPossible(mouseEvent) && DragRecognitionSupport.mousePressed(mouseEvent)) {
                    mouseEvent.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled()) {
                if (this.dragStarted) {
                    mouseEvent.consume();
                }
                DragRecognitionSupport.mouseReleased(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.getDragEnabled() && (this.dragStarted || DragRecognitionSupport.mouseDragged(mouseEvent, this))) {
                mouseEvent.consume();
            }
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            int n2;
            Caret caret;
            int n3;
            JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
            if (jTextComponent.isEnabled() && (n3 = (caret = jTextComponent.getCaret()).getDot()) != (n2 = caret.getMark())) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n4 = jTextComponent.viewToModel(point);
                int n5 = Math.min(n3, n2);
                int n6 = Math.max(n3, n2);
                if (n4 >= n5 && n4 < n6) {
                    return true;
                }
            }
            return false;
        }
    }

    class FocusAction
    extends AbstractAction {
        FocusAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicTextUI.this.editor.requestFocus();
        }

        public boolean isEnabled() {
            return BasicTextUI.this.editor.isEditable();
        }
    }

    class RootView
    extends View {
        private View view;

        RootView() {
            super(null);
        }

        void setView(View view) {
            View view2 = this.view;
            this.view = null;
            if (view2 != null) {
                view2.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        public AttributeSet getAttributes() {
            return null;
        }

        public float getPreferredSpan(int n2) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n2);
            }
            return 10.0f;
        }

        public float getMinimumSpan(int n2) {
            if (this.view != null) {
                return this.view.getMinimumSpan(n2);
            }
            return 10.0f;
        }

        public float getMaximumSpan(int n2) {
            return 2.1474836E9f;
        }

        public void preferenceChanged(View view, boolean bl2, boolean bl3) {
            BasicTextUI.this.editor.revalidate();
        }

        public float getAlignment(int n2) {
            if (this.view != null) {
                return this.view.getAlignment(n2);
            }
            return 0.0f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                this.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public void setParent(View view) {
            throw new Error("Can't set parent on root view");
        }

        public int getViewCount() {
            return 1;
        }

        public View getView(int n2) {
            return this.view;
        }

        public int getViewIndex(int n2, Position.Bias bias) {
            return 0;
        }

        public Shape getChildAllocation(int n2, Shape shape) {
            return shape;
        }

        public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n2, shape, bias);
            }
            return null;
        }

        public Shape modelToView(int n2, Position.Bias bias, int n3, Position.Bias bias2, Shape shape) throws BadLocationException {
            if (this.view != null) {
                return this.view.modelToView(n2, bias, n3, bias2, shape);
            }
            return null;
        }

        public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
            if (this.view != null) {
                int n2 = this.view.viewToModel(f2, f3, shape, biasArray);
                return n2;
            }
            return -1;
        }

        public int getNextVisualPositionFrom(int n2, Position.Bias bias, Shape shape, int n3, Position.Bias[] biasArray) throws BadLocationException {
            if (this.view != null) {
                int n4 = this.view.getNextVisualPositionFrom(n2, bias, shape, n3, biasArray);
                if (n4 != -1) {
                    n2 = n4;
                } else {
                    biasArray[0] = bias;
                }
            }
            return n2;
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.view != null) {
                this.view.changedUpdate(documentEvent, shape, viewFactory);
            }
        }

        public Document getDocument() {
            return BasicTextUI.this.editor.getDocument();
        }

        public int getStartOffset() {
            if (this.view != null) {
                return this.view.getStartOffset();
            }
            return this.getElement().getStartOffset();
        }

        public int getEndOffset() {
            if (this.view != null) {
                return this.view.getEndOffset();
            }
            return this.getElement().getEndOffset();
        }

        public Element getElement() {
            if (this.view != null) {
                return this.view.getElement();
            }
            return BasicTextUI.this.editor.getDocument().getDefaultRootElement();
        }

        public View breakView(int n2, float f2, Shape shape) {
            throw new Error("Can't break root view");
        }

        public int getResizeWeight(int n2) {
            if (this.view != null) {
                return this.view.getResizeWeight(n2);
            }
            return 0;
        }

        public void setSize(float f2, float f3) {
            if (this.view != null) {
                this.view.setSize(f2, f3);
            }
        }

        public Container getContainer() {
            return BasicTextUI.this.editor;
        }

        public ViewFactory getViewFactory() {
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.editor);
            ViewFactory viewFactory = editorKit.getViewFactory();
            if (viewFactory != null) {
                return viewFactory;
            }
            return BasicTextUI.this;
        }
    }

    class TextActionWrapper
    extends TextAction {
        TextAction action;

        public TextActionWrapper(TextAction textAction) {
            super((String)textAction.getValue("Name"));
            this.action = null;
            this.action = textAction;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }

        public boolean isEnabled() {
            return BasicTextUI.this.editor == null || BasicTextUI.this.editor.isEditable() ? this.action.isEnabled() : false;
        }
    }

    static class TextDropTargetListener
    extends BasicDropTargetListener {
        int dot;
        int mark;
        boolean visible;

        TextDropTargetListener() {
        }

        protected void saveComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            this.dot = caret.getDot();
            this.mark = caret.getMark();
            this.visible = caret instanceof DefaultCaret ? ((DefaultCaret)caret).isActive() : caret.isVisible();
            caret.setVisible(true);
        }

        protected void restoreComponentState(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setDot(this.mark);
            caret.moveDot(this.dot);
            caret.setVisible(this.visible);
        }

        protected void restoreComponentStateForDrop(JComponent jComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            Caret caret = jTextComponent.getCaret();
            caret.setVisible(this.visible);
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            jTextComponent.setCaretPosition(jTextComponent.viewToModel(point));
        }
    }

    static class TextTransferHandler
    extends TransferHandler
    implements UIResource {
        private JTextComponent exportComp;
        private boolean shouldRemove;
        private int p0;
        private int p1;

        TextTransferHandler() {
        }

        protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
            DataFlavor dataFlavor = null;
            DataFlavor dataFlavor2 = null;
            DataFlavor dataFlavor3 = null;
            if (jTextComponent instanceof JEditorPane) {
                for (int i2 = 0; i2 < dataFlavorArray.length; ++i2) {
                    String string = dataFlavorArray[i2].getMimeType();
                    if (string.startsWith(((JEditorPane)jTextComponent).getEditorKit().getContentType())) {
                        return dataFlavorArray[i2];
                    }
                    if (dataFlavor == null && string.startsWith("text/plain")) {
                        dataFlavor = dataFlavorArray[i2];
                        continue;
                    }
                    if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i2].getRepresentationClass() == String.class) {
                        dataFlavor2 = dataFlavorArray[i2];
                        continue;
                    }
                    if (dataFlavor3 != null || !dataFlavorArray[i2].equals(DataFlavor.stringFlavor)) continue;
                    dataFlavor3 = dataFlavorArray[i2];
                }
                if (dataFlavor != null) {
                    return dataFlavor;
                }
                if (dataFlavor2 != null) {
                    return dataFlavor2;
                }
                if (dataFlavor3 != null) {
                    return dataFlavor3;
                }
                return null;
            }
            for (int i3 = 0; i3 < dataFlavorArray.length; ++i3) {
                String string = dataFlavorArray[i3].getMimeType();
                if (string.startsWith("text/plain")) {
                    return dataFlavorArray[i3];
                }
                if (dataFlavor2 == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i3].getRepresentationClass() == String.class) {
                    dataFlavor2 = dataFlavorArray[i3];
                    continue;
                }
                if (dataFlavor3 != null || !dataFlavorArray[i3].equals(DataFlavor.stringFlavor)) continue;
                dataFlavor3 = dataFlavorArray[i3];
            }
            if (dataFlavor2 != null) {
                return dataFlavor2;
            }
            if (dataFlavor3 != null) {
                return dataFlavor3;
            }
            return null;
        }

        protected void handleReaderImport(Reader reader, JTextComponent jTextComponent, boolean bl2) throws BadLocationException, IOException {
            if (bl2) {
                int n2 = jTextComponent.getSelectionStart();
                int n3 = jTextComponent.getSelectionEnd();
                int n4 = n3 - n2;
                EditorKit editorKit = jTextComponent.getUI().getEditorKit(jTextComponent);
                Document document = jTextComponent.getDocument();
                if (n4 > 0) {
                    document.remove(n2, n4);
                }
                editorKit.read(reader, document, n2);
            } else {
                int n5;
                char[] cArray = new char[1024];
                boolean bl3 = false;
                StringBuffer stringBuffer = null;
                while ((n5 = reader.read(cArray, 0, cArray.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer(n5);
                    }
                    int n6 = 0;
                    block5: for (int i2 = 0; i2 < n5; ++i2) {
                        switch (cArray[i2]) {
                            case '\r': {
                                if (bl3) {
                                    if (i2 == 0) {
                                        stringBuffer.append('\n');
                                        continue block5;
                                    }
                                    cArray[i2 - 1] = 10;
                                    continue block5;
                                }
                                bl3 = true;
                                continue block5;
                            }
                            case '\n': {
                                if (!bl3) continue block5;
                                if (i2 > n6 + 1) {
                                    stringBuffer.append(cArray, n6, i2 - n6 - 1);
                                }
                                bl3 = false;
                                n6 = i2;
                                continue block5;
                            }
                            default: {
                                if (!bl3) continue block5;
                                if (i2 == 0) {
                                    stringBuffer.append('\n');
                                } else {
                                    cArray[i2 - 1] = 10;
                                }
                                bl3 = false;
                            }
                        }
                    }
                    if (n6 >= n5) continue;
                    if (bl3) {
                        if (n6 >= n5 - 1) continue;
                        stringBuffer.append(cArray, n6, n5 - n6 - 1);
                        continue;
                    }
                    stringBuffer.append(cArray, n6, n5 - n6);
                }
                if (bl3) {
                    stringBuffer.append('\n');
                }
                jTextComponent.replaceSelection(stringBuffer != null ? stringBuffer.toString() : "");
            }
        }

        public int getSourceActions(JComponent jComponent) {
            if (jComponent instanceof JPasswordField && jComponent.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
                return 0;
            }
            return ((JTextComponent)jComponent).isEditable() ? 3 : 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.exportComp = (JTextComponent)jComponent;
            this.shouldRemove = true;
            this.p0 = this.exportComp.getSelectionStart();
            this.p1 = this.exportComp.getSelectionEnd();
            return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n2) {
            if (this.shouldRemove && n2 == 2) {
                TextTransferable textTransferable = (TextTransferable)transferable;
                textTransferable.removeText();
            }
            this.exportComp = null;
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (jTextComponent == this.exportComp && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
                this.shouldRemove = false;
                return true;
            }
            boolean bl2 = false;
            DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
            if (dataFlavor != null) {
                try {
                    Object object;
                    boolean bl3 = false;
                    if (jComponent instanceof JEditorPane && !((JEditorPane)(object = (JEditorPane)jComponent)).getContentType().startsWith("text/plain") && dataFlavor.getMimeType().startsWith(((JEditorPane)object).getContentType())) {
                        bl3 = true;
                    }
                    if ((object = jTextComponent.getInputContext()) != null) {
                        ((InputContext)object).endComposition();
                    }
                    Reader reader = dataFlavor.getReaderForText(transferable);
                    this.handleReaderImport(reader, jTextComponent, bl3);
                    bl2 = true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return bl2;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                return false;
            }
            return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
        }

        static class TextTransferable
        extends BasicTransferable {
            Position p0;
            Position p1;
            String mimeType;
            String richText;
            JTextComponent c;

            TextTransferable(JTextComponent jTextComponent, int n2, int n3) {
                super(null, null);
                this.c = jTextComponent;
                Document document = jTextComponent.getDocument();
                try {
                    this.p0 = document.createPosition(n2);
                    this.p1 = document.createPosition(n3);
                    this.plainData = jTextComponent.getSelectedText();
                    if (jTextComponent instanceof JEditorPane) {
                        JEditorPane jEditorPane = (JEditorPane)jTextComponent;
                        this.mimeType = jEditorPane.getContentType();
                        if (this.mimeType.startsWith("text/plain")) {
                            return;
                        }
                        StringWriter stringWriter = new StringWriter(this.p1.getOffset() - this.p0.getOffset());
                        jEditorPane.getEditorKit().write(stringWriter, document, this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                        if (this.mimeType.startsWith("text/html")) {
                            this.htmlData = stringWriter.toString();
                        } else {
                            this.richText = stringWriter.toString();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            void removeText() {
                if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                    try {
                        Document document = this.c.getDocument();
                        document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }

            protected DataFlavor[] getRicherFlavors() {
                if (this.richText == null) {
                    return null;
                }
                try {
                    DataFlavor[] dataFlavorArray = new DataFlavor[]{new DataFlavor(this.mimeType + ";class=java.lang.String"), new DataFlavor(this.mimeType + ";class=java.io.Reader"), new DataFlavor(this.mimeType + ";class=java.io.InputStream;charset=unicode")};
                    return dataFlavorArray;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }

            protected Object getRicherData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
                if (this.richText == null) {
                    return null;
                }
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return this.richText;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(this.richText);
                }
                if (InputStream.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringBufferInputStream(this.richText);
                }
                throw new UnsupportedFlavorException(dataFlavor);
            }
        }
    }

    class UpdateHandler
    implements PropertyChangeListener,
    DocumentListener,
    LayoutManager2,
    UIResource {
        private Hashtable constraints;
        private boolean i18nView = false;

        UpdateHandler() {
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof Document || object2 instanceof Document) {
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                    this.i18nView = false;
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                    if ("document" == string) {
                        BasicTextUI.this.setView(null);
                        BasicTextUI.this.propertyChange(propertyChangeEvent);
                        BasicTextUI.this.modelChanged();
                        return;
                    }
                }
                BasicTextUI.this.modelChanged();
            }
            if ("focusAccelerator" == string) {
                BasicTextUI.this.updateFocusAcceleratorBinding(true);
            } else if ("componentOrientation" == string) {
                BasicTextUI.this.modelChanged();
            } else if ("font" == string) {
                BasicTextUI.this.modelChanged();
            } else if ("transferHandler" == string) {
                DropTarget dropTarget = BasicTextUI.this.editor.getDropTarget();
                if (dropTarget instanceof UIResource) {
                    if (defaultDropTargetListener == null) {
                        defaultDropTargetListener = new TextDropTargetListener();
                    }
                    try {
                        dropTarget.addDropTargetListener(defaultDropTargetListener);
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                }
            } else if ("editable" == string) {
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(propertyChangeEvent);
        }

        public final void insertUpdate(DocumentEvent documentEvent) {
            Boolean bl2;
            Document document = documentEvent.getDocument();
            Object object = document.getProperty("i18n");
            if (object instanceof Boolean && (bl2 = (Boolean)object) != this.i18nView) {
                this.i18nView = bl2;
                BasicTextUI.this.modelChanged();
                return;
            }
            bl2 = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.insertUpdate(documentEvent, (Shape)((Object)bl2), BasicTextUI.this.rootView.getViewFactory());
        }

        public final void removeUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.removeUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public final void changedUpdate(DocumentEvent documentEvent) {
            Rectangle rectangle = BasicTextUI.this.painted ? BasicTextUI.this.getVisibleEditorRect() : null;
            BasicTextUI.this.rootView.changedUpdate(documentEvent, rectangle, BasicTextUI.this.rootView.getViewFactory());
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
            if (this.constraints != null) {
                this.constraints.remove(component);
            }
        }

        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Rectangle rectangle;
            if (this.constraints != null && !this.constraints.isEmpty() && (rectangle = BasicTextUI.this.getVisibleEditorRect()) != null) {
                Document document = BasicTextUI.this.editor.getDocument();
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).readLock();
                }
                try {
                    BasicTextUI.this.rootView.setSize(rectangle.width, rectangle.height);
                    Enumeration enumeration = this.constraints.keys();
                    while (enumeration.hasMoreElements()) {
                        Component component = (Component)enumeration.nextElement();
                        View view = (View)this.constraints.get(component);
                        Shape shape = this.calculateViewPosition(rectangle, view);
                        if (shape == null) continue;
                        Rectangle rectangle2 = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                        component.setBounds(rectangle2);
                    }
                }
                finally {
                    if (document instanceof AbstractDocument) {
                        ((AbstractDocument)document).readUnlock();
                    }
                }
            }
        }

        Shape calculateViewPosition(Shape shape, View view) {
            int n2 = view.getStartOffset();
            View view2 = null;
            View view3 = BasicTextUI.this.rootView;
            while (view3 != null && view3 != view) {
                int n3 = ((View)view3).getViewIndex(n2, Position.Bias.Forward);
                shape = ((View)view3).getChildAllocation(n3, shape);
                view2 = ((View)view3).getView(n3);
                view3 = view2;
            }
            return view2 != null ? shape : null;
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object instanceof View) {
                if (this.constraints == null) {
                    this.constraints = new Hashtable(7);
                }
                this.constraints.put(component, object);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return null;
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.5f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

