/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.awt.DisplayChangedListener;
import sun.awt.FontConfiguration;
import sun.awt.SunDisplayChanger;
import sun.awt.Win32GraphicsDevice;
import sun.awt.WindowsFlags;
import sun.awt.windows.WFontConfiguration;
import sun.awt.windows.WPrinterJob;
import sun.awt.windows.WToolkit;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment
implements DisplayChangedListener {
    SunDisplayChanger displayChanger = new SunDisplayChanger();
    private static boolean displayInitialized;
    static String fontsForPrinting;

    public static void init() {
    }

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    protected native int getNumScreens();

    protected native int getDefaultScreen();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public void displayChanged() {
        GraphicsDevice[] graphicsDeviceArray = this.resetDisplays();
        WToolkit.resetGC();
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            if (!(graphicsDeviceArray[i2] instanceof Win32GraphicsDevice)) continue;
            ((Win32GraphicsDevice)graphicsDeviceArray[i2]).displayChanged();
        }
        this.displayChanger.notifyListeners();
    }

    public void paletteChanged() {
        this.displayChanger.notifyPaletteChanged();
    }

    public synchronized GraphicsDevice[] resetDisplays() {
        GraphicsDevice[] graphicsDeviceArray = this.screens;
        return graphicsDeviceArray;
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.displayChanger.remove(displayChangedListener);
    }

    private static native String getEUDCFontFile();

    protected boolean useAbsoluteFontFileNames() {
        return false;
    }

    protected void registerFontFile(String string, String[] stringArray, int n2, boolean bl2) {
        int n3;
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        this.registeredFontFiles.add(string);
        if (ttFilter.accept(null, string)) {
            n3 = 0;
        } else if (t1Filter.accept(null, string)) {
            n3 = 1;
        } else {
            return;
        }
        if (this.fontPath == null) {
            this.fontPath = this.getPlatformFontPath(noType1Font);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.fontPath, File.pathSeparator);
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2, string);
                if (!file.canRead()) continue;
                String string3 = file.getAbsolutePath();
                if (bl2) {
                    FontManager.registerDeferredFont(string, string3, stringArray, n3, true, n2);
                } else {
                    FontManager.registerFontFile(string3, stringArray, n3, true, n2);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
    }

    protected void registerJREFontsWithPlatform(String string) {
        fontsForPrinting = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerJREFontsForPrinting() {
        String string = null;
        Object object = Win32GraphicsEnvironment.class;
        synchronized (Win32GraphicsEnvironment.class) {
            if (fontsForPrinting == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            string = fontsForPrinting;
            fontsForPrinting = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = new File(string);
            String[] stringArray = ((File)object).list(new SunGraphicsEnvironment.TTFilter());
            if (stringArray == null) {
                return;
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file = new File((File)object, stringArray[i2]);
                Win32GraphicsEnvironment.registerFontWithPlatform(file.getAbsolutePath());
            }
            return;
        }
    }

    protected static native void registerFontWithPlatform(String var0);

    protected static native void deRegisterFontWithPlatform(String var0);

    protected GraphicsDevice makeScreenDevice(int n2) {
        return new Win32GraphicsDevice(n2);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new WPrinterJob();
    }

    protected FontConfiguration createFontConfiguration() {
        return new WFontConfiguration(this);
    }

    public FontConfiguration createFontConfiguration(boolean bl2, boolean bl3) {
        return new WFontConfiguration(this, bl2, bl3);
    }

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initFlags();
        Win32GraphicsEnvironment.initDisplayWrapper();
        eudcFontFileName = Win32GraphicsEnvironment.getEUDCFontFile();
        fontsForPrinting = null;
    }
}

