/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import sun.awt.FontConfiguration;
import sun.awt.PlatformFont;
import sun.awt.image.ByteComponentRaster;
import sun.awt.windows.WPrinterJob;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PathGraphics;
import sun.print.ProxyGraphics2D;

class WPathGraphics
extends PathGraphics {
    private static final int DEFAULT_USER_RES = 72;
    private static final float MIN_DEVICE_LINEWIDTH = 1.2f;
    private static final float MAX_THINLINE_INCHES = 0.014f;
    private Font lastFont;
    private Font lastDeviceSizeFont;
    private int lastAngle;
    private float lastScaledFontSize;
    private float lastAverageWidthScale;

    WPathGraphics(Graphics2D graphics2D, PrinterJob printerJob, Printable printable, PageFormat pageFormat, int n2, boolean bl2) {
        super(graphics2D, printerJob, printable, pageFormat, n2, bl2);
    }

    public Graphics create() {
        return new WPathGraphics((Graphics2D)this.getDelegate().create(), this.getPrinterJob(), this.getPrintable(), this.getPageFormat(), this.getPageIndex(), this.canDoRedraws());
    }

    public void draw(Shape shape) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = null;
            BasicStroke basicStroke2 = (BasicStroke)stroke;
            float f2 = basicStroke2.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f2, f2);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            if (f3 < 1.2f) {
                Point2D.Float float_2 = new Point2D.Float(1.2f, 1.2f);
                try {
                    AffineTransform affineTransform2 = affineTransform.createInverse();
                    affineTransform2.deltaTransform(float_2, float_2);
                    float f4 = Math.max(Math.abs(float_2.x), Math.abs(float_2.y));
                    basicStroke = new BasicStroke(f4, basicStroke2.getEndCap(), basicStroke2.getLineJoin(), basicStroke2.getMiterLimit(), basicStroke2.getDashArray(), basicStroke2.getDashPhase());
                    this.setStroke(basicStroke);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
            }
            super.draw(shape);
            if (basicStroke != null) {
                this.setStroke(basicStroke2);
            }
        } else {
            super.draw(shape);
        }
    }

    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    protected int platformFontCount(Font font, String string) {
        boolean bl2;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n2 = affineTransform2.getType();
        boolean bl3 = bl2 = n2 != 32 && (n2 & 0x40) == 0;
        if (!bl2) {
            return 0;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Font2D font2D = FontManager.getFont2D(font);
        if (font2D instanceof CompositeFont) {
            if (!((CompositeFont)font2D).isStdComposite() || FontManager.usingAlternateCompositeFonts()) {
                return 0;
            }
            return wPrinterJob.setLogicalFont(font, 0, 1.0f) ? 1 : 0;
        }
        return wPrinterJob.setFont(font, 0, 1.0f) ? 1 : 0;
    }

    public void drawString(String string, float f2, float f3, Font font, FontRenderContext fontRenderContext, float f4) {
        if (string.length() == 0) {
            return;
        }
        Font font2 = this.getFont();
        if (!font2.equals(font)) {
            this.setFont(font);
        } else {
            font2 = null;
        }
        boolean bl2 = false;
        AffineTransform affineTransform = this.getTransform();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        affineTransform2.concatenate(this.getFont().getTransform());
        int n2 = affineTransform2.getType();
        boolean bl3 = n2 != 32 && (n2 & 0x40) == 0;
        boolean bl4 = this.stringNeedsShaping(string);
        if (!WPrinterJob.shapeTextProp && bl3 && !bl4) {
            Font font3;
            double d2;
            Point2D.Float float_ = new Point2D.Float(f2, f3);
            affineTransform.transform(float_, float_);
            Font font4 = this.getFont();
            float f5 = font4.getSize2D();
            Point2D.Double double_ = new Point2D.Double(0.0, 1.0);
            affineTransform2.deltaTransform(double_, double_);
            double d3 = Math.sqrt(double_.x * double_.x + double_.y * double_.y);
            float f6 = (float)((double)f5 * d3);
            Point2D.Double double_2 = new Point2D.Double(1.0, 0.0);
            affineTransform2.deltaTransform(double_2, double_2);
            double d4 = Math.sqrt(double_2.x * double_2.x + double_2.y * double_2.y);
            float f7 = (float)((double)f5 * d4);
            float f8 = (float)(d4 / d3);
            if (f8 > 0.999f && f8 < 1.001f) {
                f8 = 1.0f;
            }
            if ((d2 = Math.toDegrees(Math.atan2(double_2.y, double_2.x))) < 0.0) {
                d2 += 360.0;
            }
            if (d2 != 0.0) {
                d2 = 360.0 - d2;
            }
            int n3 = (int)Math.round(d2 * 10.0);
            if (font4 != null && this.lastFont != null && this.lastDeviceSizeFont != null && f6 == this.lastScaledFontSize && f8 == this.lastAverageWidthScale && font4.equals(this.lastFont) && n3 == this.lastAngle) {
                font3 = this.lastDeviceSizeFont;
            } else {
                font3 = font4.deriveFont(f6);
                this.lastAngle = n3;
                this.lastScaledFontSize = f6;
                this.lastAverageWidthScale = f8;
                this.lastDeviceSizeFont = font3;
                this.lastFont = font4;
            }
            Font2D font2D = FontManager.getFont2D(font3);
            boolean bl5 = font2D instanceof CompositeFont && !((CompositeFont)font2D).isStdComposite();
            WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
            Font font5 = null;
            boolean bl6 = false;
            boolean bl7 = wPrinterJob.setFont(font3, n3, f8);
            if (bl7 && bl5) {
                Font font6 = new Font(font3.getFamily(), font3.getStyle(), 12);
                boolean bl8 = bl7 = font6.canDisplayUpTo(string) == -1;
            }
            if (!bl7 && SunGraphicsEnvironment.isLogicalFont(font3)) {
                if (!FontManager.usingAlternateCompositeFonts() && !bl5) {
                    font5 = font3;
                    if (FontConfiguration.isLogicalFontFaceName(font5.getFontName())) {
                        int n4 = font2D.getStyle() | font5.getStyle();
                        font5 = new Font(font3.getFamily(), n4, font3.getSize());
                    }
                    bl6 = wPrinterJob.setLogicalFont(font5, n3, f8);
                }
                if (bl6) {
                    try {
                        if (((PlatformFont)font5.getPeer()).makeMultiCharsetString(string, false) == null) {
                            bl6 = false;
                        }
                    }
                    catch (Exception exception) {
                        bl6 = false;
                    }
                }
            }
            if (bl7 || bl6) {
                try {
                    wPrinterJob.setTextColor((Color)this.getPaint());
                }
                catch (ClassCastException classCastException) {
                    if (font2 != null) {
                        this.setFont(font2);
                    }
                    throw new IllegalArgumentException("Expected a Color instance");
                }
                if (this.getClip() != null) {
                    this.deviceClip(this.getClip().getPathIterator(affineTransform));
                }
                wPrinterJob.textOut(string, float_.x, float_.y, bl6 ? font5 : null);
                bl2 = true;
            }
        }
        if (!bl2) {
            if (font2 != null) {
                this.setFont(font2);
                font2 = null;
            }
            super.drawString(string, f2, f3, font, fontRenderContext, f4);
        }
        if (font2 != null) {
            this.setFont(font2);
        }
    }

    private boolean stringNeedsShaping(String string) {
        boolean bl2 = false;
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if ((c2 & 0xFE00) == 0) continue;
            if (c2 >= '\u0590' && c2 <= '\u05ff') {
                bl2 = true;
                break;
            }
            if (c2 >= '\u0600' && c2 <= '\u06ff') {
                bl2 = true;
                break;
            }
            if (c2 >= '\u202a' && c2 <= '\u202e') {
                bl2 = true;
                break;
            }
            if (c2 < '\u206a' || c2 > '\u206f') continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    protected boolean drawImageToPlatform(Image image, AffineTransform affineTransform, Color color, int n2, int n3, int n4, int n5, boolean bl2) {
        BufferedImage bufferedImage = this.getBufferedImage(image);
        if (bufferedImage == null) {
            return true;
        }
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        AffineTransform affineTransform2 = this.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        affineTransform2.concatenate(affineTransform);
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        Point2D.Float float_ = new Point2D.Float(1.0f, 0.0f);
        Point2D.Float float_2 = new Point2D.Float(0.0f, 1.0f);
        affineTransform2.deltaTransform(float_, float_);
        affineTransform2.deltaTransform(float_2, float_2);
        Point2D.Float float_3 = new Point2D.Float(0.0f, 0.0f);
        double d2 = float_.distance(float_3);
        double d3 = float_2.distance(float_3);
        if (d2 != 0.0 && d3 != 0.0) {
            AffineTransform affineTransform3 = new AffineTransform(dArray[0] / d2, dArray[1] / d3, dArray[2] / d2, dArray[3] / d3, dArray[4] / d2, dArray[5] / d3);
            Rectangle2D.Float float_4 = new Rectangle2D.Float(n2, n3, n4, n5);
            Shape shape = affineTransform3.createTransformedShape(float_4);
            Rectangle2D rectangle2D = shape.getBounds2D();
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + 0.001, rectangle2D.getHeight() + 0.001);
            int n6 = (int)rectangle2D.getWidth();
            int n7 = (int)rectangle2D.getHeight();
            if (n6 > 0 && n7 > 0) {
                boolean bl3 = true;
                if (!bl2 && this.hasTransparentPixels(bufferedImage)) {
                    bl3 = false;
                    if (this.isBitmaskTransparency(bufferedImage)) {
                        if (color == null) {
                            if (this.drawBitmaskImage(bufferedImage, affineTransform, color, n2, n3, n4, n5)) {
                                return true;
                            }
                        } else if (color.getTransparency() == 1) {
                            bl3 = true;
                        }
                    }
                    if (!this.canDoRedraws()) {
                        bl3 = true;
                    }
                } else {
                    color = null;
                }
                if ((n2 + n4 > bufferedImage.getWidth(null) || n3 + n5 > bufferedImage.getHeight(null)) && this.canDoRedraws()) {
                    bl3 = false;
                }
                if (!bl3) {
                    wPrinterJob.saveState(this.getTransform(), this.getClip(), rectangle2D, d2, d3, float_4, affineTransform);
                    return true;
                }
                BufferedImage bufferedImage2 = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.clipRect(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
                graphics2D.transform(affineTransform3);
                if (color == null) {
                    color = Color.white;
                }
                graphics2D.drawImage(bufferedImage, n2, n3, n2 + n4, n3 + n5, n2, n3, n2 + n4, n3 + n5, color, null);
                Shape shape2 = this.getClip();
                this.clip(affineTransform.createTransformedShape(float_4));
                this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
                Rectangle2D.Float float_5 = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
                ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage2.getRaster();
                wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_5.x, float_5.y, (float)Math.rint((double)float_5.width + 0.5), (float)Math.rint((double)float_5.height + 0.5), 0.0f, 0.0f, bufferedImage2.getWidth(), bufferedImage2.getHeight());
                graphics2D.dispose();
                this.setClip(shape2);
            }
        }
        return true;
    }

    public void redrawRegion(Rectangle2D rectangle2D, double d2, double d3, Rectangle2D rectangle2D2, AffineTransform affineTransform) throws PrinterException {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        Printable printable = this.getPrintable();
        PageFormat pageFormat = this.getPageFormat();
        int n2 = this.getPageIndex();
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 5);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        ProxyGraphics2D proxyGraphics2D = new ProxyGraphics2D(graphics2D, wPrinterJob);
        proxyGraphics2D.setColor(Color.white);
        proxyGraphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.clipRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        proxyGraphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
        float f2 = (float)(wPrinterJob.getXRes() / d2);
        float f3 = (float)(wPrinterJob.getYRes() / d3);
        proxyGraphics2D.scale(f2 / 72.0f, f3 / 72.0f);
        proxyGraphics2D.translate(-wPrinterJob.getPhysicalPrintableX(pageFormat.getPaper()) / wPrinterJob.getXRes() * 72.0, -wPrinterJob.getPhysicalPrintableY(pageFormat.getPaper()) / wPrinterJob.getYRes() * 72.0);
        proxyGraphics2D.transform(new AffineTransform(this.getPageFormat().getMatrix()));
        proxyGraphics2D.setPaint(Color.black);
        printable.print(proxyGraphics2D, pageFormat, n2);
        graphics2D.dispose();
        this.clip(affineTransform.createTransformedShape(rectangle2D2));
        this.deviceClip(this.getClip().getPathIterator(this.getTransform()));
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)(rectangle2D.getX() * d2), (float)(rectangle2D.getY() * d3), (float)(rectangle2D.getWidth() * d2), (float)(rectangle2D.getHeight() * d3));
        ByteComponentRaster byteComponentRaster = (ByteComponentRaster)bufferedImage.getRaster();
        wPrinterJob.drawImage3ByteBGR(byteComponentRaster.getDataStorage(), float_.x, float_.y, float_.width, float_.height, 0.0f, 0.0f, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    protected void deviceFill(PathIterator pathIterator, Color color) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectSolidBrush(color);
        wPrinterJob.fillPath();
    }

    protected void deviceClip(PathIterator pathIterator) {
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        this.convertToWPath(pathIterator);
        wPrinterJob.selectClipPath();
    }

    protected void deviceFrameRect(int n2, int n3, int n4, int n5, Color color) {
        boolean bl2;
        AffineTransform affineTransform = this.getTransform();
        int n6 = affineTransform.getType();
        boolean bl3 = bl2 = (n6 & 0x30) != 0;
        if (bl2) {
            this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            int n7 = basicStroke.getEndCap();
            int n8 = basicStroke.getLineJoin();
            if (n7 == 2 && n8 == 0 && basicStroke.getMiterLimit() == 10.0f) {
                float f2 = basicStroke.getLineWidth();
                Point2D.Float float_ = new Point2D.Float(f2, f2);
                affineTransform.deltaTransform(float_, float_);
                float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
                Point2D.Float float_2 = new Point2D.Float(n2, n3);
                affineTransform.transform(float_2, float_2);
                Point2D.Float float_3 = new Point2D.Float(n2 + n4, n3 + n5);
                affineTransform.transform(float_3, float_3);
                float f4 = (float)(float_3.getX() - float_2.getX());
                float f5 = (float)(float_3.getY() - float_2.getY());
                WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
                if (wPrinterJob.selectStylePen(n7, n8, f3, color)) {
                    wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f4, f5);
                } else {
                    double d2 = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                    if ((double)f3 / d2 < (double)0.014f) {
                        wPrinterJob.selectPen(f3, color);
                        wPrinterJob.frameRect((float)float_2.getX(), (float)float_2.getY(), f4, f5);
                    } else {
                        this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
                    }
                }
            } else {
                this.draw(new Rectangle2D.Float(n2, n3, n4, n5));
            }
        }
    }

    protected void deviceFillRect(int n2, int n3, int n4, int n5, Color color) {
        boolean bl2;
        AffineTransform affineTransform = this.getTransform();
        int n6 = affineTransform.getType();
        boolean bl3 = bl2 = (n6 & 0x30) != 0;
        if (bl2) {
            this.fill(new Rectangle2D.Float(n2, n3, n4, n5));
            return;
        }
        Point2D.Float float_ = new Point2D.Float(n2, n3);
        affineTransform.transform(float_, float_);
        Point2D.Float float_2 = new Point2D.Float(n2 + n4, n3 + n5);
        affineTransform.transform(float_2, float_2);
        float f2 = (float)(float_2.getX() - float_.getX());
        float f3 = (float)(float_2.getY() - float_.getY());
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        wPrinterJob.fillRect((float)float_.getX(), (float)float_.getY(), f2, f3, color);
    }

    protected void deviceDrawLine(int n2, int n3, int n4, int n5, Color color) {
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            WPrinterJob wPrinterJob;
            BasicStroke basicStroke = (BasicStroke)stroke;
            if (basicStroke.getDashArray() != null) {
                this.draw(new Line2D.Float(n2, n3, n4, n5));
                return;
            }
            float f2 = basicStroke.getLineWidth();
            Point2D.Float float_ = new Point2D.Float(f2, f2);
            AffineTransform affineTransform = this.getTransform();
            affineTransform.deltaTransform(float_, float_);
            float f3 = Math.min(Math.abs(float_.x), Math.abs(float_.y));
            Point2D.Float float_2 = new Point2D.Float(n2, n3);
            affineTransform.transform(float_2, float_2);
            Point2D.Float float_3 = new Point2D.Float(n4, n5);
            affineTransform.transform(float_3, float_3);
            int n6 = basicStroke.getEndCap();
            int n7 = basicStroke.getLineJoin();
            if (float_3.getX() == float_2.getX() && float_3.getY() == float_2.getY()) {
                n6 = 1;
            }
            if ((wPrinterJob = (WPrinterJob)this.getPrinterJob()).selectStylePen(n6, n7, f3, color)) {
                wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
            } else {
                double d2 = Math.min(wPrinterJob.getXRes(), wPrinterJob.getYRes());
                if (n6 == 1 || (n2 == n4 || n3 == n5) && (double)f3 / d2 < (double)0.014f) {
                    wPrinterJob.selectPen(f3, color);
                    wPrinterJob.moveTo((float)float_2.getX(), (float)float_2.getY());
                    wPrinterJob.lineTo((float)float_3.getX(), (float)float_3.getY());
                } else {
                    this.draw(new Line2D.Float(n2, n3, n4, n5));
                }
            }
        }
    }

    private void convertToWPath(PathIterator pathIterator) {
        float[] fArray = new float[6];
        WPrinterJob wPrinterJob = (WPrinterJob)this.getPrinterJob();
        int n2 = pathIterator.getWindingRule() == 0 ? 1 : 2;
        wPrinterJob.setPolyFillMode(n2);
        wPrinterJob.beginPath();
        while (!pathIterator.isDone()) {
            int n3 = pathIterator.currentSegment(fArray);
            switch (n3) {
                case 0: {
                    wPrinterJob.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    wPrinterJob.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    int n4 = wPrinterJob.getPenX();
                    int n5 = wPrinterJob.getPenY();
                    float f2 = (float)n4 + (fArray[0] - (float)n4) * 2.0f / 3.0f;
                    float f3 = (float)n5 + (fArray[1] - (float)n5) * 2.0f / 3.0f;
                    float f4 = fArray[2] - (fArray[2] - fArray[0]) * 2.0f / 3.0f;
                    float f5 = fArray[3] - (fArray[3] - fArray[1]) * 2.0f / 3.0f;
                    wPrinterJob.polyBezierTo(f2, f3, f4, f5, fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    wPrinterJob.polyBezierTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    break;
                }
                case 4: {
                    wPrinterJob.closeFigure();
                }
            }
            pathIterator.next();
        }
        wPrinterJob.endPath();
    }
}

