/*
 * Decompiled with CFR 0.152.
 */
package sun.security.acl;

import java.security.Principal;
import java.security.acl.Acl;
import java.security.acl.AclEntry;
import java.security.acl.Group;
import java.security.acl.NotOwnerException;
import java.security.acl.Permission;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.security.acl.AclEnumerator;
import sun.security.acl.OwnerImpl;

public class AclImpl
extends OwnerImpl
implements Acl {
    private Hashtable allowedUsersTable = new Hashtable(23);
    private Hashtable allowedGroupsTable = new Hashtable(23);
    private Hashtable deniedUsersTable = new Hashtable(23);
    private Hashtable deniedGroupsTable = new Hashtable(23);
    private String aclName = null;
    private Vector zeroSet = new Vector(1, 1);

    public AclImpl(Principal principal, String string) {
        super(principal);
        try {
            this.setName(principal, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setName(Principal principal, String string) throws NotOwnerException {
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        this.aclName = string;
    }

    public String getName() {
        return this.aclName;
    }

    public synchronized boolean addEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.findTable(aclEntry);
        if (hashtable.get(principal2 = aclEntry.getPrincipal()) != null) {
            return false;
        }
        hashtable.put(principal2, aclEntry);
        return true;
    }

    public synchronized boolean removeEntry(Principal principal, AclEntry aclEntry) throws NotOwnerException {
        Principal principal2;
        if (!this.isOwner(principal)) {
            throw new NotOwnerException();
        }
        Hashtable hashtable = this.findTable(aclEntry);
        Object v2 = hashtable.remove(principal2 = aclEntry.getPrincipal());
        return v2 != null;
    }

    public synchronized Enumeration getPermissions(Principal principal) {
        Enumeration enumeration = this.subtract(this.getGroupPositive(principal), this.getGroupNegative(principal));
        Enumeration enumeration2 = this.subtract(this.getGroupNegative(principal), this.getGroupPositive(principal));
        Enumeration enumeration3 = this.subtract(this.getIndividualPositive(principal), this.getIndividualNegative(principal));
        Enumeration enumeration4 = this.subtract(this.getIndividualNegative(principal), this.getIndividualPositive(principal));
        Enumeration enumeration5 = this.subtract(enumeration, enumeration4);
        Enumeration enumeration6 = AclImpl.union(enumeration3, enumeration5);
        enumeration3 = this.subtract(this.getIndividualPositive(principal), this.getIndividualNegative(principal));
        enumeration4 = this.subtract(this.getIndividualNegative(principal), this.getIndividualPositive(principal));
        enumeration5 = this.subtract(enumeration2, enumeration3);
        Enumeration enumeration7 = AclImpl.union(enumeration4, enumeration5);
        return this.subtract(enumeration6, enumeration7);
    }

    public boolean checkPermission(Principal principal, Permission permission) {
        Enumeration enumeration = this.getPermissions(principal);
        while (enumeration.hasMoreElements()) {
            Permission permission2 = (Permission)enumeration.nextElement();
            if (!((Object)permission2).equals(permission)) continue;
            return true;
        }
        return false;
    }

    public synchronized Enumeration entries() {
        return new AclEnumerator(this, this.allowedUsersTable, this.allowedGroupsTable, this.deniedUsersTable, this.deniedGroupsTable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.entries();
        while (enumeration.hasMoreElements()) {
            AclEntry aclEntry = (AclEntry)enumeration.nextElement();
            stringBuffer.append(((Object)aclEntry).toString().trim());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private Hashtable findTable(AclEntry aclEntry) {
        Hashtable hashtable = null;
        Principal principal = aclEntry.getPrincipal();
        hashtable = principal instanceof Group ? (aclEntry.isNegative() ? this.deniedGroupsTable : this.allowedGroupsTable) : (aclEntry.isNegative() ? this.deniedUsersTable : this.allowedUsersTable);
        return hashtable;
    }

    private static Enumeration union(Enumeration enumeration, Enumeration enumeration2) {
        Vector vector = new Vector(20, 20);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            Object e2 = enumeration2.nextElement();
            if (vector.contains(e2)) continue;
            vector.addElement(e2);
        }
        return vector.elements();
    }

    private Enumeration subtract(Enumeration enumeration, Enumeration enumeration2) {
        Vector vector = new Vector(20, 20);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            Object e2 = enumeration2.nextElement();
            if (!vector.contains(e2)) continue;
            vector.removeElement(e2);
        }
        return vector.elements();
    }

    private Enumeration getGroupPositive(Principal principal) {
        Enumeration enumeration = this.zeroSet.elements();
        Enumeration enumeration2 = this.allowedGroupsTable.keys();
        while (enumeration2.hasMoreElements()) {
            Group group = (Group)enumeration2.nextElement();
            if (!group.isMember(principal)) continue;
            AclEntry aclEntry = (AclEntry)this.allowedGroupsTable.get(group);
            enumeration = AclImpl.union(aclEntry.permissions(), enumeration);
        }
        return enumeration;
    }

    private Enumeration getGroupNegative(Principal principal) {
        Enumeration enumeration = this.zeroSet.elements();
        Enumeration enumeration2 = this.deniedGroupsTable.keys();
        while (enumeration2.hasMoreElements()) {
            Group group = (Group)enumeration2.nextElement();
            if (!group.isMember(principal)) continue;
            AclEntry aclEntry = (AclEntry)this.deniedGroupsTable.get(group);
            enumeration = AclImpl.union(aclEntry.permissions(), enumeration);
        }
        return enumeration;
    }

    private Enumeration getIndividualPositive(Principal principal) {
        Enumeration<Object> enumeration = this.zeroSet.elements();
        AclEntry aclEntry = (AclEntry)this.allowedUsersTable.get(principal);
        if (aclEntry != null) {
            enumeration = aclEntry.permissions();
        }
        return enumeration;
    }

    private Enumeration getIndividualNegative(Principal principal) {
        Enumeration<Object> enumeration = this.zeroSet.elements();
        AclEntry aclEntry = (AclEntry)this.deniedUsersTable.get(principal);
        if (aclEntry != null) {
            enumeration = aclEntry.permissions();
        }
        return enumeration;
    }
}

