/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.share.event.ListenerManager;
import oracle.help.navigator.LazyNavigator;
import oracle.help.navigator.Navigator;
import oracle.help.navigator.NavigatorEvent;
import oracle.help.navigator.NavigatorListener;

public class NavigatorTabPanel
extends JTabbedPane
implements NavigatorListener,
ChangeListener {
    private ListenerManager _listeners = new ListenerManager();
    private Navigator _activeNavigator = null;
    private ArrayList _navigators = new ArrayList();

    public NavigatorTabPanel() {
        this.addChangeListener(this);
    }

    public synchronized void addNavigator(Navigator navigator) {
        if (navigator != null) {
            String string = navigator.getLabel();
            Image image = navigator.getLabelImage();
            if (string == null) {
                string = navigator.getDefaultLabel();
            } else if (string.length() == 0) {
                string = navigator.getDefaultLabel();
            }
            navigator.addNavigatorListener(this);
            if (image != null) {
                ImageIcon imageIcon = new ImageIcon(image);
                this.addTab(string, imageIcon, navigator);
            } else {
                this.addTab(string, navigator);
            }
        } else {
            throw new IllegalArgumentException("Null parameter passed to addNavigator");
        }
        this._navigators.add(navigator);
    }

    public synchronized void removeNavigator(Navigator navigator) {
        int n = this.getTabCount();
        if (navigator != null) {
            int n2 = n - 1;
            while (n2 >= 0) {
                Component component = this.getComponentAt(n2);
                if (component == navigator) {
                    navigator.removeNavigatorListener(this);
                    this.removeTabAt(n2);
                }
                --n2;
            }
            ((AbstractCollection)this._navigators).remove(navigator);
        }
    }

    public synchronized Navigator[] getNavigators() {
        Navigator[] navigatorArray = null;
        if (this._navigators.size() > 0) {
            navigatorArray = new Navigator[this._navigators.size()];
            this._navigators.toArray(navigatorArray);
        }
        return navigatorArray;
    }

    public void topicSelected(NavigatorEvent navigatorEvent) {
        if (navigatorEvent != null && navigatorEvent.getSource() == this._activeNavigator) {
            this._fireNavigatorEvent(navigatorEvent);
        }
    }

    public void topicActivated(NavigatorEvent navigatorEvent) {
        if (navigatorEvent != null && navigatorEvent.getSource() == this._activeNavigator) {
            this._fireNavigatorEvent(navigatorEvent);
        }
    }

    public void addActiveNavigatorListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this._listeners.addListener((EventListener)navigatorListener);
        }
    }

    public void removeActiveNavigatorListener(NavigatorListener navigatorListener) {
        if (navigatorListener != null) {
            this._listeners.removeListener((EventListener)navigatorListener);
        }
    }

    public Navigator getActiveNavigator() {
        return this._activeNavigator;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent != null) {
            Component component = this.getSelectedComponent();
            try {
                this._activeNavigator = (Navigator)component;
            }
            catch (Exception exception) {
                this._activeNavigator = null;
            }
            if (this._activeNavigator != null) {
                this._fireNavigatorEvent(new NavigatorEvent(this._activeNavigator, 2000, this._activeNavigator.getCurrentSelection()));
            } else {
                this._fireNavigatorEvent(new NavigatorEvent(this, 2000, null));
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        this._initializeNavigators();
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        this._initializeNavigators();
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        this._initializeNavigators();
    }

    private void _initializeNavigators() {
        Iterator iterator = ((AbstractList)this._navigators).iterator();
        while (iterator.hasNext()) {
            LazyNavigator lazyNavigator;
            Navigator navigator = (Navigator)iterator.next();
            if (!(navigator instanceof LazyNavigator) || (lazyNavigator = (LazyNavigator)navigator).isInitialized()) continue;
            lazyNavigator.initializeLazyNavigator();
        }
    }

    private void _fireNavigatorEvent(NavigatorEvent navigatorEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                NavigatorListener navigatorListener = (NavigatorListener)enumeration.nextElement();
                if (navigatorEvent.getID() == 2000) {
                    navigatorListener.topicSelected(navigatorEvent);
                    continue;
                }
                navigatorListener.topicActivated(navigatorEvent);
            }
        }
    }
}

