/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.navigator.tocNavigator;

import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.ewt.dTree.DTreeDeferredParent;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.model.OneDModel;
import oracle.help.common.Topic;
import oracle.help.common.TopicTreeNode;
import oracle.help.java.tree.TopicTreeComponent;
import oracle.help.java.tree.TopicTreeEvent;
import oracle.help.java.tree.TopicTreeItem;
import oracle.help.java.util.ImageLoader;
import oracle.help.navigator.tocNavigator.TOCItemFactory;

public class TOCBranchItem
extends DTreeDeferredParent
implements TopicTreeItem {
    private ImageIcon _collapsedIcon = null;
    private ImageIcon _expandedIcon = null;
    private static ImageIcon _defaultExpandedIcon = null;
    private static ImageIcon _defaultCollapsedIcon = null;

    public TOCBranchItem(OneDModel oneDModel) {
        super(oneDModel);
    }

    public Topic getTopic() {
        TopicTreeNode topicTreeNode = this.getTopicTreeNode();
        return topicTreeNode.getTopic();
    }

    public TopicTreeNode getTopicTreeNode() {
        DTreeDeferringParent dTreeDeferringParent = this.getDeferringParent();
        TopicTreeNode topicTreeNode = (TopicTreeNode)dTreeDeferringParent.getChildData(this.getIndex());
        return topicTreeNode;
    }

    public DTreeItemFactory getItemFactory() {
        return TOCItemFactory.getInstance();
    }

    public String getLabel() {
        String string = null;
        Topic topic = this.getTopic();
        if (topic != null) {
            string = topic.getLabel();
        }
        return string;
    }

    public Icon getIcon() {
        ImageIcon imageIcon = null;
        imageIcon = this.isExpanded() ? this.getExpandedIcon() : this.getCollapsedIcon();
        return imageIcon;
    }

    protected ImageIcon getExpandedIcon() {
        if (this._expandedIcon == null) {
            this._expandedIcon = this._getCustomIcon();
            if (this._expandedIcon == null) {
                Image image;
                if (_defaultExpandedIcon == null && (image = ImageLoader.loadImage(this.getClass(), "images/openbook.gif")) != null) {
                    _defaultExpandedIcon = new ImageIcon(image);
                }
                this._expandedIcon = _defaultExpandedIcon;
            }
        }
        return this._expandedIcon;
    }

    protected ImageIcon getCollapsedIcon() {
        if (this._collapsedIcon == null) {
            this._collapsedIcon = this._getCustomIcon();
            if (this._collapsedIcon == null) {
                Image image;
                if (_defaultCollapsedIcon == null && (image = ImageLoader.loadImage(this.getClass(), "images/closedbook.gif")) != null) {
                    _defaultCollapsedIcon = new ImageIcon(image);
                }
                this._collapsedIcon = _defaultCollapsedIcon;
            }
        }
        return this._collapsedIcon;
    }

    private ImageIcon _getCustomIcon() {
        Image image;
        ImageIcon imageIcon = null;
        Image image2 = null;
        if (this.isExpanded() && (image = ImageLoader.loadImage(this.getTopic().getActiveIcon())) != null) {
            image2 = image;
        }
        if (image2 == null) {
            image2 = ImageLoader.loadImage(this.getTopic().getDefaultIcon());
        }
        if (image2 != null) {
            imageIcon = new ImageIcon(image2);
        }
        return imageIcon;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            TopicTreeComponent topicTreeComponent = (TopicTreeComponent)this.getTree();
            Point point = new Point(this.getX() + mouseEvent.getX(), this.getY() + mouseEvent.getY());
            topicTreeComponent.firePopupRequested(new TopicTreeEvent(this, 2002), point);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }
}

