/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay;

import java.awt.Component;
import java.awt.Point;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.JPanel;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.AssociativeLink;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.WindowType;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.library.Library;
import oracle.help.topicDisplay.TopicDisplay;
import oracle.help.topicDisplay.TopicDisplayEvent;
import oracle.help.topicDisplay.TopicDisplayException;
import oracle.help.topicDisplay.TopicDisplayListener;
import oracle.help.topicDisplay.popup.ALinkPopup;
import oracle.help.topicDisplay.popup.HTMLPopupWindow;
import oracle.help.topicDisplay.print.BrowserPrintJob;
import oracle.help.topicDisplay.print.TopicPrintJob;

public class BrowserTopicDisplay
implements TopicDisplay,
URLListener,
ProtocolListener {
    private URL _currentURL;
    private WindowType _currentWindowType;
    private Library _library;
    private HTMLBrowser _browser;
    private ListenerManager _listeners;

    public BrowserTopicDisplay(HTMLBrowser hTMLBrowser) {
        this(hTMLBrowser, null);
    }

    public BrowserTopicDisplay(HTMLBrowser hTMLBrowser, Library library) {
        if (hTMLBrowser == null) {
            throw new IllegalArgumentException("BrowserTopicDisplayPanel:  HTMLBrowser parameter to constructor cannot be null");
        }
        this._browser = hTMLBrowser;
        this._browser.addURLListener(this);
        this._browser.addProtocolListener(this);
        this._currentURL = null;
        this._listeners = new ListenerManager();
        this._library = library;
    }

    public void displayTopic(Topic topic) throws TopicDisplayException {
        URL uRL = null;
        if (topic != null) {
            if (topic.hasTarget()) {
                try {
                    Target target = topic.getTarget();
                    uRL = target.getURL();
                }
                catch (Exception exception) {
                    throw new TopicDisplayException("BrowserTopicDisplay:  Target URL is Malformed");
                }
            } else {
                throw new TopicDisplayException("BrowserTopicDisplay:  Cannot display Topic (Topic has no target)");
            }
        }
        this.setBrowserURL(uRL);
    }

    public TopicPrintJob getTopicPrintJob() {
        if (this._browser.isPrintingSupported()) {
            return new BrowserPrintJob(this._browser);
        }
        return null;
    }

    public URL getCurrentURL() {
        return this._currentURL;
    }

    public void runFindDialog() {
        this._browser.runFindDialog();
    }

    public JPanel getDisplayContainer() {
        return this._browser.getHTMLContainer();
    }

    public void clear() {
        this._currentURL = null;
        this._currentWindowType = null;
        this._browser.clear();
    }

    public void dispose() {
        this._browser.removeURLListener(this);
        this._browser.removeProtocolListener(this);
        this._browser.dispose();
        this._currentURL = null;
        this._currentWindowType = null;
        this._library = null;
        this._browser = null;
        this._listeners = null;
    }

    public void addDisplayListener(TopicDisplayListener topicDisplayListener) {
        if (topicDisplayListener != null) {
            this._listeners.addListener((EventListener)topicDisplayListener);
        }
    }

    public void removeDisplayListener(TopicDisplayListener topicDisplayListener) {
        if (topicDisplayListener != null) {
            this._listeners.removeListener((EventListener)topicDisplayListener);
        }
    }

    public void urlChanged(URLEvent uRLEvent) {
        this._handleURLEvent(uRLEvent);
    }

    public void anchorChanged(URLEvent uRLEvent) {
        this._handleURLEvent(uRLEvent);
    }

    public void protocolReceived(ProtocolEvent protocolEvent) {
        if (protocolEvent.getLinkType() != 2003) {
            if (this._library != null) {
                String string = protocolEvent.getLinkID();
                Point point = protocolEvent.getPoint();
                if (protocolEvent.getLinkType() == 2000) {
                    AssociativeLink associativeLink = this._library.getAssociativeLink(string);
                    ALinkPopup aLinkPopup = new ALinkPopup(associativeLink, point, this.getDisplayContainer());
                    ((Component)aLinkPopup).setVisible(true);
                    Topic topic = aLinkPopup.getSelectedTopic();
                    aLinkPopup.dispose();
                    if (topic != null) {
                        this.displayTopic(topic);
                    }
                } else if (protocolEvent.getLinkType() == 2001) {
                    URL uRL = this._library.mapIDToURL(string);
                    if (uRL != null) {
                        HTMLPopupWindow hTMLPopupWindow = new HTMLPopupWindow(this, this._browser.getClass(), uRL, point, this.getDisplayContainer());
                    } else {
                        System.err.println("Error: topic id " + string + " does not map to an URL.");
                    }
                } else if (protocolEvent.getLinkType() == 2002) {
                    URL uRL = this._library.mapIDToURL(string);
                    if (uRL != null) {
                        this.setBrowserURL(uRL);
                    } else {
                        System.err.println("Error: topic id " + string + " does not map to an URL.");
                    }
                }
            } else {
                throw new TopicDisplayException("ERROR:  OHJ specific protocol encountered.  You must associate a Library with the BrowserTopicDisplay during construction to use OHJ's special protocols.");
            }
        }
    }

    public void setBrowserURL(URL uRL) {
        if (uRL == null) {
            throw new TopicDisplayException("BrowserTopicDisplay:  Error Displaying Topic");
        }
        String string = uRL.toString();
        boolean bl = false;
        if (string.indexOf("#") != -1) {
            bl = true;
        }
        if (!uRL.equals(this._currentURL) || bl) {
            this._currentURL = uRL;
            this.handleWindowType(uRL);
            this._browser.setURL(uRL);
        }
    }

    public boolean canGoBack() {
        return this._browser.canGoBack();
    }

    public void goBack() {
        this._browser.goBack();
    }

    public boolean canGoForward() {
        return this._browser.canGoForward();
    }

    public void goForward() {
        this._browser.goForward();
    }

    public String getSelectedText() {
        return this._browser.getSelectedText();
    }

    public void increaseFontSize() {
        this._browser.increaseFontSize();
    }

    public void decreaseFontSize() {
        this._browser.decreaseFontSize();
    }

    public void selectAll() {
        this._browser.selectAll();
    }

    public String getCurrentPageTitle() {
        return this._browser.getCurrentPageTitle();
    }

    private void handleWindowType(URL uRL) {
        WindowType windowType;
        if (this._library != null && uRL != null && this._currentWindowType != (windowType = this._library.mapURLToWindowType(uRL))) {
            this._currentWindowType = windowType;
            TopicDisplayEvent topicDisplayEvent = new TopicDisplayEvent(this, 2000, 1, this._currentURL, this._currentWindowType);
            this._fireTopicDisplayEvent(topicDisplayEvent);
        }
    }

    private void _handleURLEvent(URLEvent uRLEvent) {
        if (uRLEvent != null) {
            String string = uRLEvent.getAnchor();
            if (uRLEvent.getID() == 2000 || uRLEvent.getID() == 2001) {
                this._currentURL = uRLEvent.getURL();
                if (uRLEvent.getID() == 2000) {
                    this.handleWindowType(this._currentURL);
                    if (this._currentWindowType != null) {
                        if (this._currentWindowType.getPageBG() != null) {
                            this._browser.setDefaultBackground(this._currentWindowType.getPageBG());
                        }
                        if (this._currentWindowType.getTextFG() != null) {
                            this._browser.setDefaultTextForeground(this._currentWindowType.getTextFG());
                        }
                        if (this._currentWindowType.getLinkFG() != null) {
                            this._browser.setDefaultLinkForeground(this._currentWindowType.getLinkFG());
                        }
                    }
                }
                this._fireTopicDisplayEvent(new TopicDisplayEvent(this, 2000, 0, this._currentURL, this._currentWindowType, string));
            }
        }
    }

    private void _fireTopicDisplayEvent(TopicDisplayEvent topicDisplayEvent) {
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TopicDisplayListener topicDisplayListener = (TopicDisplayListener)enumeration.nextElement();
                topicDisplayListener.topicDisplayChanged(topicDisplayEvent);
            }
        }
    }
}

