/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.util.EventObject;
import java.util.HashMap;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.view.View;

public final class Context {
    private final HashMap _hash;
    private static final String VIEW = "Context.VIEW";
    private static final String WORKSPACE = "Context.WORKSPACE";
    private static final String PROJECT = "Context.PROJECT";
    private static final String EVENT = "Context.EVENT";
    private static final String SELECTION = "Context.SELECTION";
    private static final Element[] EMPTY_SELECTION = new Element[0];
    private static final String NODE = "Context.NODE";

    void $init$() {
        this._hash = new HashMap();
    }

    public Context() {
        this.$init$();
    }

    public Context(Context context) {
        this.$init$();
        if (context != null) {
            this._hash.putAll(context._hash);
        }
    }

    public Context(Element element) {
        this.$init$();
        this.setElement(element);
        if (element instanceof Node) {
            this.setNode((Node)element);
        }
    }

    public Context(Node node) {
        this.$init$();
        this.setNode(node);
        this.setElement(node);
    }

    public Context(Workspace workspace, Project project) {
        this.$init$();
        this.setWorkspace(workspace);
        this.setProject(project);
    }

    public Context(View view, Workspace workspace, Project project, Node node) {
        this.$init$();
        this.setView(view);
        this.setWorkspace(workspace);
        this.setProject(project);
        this.setNode(node);
        this.setSelection(new Element[]{node});
    }

    public static Context newIdeContext() {
        Context context = new Context();
        context.initViewWorkspaceProject();
        View view = context.getView();
        if (view != null) {
            context.setSelection(view.getSelection());
        }
        return context;
    }

    public static Context newIdeContext(Element element) {
        Context context = new Context();
        context.initViewWorkspaceProject();
        context.setElement(element);
        return context;
    }

    public static Context newIdeContext(Node node) {
        Context context = new Context();
        context.initViewWorkspaceProject();
        context.setNode(node);
        context.setElement(node);
        return context;
    }

    public static Context newIdeContext(View view) {
        Context context = new Context();
        context.initWorkspaceProject();
        if (view != null) {
            context.setView(view);
            Element[] elementArray = view.getSelection();
            if (elementArray != null) {
                Element[] elementArray2 = (Element[])elementArray.clone();
                context.setSelection(elementArray2);
            }
        }
        return context;
    }

    public static Context newIdeContext(View view, EventObject eventObject) {
        Context context = Context.newIdeContext(view);
        context.setEvent(eventObject);
        return context;
    }

    public final boolean equals(Object object) {
        if (object instanceof Context) {
            Context context = (Context)object;
            return this._hash.equals(context._hash);
        }
        return false;
    }

    public final int hashCode() {
        return this._hash.hashCode();
    }

    public final Object getProperty(String string) {
        return this._hash.get(string);
    }

    public final void setProperty(String string, Object object) {
        this._hash.put(string, object);
    }

    public final void removeProperty(String string) {
        this._hash.remove(string);
    }

    public final boolean containsProperty(String string) {
        return this._hash.containsKey(string);
    }

    public final boolean getBoolean(String string) {
        return Boolean.TRUE.equals(this.getProperty(string));
    }

    public final void setBoolean(String string, boolean bl) {
        this.setProperty(string, bl);
    }

    public final int getInt(String string) {
        Object object = this.getProperty(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public final void setInt(String string, int n) {
        this.setProperty(string, new Integer(n));
    }

    public final View getView() {
        return (View)this.getProperty(VIEW);
    }

    public final void setView(View view) {
        this.setProperty(VIEW, view);
    }

    public final Workspace getWorkspace() {
        return (Workspace)this.getProperty(WORKSPACE);
    }

    public final void setWorkspace(Workspace workspace) {
        this.setProperty(WORKSPACE, workspace);
    }

    public final Project getProject() {
        return (Project)this.getProperty(PROJECT);
    }

    public final void setProject(Project project) {
        this.setProperty(PROJECT, project);
    }

    public final EventObject getEvent() {
        return (EventObject)this.getProperty(EVENT);
    }

    public final void setEvent(EventObject eventObject) {
        this.setProperty(EVENT, eventObject);
    }

    public final Element[] getSelection() {
        Object object = this.getProperty(SELECTION);
        return object != null ? (Element[])object : EMPTY_SELECTION;
    }

    public final void setSelection(Element[] elementArray) {
        this.setProperty(SELECTION, elementArray != null ? (Element[])elementArray.clone() : EMPTY_SELECTION);
    }

    public final Node getNode() {
        if (this.containsProperty(NODE)) {
            return (Node)this.getProperty(NODE);
        }
        Element[] elementArray = this.getSelection();
        if (elementArray != null && elementArray.length > 0 && elementArray[0] instanceof Node) {
            return (Node)elementArray[0];
        }
        return null;
    }

    public final void setNode(Node node) {
        this.setProperty(NODE, node);
    }

    public final Element getElement() {
        Element[] elementArray = this.getSelection();
        return elementArray != null && elementArray.length > 0 ? elementArray[0] : null;
    }

    public final void setElement(Element element) {
        this.setSelection(new Element[]{element});
    }

    private final void initViewWorkspaceProject() {
        IdeMainWindow ideMainWindow = Ide.getMainWindow();
        if (ideMainWindow != null) {
            this.setView(ideMainWindow.getLastActiveView());
        }
        this.initWorkspaceProject();
    }

    private final void initWorkspaceProject() {
        this.setWorkspace(Ide.getActiveWorkspace());
        this.setProject(Ide.getActiveProject());
    }
}

