/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.extension.Extension;
import javax.ide.util.Version;
import oracle.ide.Ide;
import oracle.ide.IdeHook;

public abstract class ExtensionRegistry
extends javax.ide.extension.ExtensionRegistry {
    protected static final String EXTENSIONS_DIR = "extensions";
    private static final Logger _extensionLogger = Logger.getLogger(ExtensionRegistry.class.getName());
    protected Logger _manifestLogger;
    private final Map _ideHooksByElementName;

    void $init$() {
        this._manifestLogger = null;
        this._ideHooksByElementName = new HashMap();
    }

    public static final ExtensionRegistry getOracleRegistry() {
        return (ExtensionRegistry)javax.ide.extension.ExtensionRegistry.getExtensionRegistry();
    }

    public final Logger getLogger() {
        return _extensionLogger;
    }

    public final Logger getManifestLogger() {
        if (this._manifestLogger == null) {
            this.createExtensionLogger();
        }
        return this._manifestLogger;
    }

    public abstract boolean isLoaded(String var1);

    public abstract boolean isUserExtension(String var1);

    public abstract boolean isNewlyInstalled(String var1);

    public abstract URL getSystemDirectory(String var1);

    public abstract URL getSystemDirectory(String var1, Version var2);

    public final String getInstallDirectory(String string) {
        return this.getInstallDirectory(string, null);
    }

    public final String getInstallDirectory(String string, Version version) {
        File file = this.getExtensionFile(string, version, "", true);
        if (file == null) {
            return "";
        }
        if (file.isDirectory()) {
            return file.getPath();
        }
        return "";
    }

    private final File getExtensionFile(String string, Version version, String string2, boolean bl) {
        File file;
        File file2;
        if (string == null) {
            throw new NullPointerException("extensionId is null");
        }
        if (version == null) {
            Extension extension = this.findExtension(string);
            if (extension == null) {
                throw new IllegalArgumentException("Extension with id " + string + " doesn't exist.");
            }
            version = extension.getVersion();
        }
        if (bl && (file2 = new File(this.getExtensionsDirPath(Ide.getUserHomeDirectory(), string, version, string2))).exists()) {
            return file2;
        }
        if (!Ide.getUserHomeDirectory().equals(Ide.getHomeDirectory()) && (file = new File(this.getExtensionsDirPath(Ide.getHomeDirectory(), string, version, string2))).exists()) {
            return file;
        }
        return null;
    }

    private final String getExtensionsDirPath(String string, String string2, Version version, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("extensions/");
        stringBuffer.append(string2);
        stringBuffer.append('.');
        String string4 = version.toCanonicalString();
        while (true) {
            File file;
            if ((file = new File(stringBuffer.toString() + string4 + string3)).exists()) {
                return file.getPath();
            }
            int n = string4.lastIndexOf(46);
            if (n < 1) break;
            string4 = string4.substring(0, n);
        }
        File file = new File(stringBuffer.substring(0, stringBuffer.length() - 1) + string3);
        if (file.exists()) {
            return file.getPath();
        }
        return new File(stringBuffer.toString() + version.toString() + string3).getPath();
    }

    protected String getExtensionJAR(String string, Version version, boolean bl) {
        File file = this.getExtensionFile(string, version, ".jar", bl);
        if (file == null) {
            return "";
        }
        return file.getAbsolutePath();
    }

    public String getExtensionJAR(String string, Version version) {
        return this.getExtensionJAR(string, version, true);
    }

    public IdeHook getIdeHook(ElementName elementName) {
        if (elementName == null) {
            throw new NullPointerException("elementName is null");
        }
        return (IdeHook)((Object)this._ideHooksByElementName.get(elementName));
    }

    protected final void registerIdeHook(ElementName elementName, IdeHook ideHook) {
        this._ideHooksByElementName.put(elementName, ideHook);
    }

    public abstract Collection getAllExtensions();

    public abstract Extension findExtensionEvenIfNotLoaded(String var1);

    public ExtensionRegistry() {
        this.$init$();
    }
}

