/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.IdeArgs;
import oracle.ide.IdeCore;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.Version;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.IdeProperties;
import oracle.ide.model.Element;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.MiscellaneousFolder;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.util.HistoryList;

public final class Ide {
    private static final String PROP_LAUNCHER_PROCESS_ID = "ide.launcherProcessId";
    private static IdeCore _instanceCore;

    public static float getVersion() {
        return Version.VERSION;
    }

    public static boolean isRunning() {
        return _instanceCore != null;
    }

    public static IdeMainWindow getMainWindow() {
        return _instanceCore.getMainWindow();
    }

    public static IdeArgs getIdeArgs() {
        return _instanceCore.getIdeArgs();
    }

    public static String getProductID() {
        return _instanceCore.getProductID();
    }

    public static String getProductVersion() {
        return _instanceCore.getProductVersion();
    }

    public static String getBinDirectory() {
        return _instanceCore.getBinDirectory();
    }

    public static String getHomeDirectory() {
        return _instanceCore.getHomeDirectory();
    }

    public static String getOracleHomeDirectory() {
        return _instanceCore.getOracleHomeDirectory();
    }

    public static String getLibDirectory() {
        return _instanceCore.getLibDirectory();
    }

    public static String getUserHomeDirectory() {
        return _instanceCore.getUserHomeDirectory();
    }

    public static String getTrueUserHomeDirectory() {
        return _instanceCore.getTrueUserHomeDirectory();
    }

    public static String getSystemDirectory() {
        return _instanceCore.getSystemDirectory();
    }

    public static String getWorkDirectory() {
        return _instanceCore.getWorkDirectory();
    }

    public static String getProgramName() {
        return _instanceCore.getProgramName();
    }

    public static String getProgramShortName() {
        return _instanceCore.getProgramShortName();
    }

    public static IdeProperties getIdeProperties() {
        return _instanceCore.getIdeProperties();
    }

    public static String getProperty(String string) {
        return Ide.getProperty(string, null);
    }

    public static String getProperty(String string, String string2) {
        return _instanceCore.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        return _instanceCore.setProperty(string, string2);
    }

    public static WaitCursor getWaitCursor() {
        return _instanceCore.getWaitCursor();
    }

    public static ComponentVersionManager getVersionInfo() {
        return _instanceCore.getVersionInfo();
    }

    public static IdeSettings getSettings() {
        return _instanceCore.getSettings();
    }

    public static KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        return _instanceCore.getKeyStrokeContextRegistry();
    }

    public static EnvironOptions getEnvironOptions() {
        return _instanceCore.getEnvironOptions();
    }

    public static DTCache getDTCache() {
        return _instanceCore.getDTCache();
    }

    public static IdeSystem getSystem() {
        return _instanceCore.getSystem();
    }

    public static Workspaces getWorkspaces() {
        return _instanceCore.getWorkspaces();
    }

    public static Workspace getActiveWorkspace() {
        Workspaces workspaces = Ide.getWorkspaces();
        return workspaces != null ? workspaces.currentActiveWorkspace() : null;
    }

    public static void setActiveWorkspace(Workspace workspace) {
        Workspaces workspaces = Ide.getWorkspaces();
        if (workspaces != null) {
            workspaces.setActiveWorkspace(workspace);
        }
    }

    public static Project getActiveProject() {
        Workspace workspace = Ide.getActiveWorkspace();
        return workspace != null ? workspace.currentActiveProject() : null;
    }

    public static void setActiveProject(Project project) {
        Workspace workspace = Ide.getActiveWorkspace();
        if (workspace != null) {
            workspace.setActiveProject(project);
        }
    }

    public static Project getDefaultProject() {
        return Ide.getSystem().getPreferences().getDefaultProject();
    }

    public static Workspace getDefaultWorkspace() {
        return Ide.getSystem().getPreferences().getDefaultWorkspace();
    }

    public static MiscellaneousFolder getMiscellaneousFolder() {
        return _instanceCore.getMiscellaneousFolder();
    }

    public static boolean addToMiscellaneousFolder(Element element) {
        MiscellaneousFolder miscellaneousFolder = Ide.getMiscellaneousFolder();
        if (miscellaneousFolder != null && miscellaneousFolder.canAdd(element)) {
            if (miscellaneousFolder.containsChild(element)) {
                return true;
            }
            if (miscellaneousFolder.add(element)) {
                miscellaneousFolder.checkAddToSystem();
                UpdateMessage.fireChildAdded(miscellaneousFolder, element);
                return true;
            }
        }
        return false;
    }

    public static void addIdeListener(IdeListener ideListener) {
        _instanceCore.addIdeListener(ideListener);
    }

    public static void removeIdeListener(IdeListener ideListener) {
        _instanceCore.removeIdeListener(ideListener);
    }

    public static InputMap getIdeInputMap() {
        return _instanceCore.getIdeInputMap();
    }

    public static ActionMap getIdeActionMap() {
        return _instanceCore.getIdeActionMap();
    }

    public static boolean isQuitting() {
        return _instanceCore.isQuitting();
    }

    public static boolean isStarting() {
        return _instanceCore.isStarting();
    }

    public static Integer findCmdID(String string) {
        return _instanceCore.findCmdID(string);
    }

    public static String findCmdName(int n) {
        return _instanceCore.findCmdName(n);
    }

    public static int createCmdID(String string) {
        return _instanceCore.createCmdID(string);
    }

    public static int findOrCreateCmdID(String string) {
        return _instanceCore.findOrCreateCmdID(string);
    }

    public static Map getMacros() {
        return _instanceCore.getMacros();
    }

    public static int quit(IdeAction ideAction, Context context) {
        return _instanceCore.quit(ideAction, context);
    }

    public static int quit() {
        return Ide.quit(IdeActions.getFileExitAction(), Ide.getMainWindow().getIdeMainWindowView().getContext());
    }

    public static Menubar getMenubar() {
        return Ide.getMainWindow().getMenubar();
    }

    public static Toolbar getToolbar() {
        return Ide.getMainWindow().getIdeMainWindowView().getToolbar();
    }

    public static StatusBar getStatusBar() {
        return Ide.getMainWindow().getStatusBar();
    }

    public static NavigatorWindow getLastActiveNavigator() {
        return Ide.getMainWindow().getLastActiveNavigator();
    }

    public static HistoryList loadHistoryList(String string) {
        return new HistoryList(string, Ide.getIdeProperties());
    }

    public static void startup(IdeArgs ideArgs) {
        IdeCore ideCore = new IdeCore(ideArgs);
        Ide.startup(ideCore, ideArgs);
    }

    public static void startup(IdeCore ideCore, IdeArgs ideArgs) {
        if (_instanceCore != null) {
            throw new IllegalStateException("IDE is already started");
        }
        _instanceCore = ideCore;
        _instanceCore.startupImpl(ideArgs);
    }

    public static Controller getIdeController() {
        return _instanceCore.getController();
    }

    public static String getInstallDirectory(File file) {
        return _instanceCore.getInstallDirectory(file);
    }

    static void preTerminate() {
        _instanceCore.preTerminate();
    }

    static void terminate() {
        _instanceCore.terminate();
    }

    private Ide() {
    }

    public static final boolean canRestart() {
        return System.getProperty(PROP_LAUNCHER_PROCESS_ID) != null;
    }

    public static final void restart() throws UnsupportedOperationException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while ((string = System.getProperty("ide.startingArg" + Integer.toString(n))) != null) {
            arrayList.add(string);
            ++n;
        }
        string = System.getProperty(PROP_LAUNCHER_PROCESS_ID);
        if (arrayList.size() > 0 && string != null) {
            arrayList.add("-pid:" + Integer.parseInt(string));
            arrayList.add("-startingcwd:" + System.getProperty("ide.startingcwd", ""));
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            try {
                Process process = Runtime.getRuntime().exec(stringArray);
                process.exitValue();
                Ide.quit();
                return;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                Ide.quit();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new UnsupportedOperationException("Restarting not supported on this platform");
    }
}

