/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import oracle.ide.util.IdeUtil;

public final class IdeArgs {
    private static final char OPTION_PREFIX = '-';
    private static final char VALUE_SEPARATOR = ':';
    private final String[] _args;
    private boolean _bCreateUI;
    private String _sPlatformFileName;
    private boolean _migrate;

    public IdeArgs() {
        this(new String[0]);
    }

    public IdeArgs(String[] stringArray) {
        this._args = stringArray;
        this.parseArgs(stringArray);
    }

    private void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.length() != 0 && string.charAt(0) == '-') {
                String string2;
                String string3 = string.substring(1);
                String string4 = IdeUtil.getSubString(string3, ':', true);
                if (string4 != null) {
                    string2 = IdeUtil.getSubString(string3, ':', false);
                } else {
                    string4 = string;
                    string2 = null;
                }
                if (string4.compareTo("pf") == 0 || string4.compareTo("platformfile") == 0) {
                    this._sPlatformFileName = IdeArgs.getValue(string2);
                } else if (string4.compareTo("migrate") == 0) {
                    this._migrate = true;
                }
            }
            ++n;
        }
    }

    private static String getValue(String string) {
        int n;
        if (string != null && (n = string.length()) > 1 && (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'"))) {
            string = string.substring(1, n - 1);
        }
        return string;
    }

    public final String[] getArgs() {
        return this._args;
    }

    public boolean hasArg(String string) {
        if (this._args != null && string != null) {
            int n = 0;
            while (n < this._args.length) {
                if (string.equals(this._args[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean getCreateUI() {
        return this._bCreateUI;
    }

    public void setCreateUI(boolean bl) {
        this._bCreateUI = bl;
    }

    public String getPlatformFileName() {
        return this._sPlatformFileName;
    }

    public boolean isMigrate() {
        return this._migrate;
    }
}

