/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.JViewport;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.RevertNodeCommand;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.JFastTreeTable;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.inspector.InspectorManager;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogWindow;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.RelativeDirectoryContextFolder;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.IdeArb;
import oracle.ide.view.View;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.util.SwingClosure;

final class IdeController
implements Controller {
    private int _recursiveControllerCheck;

    IdeController() {
    }

    public boolean update(IdeAction ideAction, Context context) {
        try {
            ++this._recursiveControllerCheck;
            int n = ideAction.getCommandId();
            if (n == 5) {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                boolean bl = commandProcessor.canUndo(context);
                ideAction.setEnabled(bl);
                String string = bl ? commandProcessor.getUndoLabel(context) : "";
                ideAction.putValue("Name", IdeArb.format(82, string));
                boolean bl2 = true;
                --this._recursiveControllerCheck;
                return bl2;
            }
            if (n == 6) {
                CommandProcessor commandProcessor = CommandProcessor.getInstance();
                boolean bl = commandProcessor.canRedo(context);
                ideAction.setEnabled(bl);
                String string = bl ? commandProcessor.getRedoLabel(context) : "";
                ideAction.putValue("Name", IdeArb.format(85, string));
                boolean bl3 = true;
                --this._recursiveControllerCheck;
                return bl3;
            }
            if (n == 73) {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                boolean bl = navigationManager != null ? navigationManager.canNavigateBack() : false;
                ideAction.setEnabled(bl);
                boolean bl4 = true;
                --this._recursiveControllerCheck;
                return bl4;
            }
            if (n == 74) {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                boolean bl = navigationManager != null ? navigationManager.canNavigateForward() : false;
                ideAction.setEnabled(bl);
                boolean bl5 = true;
                --this._recursiveControllerCheck;
                return bl5;
            }
            if (n == 75) {
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                boolean bl = navigationManager != null ? navigationManager.canNavigateToLastEdit() : false;
                ideAction.setEnabled(bl);
                boolean bl6 = true;
                --this._recursiveControllerCheck;
                return bl6;
            }
            if (n == 33) {
                ideAction.setEnabled(InspectorManager.getInspectorManager() != null);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 49) {
                ideAction.setEnabled(ExplorerManager.getExplorerManager() != null);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 34) {
                ideAction.setEnabled(LogManager.getLogManager() != null);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 67) {
                ideAction.setEnabled(false);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 68) {
                ideAction.setEnabled(false);
                ideAction.setState(false);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 0) {
                ideAction.setEnabled(true);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 11) {
                boolean bl = IdeController.canSave(context);
                ideAction.setEnabled(bl);
                boolean bl7 = true;
                --this._recursiveControllerCheck;
                return bl7;
            }
            if (n == 12) {
                boolean bl = IdeController.canSaveAs(context);
                ideAction.setEnabled(bl);
                boolean bl8 = true;
                --this._recursiveControllerCheck;
                return bl8;
            }
            if (n == 14) {
                boolean bl = IdeController.canRename(context);
                ideAction.setEnabled(bl);
                boolean bl9 = true;
                --this._recursiveControllerCheck;
                return bl9;
            }
            if (n == 52) {
                boolean bl = IdeController.isRevertable(context);
                ideAction.setEnabled(bl);
                boolean bl10 = true;
                --this._recursiveControllerCheck;
                return bl10;
            }
            if (n == 57) {
                boolean bl = IdeController.isLocatableInNavigator(context);
                ideAction.setEnabled(bl);
                boolean bl11 = true;
                --this._recursiveControllerCheck;
                return bl11;
            }
            if (n == 13) {
                ideAction.setEnabled(true);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 2 || n == 3) {
                boolean bl = context != null && context.getWorkspace() != null;
                ideAction.setEnabled(bl);
                boolean bl12 = true;
                --this._recursiveControllerCheck;
                return bl12;
            }
            if (n == 8) {
                boolean bl = context != null && context.getProject() != null;
                ideAction.setEnabled(bl);
                boolean bl13 = true;
                --this._recursiveControllerCheck;
                return bl13;
            }
            if (n == 48) {
                boolean bl = this.updateCloseNode(context, ideAction);
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 21 || n == 47 || n == 52) {
                ideAction.setEnabled(false);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 51) {
                ideAction.setEnabled(false);
            } else {
                if (n == 9 || n == 10 || n == 15 || n == 4 || n == 36 || n == 37 || n == 38) {
                    ideAction.setEnabled(true);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 69) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    StatusBar statusBar = ideMainWindow.getStatusBar();
                    ideAction.setEnabled(true);
                    ideAction.setState(statusBar.getGUI().isVisible());
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 30 || n == 31) {
                    Controller controller;
                    View view;
                    LogPage logPage;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage = logWindow.getPage()) != null && (view = logPage.getLogPageView()) != null && (controller = view.getController()) != null && controller != this && controller.update(ideAction, context)) {
                        boolean bl = true;
                        --this._recursiveControllerCheck;
                        return bl;
                    }
                    ideAction.setEnabled(false);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 17 || n == 18 || n == 19 || n == 78 || n == 20 || n == 22 || n == 35 || n == 40 || n == 41 || n == 42 || n == 43 || n == 54 || n == 55) {
                    ideAction.setEnabled(false);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 77) {
                    boolean bl = this.canCopyPath(context);
                    ideAction.setEnabled(bl);
                    boolean bl14 = true;
                    --this._recursiveControllerCheck;
                    return bl14;
                }
                if (n == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean bl = editorManager.update(ideAction, context);
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 72) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    if (ideMainWindow.getTimestampMap() == null) {
                        ideAction.setEnabled(false);
                    } else {
                        ideAction.setEnabled(true);
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
            }
            if (n == 23 || n == 24 || n == 25 || n == 53 || n == 26 || n == 27 || n == 28 || n == 29 || n == 32 || n == ExplorerManager.SELECT_IN_STRUCTURE_CMD_ID || n == 56 || n == 57 || n == 16) {
                ideAction.setEnabled(false);
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            boolean bl = false;
            --this._recursiveControllerCheck;
            return bl;
        }
        catch (Throwable throwable) {
            --this._recursiveControllerCheck;
            throw throwable;
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        try {
            ++this._recursiveControllerCheck;
            if (ideAction == null) {
                boolean bl = false;
                --this._recursiveControllerCheck;
                return bl;
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Command command = null;
            int n = ideAction.getCommandId();
            if (n == 5) {
                try {
                    commandProcessor.undo(context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 6) {
                try {
                    commandProcessor.redo(context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            if (n == 0 || n == 2 || n == 3 || n == 8 || n == 11 || n == 12 || n == 14 || n == 13 || n == 47 || n == 21 || n == 34 || n == 48) {
                command = CommandProcessor.createCommand(ideAction.getCommand(), context);
            } else {
                if (n == 73) {
                    NavigationManager navigationManager = NavigationManager.getNavigationManager();
                    if (navigationManager != null) {
                        try {
                            navigationManager.navigateBack();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 74) {
                    NavigationManager navigationManager = NavigationManager.getNavigationManager();
                    if (navigationManager != null) {
                        try {
                            navigationManager.navigateForward();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 75) {
                    NavigationManager navigationManager = NavigationManager.getNavigationManager();
                    if (navigationManager != null) {
                        try {
                            navigationManager.navigateToLastEdit();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 33) {
                    if (InspectorManager.getInspectorManager() != null) {
                        InspectorManager.getInspectorManager().showLastView(context);
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 49) {
                    ExplorerManager.getExplorerManager().showLastView(context);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 9) {
                    command = CommandProcessor.createCommand(ideAction.getCommand(), context);
                    command.setData(ideAction.getValue("UserData"));
                    try {
                        command.doit();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 30 || n == 31) {
                    Controller controller;
                    View view;
                    LogPage logPage;
                    LogWindow logWindow = LogManager.getIdeLogWindow();
                    if (logWindow != null && (logPage = logWindow.getPage()) != null && (view = logPage.getLogPageView()) != null && (controller = view.getController()) != null && controller != this && controller.handleEvent(ideAction, context)) {
                        boolean bl = true;
                        --this._recursiveControllerCheck;
                        return bl;
                    }
                    boolean bl = false;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 4) {
                    Ide.quit(ideAction, context);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 36) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    View view = ideMainWindow.getIdeMainWindowView();
                    Toolbar toolbar = view.getToolbar();
                    view.setToolbarVisible(toolbar.isVisible() ^ true);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 69) {
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    StatusBar statusBar = ideMainWindow.getStatusBar();
                    ideMainWindow.setStatusBarVisible(statusBar.getGUI().isVisible() ^ true);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 77) {
                    this.whenCopyPath(context);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 39) {
                    EditorManager editorManager = EditorManager.getEditorManager();
                    boolean bl = editorManager.handleEvent(ideAction, context);
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 52) {
                    RevertNodeCommand.reload(context);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 57) {
                    NavigatorManager navigatorManager = IdeController.findNavigatorManager();
                    navigatorManager.openNavigator(context);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 72) {
                    try {
                        1 var26_44 = new 1(true);
                        var26_44.run();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
                if (n == 50) {
                    View view;
                    IdeMainWindow ideMainWindow = Ide.getMainWindow();
                    View view2 = view = ideMainWindow != null ? ideMainWindow.getLastActiveView() : null;
                    if (view == null) {
                        boolean bl = true;
                        --this._recursiveControllerCheck;
                        return bl;
                    }
                    ContextMenu contextMenu = view.getContextMenu();
                    if (contextMenu == null) {
                        boolean bl = true;
                        --this._recursiveControllerCheck;
                        return bl;
                    }
                    Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (component == null && (component = view.getGUI()) == null) {
                        boolean bl = true;
                        --this._recursiveControllerCheck;
                        return bl;
                    }
                    int n2 = 0;
                    int n3 = 0;
                    if (component instanceof JTree) {
                        JTree jTree = (JTree)component;
                        int[] nArray = jTree.getSelectionRows();
                        if (nArray != null) {
                            Rectangle rectangle;
                            Container container = jTree.getParent();
                            if (container instanceof JViewport) {
                                JViewport jViewport = (JViewport)container;
                                rectangle = jViewport.getViewRect();
                            } else {
                                rectangle = jTree.getVisibleRect();
                            }
                            int n4 = nArray.length - 1;
                            while (n4 >= 0) {
                                int n5 = nArray[n4];
                                Rectangle rectangle2 = jTree.getRowBounds(n5);
                                if (rectangle.contains(rectangle2.x, rectangle2.y)) {
                                    n2 = rectangle2.x + rectangle2.height;
                                    n3 = rectangle2.y + rectangle2.height;
                                    break;
                                }
                                --n4;
                            }
                        }
                    } else if (component instanceof JFastTreeTable) {
                        JFastTreeTable jFastTreeTable = (JFastTreeTable)component;
                        int[] nArray = jFastTreeTable.getSelectedRows();
                        if (nArray != null) {
                            Rectangle rectangle;
                            int n6 = jFastTreeTable.getSelectedColumn();
                            Container container = jFastTreeTable.getParent();
                            if (container instanceof JViewport) {
                                JViewport jViewport = (JViewport)container;
                                rectangle = jViewport.getViewRect();
                            } else {
                                rectangle = jFastTreeTable.getVisibleRect();
                            }
                            int n7 = nArray.length - 1;
                            while (n7 >= 0) {
                                int n8 = nArray[n7];
                                Rectangle rectangle3 = jFastTreeTable.getCellRect(n8, n6, true);
                                if (rectangle.contains(rectangle3.x, rectangle3.y)) {
                                    n2 = rectangle3.x;
                                    n3 = rectangle3.y + rectangle3.height;
                                    break;
                                }
                                --n7;
                            }
                        }
                    } else {
                        Container container = component.getParent();
                        if (component.getParent() instanceof JViewport) {
                            JViewport jViewport = (JViewport)container;
                            Point point = jViewport.getViewPosition();
                            n2 += point.x;
                            n3 += point.y;
                        } else {
                            n2 += component.getX();
                            n3 += component.getY();
                        }
                    }
                    n2 = Math.max(n2, 0);
                    n3 = Math.max(n3, 0);
                    MouseEvent mouseEvent = new MouseEvent(component, 502, System.currentTimeMillis(), 0, n2, n3, 1, true);
                    Context context2 = view.getContext(mouseEvent);
                    context2.setEvent(mouseEvent);
                    contextMenu.show(context2);
                    boolean bl = true;
                    --this._recursiveControllerCheck;
                    return bl;
                }
            }
            if (command != null) {
                try {
                    commandProcessor.invoke(command);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                boolean bl = true;
                --this._recursiveControllerCheck;
                return bl;
            }
            boolean bl = false;
            --this._recursiveControllerCheck;
            return bl;
        }
        catch (Throwable throwable) {
            --this._recursiveControllerCheck;
            throw throwable;
        }
    }

    static void reloadNodes(Map map, boolean bl, boolean bl2) {
        NodeUtil.reloadBuffers(map, bl, bl2);
    }

    private boolean updateCloseNode(Context context, IdeAction ideAction) {
        if (context != null) {
            boolean bl = false;
            Node node = context.getNode();
            if (node == null) {
                Element element = context.getElement();
                if (element != null) {
                    if (element.mayHaveChildren()) {
                        ideAction.putValue("Name", IdeArb.format(277, IdeArb.getString(284)));
                    } else {
                        ideAction.putValue("Name", IdeArb.format(277, IdeArb.getString(283)));
                    }
                    if (element.getAttributes().isSet(ElementAttributes.CLOSEABLE) && element instanceof Node && ((Node)element).isOpen()) {
                        bl = true;
                    }
                }
            } else if (node.getAttributes().isSet(ElementAttributes.CLOSEABLE) && node.isOpen()) {
                bl = true;
            }
            ideAction.setEnabled(bl);
        }
        return true;
    }

    private static boolean isLocatableInNavigator(Context context) {
        if (context != null) {
            Node node;
            if (context.getView() instanceof NavigatorWindow) {
                return false;
            }
            NavigatorManager navigatorManager = IdeController.findNavigatorManager();
            if (navigatorManager != null && (node = context.getNode()) != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean canSave(Context context) {
        boolean bl = false;
        if (context != null) {
            if (IdeController.canSave(context.getElement())) {
                bl = true;
            } else if (IdeController.canSave(context.getNode())) {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean canSave(Element element) {
        Node node;
        boolean bl = false;
        if (element != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (node = (Node)element).isDirty()) {
            bl = true;
        }
        return bl;
    }

    private static boolean canSaveAs(Context context) {
        boolean bl = false;
        if (context != null) {
            Element[] elementArray;
            Element element;
            Node node = context.getNode();
            if (node != null && node.getAttributes().isSet(ElementAttributes.EDITOR_SAVEABLE_AS)) {
                bl = true;
            }
            if (!bl && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (elementArray = context.getSelection()) != null && elementArray.length == 1 && element.getAttributes().isSet(ElementAttributes.SAVEABLE_AS)) {
                bl = true;
            }
        }
        return bl;
    }

    private static boolean canRename(Context context) {
        Element[] elementArray;
        Element element;
        boolean bl = false;
        if (context != null && (element = context.getElement()) != null && element.getAttributes().isSet(ElementAttributes.SAVEABLE) && (elementArray = context.getSelection()) != null && elementArray.length == 1 && element.getAttributes().isSet(ElementAttributes.RENAMEABLE)) {
            bl = true;
        }
        return bl;
    }

    private static boolean isRevertable(Context context) {
        Attributes attributes;
        Node node;
        boolean bl = false;
        if (context != null && (node = context.getNode()) != null && !(attributes = node.getAttributes()).isSet(ElementAttributes.NON_RELOADABLE) && node.isDirty() && !node.isNew()) {
            bl = true;
        }
        return bl;
    }

    private static NavigatorManager findNavigatorManager() {
        NavigatorWindow navigatorWindow = Ide.getLastActiveNavigator();
        if (navigatorWindow != null) {
            return navigatorWindow.getManager();
        }
        return NavigatorManager.getWorkspaceNavigatorManager();
    }

    private boolean canCopyPath(Context context) {
        boolean bl = false;
        if (context != null) {
            Node node = context.getNode();
            if (node != null) {
                bl = true;
            } else {
                Element[] elementArray = context.getSelection();
                if (elementArray.length > 0) {
                    bl = true;
                    int n = 0;
                    while (bl && n < elementArray.length) {
                        Element element = elementArray[n];
                        bl = element instanceof Locatable || element instanceof RelativeDirectoryContextFolder;
                        ++n;
                    }
                }
            }
        }
        return bl;
    }

    private void whenCopyPath(Context context) {
        String string;
        Node node = context.getNode();
        if (node != null) {
            URL uRL = node.getURL();
            string = URLFileSystem.getPlatformPathName(uRL);
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            Element[] elementArray = context.getSelection();
            if (elementArray.length > 0) {
                int n = 0;
                while (n < elementArray.length) {
                    Element element = elementArray[n];
                    if (element instanceof Locatable) {
                        Locatable locatable = (Locatable)((Object)element);
                        URL uRL = locatable.getURL();
                        String string2 = URLFileSystem.getPlatformPathName(uRL);
                        stringBuffer.append(string2);
                        stringBuffer.append('\n');
                    } else if (element instanceof RelativeDirectoryContextFolder) {
                        RelativeDirectoryContextFolder relativeDirectoryContextFolder = (RelativeDirectoryContextFolder)element;
                        URLPath uRLPath = relativeDirectoryContextFolder.getRootDirectories();
                        String string3 = relativeDirectoryContextFolder.getRelativePath();
                        Iterator iterator = uRLPath.iterator();
                        while (iterator.hasNext()) {
                            URL uRL = (URL)iterator.next();
                            URL uRL2 = URLFactory.newDirURL(uRL, string3);
                            String string4 = URLFileSystem.getPlatformPathName(uRL2);
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(File.pathSeparatorChar);
                            }
                            stringBuffer.append(string4);
                        }
                    }
                    ++n;
                }
            }
            string = stringBuffer.toString();
        }
        StringSelection stringSelection = new StringSelection(string);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, null);
    }

    final class 1
    extends SwingClosure {
        protected void runImpl() throws Exception {
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            IdeController.reloadNodes(ideMainWindow.getTimestampMap(), false, true);
        }

        public 1(boolean bl) {
            super(bl);
        }
    }
}

