/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ComponentVersionManager;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeController;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMacros;
import oracle.ide.IdeMainWindow;
import oracle.ide.Version;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.DTCache;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.PlatformProperties;
import oracle.ide.config.SplashScreenOptions;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.SplashScreen;
import oracle.ide.controls.WaitCursor;
import oracle.ide.help.AboutBoxFactory;
import oracle.ide.help.AboutBoxModel;
import oracle.ide.keyboard.DialogWatcher;
import oracle.ide.keyboard.GrabbableFocusManager;
import oracle.ide.keyboard.KeyStroke2String;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogManager;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.MigrationManager;
import oracle.ide.model.IdeSystem;
import oracle.ide.model.MiscellaneousFolder;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Preferences;
import oracle.ide.model.Reference;
import oracle.ide.model.Workspaces;
import oracle.ide.net.IdeURLStreamHandlerFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.ide.nulls.NullSecurityManager;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.CollectionEvent;
import oracle.ide.util.CollectionListener;
import oracle.ide.util.Encodings;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ideri.util.Product;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessageDialogPersistence;
import oracle.javatools.jndi.Names;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.PlatformUtils;
import oracle.javatools.util.SwingUtils;

public class IdeCore {
    private static final String INSTALL_PATH = "Ide.InstallPath";
    private final IdeArgs ideArgs;
    private final IdeController _controller;
    private final boolean _createUI;
    private final HashMap cmdTable;
    private final HashMap cmdHash;
    private WaitCursor waitCursor;
    private ActionMap anyActionMap;
    private String oracleHome;
    private String ideHome;
    private String userHome;
    private String trueUserHome;
    private String binDir;
    private String systemDirectory;
    private String productVersion;
    private IdeSettings settings;
    private DTCache dtCache;
    private KeyStrokeContextRegistry keyStrokeContextRegistry;
    private IdeProperties idePropertiesInstance;
    private IdeSystem ideSystem;
    private Preferences preferences;
    private Workspaces workspaces;
    private MiscellaneousFolder miscellaneousFolder;
    private ComponentVersionManager versionMgr;
    private Map _macros;
    private ArrayList _ideListeners;
    private boolean _quitting;
    private boolean _starting;
    private static int nextUniqueCmd = 79;
    private String startupCaption;
    private Image startupImage;
    protected String productID;

    void $init$() {
        this.cmdTable = new HashMap();
        this.cmdHash = new HashMap();
        this.versionMgr = new ComponentVersionManager();
        this.startupCaption = Version.NAME;
        this.productID = "oracle.ide";
    }

    protected IdeCore(IdeArgs ideArgs) {
        this.$init$();
        this.ideArgs = ideArgs;
        this._createUI = ideArgs.getCreateUI();
        this._controller = new IdeController();
    }

    protected String getSplashScreenFilename() {
        String string = System.getProperty("ide.splash.screen");
        return string != null ? string : "splash.gif";
    }

    protected SecurityManager getSecurityManager() {
        return new 7();
    }

    protected AddinManager getAddinManager() {
        return null;
    }

    protected Addin[] createCoreModules() {
        return null;
    }

    protected void initializeLookAndFeel() {
        this.initializePlatformLookAndFeel();
    }

    private void initializePlatformLookAndFeel() {
        try {
            if (PlatformUtils.isMac() || PlatformUtils.isWindows()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    IdeArgs getIdeArgs() {
        return this.ideArgs;
    }

    Controller getController() {
        return this._controller;
    }

    protected String getProductID() {
        return this.productID;
    }

    String getProductVersion() {
        return this.productVersion;
    }

    String getBinDirectory() {
        return this.binDir;
    }

    String getHomeDirectory() {
        return this.ideHome;
    }

    String getOracleHomeDirectory() {
        if (this.oracleHome == null) {
            File file = new File(this.getHomeDirectory());
            this.oracleHome = file.getParent();
            if (!this.oracleHome.endsWith(File.pathSeparator)) {
                this.oracleHome = this.oracleHome + File.separator;
            }
        }
        return this.oracleHome;
    }

    String getLibDirectory() {
        return this.getHomeDirectory() + "lib" + File.separator;
    }

    String getUserHomeDirectory() {
        return this.userHome;
    }

    String getTrueUserHomeDirectory() {
        return this.trueUserHome;
    }

    String getSystemDirectory() {
        return this.systemDirectory;
    }

    String getWorkDirectory() {
        Workspaces workspaces = this.getWorkspaces();
        if (workspaces != null) {
            URL uRL = this.getWorkspaces().getWorkDirectory();
            return URLFileSystem.getPlatformPathName(uRL) + File.separator;
        }
        return this.getHomeDirectory() + "mywork" + File.separator;
    }

    String getProgramName() {
        return IdeUtil.getProgramName();
    }

    String getProgramShortName() {
        return IdeUtil.getProgramShortName();
    }

    IdeProperties getIdeProperties() {
        return this.idePropertiesInstance;
    }

    String getProperty(String string, String string2) {
        IdeProperties ideProperties = this.getIdeProperties();
        return ideProperties != null ? ideProperties.getProperty(string, string2) : null;
    }

    String setProperty(String string, String string2) {
        IdeProperties ideProperties = this.getIdeProperties();
        return (String)(ideProperties != null ? ideProperties.setProperty(string, string2) : null);
    }

    IdeMainWindow getMainWindow() {
        return (IdeMainWindow)MainWindow.getMainWindow((javax.naming.Context)Names.newInitialContext(), (int)1);
    }

    WaitCursor getWaitCursor() {
        if (this.waitCursor == null) {
            this.waitCursor = new WaitCursor();
            this.waitCursor.attach((RootPaneContainer)((Object)this.getMainWindow()));
        }
        return this.waitCursor;
    }

    ComponentVersionManager getVersionInfo() {
        return this.versionMgr;
    }

    IdeSettings getSettings() {
        return this.loadIdeSettings();
    }

    KeyStrokeContextRegistry getKeyStrokeContextRegistry() {
        if (this.keyStrokeContextRegistry == null) {
            this.keyStrokeContextRegistry = new KeyStrokeContextRegistry();
            this.keyStrokeContextRegistry.addListener(new 6());
        }
        return this.keyStrokeContextRegistry;
    }

    EnvironOptions getEnvironOptions() {
        return (EnvironOptions)this.getSettings().getData("environment-options");
    }

    DTCache getDTCache() {
        if (this.dtCache == null) {
            this.dtCache = new DTCache();
            this.dtCache.load();
        }
        return this.dtCache;
    }

    IdeSystem getSystem() {
        if (this.ideSystem == null) {
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            URL uRL = extensionRegistry.getSystemDirectory(this.getProductID());
            uRL = URLFactory.newURL(uRL, "System.sys");
            this.ideSystem = new IdeSystem(uRL);
        }
        return this.ideSystem;
    }

    Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.getSystem().getPreferences();
            if (this.preferences == null) {
                this.preferences = (Preferences)this.getSystem().getChild(Preferences.class);
                if (this.preferences == null) {
                    this.preferences = new Preferences();
                }
                this.getSystem().remove(this.preferences);
                this.getSystem().setPreferences(this.preferences);
            }
        }
        return this.preferences;
    }

    Workspaces getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = (Workspaces)this.getSystem().getChild(Workspaces.class);
        }
        return this.workspaces;
    }

    MiscellaneousFolder getMiscellaneousFolder() {
        if (this.miscellaneousFolder == null) {
            this.miscellaneousFolder = (MiscellaneousFolder)this.getSystem().getChild(MiscellaneousFolder.class);
            if (this.miscellaneousFolder == null) {
                File file = new File(this.getSystemDirectory(), "MiscellaneousFiles.misc");
                URL uRL = URLFactory.newFileURL(file);
                try {
                    this.miscellaneousFolder = (MiscellaneousFolder)NodeFactory.findOrCreate(MiscellaneousFolder.class, uRL);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return this.miscellaneousFolder;
    }

    void addIdeListener(IdeListener ideListener) {
        if (this._ideListeners == null) {
            this._ideListeners = new ArrayList(2);
        }
        this._ideListeners.add(ideListener);
    }

    void removeIdeListener(IdeListener ideListener) {
        if (this._ideListeners != null) {
            this._ideListeners.remove(ideListener);
        }
    }

    InputMap getIdeInputMap() {
        return this.getMainWindow().getInputMap();
    }

    ActionMap getIdeActionMap() {
        IdeMainWindow ideMainWindow = this.getMainWindow();
        if (ideMainWindow == null) {
            if (this.anyActionMap == null) {
                this.anyActionMap = new ActionMap();
            }
            return this.anyActionMap;
        }
        return ideMainWindow.getActionMap();
    }

    boolean isQuitting() {
        return this._quitting;
    }

    boolean isStarting() {
        return this._starting;
    }

    int createCmdID(String string) {
        return this.createCmdID(-1, string);
    }

    private int createCmdID(int n, String string) {
        if (n == -1) {
            n = ++nextUniqueCmd;
        }
        Integer n2 = new Integer(n);
        this.cmdTable.put(n2, string);
        this.cmdHash.put(string, n2);
        return n;
    }

    int findOrCreateCmdID(String string) {
        return this.findOrCreateCmdID(-1, string);
    }

    private int findOrCreateCmdID(int n, String string) {
        Integer n2 = this.findCmdID(string);
        if (n2 != null) {
            return n2;
        }
        return this.createCmdID(n, string);
    }

    Integer findCmdID(String string) {
        return (Integer)this.cmdHash.get(string);
    }

    String findCmdName(int n) {
        return (String)this.cmdTable.get(new Integer(n));
    }

    Map getMacros() {
        if (this._macros == null) {
            String string = this.getHomeDirectory();
            String string2 = this.getSystemDirectory();
            String string3 = this.getUserHomeDirectory();
            String string4 = this.getWorkDirectory();
            this._macros = new IdeMacros(string, string2, string3, string4).getMap();
        }
        return this._macros;
    }

    int quit(IdeAction ideAction, Context context) {
        if (this._quitting) {
            return 1;
        }
        this._quitting = true;
        Command command = CommandProcessor.createCommand(ideAction.getCommand(), context);
        command.setData(this.getMainWindow().getIdeMainWindowView());
        int n = 1;
        try {
            try {
                n = CommandProcessor.getInstance().invoke(command);
            }
            catch (Exception exception) {
                n = 1;
            }
        }
        finally {
            if (n == 1) {
                this._quitting = false;
            }
        }
        return n;
    }

    void preTerminate() {
        Layouts layouts;
        this.fireIdeEvent(3);
        if (LogManager.getLogManager() != null) {
            LogManager.getLogManager().shutdown();
        }
        if ((layouts = Layouts.getLayouts()) != null) {
            layouts.activateLayout(null, false);
        }
    }

    void terminate() {
        SaveAllCommand.saveSystemFiles();
        VirtualFileSystemHelper.shutdownVFS();
    }

    void fireIdeEvent(int n) {
        if (this._ideListeners != null) {
            SwingUtilities.invokeLater(new 5(this, n));
        }
    }

    private void fireIdeEvent(IdeListener ideListener, IdeEvent ideEvent) {
        switch (ideEvent.getID()) {
            case 1: {
                try {
                    ideListener.addinsLoaded(ideEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 2: {
                try {
                    ideListener.mainWindowOpened(ideEvent);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 3: {
                try {
                    ideListener.mainWindowClosing(ideEvent);
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    String getInstallDirectory(File file) {
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                Properties properties = new Properties();
                File file2 = new File(file, "ide.properties");
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                properties.load(bufferedInputStream);
                String string = properties.getProperty(INSTALL_PATH, null);
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    void startupImpl(IdeArgs ideArgs) {
        if (this._starting) {
            throw new IllegalStateException("IDE is already started");
        }
        Window window = null;
        try {
            String string;
            this._starting = true;
            if (Version.DEBUG_BUILD != 0 && !Boolean.valueOf(System.getProperty("ide.noassert")).booleanValue()) {
                Thread.currentThread().getContextClassLoader().setPackageAssertionStatus("oracle", true);
            }
            URL.setURLStreamHandlerFactory(IdeURLStreamHandlerFactory.getInstance());
            ToStringManager.registerCustomConverter(KeyStroke2String.class);
            Object2Dom.exemptTypeFromIdref(Reference.class);
            Object2Dom.exemptTypeFromIdref(KeyStroke.class);
            this.binDir = IdeCore.canonicalize(System.getProperty("user.dir", "."));
            if (!this.binDir.endsWith(File.separator)) {
                this.binDir = this.binDir + File.separator;
            }
            this.ideHome = IdeCore.canonicalize(System.getProperty("ide.home", null));
            if (!ModelUtil.hasLength((String)this.ideHome)) {
                File file = new File(this.binDir);
                this.ideHome = file.getParent();
            }
            if (!this.ideHome.endsWith(File.separator)) {
                this.ideHome = this.ideHome + File.separator;
            }
            this.userHome = IdeCore.canonicalize(System.getProperty("ide.user.dir", null));
            if (!ModelUtil.hasLength((String)this.userHome)) {
                this.userHome = this.ideHome;
            } else if (!this.userHome.endsWith(File.separator)) {
                this.userHome = this.userHome + File.separator;
            }
            this.trueUserHome = IdeCore.canonicalize(System.getProperty("user.home", null));
            if (!ModelUtil.hasLength((String)this.trueUserHome)) {
                this.trueUserHome = this.userHome;
            } else if (!this.trueUserHome.endsWith(File.separator)) {
                this.trueUserHome = this.trueUserHome + File.separator;
            }
            this.productVersion = System.getProperty("product.version", null);
            if (!ModelUtil.hasLength((String)this.productVersion)) {
                this.productVersion = Version.VER + "." + Version.BUILD_NUM;
            }
            this.systemDirectory = this.userHome + "system" + File.separator;
            VirtualFileSystemHelper.enableVFS();
            if (this._createUI && (string = this.getSplashScreenFilename()) != null && SplashScreenOptions.getShowSplashScreen()) {
                int n = SplashScreenOptions.getSplashScreenCounter();
                if (n != -1) {
                    SplashScreen.create((String)(this.binDir + string), (int)n);
                } else {
                    SplashScreen.create((String)(this.binDir + string));
                }
            }
            this.createCmdID(0, "Ide.NEW_WORKSPACE_CMD_ID");
            this.createCmdID(67, "Ide.NEW_VIEW_CMD_ID");
            this.createCmdID(68, "Ide.FREEZE_CMD_ID");
            this.createCmdID(70, "ACTIVATE_LEFT_BUTTON_CMD_ID");
            this.createCmdID(71, "ACTIVATE_RIGHT_BUTTON_CMD_ID");
            this.createCmdID(2, "Ide.NEW_PROJECT_CMD_ID");
            this.createCmdID(3, "Ide.NEW_EMPTY_PROJECT_CMD_ID");
            this.createCmdID(4, "Ide.EXIT_CMD_ID");
            this.createCmdID(5, "Ide.UNDO_CMD_ID");
            this.createCmdID(6, "Ide.REDO_CMD_ID");
            this.createCmdID(65, "Ide.SYSTEM_CMD_ID");
            this.createCmdID(64, "Ide.APPLICATIONS_CMD_ID");
            this.createCmdID(66, "Ide.CONNECTIONS_CMD_ID");
            this.createCmdID(8, "Ide.NEW_CLASS_CMD_ID");
            this.createCmdID(9, "Ide.OPEN_CMD_ID");
            this.createCmdID(10, "Ide.REOPEN_CMD_ID");
            this.createCmdID(11, "Ide.SAVE_CMD_ID");
            this.createCmdID(12, "Ide.SAVE_AS_CMD_ID");
            this.createCmdID(13, "Ide.SAVE_ALL_CMD_ID");
            this.createCmdID(52, "Ide.REVERT_CMD_ID");
            this.createCmdID(14, "Ide.RENAME_CMD_ID");
            this.createCmdID(15, "Ide.PRINTER_SETUP_CMD_ID");
            this.createCmdID(16, "Ide.PRINT_CMD_ID");
            this.createCmdID(17, "Ide.CUT_CMD_ID");
            this.createCmdID(18, "Ide.COPY_CMD_ID");
            this.createCmdID(77, "Ide.COPY_PATH_CMD_ID");
            this.createCmdID(19, "Ide.PASTE_CMD_ID");
            this.createCmdID(78, "Ide.EXTENDED_PASTE_CMD_ID");
            this.createCmdID(20, "Ide.DELETE_CMD_ID");
            this.createCmdID(48, "Ide.CLOSE_NODE_CMD_ID");
            this.createCmdID(51, "Ide.REFRESH_CMD_ID");
            this.createCmdID(21, "Ide.REMOVE_FILE_CMD_ID");
            this.createCmdID(47, "Ide.REMOVE_FROM_DISK_CMD_ID");
            this.createCmdID(22, "Ide.SELECT_ALL_CMD_ID");
            this.createCmdID(23, "Ide.FIND_CMD_ID");
            this.createCmdID(24, "Ide.REPLACE_CMD_ID");
            this.createCmdID(25, "Ide.SEARCH_AGAIN_CMD_ID");
            this.createCmdID(53, "Ide.SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(26, "Ide.INCREMENTAL_SEARCH_FORWARD_CMD_ID");
            this.createCmdID(27, "Ide.INCREMENTAL_SEARCH_BACKWARD_CMD_ID");
            this.createCmdID(28, "Ide.SEARCH_SOURCE_PATH_CMD_ID");
            this.createCmdID(29, "Ide.GOTO_LINE_NUMBER_CMD_ID");
            this.createCmdID(30, "Ide.NEXTMSG_CMD_ID");
            this.createCmdID(31, "Ide.PREVMSG_CMD_ID");
            this.createCmdID(32, "Ide.BROWSE_SYMBOL_CMD_ID");
            this.createCmdID(33, "Ide.INSPECTOR_CMD_ID");
            this.createCmdID(34, "Ide.LOG_WINDOW_CMD_ID");
            this.createCmdID(35, "Ide.PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(36, "Ide.TOOLBAR_CMD_ID");
            this.createCmdID(69, "Ide.STATUS_BAR_CMD_ID");
            this.createCmdID(37, "Ide.DEFAULT_PROJECT_SETTINGS_CMD_ID");
            this.createCmdID(38, "Ide.IDE_SETTINGS_CMD_ID");
            this.createCmdID(39, "Ide.CLOSE_ALL_CMD_ID");
            this.createCmdID(44, "Ide.STRUCTURE_CHANGE_CMD_ID");
            this.createCmdID(45, "Ide.PROPERTY_SET_CMD_ID");
            this.createCmdID(49, "Ide.EXPLORER_CMD_ID");
            this.createCmdID(40, "Ide.NEXT_EDITOR_CMD_ID");
            this.createCmdID(41, "Ide.PREV_EDITOR_CMD_ID");
            this.createCmdID(42, "Ide.NEXT_EDITORFRAME_CMD_ID");
            this.createCmdID(43, "Ide.PREV_EDITORFRAME_CMD_ID");
            this.createCmdID(50, "Ide.CONTEXT_MENU_CMD_ID");
            this.createCmdID(54, "Ide.EXPAND_ALL_CMD_ID");
            this.createCmdID(55, "Ide.COLLAPSE_ALL_CMD_ID");
            this.createCmdID(56, "Ide.PROPERTIES_CMD_ID");
            this.createCmdID(57, "Ide.NAVIGATE_CMD_ID");
            this.createCmdID(58, "Ide.WINDOW_TILE_HORZ_CMD_ID");
            this.createCmdID(59, "Ide.WINDOW_TILE_VERT_CMD_ID");
            this.createCmdID(60, "Ide.WINDOW_CASCADE_CMD_ID");
            this.createCmdID(61, "Ide.WINDOWS_DOT_DOT_DOT_CMD_ID");
            this.createCmdID(73, "Ide.BACK_CMD_ID");
            this.createCmdID(74, "Ide.FORWARD_CMD_ID");
            this.createCmdID(75, "Ide.LAST_EDIT_CMD_ID");
            this.createCmdID(76, "Ide.REPLACE_SOURCE_PATH_CMD_ID");
            this.createCmdID(79, "Ide.ABOUT_CMD_ID");
            String string2 = System.getProperty("ide.encodings.file");
            File file = new File(this.binDir, string2 != null ? string2 : "encodings.xml");
            Encodings.setEncodingsFile(file);
            System.setProperty("java.naming.factory.initial", "oracle.javatools.jndi.LocalInitialContextFactory");
            if (this._createUI) {
                this.initializePlatformLookAndFeel();
            }
            PlatformProperties.setForceLoad(ideArgs.getPlatformFileName());
            this.getAddinManager();
            PerformanceLogger.get().startTiming("init_extensionRegistry", "Initializing extensions...");
            ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
            PerformanceLogger.get().stopTiming("init_extensionRegistry", "Initialized extensions");
            PerformanceLogger.get().startTiming("init_branding", "Branding...");
            String string3 = Product.getProductID();
            if (string3 != null && extensionRegistry.findExtension(string3) == null) {
                System.err.println("Product extension " + string3 + " does not exist!");
                System.exit(1);
            }
            if (this._createUI) {
                window = new StartupWindow(this.startupCaption, this.startupImage);
                IdeUtil.setStartupWindow((JFrame)window);
                this.installAboutBox();
            }
            PerformanceLogger.get().stopTiming("init_branding", "Branded");
            SplashScreen.log((String)IdeArb.getString(12));
            this.verifyUserHome();
            this.copyExtensionUserData();
            MigrationManager migrationManager = MigrationManager.getMigrationManager();
            if (migrationManager != null) {
                migrationManager.migrate();
            }
            SplashScreen.log((String)IdeArb.getString(13));
            this.loadIdeSettings();
            SplashScreen.log((String)IdeArb.getString(14));
            this.loadIdeProperties();
            MessageDialog.setPersistence((MessageDialogPersistence)new 4());
            SplashScreen.log((String)IdeArb.getString(11));
            this.verifyJdkVersion();
            SecurityManager securityManager = this.getSecurityManager();
            if (securityManager != null) {
                System.setSecurityManager(securityManager);
            }
            SplashScreen.log((String)IdeArb.getString(18));
            this.getPreferences();
            if (this._createUI) {
                this.initializeLookAndFeel();
            }
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.initializeCoreModules", "Initializing core modules...");
            SplashScreen.log((String)IdeArb.getString(16));
            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.createCoreModules");
            Addin[] addinArray = this.createCoreModules();
            if (this._createUI) {
                IdeUtil.setMainWindow((JFrame)((Object)this.getMainWindow()));
            }
            this.brandMainWindow();
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.createCoreModules", "Created core modules");
            SplashScreen.log((String)IdeArb.getString(19));
            IdeCore.initializeModules(addinArray);
            PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.initializeCoreModules", "Initialized core modules");
            this.initProductAndUserAddins();
            VirtualFileSystemHelper.enableNativeWatching();
            EnvironOptions environOptions = this.getEnvironOptions();
            boolean bl = environOptions.getVerifyVFSData();
            VirtualFileSystemHelper.setVerifyPersistedData(bl);
            if (migrationManager != null) {
                migrationManager.finishMigration();
            }
            if (this._createUI) {
                FileOpenHistory.getInstance();
                GrabbableFocusManager.install();
                DialogWatcher.install();
                this.getMainWindow().postInitialize(ideArgs);
                this.fireIdeEvent(2);
            }
            this.startupCaption = this.getProductNameFromBranding();
            SwingUtils.setProgramName((String)this.startupCaption);
            String string4 = this.getProductShortNameFromBranding();
            SwingUtils.setProgramShortName((String)string4);
        }
        finally {
            this._starting = false;
            if (window != null) {
                IdeUtil.setStartupWindow(null);
                window.setVisible(false);
                window.dispose();
                window = null;
            }
        }
    }

    private static String canonicalize(String string) {
        if (string == null || string.trim().length() == 0) {
            return string;
        }
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.toString();
    }

    private void verifyUserHome() {
        File file = new File(this.userHome + File.separator).getAbsoluteFile();
        file.mkdirs();
        if (!file.isDirectory() || !file.canWrite()) {
            String string = IdeArb.format(234, file.getAbsolutePath());
            String string2 = this.startupCaption;
            MessageDialog.error((Component)SwingUtils.getToplevelWindow(), (Object)string, (String)string2, null);
            System.exit(1);
        }
    }

    private synchronized IdeSettings loadIdeSettings() {
        if (this.settings == null) {
            this.settings = new IdeSettings();
            this.settings.register();
            this.settings.load();
            this.settings.init();
            EnvironOptions environOptions = this.getEnvironOptions();
            IdeUtil.setIdeEncoding(environOptions.getEncoding());
            environOptions.addChangeListener(new 3());
            KeyStrokeOptions keyStrokeOptions = this.settings.getKeyStrokeOptions();
            keyStrokeOptions.setKeyboardPanelEventDispatcher(new 2());
        }
        return this.settings;
    }

    private void loadIdeProperties() {
        if (this.idePropertiesInstance == null) {
            this.idePropertiesInstance = new IdeProperties();
            this.idePropertiesInstance.ensureOpen();
            this.idePropertiesInstance.setProperty(INSTALL_PATH, this.binDir);
        }
    }

    private void verifyJdkVersion() {
        String string = this.getProperty("showBadJdkWarning", Boolean.TRUE.toString());
        String string2 = this.getProperty("launched.from.jdev", Boolean.TRUE.toString());
        if (Boolean.valueOf(string).booleanValue() && !Boolean.valueOf(string2).booleanValue()) {
            String string3 = PlatformUtils.isMac() ? "1.4.2" : "1.5.0";
            String string4 = string3.replace('_', '.');
            String string5 = System.getProperty("java.version", string3);
            String string6 = string5.replace('_', '.');
            if (!string6.startsWith(string4)) {
                String string7 = IdeArb.format(340, string3, string5);
                if (this._createUI) {
                    new 1(this, string7).doit();
                } else {
                    System.err.println("Warning: " + string7);
                }
            }
        }
    }

    private static void initializeModules(Addin[] addinArray) {
        if (addinArray != null) {
            int n = addinArray.length;
            int n2 = 0;
            while (n2 < n) {
                Addin addin = addinArray[n2];
                if (addin != null) {
                    try {
                        try {
                            PerformanceLogger.get().startTiming("oracle.ide.IdeCore.module." + addin.getClass().getName());
                            addin.initialize();
                        }
                        catch (ThreadDeath threadDeath) {
                            throw threadDeath;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                    }
                    finally {
                        PerformanceLogger.get().stopTiming("oracle.ide.IdeCore.module." + addin.getClass().getName(), addin.getClass().getName());
                    }
                }
                ++n2;
            }
        }
    }

    protected void initProductAndUserAddins() {
        AddinManager.getAddinManager().initProductAndUserAddins();
        this.fireIdeEvent(1);
    }

    protected void copyExtensionUserData() {
    }

    private final void installAboutBox() {
        AboutBoxModel aboutBoxModel = new AboutBoxModel();
        aboutBoxModel.setProductName(Ide.getProgramName());
        AboutBoxFactory aboutBoxFactory = new AboutBoxFactory();
        aboutBoxFactory.setModel(aboutBoxModel);
        this.installAboutBox(aboutBoxFactory);
        AboutBoxFactory.setAboutBoxFactory(aboutBoxFactory);
        this.initAboutBoxModel();
    }

    protected void installAboutBox(AboutBoxFactory aboutBoxFactory) {
    }

    protected String getProductNameFromBranding() {
        return "";
    }

    protected String getProductShortNameFromBranding() {
        return "";
    }

    protected void initAboutBoxModel() {
    }

    protected void brandMainWindow() {
    }

    static ArrayList ra$_ideListeners(IdeCore ideCore) {
        return ideCore._ideListeners;
    }

    static void mav$fireIdeEvent(IdeCore ideCore, IdeListener ideListener, IdeEvent ideEvent) {
        ideCore.fireIdeEvent(ideListener, ideEvent);
    }

    static String ra$startupCaption(IdeCore ideCore) {
        return ideCore.startupCaption;
    }

    public final class 7
    extends NullSecurityManager {
        public void checkExit(int n) {
            if (Beans.isDesignTime()) {
                throw new SecurityException();
            }
        }

        public ThreadGroup getThreadGroup() {
            return super.getThreadGroup();
        }
    }

    public final class 6
    implements CollectionListener {
        public void elementAdded(CollectionEvent collectionEvent) {
            KeyStrokeOptions keyStrokeOptions = IdeCore.this.getSettings().getKeyStrokeOptions();
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)collectionEvent.getElement();
            keyStrokeOptions.addContext(keyStrokeContext);
        }

        public void elementRemoved(CollectionEvent collectionEvent) {
            KeyStrokeOptions keyStrokeOptions = IdeCore.this.getSettings().getKeyStrokeOptions();
            KeyStrokeContext keyStrokeContext = (KeyStrokeContext)collectionEvent.getElement();
            keyStrokeOptions.removeContext(keyStrokeContext);
        }
    }

    public final class 5
    implements Runnable {
        private final /* synthetic */ int v$nEventID;
        final /* synthetic */ IdeCore this$0;

        public void run() {
            int n = IdeCore.ra$_ideListeners(this.this$0).size();
            if (n > 0) {
                IdeEvent ideEvent = new IdeEvent(this.v$nEventID);
                IdeListener[] ideListenerArray = IdeCore.ra$_ideListeners(this.this$0).toArray(new IdeListener[n]);
                int n2 = 0;
                while (n2 < n) {
                    IdeCore.mav$fireIdeEvent(this.this$0, ideListenerArray[n2], ideEvent);
                    ++n2;
                }
            }
        }

        public 5(IdeCore ideCore, int n) {
            this.v$nEventID = n;
            this.this$0 = ideCore;
        }
    }

    public final class 4
    extends MessageDialogPersistence {
        protected File getUserDirectory() {
            return new File(URLFileSystem.getPlatformPathName(ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide")));
        }
    }

    public final class 3
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            IdeUtil.setIdeEncoding(IdeCore.this.getEnvironOptions().getEncoding());
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            IdeCore.this.fireIdeEvent(4);
        }
    }

    public final class 1 {
        private final /* synthetic */ String v$msg;
        final /* synthetic */ IdeCore this$0;

        public void doit() {
            String string = IdeCore.ra$startupCaption(this.this$0);
            boolean bl = MessageDialog.optionalConfirm((String)"oracle.ide.badJdkWarning", (Component)SwingUtils.getToplevelWindow(), (String)this.v$msg, (String)string, null);
            if (!bl) {
                System.exit(1);
            }
        }

        public 1(IdeCore ideCore, String string) {
            this.v$msg = string;
            this.this$0 = ideCore;
        }
    }

    private static final class StartupWindow
    extends JFrame
    implements AWTEventListener {
        private int openChildren;

        void $init$() {
            this.openChildren = 0;
        }

        StartupWindow(String string, Image image) {
            super(string);
            this.$init$();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            toolkit.addAWTEventListener(this, 64);
            this.setIconImage(image);
            this.setUndecorated(true);
            this.setBounds(dimension.width / 2, dimension.height / 2, 0, 0);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
        }

        public void dispose() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.dispose();
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            block0 : switch (aWTEvent.getID()) {
                case 200: {
                    Window window = (Window)aWTEvent.getSource();
                    Window[] windowArray = this.getOwnedWindows();
                    if (windowArray == null) break;
                    int n = windowArray.length - 1;
                    while (n >= 0) {
                        if (window == windowArray[n]) {
                            ++this.openChildren;
                            break block0;
                        }
                        --n;
                    }
                    break;
                }
                case 202: {
                    Window window = (Window)aWTEvent.getSource();
                    Window[] windowArray = this.getOwnedWindows();
                    if (windowArray == null) break;
                    int n = windowArray.length - 1;
                    while (n >= 0) {
                        if (window == windowArray[n]) {
                            --this.openChildren;
                            break;
                        }
                        --n;
                    }
                    if (this.openChildren != 0) break;
                    this.setVisible(false);
                }
            }
        }
    }
}

