/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeActivationEvent;
import oracle.ide.IdeActivationListener;
import oracle.ide.IdeArgs;
import oracle.ide.IdeController;
import oracle.ide.IdeViewHandler;
import oracle.ide.cmd.SaveAllCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.StatusBar;
import oracle.ide.controls.StatusBarControl;
import oracle.ide.controls.Toolbar;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.javatools.controls.MainWindow;
import oracle.javatools.dialogs.ExceptionDialog;

public abstract class IdeMainWindow
extends MainWindow
implements Addin {
    public static final String MENU_FILE = "File";
    public static final String MENU_FILE_REOPEN = "FileReopen";
    public static final String MENU_EDIT = "Edit";
    public static final String MENU_VIEW = "View";
    public static final String MENU_VIEW_OPTIONS = "ViewOptions";
    public static final String MENU_VIEW_TOOLBARS = "ViewToolbars";
    public static final String MENU_SEARCH = "Search";
    public static final String MENU_NAVIGATE = "Navigate";
    public static final String MENU_RUN = "Run";
    public static final String MENU_TOOLS = "Tools";
    public static final String MENU_WINDOW = "Window";
    public static final String MENU_HELP = "Help";
    public static final String ACTION_CATEGORY_FILE = IdeArb.getString(22);
    public static final String ACTION_CATEGORY_EDIT = IdeArb.getString(80);
    public static final String ACTION_CATEGORY_VIEW = IdeArb.getString(151);
    public static final String ACTION_CATEGORY_SEARCH = IdeArb.getString(106);
    public static final String ACTION_CATEGORY_NAVIGATE = IdeArb.getString(144);
    public static final String ACTION_CATEGORY_TOOLS = IdeArb.getString(181);
    public static final String ACTION_CATEGORY_WINDOWS = IdeArb.getString(191);
    public static final String ACTION_CATEGORY_HELP = IdeArb.getString(415);
    private Image _mainIcon;
    private final View _view;
    private static final String NAME_ID_PROP = "MainWindow";
    private Menubar _menubar;
    private Toolbar _toolbar;
    private StatusBar _statusBar;
    private ActionMap _actionMap;
    private InputMap _inputMap;
    private MultiInputMap _topInputMap;
    private IdeViewHandler _viewHandler;
    private NodeReloader _nodeReloader;

    public abstract void registerView(View var1);

    public abstract void unregisterView(View var1);

    public abstract View getLastActiveView();

    public abstract List getVisibleViews();

    public abstract ControllerContext getControllerContext();

    public abstract void addActiveViewListener(ActiveViewListener var1);

    public abstract void removeActiveViewListener(ActiveViewListener var1);

    public abstract void addIdeActivationListener(IdeActivationListener var1);

    public abstract void removeIdeActivationListener(IdeActivationListener var1);

    public abstract void addDynamicMenuListener(DynamicMenuListener var1);

    public abstract void removeDynamicMenuListener(DynamicMenuListener var1);

    public static final void updateVisibleActions() {
        IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_USER_EXTENSION);
    }

    void $init$() {
        this._view = new 2(NAME_ID_PROP);
    }

    public final View getIdeMainWindowView() {
        return this._view;
    }

    public void close() {
        Ide.preTerminate();
        this.setVisible(false);
        this.dispose();
    }

    public void updateTitle(Object object) {
    }

    public void setStatusBarVisible(boolean bl) {
        StatusBar statusBar = this.getStatusBar();
        if (statusBar != null) {
            statusBar.getGUI().setVisible(bl);
            Ide.setProperty("MainWindow.Statusbar.visible", bl ? "TRUE" : "FALSE");
        }
    }

    public void initialize() {
        super.initialize();
        this.getInputMap();
        this._viewHandler = new IdeViewHandler();
        this.addActiveViewListener(this._viewHandler);
        this._nodeReloader = new NodeReloader(null);
        this.addIdeActivationListener(this._nodeReloader);
    }

    protected void postInitialize(IdeArgs ideArgs) {
    }

    public String getMainTitle() {
        return IdeUtil.getProgramName();
    }

    public void setMainTitle(String string) {
        IdeUtil.setProgramName(string);
        this.setTitle(this.getMainTitle());
    }

    public Image getMainIcon() {
        return this._mainIcon;
    }

    public void setMainIcon(Image image) {
        this._mainIcon = image;
        this.setIconImage(this.getMainIcon());
    }

    protected final Menubar getMenubar() {
        if (this._menubar == null) {
            this._menubar = this.createMenubar();
        }
        return this._menubar;
    }

    protected Menubar createMenubar() {
        return new Menubar(this.getIdeMainWindowView());
    }

    protected Toolbar createToolbar() {
        return new Toolbar();
    }

    protected final StatusBar getStatusBar() {
        if (this._statusBar == null) {
            this._statusBar = this.createStatusBar();
            this.updateStatusBarAction();
        }
        return this._statusBar;
    }

    protected void updateStatusBarAction() {
        String string = Ide.getProperty("MainWindow.Statusbar.visible", "true");
        boolean bl = Boolean.valueOf(string);
        this.getStatusBar().getGUI().setVisible(bl);
        IdeAction ideAction = IdeAction.find(69);
        if (ideAction != null) {
            ideAction.setState(bl);
        }
    }

    protected StatusBar createStatusBar() {
        return new StatusBarControl();
    }

    protected ActionMap getActionMap() {
        if (this._actionMap == null) {
            this._actionMap = new ActionMap();
            ActionMap actionMap = this.getRootPane().getActionMap();
            this._actionMap.setParent(actionMap);
            this._actionMap.put(MultiInputMap.NULL_ACTION_BIND, MultiInputMap.NULL_ACTION);
            this.getRootPane().setActionMap(this._actionMap);
        }
        return this._actionMap;
    }

    protected InputMap getInputMap() {
        if (this._inputMap == null) {
            this._topInputMap = new MultiInputMap(true);
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            keyStrokeOptions.addChangeListener(new 1());
            this._inputMap = this.getRootPane().getInputMap(1);
            this._inputMap.setParent(this._topInputMap);
            this.refreshInputMap();
        }
        return this._inputMap;
    }

    protected final void terminateIde() {
        Ide.terminate();
    }

    NavigatorWindow getLastActiveNavigator() {
        return this._viewHandler.getLastActiveNavigator();
    }

    Map getTimestampMap() {
        return this._nodeReloader.getTimestampMap();
    }

    private void refreshInputMap() {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        MultiMapAdapter.fillGlobalMap(this._topInputMap, keyStrokeOptions);
    }

    public static final void updateVisibleActions(int n) {
        if (Ide.getMainWindow() != null) {
            Ide.getMainWindow().getIdeMainWindowView().updateVisibleActions(new UpdateMessage(n, null));
        }
    }

    public IdeMainWindow() {
        this.$init$();
    }

    static Toolbar ra$_toolbar(IdeMainWindow ideMainWindow) {
        return ideMainWindow._toolbar;
    }

    static void wa$_toolbar(IdeMainWindow ideMainWindow, Toolbar toolbar) {
        ideMainWindow._toolbar = toolbar;
    }

    static void mav$refreshInputMap(IdeMainWindow ideMainWindow) {
        ideMainWindow.refreshInputMap();
    }

    public final class 2
    extends View {
        public void close() {
            IdeMainWindow.this.close();
        }

        public void show() {
            IdeMainWindow.this.show();
        }

        public void updateTitle(Object object) {
            IdeMainWindow.this.updateTitle(object);
        }

        public boolean isVisible() {
            return IdeMainWindow.this.isVisible();
        }

        public Component getGUI() {
            return IdeMainWindow.this;
        }

        public void updateVisibleActions(UpdateMessage updateMessage) {
            try {
                UpdateVisibleActions.scheduleUpdate(updateMessage);
            }
            catch (Exception exception) {
                ExceptionDialog.showExceptionDialog((Window)((Object)IdeMainWindow.this), (Exception)exception);
            }
        }

        public Toolbar getToolbar() {
            if (IdeMainWindow.ra$_toolbar(IdeMainWindow.this) == null) {
                IdeMainWindow.wa$_toolbar(IdeMainWindow.this, IdeMainWindow.this.createToolbar());
                String string = Ide.getProperty("MainWindow.Toolbar.visible", "true");
                boolean bl = Boolean.valueOf(string);
                IdeMainWindow.ra$_toolbar(IdeMainWindow.this).setVisible(bl);
                IdeAction ideAction = IdeAction.find(36);
                if (ideAction != null) {
                    ideAction.setState(bl);
                }
                IdeMainWindow.this.getContentPane().add((Component)IdeMainWindow.ra$_toolbar(IdeMainWindow.this), "North");
            }
            return IdeMainWindow.ra$_toolbar(IdeMainWindow.this);
        }

        public void setToolbarVisible(boolean bl) {
            Toolbar toolbar = this.getToolbar();
            if (toolbar != null) {
                toolbar.setVisible(bl);
                Ide.setProperty("MainWindow.Toolbar.visible", bl ? "TRUE" : "FALSE");
            }
        }

        public 2(String string) {
            super(string);
        }
    }

    public interface ControllerContext {
        public List getControllerProviders(View var1);
    }

    public final class 1
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            IdeMainWindow.mav$refreshInputMap(IdeMainWindow.this);
        }
    }

    private static class UpdateVisibleActions
    implements ActionListener {
        private static final int UPDATE_INTERVAL = 250;
        private static Timer _timer;
        private static UpdateMessage _updateMessage;
        private static int i;

        static {
            i = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void scheduleUpdate(UpdateMessage updateMessage) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                if (_timer == null) {
                    _timer = new Timer(250, new UpdateVisibleActions());
                    _timer.setRepeats(false);
                }
                _timer.restart();
                _updateMessage = updateMessage;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            Class<UpdateVisibleActions> clazz = UpdateVisibleActions.class;
            synchronized (UpdateVisibleActions.class) {
                _timer = null;
                UpdateMessage updateMessage = _updateMessage;
                _updateMessage = null;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                this.fireUpdate(updateMessage);
                return;
            }
        }

        private void fireUpdate(UpdateMessage updateMessage) {
            ++i;
            IdeMainWindow ideMainWindow = Ide.getMainWindow();
            if (ideMainWindow != null) {
                for (View view : ideMainWindow.getVisibleViews()) {
                    if (view != ideMainWindow.getIdeMainWindowView()) {
                        view.updateVisibleActions(updateMessage);
                        continue;
                    }
                    View.updateToolbarActions(view.getToolbar());
                }
            }
        }

        private UpdateVisibleActions() {
        }
    }

    private static final class NodeReloader
    implements IdeActivationListener {
        private HashMap _timestampMap;
        private static final int SILENT_RELOAD = 0;
        private static final int AUTOMATICALLY_RELOAD = 1;
        private static final int SAVE_ON_DEACTIVATION = 2;

        public void activated(IdeActivationEvent ideActivationEvent) {
            if (NodeReloader.getEnvironOption(1)) {
                IdeController.reloadNodes(this._timestampMap, NodeReloader.getEnvironOption(0), false);
            }
        }

        public void deactivated(IdeActivationEvent ideActivationEvent) {
            if (NodeReloader.getEnvironOption(2)) {
                try {
                    SaveAllCommand.saveAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._timestampMap = new HashMap();
            NodeUtil.storeAllTimestamps(this._timestampMap);
        }

        public Map getTimestampMap() {
            return this._timestampMap;
        }

        private static boolean getEnvironOption(int n) {
            EnvironOptions environOptions = (EnvironOptions)Ide.getSettings().getData("environment-options");
            if (n == 0) {
                return environOptions.getSilentReload();
            }
            if (n == 1) {
                return environOptions.getAutoReloadExtMod();
            }
            if (n == 2) {
                return environOptions.getSaveOnDeactivation();
            }
            return false;
        }

        private NodeReloader() {
        }

        NodeReloader(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

