/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide;

import java.awt.Color;
import javax.naming.Context;
import javax.swing.UIManager;
import oracle.ide.Addin;
import oracle.ide.util.ModelUtil;
import oracle.javatools.jndi.Names;

public abstract class IdeUIManager
implements Addin {
    private static final String UI_MANAGER_NAME = "ide/ui-manager";
    private static Color COLOR_UNSELECTED_TAB;
    private static Color COLOR_SELECTED_FOCUSED_TAB;
    private static Color COLOR_HIGHLIGHTED_TAB;
    private static Color DISABLED_TEXT_COLOR;
    private static Color ACTIVE_TITLE_COLOR;
    private static Color ACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    private static Color ACTIVE_TITLE_GRADIENT_DARK_COLOR;
    private static Color ACTIVE_TITLE_FOREGROUND_COLOR;
    private static Color ACTIVE_TITLE_BUTTON_COLOR;
    private static Color INACTIVE_TITLE_COLOR;
    private static Color INACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    private static Color INACTIVE_TITLE_GRADIENT_DARK_COLOR;
    private static Color INACTIVE_TITLE_FOREGROUND_COLOR;
    private static Color INACTIVE_TITLE_BUTTON_COLOR;
    private static Color UNSELECTED_TITLE_COLOR;
    private static Color UNSELECTED_TITLE_FOREGROUND_COLOR;
    private static Color UNSELECTED_TITLE_BUTTON_COLOR;
    private static final int GRADIENT_LIGHT_BIAS = 40;
    private static final int GRADIENT_DARK_BIAS = 20;
    public static final String STATUS_BAR_UICLASSID = "oracle.ide.controls.StatusBarControlUI";
    public static final String TREE_INACTIVE_SELECTION_FOREGROUND_KEY = "oracle.ide.explorer.TreeExplorer.inactiveSelectionForeground";
    public static final String TREE_INACTIVE_SELECTION_BACKGROUND_KEY = "oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground";
    public static final String FILEVIEW_ARCHIVE_ICON = "FileView.archiveIcon";
    public static final String DIRTY_FONT = "Oracle.dirtyFont";

    protected IdeUIManager() {
    }

    public static IdeUIManager getUIManager() {
        return (IdeUIManager)Names.lookup((Context)Names.newInitialContext(), (String)UI_MANAGER_NAME);
    }

    public static void setUIManager(IdeUIManager ideUIManager) {
        Names.bind((Context)Names.newInitialContext(), (String)UI_MANAGER_NAME, (Object)ideUIManager);
    }

    public abstract void setLookAndFeel(String var1, String var2);

    public abstract ThemeInfo[] getInstalledThemes(String var1);

    public abstract ThemeInfo getCurrentTheme(String var1);

    public abstract ThemeInfo getDefaultTheme(String var1);

    public static Color getUnselectedTabColor() {
        if (COLOR_UNSELECTED_TAB == null) {
            int n;
            int n2;
            Color color = IdeUIManager.getSelectedFocusedTabColor();
            int n3 = color.getRed();
            COLOR_UNSELECTED_TAB = (n3 + (n2 = color.getGreen()) + (n = color.getBlue())) / 3 > 127 ? new Color(n3 * 247 / 255, n2 * 247 / 255, n * 239 / 255) : new Color(Math.min(n3 * 255 / 247, 255), Math.min(n2 * 255 / 247, 255), Math.min(n * 255 / 247, 255));
        }
        return COLOR_UNSELECTED_TAB;
    }

    public static Color getSelectedFocusedTabColor() {
        if (COLOR_SELECTED_FOCUSED_TAB == null) {
            Color color = UIManager.getColor("EditorPane.background");
            COLOR_SELECTED_FOCUSED_TAB = color != null ? color : Color.WHITE;
        }
        return COLOR_SELECTED_FOCUSED_TAB;
    }

    public static Color getDisabledTextColor() {
        if (DISABLED_TEXT_COLOR == null) {
            Color color = UIManager.getLookAndFeelDefaults().getColor("textInactiveText");
            DISABLED_TEXT_COLOR = color != null ? color : Color.LIGHT_GRAY;
        }
        return DISABLED_TEXT_COLOR;
    }

    public static Color getHighlightedTabColor() {
        if (COLOR_HIGHLIGHTED_TAB == null) {
            COLOR_HIGHLIGHTED_TAB = new Color(229, 124, 10);
        }
        return COLOR_HIGHLIGHTED_TAB;
    }

    public static Color getActiveTitleColor() {
        if (ACTIVE_TITLE_COLOR == null) {
            ACTIVE_TITLE_COLOR = UIManager.getColor("InternalFrame.activeTitleBackground");
        }
        return ACTIVE_TITLE_COLOR;
    }

    public static Color getActiveTitleGradientLightColor() {
        if (ACTIVE_TITLE_GRADIENT_LIGHT_COLOR == null) {
            Color color = IdeUIManager.getActiveTitleColor();
            ACTIVE_TITLE_GRADIENT_LIGHT_COLOR = IdeUIManager.getGradientLightColor(color);
        }
        return ACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    }

    public static Color getActiveTitleGradientDarkColor() {
        if (ACTIVE_TITLE_GRADIENT_DARK_COLOR == null) {
            Color color = IdeUIManager.getActiveTitleColor();
            Color color2 = IdeUIManager.getActiveTitleGradientLightColor();
            ACTIVE_TITLE_GRADIENT_DARK_COLOR = IdeUIManager.getGradientDarkColor(color, color2);
        }
        return ACTIVE_TITLE_GRADIENT_DARK_COLOR;
    }

    public static Color getInactiveTitleColor() {
        if (INACTIVE_TITLE_COLOR == null) {
            INACTIVE_TITLE_COLOR = UIManager.getColor("Panel.background");
        }
        return INACTIVE_TITLE_COLOR;
    }

    public static Color getInactiveTitleGradientLightColor() {
        if (INACTIVE_TITLE_GRADIENT_LIGHT_COLOR == null) {
            Color color = IdeUIManager.getInactiveTitleColor();
            INACTIVE_TITLE_GRADIENT_LIGHT_COLOR = IdeUIManager.getGradientLightColor(color);
        }
        return INACTIVE_TITLE_GRADIENT_LIGHT_COLOR;
    }

    public static Color getInactiveTitleGradientDarkColor() {
        if (INACTIVE_TITLE_GRADIENT_DARK_COLOR == null) {
            Color color = IdeUIManager.getInactiveTitleColor();
            Color color2 = IdeUIManager.getInactiveTitleGradientLightColor();
            INACTIVE_TITLE_GRADIENT_DARK_COLOR = IdeUIManager.getGradientDarkColor(color, color2);
        }
        return INACTIVE_TITLE_GRADIENT_DARK_COLOR;
    }

    public static Color getInactiveTitleForegroundColor() {
        if (INACTIVE_TITLE_FOREGROUND_COLOR == null) {
            INACTIVE_TITLE_FOREGROUND_COLOR = UIManager.getColor("Label.foreground");
        }
        return INACTIVE_TITLE_FOREGROUND_COLOR;
    }

    public static Color getUnselectedTitleColor() {
        if (UNSELECTED_TITLE_COLOR == null) {
            Color color = IdeUIManager.getInactiveTitleColor();
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            UNSELECTED_TITLE_COLOR = new Color(Math.min(n + 24, 255), Math.min(n2 + 24, 255), Math.min(n3 + 24, 255));
        }
        return UNSELECTED_TITLE_COLOR;
    }

    public static Color getUnselectedTitleForegroundColor() {
        if (UNSELECTED_TITLE_FOREGROUND_COLOR == null) {
            UNSELECTED_TITLE_FOREGROUND_COLOR = IdeUIManager.getInactiveTitleForegroundColor();
        }
        return UNSELECTED_TITLE_FOREGROUND_COLOR;
    }

    private static Color getButtonColor(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() * 9 / 10);
    }

    private static Color getGradientLightColor(Color color) {
        int n = 40;
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        int n5 = Math.min(n2, Math.min(n3, n4));
        int n6 = Math.min(n5 + 40, 255);
        if (n2 + 40 < 256) {
            n6 = n2 + 40;
            n5 = Math.max(n5, n2);
        }
        if (n3 + 40 < 256) {
            n6 = Math.max(n6, n3 + 40);
            n5 = Math.max(n5, n3);
        }
        if (n4 + 40 < 256) {
            n6 = Math.max(n6, n4 + 40);
            n5 = Math.max(n5, n4);
        }
        float f = (float)n6 / (float)n5 / 255.0f;
        return new Color(Math.min((float)n2 * f, 1.0f), Math.min((float)n3 * f, 1.0f), Math.min((float)n4 * f, 1.0f));
    }

    public static Color getActiveTitleForegroundColor() {
        if (ACTIVE_TITLE_FOREGROUND_COLOR == null) {
            ACTIVE_TITLE_FOREGROUND_COLOR = UIManager.getColor("InternalFrame.activeTitleForeground");
        }
        return ACTIVE_TITLE_FOREGROUND_COLOR;
    }

    public static Color getActiveTitleButtonColor() {
        if (ACTIVE_TITLE_BUTTON_COLOR == null) {
            Color color = IdeUIManager.getActiveTitleForegroundColor();
            ACTIVE_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(color);
        }
        return ACTIVE_TITLE_BUTTON_COLOR;
    }

    public static Color getInactiveTitleButtonColor() {
        if (INACTIVE_TITLE_BUTTON_COLOR == null) {
            INACTIVE_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(IdeUIManager.getInactiveTitleForegroundColor());
        }
        return INACTIVE_TITLE_BUTTON_COLOR;
    }

    public static Color getUnselectedTitleButtonColor() {
        if (UNSELECTED_TITLE_BUTTON_COLOR == null) {
            UNSELECTED_TITLE_BUTTON_COLOR = IdeUIManager.getButtonColor(IdeUIManager.getUnselectedTitleForegroundColor());
        }
        return UNSELECTED_TITLE_BUTTON_COLOR;
    }

    private static Color getGradientDarkColor(Color color, Color color2) {
        float f = 0.5f;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = n - (int)(0.5f * (float)(color2.getRed() - n));
        int n5 = n2 - (int)(0.5f * (float)(color2.getGreen() - n2));
        int n6 = n3 - (int)(0.5f * (float)(color2.getBlue() - n3));
        return new Color(Math.max(n4, 0), Math.max(n5, 0), Math.max(n6, 0));
    }

    public static final class ThemeInfo
    implements Comparable {
        private final String _name;
        private final String _className;

        public ThemeInfo(String string, String string2) {
            this._name = string;
            this._className = string2;
        }

        public String getName() {
            return this._name;
        }

        public String getClassName() {
            return this._className;
        }

        public int compareTo(Object object) {
            ThemeInfo themeInfo = (ThemeInfo)object;
            return this.getName().compareTo(themeInfo.getName());
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof ThemeInfo)) {
                return false;
            }
            ThemeInfo themeInfo = (ThemeInfo)object;
            return ModelUtil.areEqual((Object)this.getName(), (Object)themeInfo.getName()) && ModelUtil.areEqual((Object)this.getClassName(), (Object)themeInfo.getClassName());
        }

        public int hashCode() {
            int n = 17;
            n = n * 37 + this.getName().hashCode();
            n = n * 37 + this.getClassName().hashCode();
            return n;
        }

        public String toString() {
            return this.getName();
        }
    }
}

